# https://altair-viz.github.io/gallery/one_dot_per_zipcode.html
# With smaller subplot
import altair as alt
from vega_datasets import data

# Since the data is more than 5,000 rows we'll import it from a URL
source = data.zipcodes.url

alt.Chart(source).transform_calculate(
    "leading digit", alt.expr.substring(alt.datum.zip_code, 0, 1)
).mark_circle(size=3).encode(
    longitude="longitude:Q",
    latitude="latitude:Q",
    color="leading digit:N",
    tooltip="zip_code:N",
).project(type="albersUsa").properties(width=600, height=400)
