# https://altair-viz.github.io/gallery/interactive_layered_crossfilter.html

import altair as alt
from vega_datasets import data

source = alt.UrlData(data.flights_2k.url, format={"parse": {"date": "date"}})

brush = alt.selection(type="interval", encodings=["x"])

# Define the base chart, with the common parts of the
# background and highlights
base = (
    alt.Chart()
    .mark_bar()
    .encode(
        x=alt.X(alt.repeat("column"), type="quantitative", bin=alt.Bin(maxbins=20)),
        y="count()",
    )
    .properties(width=130, height=130)
)

# gray background with selection
background = base.encode(color=alt.value("#ddd")).add_selection(brush)

# blue highlights on the transformed data
highlight = base.transform_filter(brush)

# layer the two charts & repeat
alt.layer(background, highlight, data=source).transform_calculate(
    "time", "hours(datum.date)"
).repeat(column=["distance", "delay", "time"])
