import altair as alt
import numpy as np
import pandas as pd

np.random.seed(42)

x = np.random.normal(size=100)
y = np.random.normal(size=100)

m = np.random.normal(15, 1, size=100)

source = pd.DataFrame({"x": x, "y": y, "m": m})

# interval selection in the scatter plot
pts = alt.selection_interval(encodings=["x"])

# left panel: scatter plot
points = (
    alt.Chart()
    .mark_point(filled=True, color="black")
    .encode(x="x", y="y")
    .transform_filter(pts)
    .properties(width=300, height=300)
)

# right panel: histogram
mag = (
    alt.Chart()
    .mark_bar()
    .encode(
        x="mbin:N",
        y="count()",
        color=alt.condition(pts, alt.value("black"), alt.value("lightgray")),
    )
    .properties(width=300, height=300)
    .add_params(pts)
)

# build the chart:
alt.hconcat(points, mag, data=source).transform_bin(
    "mbin", field="m", bin=alt.Bin(maxbins=20)
)
