# https://altair-viz.github.io/gallery/us_incomebrackets_by_state_facet.html
# With smaller subplots and 3 columns

import altair as alt
from vega_datasets import data

states = alt.topo_feature(data.us_10m.url, "states")
source = data.income.url

alt.Chart(source).mark_geoshape().encode(
    shape="geo:G",
    color="pct:Q",
    tooltip=["name:N", "pct:Q"],
    facet=alt.Facet("group:N", columns=3),
).transform_lookup(
    lookup="id", from_=alt.LookupData(data=states, key="id"), as_="geo"
).properties(
    width=150,
    height=80,
).project(type="albersUsa")
