# https://altair-viz.github.io/gallery/normed_parallel_coordinates.html

import altair as alt
from altair import datum
from vega_datasets import data

source = data.iris()

alt.Chart(source).transform_window(index="count()").transform_fold(
    ["petalLength", "petalWidth", "sepalLength", "sepalWidth"]
).transform_joinaggregate(
    min="min(value)", max="max(value)", groupby=["key"]
).transform_calculate(
    minmax_value=(datum.value - datum.min) / (datum.max - datum.min),
    mid=(datum.min + datum.max) / 2,
).mark_line().encode(
    x="key:N",
    y="minmax_value:Q",
    color="species:N",
    detail="index:N",
    opacity=alt.value(0.5),
).properties(width=500)
