# https://altair-viz.github.io/gallery/parallel_coordinates.html

import altair as alt
from vega_datasets import data

source = data.iris()

alt.Chart(source).transform_window(index="count()").transform_fold(
    ["petalLength", "petalWidth", "sepalLength", "sepalWidth"]
).mark_line().encode(
    x="key:N", y="value:Q", color="species:N", detail="index:N", opacity=alt.value(0.5)
).properties(width=500)
