import altair as alt
from vega_datasets import data

source = data.cars()

# Configure the options common to all layers
brush = alt.selection_interval()
base = alt.Chart(source).add_params(brush)

# Configure the points
points = base.mark_point().encode(
    x=alt.X("Miles_per_Gallon", title=""),
    y=alt.Y("Horsepower", title=""),
    color=alt.condition(brush, "Origin", alt.value("grey")),
)

# Configure the ticks
tick_axis = alt.Axis(labels=False, domain=False, ticks=False)

x_ticks = base.mark_tick().encode(
    alt.X("Miles_per_Gallon", axis=tick_axis),
    alt.Y("Origin", title="", axis=tick_axis),
    color=alt.condition(brush, "Origin", alt.value("lightgrey")),
)

y_ticks = base.mark_tick().encode(
    alt.X("Origin", title="", axis=tick_axis),
    alt.Y("Horsepower", axis=tick_axis),
    color=alt.condition(brush, "Origin", alt.value("lightgrey")),
)

# Build the chart
y_ticks | (points & x_ticks)
