# https://altair-viz.github.io/gallery/area_chart_gradient.html

import altair as alt
from vega_datasets import data

source = data.cars()

alt.Chart(source).mark_circle().encode(
    alt.X(alt.repeat("column"), type="quantitative"),
    alt.Y(alt.repeat("row"), type="quantitative"),
    color="Origin:N",
).properties(width=120, height=120).repeat(
    row=["Horsepower", "Acceleration", "Miles_per_Gallon"],
    column=["Miles_per_Gallon", "Acceleration", "Horsepower"],
).interactive()
