from __future__ import unicode_literals

commands_with_help = {
    'alias': "Creates an alias called 'name' the executes 'command'.",
    'args': 'Print the arguments of the current function.',
    'break': 'Set a break.',
    'clear': 'Clear breakpoints.',
    'commands': 'Specify a list of commands for breakpoint number bpnumber.',
    'condition': 'Make breakpoint conditional.',
    'cont': 'Continue execution, only stop when a breakpoint is encountered.',
    'continue': 'Continue execution, only stop when a breakpoint is encountered.',
    'debug': 'Enter a recursive debugger.',
    'disable': 'Disable breakpoints.',
    'down': 'Move the current frame one level down in the stack trace.',
    'enable': 'Enables breakpoints.',
    'exit': 'The program being executed is aborted.',
    'help': 'Help.',
    'ignore': 'Sets the ignore count for the given breakpoint number.',
    'jump': 'Set the next line that will be executed.',
    'list': 'List source code.',
    'next': 'Continue execution until the next line.',
    'p': 'Print the value of the expression.',
    'pp': 'Pretty-print expression.',
    'quit': 'The program being executed is aborted.',
    'restart': 'Restart the debugged python program.',
    'return': 'Continue execution until the current function returns.',
    'run': 'Restart the debugged python program.',
    'step': 'Execute the current line, stop at the first possible occasion.',
    'tbreak': 'Set a break, remove when first hit.',
    'unalias': 'Delete an alias.',
    'up': 'Move the current frame one level up in the stack trace.',
    'whatis': 'Prints the type of the argument.',
    'where': 'Print a stack trace.',
    'until': 'Continue execution until.',
    'display': 'Display the value of the expression if it changed.',
    'longlist': 'List the whole source code for the current function or frame.',
    'retval': 'Print the return value for the last return of a function.',
    'source': 'Try to get source code for the given object and display it.',
    'interact': 'Start an interactive interpreter.',
}

shortcuts = {
    'a': 'args',
    'b': 'break',
    'bt': 'where',
    'cl': 'clear',
    'd': 'down',
    'h': 'help',
    'l': 'list',
    'll': 'longlist',
    'n': 'next',
    'q': 'quit',
    'r': 'return',
    's': 'step',
    'u': 'up',
    'unt': 'until',
    'w': 'where',
}


completion_hints = [
    (('help', ), '<command>'),
    (['l', 'list'], '[<first> [<last>]]'),
    (['cl', 'clear'], '[<filename>:<lineno> | <bpnumber>...]'),
    (('j', 'jump'), '<lineno>'),
    (('restart', 'run'), '[<args>...]'),
    (('p', 'pp', 'whatis'), '<expression>'),
    (('enable', 'disable'), '<bpnumber>...'),
    (('ignore', ), '<bpnumber> <count>'),
    (('condition', ), '<bpnumber> <str_condition>'),
    (('alias', ), '<name> [<command> [<parameter>...]]'),
    (('unalias', ), '<name>'),
    (('b', 'break', 'tbreak'), '([<file>:]<lineno> | <function>) [, <condition>]'),
    (('commands', ), '<bpnumber>'),
    (('up', 'u', 'down', 'd'), '[<count>]'),
    (('until', 'unt'), '[<lineno>]'),
    (('display', 'undisplay'), '[<expression>]'),
    (('source', ), '<expression>'),
    (('commands', ), '[<bpnumber>]'),
]
