"""
    ChannelEngine Merchant API

    ChannelEngine API for merchants  # noqa: E501

    The version of the OpenAPI document: 2.13.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from channelengine_merchant_api_client.api_client import ApiClient, Endpoint as _Endpoint
from channelengine_merchant_api_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from channelengine_merchant_api_client.model.api_response import ApiResponse
from channelengine_merchant_api_client.model.collection_of_merchant_product_with_buy_box_price import CollectionOfMerchantProductWithBuyBoxPrice


class CompetitionPriceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.competition_prices_get_buy_box_prices_endpoint = _Endpoint(
            settings={
                'response_type': (CollectionOfMerchantProductWithBuyBoxPrice,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/competitionprices/buyboxprices',
                'operation_id': 'competition_prices_get_buy_box_prices',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'channel_id',
                    'gtin_list',
                    'sku_list',
                    'page',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'channel_id':
                        (int,),
                    'gtin_list':
                        ([str],),
                    'sku_list':
                        ([str],),
                    'page':
                        (int,),
                },
                'attribute_map': {
                    'channel_id': 'channelId',
                    'gtin_list': 'gtinList',
                    'sku_list': 'skuList',
                    'page': 'page',
                },
                'location_map': {
                    'channel_id': 'query',
                    'gtin_list': 'query',
                    'sku_list': 'query',
                    'page': 'query',
                },
                'collection_format_map': {
                    'gtin_list': 'multi',
                    'sku_list': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def competition_prices_get_buy_box_prices(
        self,
        **kwargs
    ):
        """Get the BuyBox winner prices  # noqa: E501

        Get the current price of the BuyBox winner per product for a channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.competition_prices_get_buy_box_prices(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            channel_id (int): The id of the channel. [optional]
            gtin_list ([str]): Search products by submitting a list of GTIN's. (optional)<br />Max. 2000.. [optional]
            sku_list ([str]): Search products by submitting a list of Sku's. (optional)<br />Max. 2000. If GtinList is already set, this one is ignored.. [optional]
            page (int): The page to filter on. Starts at 1.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CollectionOfMerchantProductWithBuyBoxPrice
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.competition_prices_get_buy_box_prices_endpoint.call_with_http_info(**kwargs)

