"""
    ChannelEngine Merchant API

    ChannelEngine API for merchants  # noqa: E501

    The version of the OpenAPI document: 2.13.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from channelengine_merchant_api_client.api_client import ApiClient, Endpoint as _Endpoint
from channelengine_merchant_api_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from channelengine_merchant_api_client.model.api_response import ApiResponse
from channelengine_merchant_api_client.model.collection_of_merchant_return_response import CollectionOfMerchantReturnResponse
from channelengine_merchant_api_client.model.collection_of_merchant_single_order_return_response import CollectionOfMerchantSingleOrderReturnResponse
from channelengine_merchant_api_client.model.creator_filter import CreatorFilter
from channelengine_merchant_api_client.model.fulfillment_type import FulfillmentType
from channelengine_merchant_api_client.model.merchant_return_acknowledge_request import MerchantReturnAcknowledgeRequest
from channelengine_merchant_api_client.model.merchant_return_request import MerchantReturnRequest
from channelengine_merchant_api_client.model.merchant_return_update_request import MerchantReturnUpdateRequest
from channelengine_merchant_api_client.model.return_reason import ReturnReason
from channelengine_merchant_api_client.model.return_status import ReturnStatus


class ReturnApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.return_acknowledge_endpoint = _Endpoint(
            settings={
                'response_type': (ApiResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/returns/merchant/acknowledge',
                'operation_id': 'return_acknowledge',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'merchant_return_acknowledge_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'merchant_return_acknowledge_request':
                        (MerchantReturnAcknowledgeRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'merchant_return_acknowledge_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json-patch+json',
                    'application/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )
        self.return_declare_for_merchant_endpoint = _Endpoint(
            settings={
                'response_type': (ApiResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/returns/merchant',
                'operation_id': 'return_declare_for_merchant',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'merchant_return_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'merchant_return_request':
                        (MerchantReturnRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'merchant_return_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json-patch+json',
                    'application/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )
        self.return_get_by_merchant_order_no_endpoint = _Endpoint(
            settings={
                'response_type': (CollectionOfMerchantSingleOrderReturnResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/returns/merchant/{merchantOrderNo}',
                'operation_id': 'return_get_by_merchant_order_no',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'merchant_order_no',
                ],
                'required': [
                    'merchant_order_no',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'merchant_order_no':
                        (str,),
                },
                'attribute_map': {
                    'merchant_order_no': 'merchantOrderNo',
                },
                'location_map': {
                    'merchant_order_no': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.return_get_declared_by_channel_endpoint = _Endpoint(
            settings={
                'response_type': (CollectionOfMerchantReturnResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/returns/merchant',
                'operation_id': 'return_get_declared_by_channel',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'channel_ids',
                    'merchant_order_nos',
                    'channel_order_nos',
                    'fulfillment_type',
                    'statuses',
                    'reasons',
                    'from_date',
                    'to_date',
                    'is_acknowledged',
                    'page',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'channel_ids':
                        ([int],),
                    'merchant_order_nos':
                        ([str],),
                    'channel_order_nos':
                        ([str],),
                    'fulfillment_type':
                        (FulfillmentType,),
                    'statuses':
                        ([ReturnStatus],),
                    'reasons':
                        ([ReturnReason],),
                    'from_date':
                        (datetime,),
                    'to_date':
                        (datetime,),
                    'is_acknowledged':
                        (bool,),
                    'page':
                        (int,),
                },
                'attribute_map': {
                    'channel_ids': 'channelIds',
                    'merchant_order_nos': 'merchantOrderNos',
                    'channel_order_nos': 'channelOrderNos',
                    'fulfillment_type': 'fulfillmentType',
                    'statuses': 'statuses',
                    'reasons': 'reasons',
                    'from_date': 'fromDate',
                    'to_date': 'toDate',
                    'is_acknowledged': 'isAcknowledged',
                    'page': 'page',
                },
                'location_map': {
                    'channel_ids': 'query',
                    'merchant_order_nos': 'query',
                    'channel_order_nos': 'query',
                    'fulfillment_type': 'query',
                    'statuses': 'query',
                    'reasons': 'query',
                    'from_date': 'query',
                    'to_date': 'query',
                    'is_acknowledged': 'query',
                    'page': 'query',
                },
                'collection_format_map': {
                    'channel_ids': 'multi',
                    'merchant_order_nos': 'multi',
                    'channel_order_nos': 'multi',
                    'statuses': 'multi',
                    'reasons': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.return_get_returns_endpoint = _Endpoint(
            settings={
                'response_type': (CollectionOfMerchantReturnResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/returns',
                'operation_id': 'return_get_returns',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'creator_type',
                    'channel_ids',
                    'merchant_order_nos',
                    'channel_order_nos',
                    'fulfillment_type',
                    'statuses',
                    'reasons',
                    'from_date',
                    'to_date',
                    'is_acknowledged',
                    'page',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'creator_type':
                        (CreatorFilter,),
                    'channel_ids':
                        ([int],),
                    'merchant_order_nos':
                        ([str],),
                    'channel_order_nos':
                        ([str],),
                    'fulfillment_type':
                        (FulfillmentType,),
                    'statuses':
                        ([ReturnStatus],),
                    'reasons':
                        ([ReturnReason],),
                    'from_date':
                        (datetime,),
                    'to_date':
                        (datetime,),
                    'is_acknowledged':
                        (bool,),
                    'page':
                        (int,),
                },
                'attribute_map': {
                    'creator_type': 'creatorType',
                    'channel_ids': 'channelIds',
                    'merchant_order_nos': 'merchantOrderNos',
                    'channel_order_nos': 'channelOrderNos',
                    'fulfillment_type': 'fulfillmentType',
                    'statuses': 'statuses',
                    'reasons': 'reasons',
                    'from_date': 'fromDate',
                    'to_date': 'toDate',
                    'is_acknowledged': 'isAcknowledged',
                    'page': 'page',
                },
                'location_map': {
                    'creator_type': 'query',
                    'channel_ids': 'query',
                    'merchant_order_nos': 'query',
                    'channel_order_nos': 'query',
                    'fulfillment_type': 'query',
                    'statuses': 'query',
                    'reasons': 'query',
                    'from_date': 'query',
                    'to_date': 'query',
                    'is_acknowledged': 'query',
                    'page': 'query',
                },
                'collection_format_map': {
                    'channel_ids': 'multi',
                    'merchant_order_nos': 'multi',
                    'channel_order_nos': 'multi',
                    'statuses': 'multi',
                    'reasons': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.return_get_unhandled_endpoint = _Endpoint(
            settings={
                'response_type': (CollectionOfMerchantReturnResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/returns/merchant/new',
                'operation_id': 'return_get_unhandled',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'channel_ids',
                    'page',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'channel_ids':
                        ([int],),
                    'page':
                        (int,),
                },
                'attribute_map': {
                    'channel_ids': 'channelIds',
                    'page': 'page',
                },
                'location_map': {
                    'channel_ids': 'query',
                    'page': 'query',
                },
                'collection_format_map': {
                    'channel_ids': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.return_update_for_merchant_endpoint = _Endpoint(
            settings={
                'response_type': (ApiResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/returns',
                'operation_id': 'return_update_for_merchant',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'merchant_return_update_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'merchant_return_update_request':
                        (MerchantReturnUpdateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'merchant_return_update_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json-patch+json',
                    'application/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )

    def return_acknowledge(
        self,
        **kwargs
    ):
        """Acknowledge Return.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.return_acknowledge(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            merchant_return_acknowledge_request (MerchantReturnAcknowledgeRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ApiResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.return_acknowledge_endpoint.call_with_http_info(**kwargs)

    def return_declare_for_merchant(
        self,
        **kwargs
    ):
        """Create Return.  # noqa: E501

        Mark (part of) an order as returned by the customer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.return_declare_for_merchant(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            merchant_return_request (MerchantReturnRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ApiResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.return_declare_for_merchant_endpoint.call_with_http_info(**kwargs)

    def return_get_by_merchant_order_no(
        self,
        merchant_order_no,
        **kwargs
    ):
        """Get Return.  # noqa: E501

        Retrieve returns based on the supplied merchant order number. May return more than 1 result.<br />This call is supposed to be used by merchants. Channels should use the 'GET /v2/returns/channel'<br />call.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.return_get_by_merchant_order_no(merchant_order_no, async_req=True)
        >>> result = thread.get()

        Args:
            merchant_order_no (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CollectionOfMerchantSingleOrderReturnResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['merchant_order_no'] = \
            merchant_order_no
        return self.return_get_by_merchant_order_no_endpoint.call_with_http_info(**kwargs)

    def return_get_declared_by_channel(
        self,
        **kwargs
    ):
        """Get Returns.  # noqa: E501

        Get all returns created by the channel. This call is supposed<br />to be used by merchants. Channels should use the 'GET /v2/returns/channel'<br />call.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.return_get_declared_by_channel(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            channel_ids ([int]): Filter on Channel IDs. [optional]
            merchant_order_nos ([str]): Filter on unique order reference used by the merchant.. [optional]
            channel_order_nos ([str]): Filter on unique order reference used by the channel.. [optional]
            fulfillment_type (FulfillmentType): Filter on the fulfillment type of the order.. [optional]
            statuses ([ReturnStatus]): Return status(es) to filter on.. [optional]
            reasons ([ReturnReason]): Return reason(s) to filter on.. [optional]
            from_date (datetime): Filter on the creation date, starting from this date. This date is inclusive.. [optional]
            to_date (datetime): Filter on the creation date, until this date. This date is exclusive.. [optional]
            is_acknowledged (bool): Filters based on acknowledgements. [optional]
            page (int): The page to filter on. Starts at 1.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CollectionOfMerchantReturnResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.return_get_declared_by_channel_endpoint.call_with_http_info(**kwargs)

    def return_get_returns(
        self,
        **kwargs
    ):
        """Get Returns.  # noqa: E501

        Get all returns created by the merchant. This call is supposed<br />to be used by merchants. To get returns created by channels, the 'GET /v2/returns/merchant' endpoint should be used.<br />Channels should use the 'GET /v2/returns/channel' call.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.return_get_returns(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            creator_type (CreatorFilter): Filter on the return's creator. Default is MIXED.. [optional]
            channel_ids ([int]): Filter on Channel IDs. [optional]
            merchant_order_nos ([str]): Filter on unique order reference used by the merchant.. [optional]
            channel_order_nos ([str]): Filter on unique order reference used by the channel.. [optional]
            fulfillment_type (FulfillmentType): Filter on the fulfillment type of the order.. [optional]
            statuses ([ReturnStatus]): Return status(es) to filter on.. [optional]
            reasons ([ReturnReason]): Return reason(s) to filter on.. [optional]
            from_date (datetime): Filter on the creation date, starting from this date. This date is inclusive.. [optional]
            to_date (datetime): Filter on the creation date, until this date. This date is exclusive.. [optional]
            is_acknowledged (bool): Filters based on acknowledgements. [optional]
            page (int): The page to filter on. Starts at 1.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CollectionOfMerchantReturnResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.return_get_returns_endpoint.call_with_http_info(**kwargs)

    def return_get_unhandled(
        self,
        **kwargs
    ):
        """Get Unhandled Returns.  # noqa: E501

        Get all new / unhandled returns created by channels. This call is supposed<br />to be used by merchants. Channels should use the 'GET /v2/returns/channel'<br />call.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.return_get_unhandled(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            channel_ids ([int]): Filter on Channel IDs. [optional]
            page (int): The page to filter on. Starts at 1.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CollectionOfMerchantReturnResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.return_get_unhandled_endpoint.call_with_http_info(**kwargs)

    def return_update_for_merchant(
        self,
        **kwargs
    ):
        """Mark a return as received.  # noqa: E501

        Mark a return as received.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.return_update_for_merchant(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            merchant_return_update_request (MerchantReturnUpdateRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ApiResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.return_update_for_merchant_endpoint.call_with_http_info(**kwargs)

