"""
    ChannelEngine Merchant API

    ChannelEngine API for merchants  # noqa: E501

    The version of the OpenAPI document: 2.13.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from channelengine_merchant_api_client.api_client import ApiClient, Endpoint as _Endpoint
from channelengine_merchant_api_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from channelengine_merchant_api_client.model.api_response import ApiResponse
from channelengine_merchant_api_client.model.collection_of_merchant_shipment_label_carrier_response import CollectionOfMerchantShipmentLabelCarrierResponse
from channelengine_merchant_api_client.model.collection_of_merchant_shipment_response import CollectionOfMerchantShipmentResponse
from channelengine_merchant_api_client.model.merchant_channel_label_shipment_request import MerchantChannelLabelShipmentRequest
from channelengine_merchant_api_client.model.merchant_shipment_label_carrier_request import MerchantShipmentLabelCarrierRequest
from channelengine_merchant_api_client.model.merchant_shipment_request import MerchantShipmentRequest
from channelengine_merchant_api_client.model.merchant_shipment_tracking_request import MerchantShipmentTrackingRequest
from channelengine_merchant_api_client.model.shipment_fulfillment_type import ShipmentFulfillmentType


class ShipmentApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.shipment_create_endpoint = _Endpoint(
            settings={
                'response_type': (ApiResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/shipments',
                'operation_id': 'shipment_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'merchant_shipment_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'merchant_shipment_request':
                        (MerchantShipmentRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'merchant_shipment_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json-patch+json',
                    'application/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )
        self.shipment_create_for_channel_method_endpoint = _Endpoint(
            settings={
                'response_type': (ApiResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/shipments/channelmethod',
                'operation_id': 'shipment_create_for_channel_method',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'merchant_channel_label_shipment_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'merchant_channel_label_shipment_request':
                        (MerchantChannelLabelShipmentRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'merchant_channel_label_shipment_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json-patch+json',
                    'application/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )
        self.shipment_get_shipment_label_carriers_endpoint = _Endpoint(
            settings={
                'response_type': (CollectionOfMerchantShipmentLabelCarrierResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/carriers/{merchantOrderNo}',
                'operation_id': 'shipment_get_shipment_label_carriers',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'merchant_order_no',
                    'merchant_shipment_label_carrier_request',
                ],
                'required': [
                    'merchant_order_no',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'merchant_order_no':
                        (str,),
                    'merchant_shipment_label_carrier_request':
                        (MerchantShipmentLabelCarrierRequest,),
                },
                'attribute_map': {
                    'merchant_order_no': 'merchantOrderNo',
                },
                'location_map': {
                    'merchant_order_no': 'path',
                    'merchant_shipment_label_carrier_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json-patch+json',
                    'application/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )
        self.shipment_index_endpoint = _Endpoint(
            settings={
                'response_type': (CollectionOfMerchantShipmentResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/shipments/merchant',
                'operation_id': 'shipment_index',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'merchant_shipment_nos',
                    'merchant_order_nos',
                    'method',
                    'shipped_from_country_codes',
                    'from_shipment_date',
                    'to_shipment_date',
                    'from_create_date',
                    'to_create_date',
                    'from_update_date',
                    'to_update_date',
                    'fulfillment_type',
                    'channel_shipment_nos',
                    'channel_order_nos',
                    'page',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'merchant_shipment_nos':
                        ([str],),
                    'merchant_order_nos':
                        ([str],),
                    'method':
                        (str,),
                    'shipped_from_country_codes':
                        ([str],),
                    'from_shipment_date':
                        (datetime,),
                    'to_shipment_date':
                        (datetime,),
                    'from_create_date':
                        (datetime,),
                    'to_create_date':
                        (datetime,),
                    'from_update_date':
                        (datetime,),
                    'to_update_date':
                        (datetime,),
                    'fulfillment_type':
                        (ShipmentFulfillmentType,),
                    'channel_shipment_nos':
                        ([str],),
                    'channel_order_nos':
                        ([str],),
                    'page':
                        (int,),
                },
                'attribute_map': {
                    'merchant_shipment_nos': 'merchantShipmentNos',
                    'merchant_order_nos': 'merchantOrderNos',
                    'method': 'method',
                    'shipped_from_country_codes': 'shippedFromCountryCodes',
                    'from_shipment_date': 'fromShipmentDate',
                    'to_shipment_date': 'toShipmentDate',
                    'from_create_date': 'fromCreateDate',
                    'to_create_date': 'toCreateDate',
                    'from_update_date': 'fromUpdateDate',
                    'to_update_date': 'toUpdateDate',
                    'fulfillment_type': 'fulfillmentType',
                    'channel_shipment_nos': 'channelShipmentNos',
                    'channel_order_nos': 'channelOrderNos',
                    'page': 'page',
                },
                'location_map': {
                    'merchant_shipment_nos': 'query',
                    'merchant_order_nos': 'query',
                    'method': 'query',
                    'shipped_from_country_codes': 'query',
                    'from_shipment_date': 'query',
                    'to_shipment_date': 'query',
                    'from_create_date': 'query',
                    'to_create_date': 'query',
                    'from_update_date': 'query',
                    'to_update_date': 'query',
                    'fulfillment_type': 'query',
                    'channel_shipment_nos': 'query',
                    'channel_order_nos': 'query',
                    'page': 'query',
                },
                'collection_format_map': {
                    'merchant_shipment_nos': 'multi',
                    'merchant_order_nos': 'multi',
                    'shipped_from_country_codes': 'multi',
                    'channel_shipment_nos': 'multi',
                    'channel_order_nos': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.shipment_shipping_label_endpoint = _Endpoint(
            settings={
                'response_type': (file,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/orders/{merchantShipmentNo}/shippinglabel',
                'operation_id': 'shipment_shipping_label',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'merchant_shipment_no',
                ],
                'required': [
                    'merchant_shipment_no',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'merchant_shipment_no':
                        (str,),
                },
                'attribute_map': {
                    'merchant_shipment_no': 'merchantShipmentNo',
                },
                'location_map': {
                    'merchant_shipment_no': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.shippingLabel',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.shipment_update_endpoint = _Endpoint(
            settings={
                'response_type': (ApiResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/shipments/{merchantShipmentNo}',
                'operation_id': 'shipment_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'merchant_shipment_no',
                    'merchant_shipment_tracking_request',
                ],
                'required': [
                    'merchant_shipment_no',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'merchant_shipment_no':
                        (str,),
                    'merchant_shipment_tracking_request':
                        (MerchantShipmentTrackingRequest,),
                },
                'attribute_map': {
                    'merchant_shipment_no': 'merchantShipmentNo',
                },
                'location_map': {
                    'merchant_shipment_no': 'path',
                    'merchant_shipment_tracking_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json-patch+json',
                    'application/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )

    def shipment_create(
        self,
        **kwargs
    ):
        """Create Shipment.  # noqa: E501

        Mark (part of) an order as shipped.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.shipment_create(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            merchant_shipment_request (MerchantShipmentRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ApiResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.shipment_create_endpoint.call_with_http_info(**kwargs)

    def shipment_create_for_channel_method(
        self,
        **kwargs
    ):
        """Create shipment for channel provided shipping labels  # noqa: E501

        Create a shipment, which will request a shipping label from the channel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.shipment_create_for_channel_method(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            merchant_channel_label_shipment_request (MerchantChannelLabelShipmentRequest): The shipment to create. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ApiResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.shipment_create_for_channel_method_endpoint.call_with_http_info(**kwargs)

    def shipment_get_shipment_label_carriers(
        self,
        merchant_order_no,
        **kwargs
    ):
        """Get carriers for channel provided shipping labels  # noqa: E501

        Get the carriers for buying a shipping label from the channel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.shipment_get_shipment_label_carriers(merchant_order_no, async_req=True)
        >>> result = thread.get()

        Args:
            merchant_order_no (str): The merchant's order reference.

        Keyword Args:
            merchant_shipment_label_carrier_request (MerchantShipmentLabelCarrierRequest): The parcel information. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CollectionOfMerchantShipmentLabelCarrierResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['merchant_order_no'] = \
            merchant_order_no
        return self.shipment_get_shipment_label_carriers_endpoint.call_with_http_info(**kwargs)

    def shipment_index(
        self,
        **kwargs
    ):
        """Get Shipments  # noqa: E501

        Gets all shipments that meet conditions.<br />If all filters are empty return all in default order (from the oldest one).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.shipment_index(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            merchant_shipment_nos ([str]): Filter on the unique references (ids) as used by the merchant.. [optional]
            merchant_order_nos ([str]): Filter on the unique references (ids) of order as used by the merchant.. [optional]
            method (str): Filter on the shipping method.. [optional]
            shipped_from_country_codes ([str]): 2-digit Country code. [optional]
            from_shipment_date (datetime): Filter on the shipment date, starting from this date. This date is inclusive.. [optional]
            to_shipment_date (datetime): Filter on the shipment date, until this date. This date is exclusive.. [optional]
            from_create_date (datetime): Filter on the create date of the shipment in ChannelEngine, starting from this date. This date is inclusive.. [optional]
            to_create_date (datetime): Filter on the create date of the shipment in ChannelEngine, until this date. This date is exclusive.. [optional]
            from_update_date (datetime): Filter on the update date of the shipment in ChannelEngine, starting from this date. This date is inclusive.. [optional]
            to_update_date (datetime): Filter on the update date of the shipment in ChannelEngine, until this date. This date is exclusive.. [optional]
            fulfillment_type (ShipmentFulfillmentType): Filter on the fulfillment type of the shipment.. [optional]
            channel_shipment_nos ([str]): Filter on the unique references (ids) as used by the channel.. [optional]
            channel_order_nos ([str]): Filter on the unique references (ids) of order as used by the channel.. [optional]
            page (int): The page to filter on. Starts at 1.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CollectionOfMerchantShipmentResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.shipment_index_endpoint.call_with_http_info(**kwargs)

    def shipment_shipping_label(
        self,
        merchant_shipment_no,
        **kwargs
    ):
        """Download shipping label.  # noqa: E501

        Downloads the shipping label for the shipment. There may pass some time between creating the shipment<br />and the availability of the label. So '404 Not Found' might incidate it is not available yet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.shipment_shipping_label(merchant_shipment_no, async_req=True)
        >>> result = thread.get()

        Args:
            merchant_shipment_no (str): The unique shipment reference as used by the merchant.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['merchant_shipment_no'] = \
            merchant_shipment_no
        return self.shipment_shipping_label_endpoint.call_with_http_info(**kwargs)

    def shipment_update(
        self,
        merchant_shipment_no,
        **kwargs
    ):
        """Update Shipment.  # noqa: E501

        Update an existing shipment with tracking information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.shipment_update(merchant_shipment_no, async_req=True)
        >>> result = thread.get()

        Args:
            merchant_shipment_no (str): The merchant's shipment reference.

        Keyword Args:
            merchant_shipment_tracking_request (MerchantShipmentTrackingRequest): The updated tracking information.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ApiResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['merchant_shipment_no'] = \
            merchant_shipment_no
        return self.shipment_update_endpoint.call_with_http_info(**kwargs)

