# coding: utf-8

"""
    ChannelEngine Merchant API

    ChannelEngine API for merchants  # noqa: E501

    The version of the OpenAPI document: 2.9.10
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from channelengine_merchant_api_client.configuration import Configuration


class MerchantChannelLabelShipmentRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'dimensions': 'MerchantShipmentPackageDimensionsRequest',
        'weight': 'MerchantShipmentPackageWeightRequest',
        'channel_method_code': 'str',
        'merchant_shipment_no': 'str',
        'merchant_order_no': 'str',
        'shipped_from_country_code': 'str',
        'lines': 'list[MerchantShipmentLineRequest]'
    }

    attribute_map = {
        'dimensions': 'Dimensions',
        'weight': 'Weight',
        'channel_method_code': 'ChannelMethodCode',
        'merchant_shipment_no': 'MerchantShipmentNo',
        'merchant_order_no': 'MerchantOrderNo',
        'shipped_from_country_code': 'ShippedFromCountryCode',
        'lines': 'Lines'
    }

    def __init__(self, dimensions=None, weight=None, channel_method_code=None, merchant_shipment_no=None, merchant_order_no=None, shipped_from_country_code=None, lines=None, local_vars_configuration=None):  # noqa: E501
        """MerchantChannelLabelShipmentRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._dimensions = None
        self._weight = None
        self._channel_method_code = None
        self._merchant_shipment_no = None
        self._merchant_order_no = None
        self._shipped_from_country_code = None
        self._lines = None
        self.discriminator = None

        self.dimensions = dimensions
        self.weight = weight
        self.channel_method_code = channel_method_code
        self.merchant_shipment_no = merchant_shipment_no
        self.merchant_order_no = merchant_order_no
        self.shipped_from_country_code = shipped_from_country_code
        self.lines = lines

    @property
    def dimensions(self):
        """Gets the dimensions of this MerchantChannelLabelShipmentRequest.  # noqa: E501


        :return: The dimensions of this MerchantChannelLabelShipmentRequest.  # noqa: E501
        :rtype: MerchantShipmentPackageDimensionsRequest
        """
        return self._dimensions

    @dimensions.setter
    def dimensions(self, dimensions):
        """Sets the dimensions of this MerchantChannelLabelShipmentRequest.


        :param dimensions: The dimensions of this MerchantChannelLabelShipmentRequest.  # noqa: E501
        :type dimensions: MerchantShipmentPackageDimensionsRequest
        """
        if self.local_vars_configuration.client_side_validation and dimensions is None:  # noqa: E501
            raise ValueError("Invalid value for `dimensions`, must not be `None`")  # noqa: E501

        self._dimensions = dimensions

    @property
    def weight(self):
        """Gets the weight of this MerchantChannelLabelShipmentRequest.  # noqa: E501


        :return: The weight of this MerchantChannelLabelShipmentRequest.  # noqa: E501
        :rtype: MerchantShipmentPackageWeightRequest
        """
        return self._weight

    @weight.setter
    def weight(self, weight):
        """Sets the weight of this MerchantChannelLabelShipmentRequest.


        :param weight: The weight of this MerchantChannelLabelShipmentRequest.  # noqa: E501
        :type weight: MerchantShipmentPackageWeightRequest
        """
        if self.local_vars_configuration.client_side_validation and weight is None:  # noqa: E501
            raise ValueError("Invalid value for `weight`, must not be `None`")  # noqa: E501

        self._weight = weight

    @property
    def channel_method_code(self):
        """Gets the channel_method_code of this MerchantChannelLabelShipmentRequest.  # noqa: E501


        :return: The channel_method_code of this MerchantChannelLabelShipmentRequest.  # noqa: E501
        :rtype: str
        """
        return self._channel_method_code

    @channel_method_code.setter
    def channel_method_code(self, channel_method_code):
        """Sets the channel_method_code of this MerchantChannelLabelShipmentRequest.


        :param channel_method_code: The channel_method_code of this MerchantChannelLabelShipmentRequest.  # noqa: E501
        :type channel_method_code: str
        """
        if self.local_vars_configuration.client_side_validation and channel_method_code is None:  # noqa: E501
            raise ValueError("Invalid value for `channel_method_code`, must not be `None`")  # noqa: E501

        self._channel_method_code = channel_method_code

    @property
    def merchant_shipment_no(self):
        """Gets the merchant_shipment_no of this MerchantChannelLabelShipmentRequest.  # noqa: E501

        The unique shipment reference used by the Merchant.  # noqa: E501

        :return: The merchant_shipment_no of this MerchantChannelLabelShipmentRequest.  # noqa: E501
        :rtype: str
        """
        return self._merchant_shipment_no

    @merchant_shipment_no.setter
    def merchant_shipment_no(self, merchant_shipment_no):
        """Sets the merchant_shipment_no of this MerchantChannelLabelShipmentRequest.

        The unique shipment reference used by the Merchant.  # noqa: E501

        :param merchant_shipment_no: The merchant_shipment_no of this MerchantChannelLabelShipmentRequest.  # noqa: E501
        :type merchant_shipment_no: str
        """
        if self.local_vars_configuration.client_side_validation and merchant_shipment_no is None:  # noqa: E501
            raise ValueError("Invalid value for `merchant_shipment_no`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                merchant_shipment_no is not None and len(merchant_shipment_no) > 250):
            raise ValueError("Invalid value for `merchant_shipment_no`, length must be less than or equal to `250`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                merchant_shipment_no is not None and len(merchant_shipment_no) < 0):
            raise ValueError("Invalid value for `merchant_shipment_no`, length must be greater than or equal to `0`")  # noqa: E501

        self._merchant_shipment_no = merchant_shipment_no

    @property
    def merchant_order_no(self):
        """Gets the merchant_order_no of this MerchantChannelLabelShipmentRequest.  # noqa: E501

        The unique order reference used by the Merchant.  # noqa: E501

        :return: The merchant_order_no of this MerchantChannelLabelShipmentRequest.  # noqa: E501
        :rtype: str
        """
        return self._merchant_order_no

    @merchant_order_no.setter
    def merchant_order_no(self, merchant_order_no):
        """Sets the merchant_order_no of this MerchantChannelLabelShipmentRequest.

        The unique order reference used by the Merchant.  # noqa: E501

        :param merchant_order_no: The merchant_order_no of this MerchantChannelLabelShipmentRequest.  # noqa: E501
        :type merchant_order_no: str
        """
        if self.local_vars_configuration.client_side_validation and merchant_order_no is None:  # noqa: E501
            raise ValueError("Invalid value for `merchant_order_no`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                merchant_order_no is not None and len(merchant_order_no) > 50):
            raise ValueError("Invalid value for `merchant_order_no`, length must be less than or equal to `50`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                merchant_order_no is not None and len(merchant_order_no) < 0):
            raise ValueError("Invalid value for `merchant_order_no`, length must be greater than or equal to `0`")  # noqa: E501

        self._merchant_order_no = merchant_order_no

    @property
    def shipped_from_country_code(self):
        """Gets the shipped_from_country_code of this MerchantChannelLabelShipmentRequest.  # noqa: E501

        The code of the country from where the package is being shipped.  # noqa: E501

        :return: The shipped_from_country_code of this MerchantChannelLabelShipmentRequest.  # noqa: E501
        :rtype: str
        """
        return self._shipped_from_country_code

    @shipped_from_country_code.setter
    def shipped_from_country_code(self, shipped_from_country_code):
        """Sets the shipped_from_country_code of this MerchantChannelLabelShipmentRequest.

        The code of the country from where the package is being shipped.  # noqa: E501

        :param shipped_from_country_code: The shipped_from_country_code of this MerchantChannelLabelShipmentRequest.  # noqa: E501
        :type shipped_from_country_code: str
        """
        if (self.local_vars_configuration.client_side_validation and
                shipped_from_country_code is not None and len(shipped_from_country_code) > 3):
            raise ValueError("Invalid value for `shipped_from_country_code`, length must be less than or equal to `3`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                shipped_from_country_code is not None and len(shipped_from_country_code) < 0):
            raise ValueError("Invalid value for `shipped_from_country_code`, length must be greater than or equal to `0`")  # noqa: E501

        self._shipped_from_country_code = shipped_from_country_code

    @property
    def lines(self):
        """Gets the lines of this MerchantChannelLabelShipmentRequest.  # noqa: E501


        :return: The lines of this MerchantChannelLabelShipmentRequest.  # noqa: E501
        :rtype: list[MerchantShipmentLineRequest]
        """
        return self._lines

    @lines.setter
    def lines(self, lines):
        """Sets the lines of this MerchantChannelLabelShipmentRequest.


        :param lines: The lines of this MerchantChannelLabelShipmentRequest.  # noqa: E501
        :type lines: list[MerchantShipmentLineRequest]
        """
        if self.local_vars_configuration.client_side_validation and lines is None:  # noqa: E501
            raise ValueError("Invalid value for `lines`, must not be `None`")  # noqa: E501

        self._lines = lines

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MerchantChannelLabelShipmentRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MerchantChannelLabelShipmentRequest):
            return True

        return self.to_dict() != other.to_dict()
