# coding: utf-8

"""
    ChannelEngine Merchant API

    ChannelEngine API for merchants  # noqa: E501

    The version of the OpenAPI document: 2.9.10
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from channelengine_merchant_api_client.configuration import Configuration


class MerchantOrderResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'channel_name': 'str',
        'channel_id': 'int',
        'global_channel_name': 'str',
        'global_channel_id': 'int',
        'channel_order_support': 'OrderSupport',
        'channel_order_no': 'str',
        'merchant_order_no': 'str',
        'status': 'OrderStatusView',
        'is_business_order': 'bool',
        'created_at': 'datetime',
        'updated_at': 'datetime',
        'merchant_comment': 'str',
        'billing_address': 'MerchantAddressResponse',
        'shipping_address': 'MerchantAddressResponse',
        'sub_total_incl_vat': 'float',
        'sub_total_vat': 'float',
        'shipping_costs_vat': 'float',
        'total_incl_vat': 'float',
        'total_vat': 'float',
        'original_sub_total_incl_vat': 'float',
        'original_sub_total_vat': 'float',
        'original_shipping_costs_incl_vat': 'float',
        'original_shipping_costs_vat': 'float',
        'original_total_incl_vat': 'float',
        'original_total_vat': 'float',
        'lines': 'list[MerchantOrderLineResponse]',
        'phone': 'str',
        'email': 'str',
        'company_registration_no': 'str',
        'vat_no': 'str',
        'payment_method': 'str',
        'payment_reference_no': 'str',
        'shipping_costs_incl_vat': 'float',
        'currency_code': 'str',
        'order_date': 'datetime',
        'channel_customer_no': 'str',
        'extra_data': 'dict(str, str)'
    }

    attribute_map = {
        'id': 'Id',
        'channel_name': 'ChannelName',
        'channel_id': 'ChannelId',
        'global_channel_name': 'GlobalChannelName',
        'global_channel_id': 'GlobalChannelId',
        'channel_order_support': 'ChannelOrderSupport',
        'channel_order_no': 'ChannelOrderNo',
        'merchant_order_no': 'MerchantOrderNo',
        'status': 'Status',
        'is_business_order': 'IsBusinessOrder',
        'created_at': 'CreatedAt',
        'updated_at': 'UpdatedAt',
        'merchant_comment': 'MerchantComment',
        'billing_address': 'BillingAddress',
        'shipping_address': 'ShippingAddress',
        'sub_total_incl_vat': 'SubTotalInclVat',
        'sub_total_vat': 'SubTotalVat',
        'shipping_costs_vat': 'ShippingCostsVat',
        'total_incl_vat': 'TotalInclVat',
        'total_vat': 'TotalVat',
        'original_sub_total_incl_vat': 'OriginalSubTotalInclVat',
        'original_sub_total_vat': 'OriginalSubTotalVat',
        'original_shipping_costs_incl_vat': 'OriginalShippingCostsInclVat',
        'original_shipping_costs_vat': 'OriginalShippingCostsVat',
        'original_total_incl_vat': 'OriginalTotalInclVat',
        'original_total_vat': 'OriginalTotalVat',
        'lines': 'Lines',
        'phone': 'Phone',
        'email': 'Email',
        'company_registration_no': 'CompanyRegistrationNo',
        'vat_no': 'VatNo',
        'payment_method': 'PaymentMethod',
        'payment_reference_no': 'PaymentReferenceNo',
        'shipping_costs_incl_vat': 'ShippingCostsInclVat',
        'currency_code': 'CurrencyCode',
        'order_date': 'OrderDate',
        'channel_customer_no': 'ChannelCustomerNo',
        'extra_data': 'ExtraData'
    }

    def __init__(self, id=None, channel_name=None, channel_id=None, global_channel_name=None, global_channel_id=None, channel_order_support=None, channel_order_no=None, merchant_order_no=None, status=None, is_business_order=None, created_at=None, updated_at=None, merchant_comment=None, billing_address=None, shipping_address=None, sub_total_incl_vat=None, sub_total_vat=None, shipping_costs_vat=None, total_incl_vat=None, total_vat=None, original_sub_total_incl_vat=None, original_sub_total_vat=None, original_shipping_costs_incl_vat=None, original_shipping_costs_vat=None, original_total_incl_vat=None, original_total_vat=None, lines=None, phone=None, email=None, company_registration_no=None, vat_no=None, payment_method=None, payment_reference_no=None, shipping_costs_incl_vat=None, currency_code=None, order_date=None, channel_customer_no=None, extra_data=None, local_vars_configuration=None):  # noqa: E501
        """MerchantOrderResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._channel_name = None
        self._channel_id = None
        self._global_channel_name = None
        self._global_channel_id = None
        self._channel_order_support = None
        self._channel_order_no = None
        self._merchant_order_no = None
        self._status = None
        self._is_business_order = None
        self._created_at = None
        self._updated_at = None
        self._merchant_comment = None
        self._billing_address = None
        self._shipping_address = None
        self._sub_total_incl_vat = None
        self._sub_total_vat = None
        self._shipping_costs_vat = None
        self._total_incl_vat = None
        self._total_vat = None
        self._original_sub_total_incl_vat = None
        self._original_sub_total_vat = None
        self._original_shipping_costs_incl_vat = None
        self._original_shipping_costs_vat = None
        self._original_total_incl_vat = None
        self._original_total_vat = None
        self._lines = None
        self._phone = None
        self._email = None
        self._company_registration_no = None
        self._vat_no = None
        self._payment_method = None
        self._payment_reference_no = None
        self._shipping_costs_incl_vat = None
        self._currency_code = None
        self._order_date = None
        self._channel_customer_no = None
        self._extra_data = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.channel_name = channel_name
        self.channel_id = channel_id
        self.global_channel_name = global_channel_name
        self.global_channel_id = global_channel_id
        if channel_order_support is not None:
            self.channel_order_support = channel_order_support
        self.channel_order_no = channel_order_no
        self.merchant_order_no = merchant_order_no
        if status is not None:
            self.status = status
        if is_business_order is not None:
            self.is_business_order = is_business_order
        self.created_at = created_at
        self.updated_at = updated_at
        self.merchant_comment = merchant_comment
        self.billing_address = billing_address
        self.shipping_address = shipping_address
        self.sub_total_incl_vat = sub_total_incl_vat
        self.sub_total_vat = sub_total_vat
        self.shipping_costs_vat = shipping_costs_vat
        if total_incl_vat is not None:
            self.total_incl_vat = total_incl_vat
        self.total_vat = total_vat
        self.original_sub_total_incl_vat = original_sub_total_incl_vat
        self.original_sub_total_vat = original_sub_total_vat
        self.original_shipping_costs_incl_vat = original_shipping_costs_incl_vat
        self.original_shipping_costs_vat = original_shipping_costs_vat
        self.original_total_incl_vat = original_total_incl_vat
        self.original_total_vat = original_total_vat
        self.lines = lines
        self.phone = phone
        self.email = email
        self.company_registration_no = company_registration_no
        self.vat_no = vat_no
        self.payment_method = payment_method
        self.payment_reference_no = payment_reference_no
        self.shipping_costs_incl_vat = shipping_costs_incl_vat
        self.currency_code = currency_code
        self.order_date = order_date
        self.channel_customer_no = channel_customer_no
        self.extra_data = extra_data

    @property
    def id(self):
        """Gets the id of this MerchantOrderResponse.  # noqa: E501

        The unique identifier used by ChannelEngine. This identifier does  not have to be saved. It should only be used in a call to acknowledge the order.  # noqa: E501

        :return: The id of this MerchantOrderResponse.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this MerchantOrderResponse.

        The unique identifier used by ChannelEngine. This identifier does  not have to be saved. It should only be used in a call to acknowledge the order.  # noqa: E501

        :param id: The id of this MerchantOrderResponse.  # noqa: E501
        :type id: int
        """

        self._id = id

    @property
    def channel_name(self):
        """Gets the channel_name of this MerchantOrderResponse.  # noqa: E501

        The name of the channel for this specific environment/account.  # noqa: E501

        :return: The channel_name of this MerchantOrderResponse.  # noqa: E501
        :rtype: str
        """
        return self._channel_name

    @channel_name.setter
    def channel_name(self, channel_name):
        """Sets the channel_name of this MerchantOrderResponse.

        The name of the channel for this specific environment/account.  # noqa: E501

        :param channel_name: The channel_name of this MerchantOrderResponse.  # noqa: E501
        :type channel_name: str
        """

        self._channel_name = channel_name

    @property
    def channel_id(self):
        """Gets the channel_id of this MerchantOrderResponse.  # noqa: E501

        The unique ID of the channel for this specific environment/account.  # noqa: E501

        :return: The channel_id of this MerchantOrderResponse.  # noqa: E501
        :rtype: int
        """
        return self._channel_id

    @channel_id.setter
    def channel_id(self, channel_id):
        """Sets the channel_id of this MerchantOrderResponse.

        The unique ID of the channel for this specific environment/account.  # noqa: E501

        :param channel_id: The channel_id of this MerchantOrderResponse.  # noqa: E501
        :type channel_id: int
        """

        self._channel_id = channel_id

    @property
    def global_channel_name(self):
        """Gets the global_channel_name of this MerchantOrderResponse.  # noqa: E501

        The name of the channel across all of ChannelEngine.  # noqa: E501

        :return: The global_channel_name of this MerchantOrderResponse.  # noqa: E501
        :rtype: str
        """
        return self._global_channel_name

    @global_channel_name.setter
    def global_channel_name(self, global_channel_name):
        """Sets the global_channel_name of this MerchantOrderResponse.

        The name of the channel across all of ChannelEngine.  # noqa: E501

        :param global_channel_name: The global_channel_name of this MerchantOrderResponse.  # noqa: E501
        :type global_channel_name: str
        """

        self._global_channel_name = global_channel_name

    @property
    def global_channel_id(self):
        """Gets the global_channel_id of this MerchantOrderResponse.  # noqa: E501

        The unique ID of the channel across all of ChannelEngine.  # noqa: E501

        :return: The global_channel_id of this MerchantOrderResponse.  # noqa: E501
        :rtype: int
        """
        return self._global_channel_id

    @global_channel_id.setter
    def global_channel_id(self, global_channel_id):
        """Sets the global_channel_id of this MerchantOrderResponse.

        The unique ID of the channel across all of ChannelEngine.  # noqa: E501

        :param global_channel_id: The global_channel_id of this MerchantOrderResponse.  # noqa: E501
        :type global_channel_id: int
        """

        self._global_channel_id = global_channel_id

    @property
    def channel_order_support(self):
        """Gets the channel_order_support of this MerchantOrderResponse.  # noqa: E501

        The type of orders the channel support.  # noqa: E501

        :return: The channel_order_support of this MerchantOrderResponse.  # noqa: E501
        :rtype: OrderSupport
        """
        return self._channel_order_support

    @channel_order_support.setter
    def channel_order_support(self, channel_order_support):
        """Sets the channel_order_support of this MerchantOrderResponse.

        The type of orders the channel support.  # noqa: E501

        :param channel_order_support: The channel_order_support of this MerchantOrderResponse.  # noqa: E501
        :type channel_order_support: OrderSupport
        """

        self._channel_order_support = channel_order_support

    @property
    def channel_order_no(self):
        """Gets the channel_order_no of this MerchantOrderResponse.  # noqa: E501

        The order reference used by the channel.  This number is not guaranteed to be unique accross all orders,  because different channels can use the same order number format.  # noqa: E501

        :return: The channel_order_no of this MerchantOrderResponse.  # noqa: E501
        :rtype: str
        """
        return self._channel_order_no

    @channel_order_no.setter
    def channel_order_no(self, channel_order_no):
        """Sets the channel_order_no of this MerchantOrderResponse.

        The order reference used by the channel.  This number is not guaranteed to be unique accross all orders,  because different channels can use the same order number format.  # noqa: E501

        :param channel_order_no: The channel_order_no of this MerchantOrderResponse.  # noqa: E501
        :type channel_order_no: str
        """

        self._channel_order_no = channel_order_no

    @property
    def merchant_order_no(self):
        """Gets the merchant_order_no of this MerchantOrderResponse.  # noqa: E501

        The unique order reference used by the Merchant  # noqa: E501

        :return: The merchant_order_no of this MerchantOrderResponse.  # noqa: E501
        :rtype: str
        """
        return self._merchant_order_no

    @merchant_order_no.setter
    def merchant_order_no(self, merchant_order_no):
        """Sets the merchant_order_no of this MerchantOrderResponse.

        The unique order reference used by the Merchant  # noqa: E501

        :param merchant_order_no: The merchant_order_no of this MerchantOrderResponse.  # noqa: E501
        :type merchant_order_no: str
        """

        self._merchant_order_no = merchant_order_no

    @property
    def status(self):
        """Gets the status of this MerchantOrderResponse.  # noqa: E501

        The status of the order.  # noqa: E501

        :return: The status of this MerchantOrderResponse.  # noqa: E501
        :rtype: OrderStatusView
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this MerchantOrderResponse.

        The status of the order.  # noqa: E501

        :param status: The status of this MerchantOrderResponse.  # noqa: E501
        :type status: OrderStatusView
        """

        self._status = status

    @property
    def is_business_order(self):
        """Gets the is_business_order of this MerchantOrderResponse.  # noqa: E501

        Indicating whether the order is a business order.  # noqa: E501

        :return: The is_business_order of this MerchantOrderResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_business_order

    @is_business_order.setter
    def is_business_order(self, is_business_order):
        """Sets the is_business_order of this MerchantOrderResponse.

        Indicating whether the order is a business order.  # noqa: E501

        :param is_business_order: The is_business_order of this MerchantOrderResponse.  # noqa: E501
        :type is_business_order: bool
        """

        self._is_business_order = is_business_order

    @property
    def created_at(self):
        """Gets the created_at of this MerchantOrderResponse.  # noqa: E501

        The date the order was created in ChannelEngine.  # noqa: E501

        :return: The created_at of this MerchantOrderResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this MerchantOrderResponse.

        The date the order was created in ChannelEngine.  # noqa: E501

        :param created_at: The created_at of this MerchantOrderResponse.  # noqa: E501
        :type created_at: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this MerchantOrderResponse.  # noqa: E501

        The date the order was last updated in ChannelEngine.  # noqa: E501

        :return: The updated_at of this MerchantOrderResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this MerchantOrderResponse.

        The date the order was last updated in ChannelEngine.  # noqa: E501

        :param updated_at: The updated_at of this MerchantOrderResponse.  # noqa: E501
        :type updated_at: datetime
        """

        self._updated_at = updated_at

    @property
    def merchant_comment(self):
        """Gets the merchant_comment of this MerchantOrderResponse.  # noqa: E501

        The optional comment a merchant can add to an order.  # noqa: E501

        :return: The merchant_comment of this MerchantOrderResponse.  # noqa: E501
        :rtype: str
        """
        return self._merchant_comment

    @merchant_comment.setter
    def merchant_comment(self, merchant_comment):
        """Sets the merchant_comment of this MerchantOrderResponse.

        The optional comment a merchant can add to an order.  # noqa: E501

        :param merchant_comment: The merchant_comment of this MerchantOrderResponse.  # noqa: E501
        :type merchant_comment: str
        """

        self._merchant_comment = merchant_comment

    @property
    def billing_address(self):
        """Gets the billing_address of this MerchantOrderResponse.  # noqa: E501

        The billing or invoice address.  # noqa: E501

        :return: The billing_address of this MerchantOrderResponse.  # noqa: E501
        :rtype: MerchantAddressResponse
        """
        return self._billing_address

    @billing_address.setter
    def billing_address(self, billing_address):
        """Sets the billing_address of this MerchantOrderResponse.

        The billing or invoice address.  # noqa: E501

        :param billing_address: The billing_address of this MerchantOrderResponse.  # noqa: E501
        :type billing_address: MerchantAddressResponse
        """

        self._billing_address = billing_address

    @property
    def shipping_address(self):
        """Gets the shipping_address of this MerchantOrderResponse.  # noqa: E501

        The shipping address.  # noqa: E501

        :return: The shipping_address of this MerchantOrderResponse.  # noqa: E501
        :rtype: MerchantAddressResponse
        """
        return self._shipping_address

    @shipping_address.setter
    def shipping_address(self, shipping_address):
        """Sets the shipping_address of this MerchantOrderResponse.

        The shipping address.  # noqa: E501

        :param shipping_address: The shipping_address of this MerchantOrderResponse.  # noqa: E501
        :type shipping_address: MerchantAddressResponse
        """

        self._shipping_address = shipping_address

    @property
    def sub_total_incl_vat(self):
        """Gets the sub_total_incl_vat of this MerchantOrderResponse.  # noqa: E501

        The total value of the order lines including VAT  (in the shop's base currency calculated using the exchange rate at the time of ordering).  # noqa: E501

        :return: The sub_total_incl_vat of this MerchantOrderResponse.  # noqa: E501
        :rtype: float
        """
        return self._sub_total_incl_vat

    @sub_total_incl_vat.setter
    def sub_total_incl_vat(self, sub_total_incl_vat):
        """Sets the sub_total_incl_vat of this MerchantOrderResponse.

        The total value of the order lines including VAT  (in the shop's base currency calculated using the exchange rate at the time of ordering).  # noqa: E501

        :param sub_total_incl_vat: The sub_total_incl_vat of this MerchantOrderResponse.  # noqa: E501
        :type sub_total_incl_vat: float
        """

        self._sub_total_incl_vat = sub_total_incl_vat

    @property
    def sub_total_vat(self):
        """Gets the sub_total_vat of this MerchantOrderResponse.  # noqa: E501

        The total amount of VAT charged over the order lines  (in the shop's base currency calculated using the exchange rate at the time of ordering).  # noqa: E501

        :return: The sub_total_vat of this MerchantOrderResponse.  # noqa: E501
        :rtype: float
        """
        return self._sub_total_vat

    @sub_total_vat.setter
    def sub_total_vat(self, sub_total_vat):
        """Sets the sub_total_vat of this MerchantOrderResponse.

        The total amount of VAT charged over the order lines  (in the shop's base currency calculated using the exchange rate at the time of ordering).  # noqa: E501

        :param sub_total_vat: The sub_total_vat of this MerchantOrderResponse.  # noqa: E501
        :type sub_total_vat: float
        """

        self._sub_total_vat = sub_total_vat

    @property
    def shipping_costs_vat(self):
        """Gets the shipping_costs_vat of this MerchantOrderResponse.  # noqa: E501

        The total amount of VAT charged over the shipping fee  (in the shop's base currency calculated using the exchange rate at the time of ordering).  # noqa: E501

        :return: The shipping_costs_vat of this MerchantOrderResponse.  # noqa: E501
        :rtype: float
        """
        return self._shipping_costs_vat

    @shipping_costs_vat.setter
    def shipping_costs_vat(self, shipping_costs_vat):
        """Sets the shipping_costs_vat of this MerchantOrderResponse.

        The total amount of VAT charged over the shipping fee  (in the shop's base currency calculated using the exchange rate at the time of ordering).  # noqa: E501

        :param shipping_costs_vat: The shipping_costs_vat of this MerchantOrderResponse.  # noqa: E501
        :type shipping_costs_vat: float
        """

        self._shipping_costs_vat = shipping_costs_vat

    @property
    def total_incl_vat(self):
        """Gets the total_incl_vat of this MerchantOrderResponse.  # noqa: E501

        The total value of the order including VAT  (in the shop's base currency calculated using the exchange rate at the time of ordering).  # noqa: E501

        :return: The total_incl_vat of this MerchantOrderResponse.  # noqa: E501
        :rtype: float
        """
        return self._total_incl_vat

    @total_incl_vat.setter
    def total_incl_vat(self, total_incl_vat):
        """Sets the total_incl_vat of this MerchantOrderResponse.

        The total value of the order including VAT  (in the shop's base currency calculated using the exchange rate at the time of ordering).  # noqa: E501

        :param total_incl_vat: The total_incl_vat of this MerchantOrderResponse.  # noqa: E501
        :type total_incl_vat: float
        """

        self._total_incl_vat = total_incl_vat

    @property
    def total_vat(self):
        """Gets the total_vat of this MerchantOrderResponse.  # noqa: E501

        The total amount of VAT charged over the total value of te order  (in the shop's base currency calculated using the exchange rate at the time of ordering).  # noqa: E501

        :return: The total_vat of this MerchantOrderResponse.  # noqa: E501
        :rtype: float
        """
        return self._total_vat

    @total_vat.setter
    def total_vat(self, total_vat):
        """Sets the total_vat of this MerchantOrderResponse.

        The total amount of VAT charged over the total value of te order  (in the shop's base currency calculated using the exchange rate at the time of ordering).  # noqa: E501

        :param total_vat: The total_vat of this MerchantOrderResponse.  # noqa: E501
        :type total_vat: float
        """

        self._total_vat = total_vat

    @property
    def original_sub_total_incl_vat(self):
        """Gets the original_sub_total_incl_vat of this MerchantOrderResponse.  # noqa: E501

        The total value of the order lines including VAT  (in the currency in which the order was paid for, see CurrencyCode).  # noqa: E501

        :return: The original_sub_total_incl_vat of this MerchantOrderResponse.  # noqa: E501
        :rtype: float
        """
        return self._original_sub_total_incl_vat

    @original_sub_total_incl_vat.setter
    def original_sub_total_incl_vat(self, original_sub_total_incl_vat):
        """Sets the original_sub_total_incl_vat of this MerchantOrderResponse.

        The total value of the order lines including VAT  (in the currency in which the order was paid for, see CurrencyCode).  # noqa: E501

        :param original_sub_total_incl_vat: The original_sub_total_incl_vat of this MerchantOrderResponse.  # noqa: E501
        :type original_sub_total_incl_vat: float
        """

        self._original_sub_total_incl_vat = original_sub_total_incl_vat

    @property
    def original_sub_total_vat(self):
        """Gets the original_sub_total_vat of this MerchantOrderResponse.  # noqa: E501

        The total amount of VAT charged over the order lines  (in the currency in which the order was paid for, see CurrencyCode).  # noqa: E501

        :return: The original_sub_total_vat of this MerchantOrderResponse.  # noqa: E501
        :rtype: float
        """
        return self._original_sub_total_vat

    @original_sub_total_vat.setter
    def original_sub_total_vat(self, original_sub_total_vat):
        """Sets the original_sub_total_vat of this MerchantOrderResponse.

        The total amount of VAT charged over the order lines  (in the currency in which the order was paid for, see CurrencyCode).  # noqa: E501

        :param original_sub_total_vat: The original_sub_total_vat of this MerchantOrderResponse.  # noqa: E501
        :type original_sub_total_vat: float
        """

        self._original_sub_total_vat = original_sub_total_vat

    @property
    def original_shipping_costs_incl_vat(self):
        """Gets the original_shipping_costs_incl_vat of this MerchantOrderResponse.  # noqa: E501

        The shipping fee including VAT  (in the currency in which the order was paid for, see CurrencyCode).  # noqa: E501

        :return: The original_shipping_costs_incl_vat of this MerchantOrderResponse.  # noqa: E501
        :rtype: float
        """
        return self._original_shipping_costs_incl_vat

    @original_shipping_costs_incl_vat.setter
    def original_shipping_costs_incl_vat(self, original_shipping_costs_incl_vat):
        """Sets the original_shipping_costs_incl_vat of this MerchantOrderResponse.

        The shipping fee including VAT  (in the currency in which the order was paid for, see CurrencyCode).  # noqa: E501

        :param original_shipping_costs_incl_vat: The original_shipping_costs_incl_vat of this MerchantOrderResponse.  # noqa: E501
        :type original_shipping_costs_incl_vat: float
        """

        self._original_shipping_costs_incl_vat = original_shipping_costs_incl_vat

    @property
    def original_shipping_costs_vat(self):
        """Gets the original_shipping_costs_vat of this MerchantOrderResponse.  # noqa: E501

        The total amount of VAT charged over the shipping fee  (in the currency in which the order was paid for, see CurrencyCode).  # noqa: E501

        :return: The original_shipping_costs_vat of this MerchantOrderResponse.  # noqa: E501
        :rtype: float
        """
        return self._original_shipping_costs_vat

    @original_shipping_costs_vat.setter
    def original_shipping_costs_vat(self, original_shipping_costs_vat):
        """Sets the original_shipping_costs_vat of this MerchantOrderResponse.

        The total amount of VAT charged over the shipping fee  (in the currency in which the order was paid for, see CurrencyCode).  # noqa: E501

        :param original_shipping_costs_vat: The original_shipping_costs_vat of this MerchantOrderResponse.  # noqa: E501
        :type original_shipping_costs_vat: float
        """

        self._original_shipping_costs_vat = original_shipping_costs_vat

    @property
    def original_total_incl_vat(self):
        """Gets the original_total_incl_vat of this MerchantOrderResponse.  # noqa: E501

        The total value of the order including VAT  (in the currency in which the order was paid for, see CurrencyCode).  # noqa: E501

        :return: The original_total_incl_vat of this MerchantOrderResponse.  # noqa: E501
        :rtype: float
        """
        return self._original_total_incl_vat

    @original_total_incl_vat.setter
    def original_total_incl_vat(self, original_total_incl_vat):
        """Sets the original_total_incl_vat of this MerchantOrderResponse.

        The total value of the order including VAT  (in the currency in which the order was paid for, see CurrencyCode).  # noqa: E501

        :param original_total_incl_vat: The original_total_incl_vat of this MerchantOrderResponse.  # noqa: E501
        :type original_total_incl_vat: float
        """

        self._original_total_incl_vat = original_total_incl_vat

    @property
    def original_total_vat(self):
        """Gets the original_total_vat of this MerchantOrderResponse.  # noqa: E501

        The total amount of VAT charged over the total value of te order  (in the currency in which the order was paid for, see CurrencyCode).  # noqa: E501

        :return: The original_total_vat of this MerchantOrderResponse.  # noqa: E501
        :rtype: float
        """
        return self._original_total_vat

    @original_total_vat.setter
    def original_total_vat(self, original_total_vat):
        """Sets the original_total_vat of this MerchantOrderResponse.

        The total amount of VAT charged over the total value of te order  (in the currency in which the order was paid for, see CurrencyCode).  # noqa: E501

        :param original_total_vat: The original_total_vat of this MerchantOrderResponse.  # noqa: E501
        :type original_total_vat: float
        """

        self._original_total_vat = original_total_vat

    @property
    def lines(self):
        """Gets the lines of this MerchantOrderResponse.  # noqa: E501


        :return: The lines of this MerchantOrderResponse.  # noqa: E501
        :rtype: list[MerchantOrderLineResponse]
        """
        return self._lines

    @lines.setter
    def lines(self, lines):
        """Sets the lines of this MerchantOrderResponse.


        :param lines: The lines of this MerchantOrderResponse.  # noqa: E501
        :type lines: list[MerchantOrderLineResponse]
        """

        self._lines = lines

    @property
    def phone(self):
        """Gets the phone of this MerchantOrderResponse.  # noqa: E501

        The customer's telephone number.  # noqa: E501

        :return: The phone of this MerchantOrderResponse.  # noqa: E501
        :rtype: str
        """
        return self._phone

    @phone.setter
    def phone(self, phone):
        """Sets the phone of this MerchantOrderResponse.

        The customer's telephone number.  # noqa: E501

        :param phone: The phone of this MerchantOrderResponse.  # noqa: E501
        :type phone: str
        """
        if (self.local_vars_configuration.client_side_validation and
                phone is not None and len(phone) > 50):
            raise ValueError("Invalid value for `phone`, length must be less than or equal to `50`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                phone is not None and len(phone) < 0):
            raise ValueError("Invalid value for `phone`, length must be greater than or equal to `0`")  # noqa: E501

        self._phone = phone

    @property
    def email(self):
        """Gets the email of this MerchantOrderResponse.  # noqa: E501

        The customer's email.  # noqa: E501

        :return: The email of this MerchantOrderResponse.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this MerchantOrderResponse.

        The customer's email.  # noqa: E501

        :param email: The email of this MerchantOrderResponse.  # noqa: E501
        :type email: str
        """
        if self.local_vars_configuration.client_side_validation and email is None:  # noqa: E501
            raise ValueError("Invalid value for `email`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                email is not None and len(email) > 250):
            raise ValueError("Invalid value for `email`, length must be less than or equal to `250`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                email is not None and len(email) < 0):
            raise ValueError("Invalid value for `email`, length must be greater than or equal to `0`")  # noqa: E501

        self._email = email

    @property
    def company_registration_no(self):
        """Gets the company_registration_no of this MerchantOrderResponse.  # noqa: E501

        Optional. A company's chamber of commerce number.  # noqa: E501

        :return: The company_registration_no of this MerchantOrderResponse.  # noqa: E501
        :rtype: str
        """
        return self._company_registration_no

    @company_registration_no.setter
    def company_registration_no(self, company_registration_no):
        """Sets the company_registration_no of this MerchantOrderResponse.

        Optional. A company's chamber of commerce number.  # noqa: E501

        :param company_registration_no: The company_registration_no of this MerchantOrderResponse.  # noqa: E501
        :type company_registration_no: str
        """
        if (self.local_vars_configuration.client_side_validation and
                company_registration_no is not None and len(company_registration_no) > 50):
            raise ValueError("Invalid value for `company_registration_no`, length must be less than or equal to `50`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                company_registration_no is not None and len(company_registration_no) < 0):
            raise ValueError("Invalid value for `company_registration_no`, length must be greater than or equal to `0`")  # noqa: E501

        self._company_registration_no = company_registration_no

    @property
    def vat_no(self):
        """Gets the vat_no of this MerchantOrderResponse.  # noqa: E501

        Optional. A company's VAT number.  # noqa: E501

        :return: The vat_no of this MerchantOrderResponse.  # noqa: E501
        :rtype: str
        """
        return self._vat_no

    @vat_no.setter
    def vat_no(self, vat_no):
        """Sets the vat_no of this MerchantOrderResponse.

        Optional. A company's VAT number.  # noqa: E501

        :param vat_no: The vat_no of this MerchantOrderResponse.  # noqa: E501
        :type vat_no: str
        """
        if (self.local_vars_configuration.client_side_validation and
                vat_no is not None and len(vat_no) > 50):
            raise ValueError("Invalid value for `vat_no`, length must be less than or equal to `50`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                vat_no is not None and len(vat_no) < 0):
            raise ValueError("Invalid value for `vat_no`, length must be greater than or equal to `0`")  # noqa: E501

        self._vat_no = vat_no

    @property
    def payment_method(self):
        """Gets the payment_method of this MerchantOrderResponse.  # noqa: E501

        The payment method used on the order.  # noqa: E501

        :return: The payment_method of this MerchantOrderResponse.  # noqa: E501
        :rtype: str
        """
        return self._payment_method

    @payment_method.setter
    def payment_method(self, payment_method):
        """Sets the payment_method of this MerchantOrderResponse.

        The payment method used on the order.  # noqa: E501

        :param payment_method: The payment_method of this MerchantOrderResponse.  # noqa: E501
        :type payment_method: str
        """
        if (self.local_vars_configuration.client_side_validation and
                payment_method is not None and len(payment_method) > 50):
            raise ValueError("Invalid value for `payment_method`, length must be less than or equal to `50`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                payment_method is not None and len(payment_method) < 0):
            raise ValueError("Invalid value for `payment_method`, length must be greater than or equal to `0`")  # noqa: E501

        self._payment_method = payment_method

    @property
    def payment_reference_no(self):
        """Gets the payment_reference_no of this MerchantOrderResponse.  # noqa: E501

        Reference or transaction id for the payment  # noqa: E501

        :return: The payment_reference_no of this MerchantOrderResponse.  # noqa: E501
        :rtype: str
        """
        return self._payment_reference_no

    @payment_reference_no.setter
    def payment_reference_no(self, payment_reference_no):
        """Sets the payment_reference_no of this MerchantOrderResponse.

        Reference or transaction id for the payment  # noqa: E501

        :param payment_reference_no: The payment_reference_no of this MerchantOrderResponse.  # noqa: E501
        :type payment_reference_no: str
        """
        if (self.local_vars_configuration.client_side_validation and
                payment_reference_no is not None and len(payment_reference_no) > 250):
            raise ValueError("Invalid value for `payment_reference_no`, length must be less than or equal to `250`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                payment_reference_no is not None and len(payment_reference_no) < 0):
            raise ValueError("Invalid value for `payment_reference_no`, length must be greater than or equal to `0`")  # noqa: E501

        self._payment_reference_no = payment_reference_no

    @property
    def shipping_costs_incl_vat(self):
        """Gets the shipping_costs_incl_vat of this MerchantOrderResponse.  # noqa: E501

        The shipping fee including VAT  (in the shop's base currency calculated using the exchange rate at the time of ordering).  # noqa: E501

        :return: The shipping_costs_incl_vat of this MerchantOrderResponse.  # noqa: E501
        :rtype: float
        """
        return self._shipping_costs_incl_vat

    @shipping_costs_incl_vat.setter
    def shipping_costs_incl_vat(self, shipping_costs_incl_vat):
        """Sets the shipping_costs_incl_vat of this MerchantOrderResponse.

        The shipping fee including VAT  (in the shop's base currency calculated using the exchange rate at the time of ordering).  # noqa: E501

        :param shipping_costs_incl_vat: The shipping_costs_incl_vat of this MerchantOrderResponse.  # noqa: E501
        :type shipping_costs_incl_vat: float
        """
        if self.local_vars_configuration.client_side_validation and shipping_costs_incl_vat is None:  # noqa: E501
            raise ValueError("Invalid value for `shipping_costs_incl_vat`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                shipping_costs_incl_vat is not None and shipping_costs_incl_vat < 0):  # noqa: E501
            raise ValueError("Invalid value for `shipping_costs_incl_vat`, must be a value greater than or equal to `0`")  # noqa: E501

        self._shipping_costs_incl_vat = shipping_costs_incl_vat

    @property
    def currency_code(self):
        """Gets the currency_code of this MerchantOrderResponse.  # noqa: E501

        The currency code for the amounts of the order.  # noqa: E501

        :return: The currency_code of this MerchantOrderResponse.  # noqa: E501
        :rtype: str
        """
        return self._currency_code

    @currency_code.setter
    def currency_code(self, currency_code):
        """Sets the currency_code of this MerchantOrderResponse.

        The currency code for the amounts of the order.  # noqa: E501

        :param currency_code: The currency_code of this MerchantOrderResponse.  # noqa: E501
        :type currency_code: str
        """
        if self.local_vars_configuration.client_side_validation and currency_code is None:  # noqa: E501
            raise ValueError("Invalid value for `currency_code`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                currency_code is not None and len(currency_code) > 3):
            raise ValueError("Invalid value for `currency_code`, length must be less than or equal to `3`")  # noqa: E501

        self._currency_code = currency_code

    @property
    def order_date(self):
        """Gets the order_date of this MerchantOrderResponse.  # noqa: E501

        The date the order was created at the channel.  # noqa: E501

        :return: The order_date of this MerchantOrderResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._order_date

    @order_date.setter
    def order_date(self, order_date):
        """Sets the order_date of this MerchantOrderResponse.

        The date the order was created at the channel.  # noqa: E501

        :param order_date: The order_date of this MerchantOrderResponse.  # noqa: E501
        :type order_date: datetime
        """
        if self.local_vars_configuration.client_side_validation and order_date is None:  # noqa: E501
            raise ValueError("Invalid value for `order_date`, must not be `None`")  # noqa: E501

        self._order_date = order_date

    @property
    def channel_customer_no(self):
        """Gets the channel_customer_no of this MerchantOrderResponse.  # noqa: E501

        The unique customer reference used by the channel.  # noqa: E501

        :return: The channel_customer_no of this MerchantOrderResponse.  # noqa: E501
        :rtype: str
        """
        return self._channel_customer_no

    @channel_customer_no.setter
    def channel_customer_no(self, channel_customer_no):
        """Sets the channel_customer_no of this MerchantOrderResponse.

        The unique customer reference used by the channel.  # noqa: E501

        :param channel_customer_no: The channel_customer_no of this MerchantOrderResponse.  # noqa: E501
        :type channel_customer_no: str
        """
        if (self.local_vars_configuration.client_side_validation and
                channel_customer_no is not None and len(channel_customer_no) > 50):
            raise ValueError("Invalid value for `channel_customer_no`, length must be less than or equal to `50`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                channel_customer_no is not None and len(channel_customer_no) < 0):
            raise ValueError("Invalid value for `channel_customer_no`, length must be greater than or equal to `0`")  # noqa: E501

        self._channel_customer_no = channel_customer_no

    @property
    def extra_data(self):
        """Gets the extra_data of this MerchantOrderResponse.  # noqa: E501

        Extra data on the order.  # noqa: E501

        :return: The extra_data of this MerchantOrderResponse.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._extra_data

    @extra_data.setter
    def extra_data(self, extra_data):
        """Sets the extra_data of this MerchantOrderResponse.

        Extra data on the order.  # noqa: E501

        :param extra_data: The extra_data of this MerchantOrderResponse.  # noqa: E501
        :type extra_data: dict(str, str)
        """

        self._extra_data = extra_data

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MerchantOrderResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MerchantOrderResponse):
            return True

        return self.to_dict() != other.to_dict()
