# coding: utf-8

"""
    ChannelEngine Merchant API

    ChannelEngine API for merchants  # noqa: E501

    The version of the OpenAPI document: 2.9.10
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from channelengine_merchant_api_client.configuration import Configuration


class MerchantReturnResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'merchant_order_no': 'str',
        'channel_order_no': 'str',
        'channel_id': 'int',
        'global_channel_id': 'int',
        'global_channel_name': 'str',
        'lines': 'list[MerchantReturnLineResponse]',
        'created_at': 'datetime',
        'updated_at': 'datetime',
        'merchant_return_no': 'str',
        'channel_return_no': 'str',
        'id': 'int',
        'reason': 'ReturnReason',
        'customer_comment': 'str',
        'merchant_comment': 'str',
        'refund_incl_vat': 'float',
        'refund_excl_vat': 'float'
    }

    attribute_map = {
        'merchant_order_no': 'MerchantOrderNo',
        'channel_order_no': 'ChannelOrderNo',
        'channel_id': 'ChannelId',
        'global_channel_id': 'GlobalChannelId',
        'global_channel_name': 'GlobalChannelName',
        'lines': 'Lines',
        'created_at': 'CreatedAt',
        'updated_at': 'UpdatedAt',
        'merchant_return_no': 'MerchantReturnNo',
        'channel_return_no': 'ChannelReturnNo',
        'id': 'Id',
        'reason': 'Reason',
        'customer_comment': 'CustomerComment',
        'merchant_comment': 'MerchantComment',
        'refund_incl_vat': 'RefundInclVat',
        'refund_excl_vat': 'RefundExclVat'
    }

    def __init__(self, merchant_order_no=None, channel_order_no=None, channel_id=None, global_channel_id=None, global_channel_name=None, lines=None, created_at=None, updated_at=None, merchant_return_no=None, channel_return_no=None, id=None, reason=None, customer_comment=None, merchant_comment=None, refund_incl_vat=None, refund_excl_vat=None, local_vars_configuration=None):  # noqa: E501
        """MerchantReturnResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._merchant_order_no = None
        self._channel_order_no = None
        self._channel_id = None
        self._global_channel_id = None
        self._global_channel_name = None
        self._lines = None
        self._created_at = None
        self._updated_at = None
        self._merchant_return_no = None
        self._channel_return_no = None
        self._id = None
        self._reason = None
        self._customer_comment = None
        self._merchant_comment = None
        self._refund_incl_vat = None
        self._refund_excl_vat = None
        self.discriminator = None

        self.merchant_order_no = merchant_order_no
        self.channel_order_no = channel_order_no
        self.channel_id = channel_id
        self.global_channel_id = global_channel_id
        self.global_channel_name = global_channel_name
        self.lines = lines
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        self.merchant_return_no = merchant_return_no
        self.channel_return_no = channel_return_no
        if id is not None:
            self.id = id
        if reason is not None:
            self.reason = reason
        self.customer_comment = customer_comment
        self.merchant_comment = merchant_comment
        if refund_incl_vat is not None:
            self.refund_incl_vat = refund_incl_vat
        if refund_excl_vat is not None:
            self.refund_excl_vat = refund_excl_vat

    @property
    def merchant_order_no(self):
        """Gets the merchant_order_no of this MerchantReturnResponse.  # noqa: E501

        The unique order reference used by the Merchant.  # noqa: E501

        :return: The merchant_order_no of this MerchantReturnResponse.  # noqa: E501
        :rtype: str
        """
        return self._merchant_order_no

    @merchant_order_no.setter
    def merchant_order_no(self, merchant_order_no):
        """Sets the merchant_order_no of this MerchantReturnResponse.

        The unique order reference used by the Merchant.  # noqa: E501

        :param merchant_order_no: The merchant_order_no of this MerchantReturnResponse.  # noqa: E501
        :type merchant_order_no: str
        """

        self._merchant_order_no = merchant_order_no

    @property
    def channel_order_no(self):
        """Gets the channel_order_no of this MerchantReturnResponse.  # noqa: E501

        The unique order reference used by the Channel.  # noqa: E501

        :return: The channel_order_no of this MerchantReturnResponse.  # noqa: E501
        :rtype: str
        """
        return self._channel_order_no

    @channel_order_no.setter
    def channel_order_no(self, channel_order_no):
        """Sets the channel_order_no of this MerchantReturnResponse.

        The unique order reference used by the Channel.  # noqa: E501

        :param channel_order_no: The channel_order_no of this MerchantReturnResponse.  # noqa: E501
        :type channel_order_no: str
        """

        self._channel_order_no = channel_order_no

    @property
    def channel_id(self):
        """Gets the channel_id of this MerchantReturnResponse.  # noqa: E501

        The id of the channel.  # noqa: E501

        :return: The channel_id of this MerchantReturnResponse.  # noqa: E501
        :rtype: int
        """
        return self._channel_id

    @channel_id.setter
    def channel_id(self, channel_id):
        """Sets the channel_id of this MerchantReturnResponse.

        The id of the channel.  # noqa: E501

        :param channel_id: The channel_id of this MerchantReturnResponse.  # noqa: E501
        :type channel_id: int
        """

        self._channel_id = channel_id

    @property
    def global_channel_id(self):
        """Gets the global_channel_id of this MerchantReturnResponse.  # noqa: E501

        The id of the Global Channel.  # noqa: E501

        :return: The global_channel_id of this MerchantReturnResponse.  # noqa: E501
        :rtype: int
        """
        return self._global_channel_id

    @global_channel_id.setter
    def global_channel_id(self, global_channel_id):
        """Sets the global_channel_id of this MerchantReturnResponse.

        The id of the Global Channel.  # noqa: E501

        :param global_channel_id: The global_channel_id of this MerchantReturnResponse.  # noqa: E501
        :type global_channel_id: int
        """

        self._global_channel_id = global_channel_id

    @property
    def global_channel_name(self):
        """Gets the global_channel_name of this MerchantReturnResponse.  # noqa: E501

        The name of the Global Channel.  # noqa: E501

        :return: The global_channel_name of this MerchantReturnResponse.  # noqa: E501
        :rtype: str
        """
        return self._global_channel_name

    @global_channel_name.setter
    def global_channel_name(self, global_channel_name):
        """Sets the global_channel_name of this MerchantReturnResponse.

        The name of the Global Channel.  # noqa: E501

        :param global_channel_name: The global_channel_name of this MerchantReturnResponse.  # noqa: E501
        :type global_channel_name: str
        """

        self._global_channel_name = global_channel_name

    @property
    def lines(self):
        """Gets the lines of this MerchantReturnResponse.  # noqa: E501


        :return: The lines of this MerchantReturnResponse.  # noqa: E501
        :rtype: list[MerchantReturnLineResponse]
        """
        return self._lines

    @lines.setter
    def lines(self, lines):
        """Sets the lines of this MerchantReturnResponse.


        :param lines: The lines of this MerchantReturnResponse.  # noqa: E501
        :type lines: list[MerchantReturnLineResponse]
        """

        self._lines = lines

    @property
    def created_at(self):
        """Gets the created_at of this MerchantReturnResponse.  # noqa: E501

        The date at which the return was created in ChannelEngine.  # noqa: E501

        :return: The created_at of this MerchantReturnResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this MerchantReturnResponse.

        The date at which the return was created in ChannelEngine.  # noqa: E501

        :param created_at: The created_at of this MerchantReturnResponse.  # noqa: E501
        :type created_at: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this MerchantReturnResponse.  # noqa: E501

        The date at which the return was last modified in ChannelEngine.  # noqa: E501

        :return: The updated_at of this MerchantReturnResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this MerchantReturnResponse.

        The date at which the return was last modified in ChannelEngine.  # noqa: E501

        :param updated_at: The updated_at of this MerchantReturnResponse.  # noqa: E501
        :type updated_at: datetime
        """

        self._updated_at = updated_at

    @property
    def merchant_return_no(self):
        """Gets the merchant_return_no of this MerchantReturnResponse.  # noqa: E501

        The unique return reference used by the Merchant, will be empty in case of a channel or unacknowledged return.  # noqa: E501

        :return: The merchant_return_no of this MerchantReturnResponse.  # noqa: E501
        :rtype: str
        """
        return self._merchant_return_no

    @merchant_return_no.setter
    def merchant_return_no(self, merchant_return_no):
        """Sets the merchant_return_no of this MerchantReturnResponse.

        The unique return reference used by the Merchant, will be empty in case of a channel or unacknowledged return.  # noqa: E501

        :param merchant_return_no: The merchant_return_no of this MerchantReturnResponse.  # noqa: E501
        :type merchant_return_no: str
        """

        self._merchant_return_no = merchant_return_no

    @property
    def channel_return_no(self):
        """Gets the channel_return_no of this MerchantReturnResponse.  # noqa: E501

        The unique return reference used by the Channel, will be empty in case of a merchant return.  # noqa: E501

        :return: The channel_return_no of this MerchantReturnResponse.  # noqa: E501
        :rtype: str
        """
        return self._channel_return_no

    @channel_return_no.setter
    def channel_return_no(self, channel_return_no):
        """Sets the channel_return_no of this MerchantReturnResponse.

        The unique return reference used by the Channel, will be empty in case of a merchant return.  # noqa: E501

        :param channel_return_no: The channel_return_no of this MerchantReturnResponse.  # noqa: E501
        :type channel_return_no: str
        """

        self._channel_return_no = channel_return_no

    @property
    def id(self):
        """Gets the id of this MerchantReturnResponse.  # noqa: E501

        The unique return reference used by ChannelEngine.  # noqa: E501

        :return: The id of this MerchantReturnResponse.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this MerchantReturnResponse.

        The unique return reference used by ChannelEngine.  # noqa: E501

        :param id: The id of this MerchantReturnResponse.  # noqa: E501
        :type id: int
        """

        self._id = id

    @property
    def reason(self):
        """Gets the reason of this MerchantReturnResponse.  # noqa: E501

        The reason code of the return.  # noqa: E501

        :return: The reason of this MerchantReturnResponse.  # noqa: E501
        :rtype: ReturnReason
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """Sets the reason of this MerchantReturnResponse.

        The reason code of the return.  # noqa: E501

        :param reason: The reason of this MerchantReturnResponse.  # noqa: E501
        :type reason: ReturnReason
        """

        self._reason = reason

    @property
    def customer_comment(self):
        """Gets the customer_comment of this MerchantReturnResponse.  # noqa: E501

        Optional. Comment of customer on the (reason of) the return.  # noqa: E501

        :return: The customer_comment of this MerchantReturnResponse.  # noqa: E501
        :rtype: str
        """
        return self._customer_comment

    @customer_comment.setter
    def customer_comment(self, customer_comment):
        """Sets the customer_comment of this MerchantReturnResponse.

        Optional. Comment of customer on the (reason of) the return.  # noqa: E501

        :param customer_comment: The customer_comment of this MerchantReturnResponse.  # noqa: E501
        :type customer_comment: str
        """
        if (self.local_vars_configuration.client_side_validation and
                customer_comment is not None and len(customer_comment) > 4001):
            raise ValueError("Invalid value for `customer_comment`, length must be less than or equal to `4001`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                customer_comment is not None and len(customer_comment) < 0):
            raise ValueError("Invalid value for `customer_comment`, length must be greater than or equal to `0`")  # noqa: E501

        self._customer_comment = customer_comment

    @property
    def merchant_comment(self):
        """Gets the merchant_comment of this MerchantReturnResponse.  # noqa: E501

        Optional. Comment of merchant on the return.  # noqa: E501

        :return: The merchant_comment of this MerchantReturnResponse.  # noqa: E501
        :rtype: str
        """
        return self._merchant_comment

    @merchant_comment.setter
    def merchant_comment(self, merchant_comment):
        """Sets the merchant_comment of this MerchantReturnResponse.

        Optional. Comment of merchant on the return.  # noqa: E501

        :param merchant_comment: The merchant_comment of this MerchantReturnResponse.  # noqa: E501
        :type merchant_comment: str
        """
        if (self.local_vars_configuration.client_side_validation and
                merchant_comment is not None and len(merchant_comment) > 4001):
            raise ValueError("Invalid value for `merchant_comment`, length must be less than or equal to `4001`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                merchant_comment is not None and len(merchant_comment) < 0):
            raise ValueError("Invalid value for `merchant_comment`, length must be greater than or equal to `0`")  # noqa: E501

        self._merchant_comment = merchant_comment

    @property
    def refund_incl_vat(self):
        """Gets the refund_incl_vat of this MerchantReturnResponse.  # noqa: E501

        Refund amount incl. VAT.  # noqa: E501

        :return: The refund_incl_vat of this MerchantReturnResponse.  # noqa: E501
        :rtype: float
        """
        return self._refund_incl_vat

    @refund_incl_vat.setter
    def refund_incl_vat(self, refund_incl_vat):
        """Sets the refund_incl_vat of this MerchantReturnResponse.

        Refund amount incl. VAT.  # noqa: E501

        :param refund_incl_vat: The refund_incl_vat of this MerchantReturnResponse.  # noqa: E501
        :type refund_incl_vat: float
        """
        if (self.local_vars_configuration.client_side_validation and
                refund_incl_vat is not None and refund_incl_vat < 0):  # noqa: E501
            raise ValueError("Invalid value for `refund_incl_vat`, must be a value greater than or equal to `0`")  # noqa: E501

        self._refund_incl_vat = refund_incl_vat

    @property
    def refund_excl_vat(self):
        """Gets the refund_excl_vat of this MerchantReturnResponse.  # noqa: E501

        Refund amount excl. VAT.  # noqa: E501

        :return: The refund_excl_vat of this MerchantReturnResponse.  # noqa: E501
        :rtype: float
        """
        return self._refund_excl_vat

    @refund_excl_vat.setter
    def refund_excl_vat(self, refund_excl_vat):
        """Sets the refund_excl_vat of this MerchantReturnResponse.

        Refund amount excl. VAT.  # noqa: E501

        :param refund_excl_vat: The refund_excl_vat of this MerchantReturnResponse.  # noqa: E501
        :type refund_excl_vat: float
        """
        if (self.local_vars_configuration.client_side_validation and
                refund_excl_vat is not None and refund_excl_vat < 0):  # noqa: E501
            raise ValueError("Invalid value for `refund_excl_vat`, must be a value greater than or equal to `0`")  # noqa: E501

        self._refund_excl_vat = refund_excl_vat

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MerchantReturnResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MerchantReturnResponse):
            return True

        return self.to_dict() != other.to_dict()
