# coding: utf-8

"""
    ChannelEngine Merchant API

    ChannelEngine API for merchants  # noqa: E501

    The version of the OpenAPI document: 2.9.10
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from channelengine_merchant_api_client.configuration import Configuration


class MerchantStockPriceUpdateRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'merchant_product_no': 'str',
        'stock': 'int',
        'price': 'float',
        'stock_location_id': 'int'
    }

    attribute_map = {
        'merchant_product_no': 'MerchantProductNo',
        'stock': 'Stock',
        'price': 'Price',
        'stock_location_id': 'StockLocationId'
    }

    def __init__(self, merchant_product_no=None, stock=None, price=None, stock_location_id=None, local_vars_configuration=None):  # noqa: E501
        """MerchantStockPriceUpdateRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._merchant_product_no = None
        self._stock = None
        self._price = None
        self._stock_location_id = None
        self.discriminator = None

        self.merchant_product_no = merchant_product_no
        self.stock = stock
        self.price = price
        self.stock_location_id = stock_location_id

    @property
    def merchant_product_no(self):
        """Gets the merchant_product_no of this MerchantStockPriceUpdateRequest.  # noqa: E501

        The unique product reference used by the Merchant (sku).  # noqa: E501

        :return: The merchant_product_no of this MerchantStockPriceUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._merchant_product_no

    @merchant_product_no.setter
    def merchant_product_no(self, merchant_product_no):
        """Sets the merchant_product_no of this MerchantStockPriceUpdateRequest.

        The unique product reference used by the Merchant (sku).  # noqa: E501

        :param merchant_product_no: The merchant_product_no of this MerchantStockPriceUpdateRequest.  # noqa: E501
        :type merchant_product_no: str
        """
        if self.local_vars_configuration.client_side_validation and merchant_product_no is None:  # noqa: E501
            raise ValueError("Invalid value for `merchant_product_no`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                merchant_product_no is not None and len(merchant_product_no) > 64):
            raise ValueError("Invalid value for `merchant_product_no`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                merchant_product_no is not None and len(merchant_product_no) < 0):
            raise ValueError("Invalid value for `merchant_product_no`, length must be greater than or equal to `0`")  # noqa: E501

        self._merchant_product_no = merchant_product_no

    @property
    def stock(self):
        """Gets the stock of this MerchantStockPriceUpdateRequest.  # noqa: E501

        The stock of the product. Should not be negative.  # noqa: E501

        :return: The stock of this MerchantStockPriceUpdateRequest.  # noqa: E501
        :rtype: int
        """
        return self._stock

    @stock.setter
    def stock(self, stock):
        """Sets the stock of this MerchantStockPriceUpdateRequest.

        The stock of the product. Should not be negative.  # noqa: E501

        :param stock: The stock of this MerchantStockPriceUpdateRequest.  # noqa: E501
        :type stock: int
        """
        if (self.local_vars_configuration.client_side_validation and
                stock is not None and stock < 0):  # noqa: E501
            raise ValueError("Invalid value for `stock`, must be a value greater than or equal to `0`")  # noqa: E501

        self._stock = stock

    @property
    def price(self):
        """Gets the price of this MerchantStockPriceUpdateRequest.  # noqa: E501

        The price of the product. Should not be negative.  # noqa: E501

        :return: The price of this MerchantStockPriceUpdateRequest.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this MerchantStockPriceUpdateRequest.

        The price of the product. Should not be negative.  # noqa: E501

        :param price: The price of this MerchantStockPriceUpdateRequest.  # noqa: E501
        :type price: float
        """
        if (self.local_vars_configuration.client_side_validation and
                price is not None and price < 0):  # noqa: E501
            raise ValueError("Invalid value for `price`, must be a value greater than or equal to `0`")  # noqa: E501

        self._price = price

    @property
    def stock_location_id(self):
        """Gets the stock_location_id of this MerchantStockPriceUpdateRequest.  # noqa: E501

        The stock location id of updated stok.  If not provided stock from default stock location will be updated.  # noqa: E501

        :return: The stock_location_id of this MerchantStockPriceUpdateRequest.  # noqa: E501
        :rtype: int
        """
        return self._stock_location_id

    @stock_location_id.setter
    def stock_location_id(self, stock_location_id):
        """Sets the stock_location_id of this MerchantStockPriceUpdateRequest.

        The stock location id of updated stok.  If not provided stock from default stock location will be updated.  # noqa: E501

        :param stock_location_id: The stock_location_id of this MerchantStockPriceUpdateRequest.  # noqa: E501
        :type stock_location_id: int
        """

        self._stock_location_id = stock_location_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MerchantStockPriceUpdateRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MerchantStockPriceUpdateRequest):
            return True

        return self.to_dict() != other.to_dict()
