# coding: utf-8

"""
    ChannelEngine Merchant API

    ChannelEngine API for merchants  # noqa: E501

    The version of the OpenAPI document: 2.9.10
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from channelengine_merchant_api_client.configuration import Configuration


class MerchantWebhookRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'url': 'str',
        'is_active': 'bool',
        'events': 'list[WebhookEventType]'
    }

    attribute_map = {
        'name': 'Name',
        'url': 'Url',
        'is_active': 'IsActive',
        'events': 'Events'
    }

    def __init__(self, name=None, url=None, is_active=None, events=None, local_vars_configuration=None):  # noqa: E501
        """MerchantWebhookRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._url = None
        self._is_active = None
        self._events = None
        self.discriminator = None

        self.name = name
        self.url = url
        if is_active is not None:
            self.is_active = is_active
        self.events = events

    @property
    def name(self):
        """Gets the name of this MerchantWebhookRequest.  # noqa: E501

        The unique webhook name.  # noqa: E501

        :return: The name of this MerchantWebhookRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this MerchantWebhookRequest.

        The unique webhook name.  # noqa: E501

        :param name: The name of this MerchantWebhookRequest.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 128):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `128`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 0):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `0`")  # noqa: E501

        self._name = name

    @property
    def url(self):
        """Gets the url of this MerchantWebhookRequest.  # noqa: E501

        The callback URL using by the webhook.  # noqa: E501

        :return: The url of this MerchantWebhookRequest.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this MerchantWebhookRequest.

        The callback URL using by the webhook.  # noqa: E501

        :param url: The url of this MerchantWebhookRequest.  # noqa: E501
        :type url: str
        """
        if self.local_vars_configuration.client_side_validation and url is None:  # noqa: E501
            raise ValueError("Invalid value for `url`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                url is not None and len(url) > 1028):
            raise ValueError("Invalid value for `url`, length must be less than or equal to `1028`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                url is not None and len(url) < 0):
            raise ValueError("Invalid value for `url`, length must be greater than or equal to `0`")  # noqa: E501

        self._url = url

    @property
    def is_active(self):
        """Gets the is_active of this MerchantWebhookRequest.  # noqa: E501

        Determining if the webhook should be active and callbacks should proceed or not.  # noqa: E501

        :return: The is_active of this MerchantWebhookRequest.  # noqa: E501
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active):
        """Sets the is_active of this MerchantWebhookRequest.

        Determining if the webhook should be active and callbacks should proceed or not.  # noqa: E501

        :param is_active: The is_active of this MerchantWebhookRequest.  # noqa: E501
        :type is_active: bool
        """

        self._is_active = is_active

    @property
    def events(self):
        """Gets the events of this MerchantWebhookRequest.  # noqa: E501

        Events supported by the webhook.  # noqa: E501

        :return: The events of this MerchantWebhookRequest.  # noqa: E501
        :rtype: list[WebhookEventType]
        """
        return self._events

    @events.setter
    def events(self, events):
        """Sets the events of this MerchantWebhookRequest.

        Events supported by the webhook.  # noqa: E501

        :param events: The events of this MerchantWebhookRequest.  # noqa: E501
        :type events: list[WebhookEventType]
        """
        if self.local_vars_configuration.client_side_validation and events is None:  # noqa: E501
            raise ValueError("Invalid value for `events`, must not be `None`")  # noqa: E501

        self._events = events

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MerchantWebhookRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MerchantWebhookRequest):
            return True

        return self.to_dict() != other.to_dict()
