from abc import ABC

from pydantic import BaseModel, Field


class BaseAgent(BaseModel, ABC):
    """Base class for agents."""

    model_config = {
        "arbitrary_types_allowed": True,
        "extra": "allow",
    }

    agent_name: str = Field(description="The name of the agent.")

    description: str = Field(description="A brief description of the agent's purpose.")

    content_types: list[str] = Field(description="Supported content types.")
