"""FastBlocks ASGI Sitemap Adapter (Legacy).

This adapter now uses FastBlocks native sitemap implementation
instead of the external asgi-sitemaps dependency.

For new projects, consider using the native adapter directly.
"""

from contextlib import suppress
from uuid import UUID

from acb.adapters import AdapterStatus
from acb.depends import depends

from ._base import SitemapBase, SitemapBaseSettings
from .core import BaseSitemap as NativeSitemap
from .core import SitemapApp


class SitemapSettings(SitemapBaseSettings):
    pass


class Sitemap(NativeSitemap[str], SitemapBase):
    sitemap: SitemapApp | None = None

    @depends.inject
    def items(self) -> list[str]:
        try:
            routes_adapter = depends.get("routes")
            if hasattr(routes_adapter, "routes"):
                return [r.path for r in routes_adapter.routes]
            return []
        except Exception:
            return []

    def location(self, item: str) -> str:
        return item

    def changefreq(self, item: str) -> str:
        return self.config.change_freq

    async def init(self) -> None:
        if not self.config.app.domain:
            msg = "`domain` must be set in AppSettings"
            raise ValueError(msg)
        self.sitemap = SitemapApp(
            self,
            domain=self.config.app.domain,
            cache_ttl=getattr(self.config, "cache_ttl", 3600),
        )


MODULE_ID = UUID("01937d86-eff0-7410-5786-a01234567890")
MODULE_STATUS = AdapterStatus.STABLE

with suppress(Exception):
    depends.set(Sitemap)
