# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoint The PowerBot service is available at the following REST endpoint:  ``` $api_url_placeholder ```  Access to the API is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.26.4
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from powerbot_client.api_client import ApiClient
from powerbot_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class HistoricDataApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_bulk_exports(self, exchange, delivery_area, date, format, **kwargs):  # noqa: E501
        """Get historic data in bulk  # noqa: E501

        Allows to retrieve historic data in bulk. Note: This query can take a while.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_bulk_exports(exchange, delivery_area, date, format, async_req=True)
        >>> result = thread.get()

        :param exchange: The target exchange (required)
        :type exchange: Exchange
        :param delivery_area: The delivery area the data is retrieved from. (required)
        :type delivery_area: str
        :param date: Indicates for what date the data is retrieved. (required)
        :type date: date
        :param format: The format of the exported file. (required)
        :type format: BulkExportsFormat
        :param exchange2: The exchange the data is retrieved from.
        :type exchange2: Exchange
        :param contracts: Indication if contract specific data should be included in the export.
        :type contracts: bool
        :param trades: Indication if trade specific data should be included in the export.
        :type trades: bool
        :param orders: Indication if order specific data should be included in the export.
        :type orders: bool
        :param capacities: Indication if cross-border capacity data should be included in the export.
        :type capacities: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BulkExportsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_bulk_exports_with_http_info(exchange, delivery_area, date, format, **kwargs)  # noqa: E501

    def get_bulk_exports_with_http_info(self, exchange, delivery_area, date, format, **kwargs):  # noqa: E501
        """Get historic data in bulk  # noqa: E501

        Allows to retrieve historic data in bulk. Note: This query can take a while.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_bulk_exports_with_http_info(exchange, delivery_area, date, format, async_req=True)
        >>> result = thread.get()

        :param exchange: The target exchange (required)
        :type exchange: Exchange
        :param delivery_area: The delivery area the data is retrieved from. (required)
        :type delivery_area: str
        :param date: Indicates for what date the data is retrieved. (required)
        :type date: date
        :param format: The format of the exported file. (required)
        :type format: BulkExportsFormat
        :param exchange2: The exchange the data is retrieved from.
        :type exchange2: Exchange
        :param contracts: Indication if contract specific data should be included in the export.
        :type contracts: bool
        :param trades: Indication if trade specific data should be included in the export.
        :type trades: bool
        :param orders: Indication if order specific data should be included in the export.
        :type orders: bool
        :param capacities: Indication if cross-border capacity data should be included in the export.
        :type capacities: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BulkExportsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'delivery_area',
            'date',
            'format',
            'exchange2',
            'contracts',
            'trades',
            'orders',
            'capacities'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bulk_exports" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `get_bulk_exports`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `get_bulk_exports`")  # noqa: E501
        # verify the required parameter 'date' is set
        if self.api_client.client_side_validation and local_var_params.get('date') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `date` when calling `get_bulk_exports`")  # noqa: E501
        # verify the required parameter 'format' is set
        if self.api_client.client_side_validation and local_var_params.get('format') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `format` when calling `get_bulk_exports`")  # noqa: E501

        if self.api_client.client_side_validation and ('delivery_area' in local_var_params and  # noqa: E501
                                                        len(local_var_params['delivery_area']) > 16):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `delivery_area` when calling `get_bulk_exports`, length must be less than or equal to `16`")  # noqa: E501
        if self.api_client.client_side_validation and ('delivery_area' in local_var_params and  # noqa: E501
                                                        len(local_var_params['delivery_area']) < 16):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `delivery_area` when calling `get_bulk_exports`, length must be greater than or equal to `16`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501
        if 'delivery_area' in local_var_params:
            path_params['delivery_area'] = local_var_params['delivery_area']  # noqa: E501
        if 'date' in local_var_params:
            path_params['date'] = local_var_params['date']  # noqa: E501

        query_params = []
        if local_var_params.get('exchange2') is not None:  # noqa: E501
            query_params.append(('exchange', local_var_params['exchange2']))  # noqa: E501
        if local_var_params.get('format') is not None:  # noqa: E501
            query_params.append(('format', local_var_params['format']))  # noqa: E501
        if local_var_params.get('contracts') is not None:  # noqa: E501
            query_params.append(('contracts', local_var_params['contracts']))  # noqa: E501
        if local_var_params.get('trades') is not None:  # noqa: E501
            query_params.append(('trades', local_var_params['trades']))  # noqa: E501
        if local_var_params.get('orders') is not None:  # noqa: E501
            query_params.append(('orders', local_var_params['orders']))  # noqa: E501
        if local_var_params.get('capacities') is not None:  # noqa: E501
            query_params.append(('capacities', local_var_params['capacities']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "BulkExportsResponse",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/historic/bulkexports/{delivery_area}/{date}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_historic_orders(self, exchange, delivery_area, **kwargs):  # noqa: E501
        """Get order book revisions for historic contracts  # noqa: E501

        Allows to retrieve all order revisions of historic contracts.  Note that this endpoint returns order revisions, and not orders. This means that the same order ID will appear multiple times, once for each update (creation, update or deletion).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_historic_orders(exchange, delivery_area, async_req=True)
        >>> result = thread.get()

        :param exchange: The target exchange (required)
        :type exchange: Exchange
        :param delivery_area: The delivery area of the target contract. (required)
        :type delivery_area: str
        :param page_size: The number of order book revisions to return in one page.
        :type page_size: int
        :param page_token: Used for request pagination. If a response has the field `next_page_token` set, you can provide that value as the `page_token` parameter to retrieve the next page of results. The first request does not need to have the `page_token` parameter set.
        :type page_token: str
        :param exchange2: This value can be used to retrieve data from other exchanges. This is only possible for exchanges you are actively using, or have used in the past.  It defaults to the current exchange if no value is specified.
        :type exchange2: Exchange
        :param delivery_start: The delivery start time of the target contract. Must be used together with `delivery_end` and `product`. Alternatively, `contract_id` can be used.
        :type delivery_start: datetime
        :param delivery_end: The delivery end time of the target contract. Must be used together with `delivery_start` and `product`. Alternatively, `contract_id` can be used.
        :type delivery_end: datetime
        :param product: The product of the target contract. Must be used together with `delivery_start` and `delivery_end`. Alternatively, `contract_id` can be used.
        :type product: str
        :param contract_id: The ID of the target contract. Alternatively, `delivery_start`, `delivery_end` and `contract_id` can be used.
        :type contract_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: HistoricOrdersResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_orders_with_http_info(exchange, delivery_area, **kwargs)  # noqa: E501

    def get_historic_orders_with_http_info(self, exchange, delivery_area, **kwargs):  # noqa: E501
        """Get order book revisions for historic contracts  # noqa: E501

        Allows to retrieve all order revisions of historic contracts.  Note that this endpoint returns order revisions, and not orders. This means that the same order ID will appear multiple times, once for each update (creation, update or deletion).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_historic_orders_with_http_info(exchange, delivery_area, async_req=True)
        >>> result = thread.get()

        :param exchange: The target exchange (required)
        :type exchange: Exchange
        :param delivery_area: The delivery area of the target contract. (required)
        :type delivery_area: str
        :param page_size: The number of order book revisions to return in one page.
        :type page_size: int
        :param page_token: Used for request pagination. If a response has the field `next_page_token` set, you can provide that value as the `page_token` parameter to retrieve the next page of results. The first request does not need to have the `page_token` parameter set.
        :type page_token: str
        :param exchange2: This value can be used to retrieve data from other exchanges. This is only possible for exchanges you are actively using, or have used in the past.  It defaults to the current exchange if no value is specified.
        :type exchange2: Exchange
        :param delivery_start: The delivery start time of the target contract. Must be used together with `delivery_end` and `product`. Alternatively, `contract_id` can be used.
        :type delivery_start: datetime
        :param delivery_end: The delivery end time of the target contract. Must be used together with `delivery_start` and `product`. Alternatively, `contract_id` can be used.
        :type delivery_end: datetime
        :param product: The product of the target contract. Must be used together with `delivery_start` and `delivery_end`. Alternatively, `contract_id` can be used.
        :type product: str
        :param contract_id: The ID of the target contract. Alternatively, `delivery_start`, `delivery_end` and `contract_id` can be used.
        :type contract_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(HistoricOrdersResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'delivery_area',
            'page_size',
            'page_token',
            'exchange2',
            'delivery_start',
            'delivery_end',
            'product',
            'contract_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_orders" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `get_historic_orders`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `get_historic_orders`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501

        query_params = []
        if local_var_params.get('page_size') is not None:  # noqa: E501
            query_params.append(('page_size', local_var_params['page_size']))  # noqa: E501
        if local_var_params.get('page_token') is not None:  # noqa: E501
            query_params.append(('page_token', local_var_params['page_token']))  # noqa: E501
        if local_var_params.get('exchange2') is not None:  # noqa: E501
            query_params.append(('exchange', local_var_params['exchange2']))  # noqa: E501
        if local_var_params.get('delivery_area') is not None:  # noqa: E501
            query_params.append(('delivery_area', local_var_params['delivery_area']))  # noqa: E501
        if local_var_params.get('delivery_start') is not None:  # noqa: E501
            query_params.append(('delivery_start', local_var_params['delivery_start']))  # noqa: E501
        if local_var_params.get('delivery_end') is not None:  # noqa: E501
            query_params.append(('delivery_end', local_var_params['delivery_end']))  # noqa: E501
        if local_var_params.get('product') is not None:  # noqa: E501
            query_params.append(('product', local_var_params['product']))  # noqa: E501
        if local_var_params.get('contract_id') is not None:  # noqa: E501
            query_params.append(('contract_id', local_var_params['contract_id']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "HistoricOrdersResponse",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/historic/publicorders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_historic_trades(self, exchange, **kwargs):  # noqa: E501
        """Get trades for historic contracts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_historic_trades(exchange, async_req=True)
        >>> result = thread.get()

        :param exchange: The target exchange (required)
        :type exchange: Exchange
        :param page_size: The number of trades to return in one page. Setting this field to `0` will return all trades if `period_match_exact` is set to `true` or only one contract ID is provided.
        :type page_size: int
        :param page_token: Used for request pagination. If a response has the field `next_page_token` set, you can provide that value as the `page_token` parameter to retrieve the next page of results. The first request does not need to have the `page_token` parameter set.
        :type page_token: str
        :param exchange2: This value can be used to retrieve data from other exchanges. This is only possible for exchanges you are actively using, or have used in the past.  It defaults to the current exchange if no value is specified.
        :type exchange2: Exchange
        :param period_start: The lower limit (inclusive) of contract delivery periods. Can be set to match contract `delivery_start` exactly with `period_match_exact`
        :type period_start: datetime
        :param period_end: The upper limit (inclusive) of contract delivery periods. Can be set to match contract `delivery_end` exactly with `period_match_exact`
        :type period_end: datetime
        :param period_match_exact: If set to true, only trades for contract with a delivery period that exactly matches `period_start` and `period_end` will be returned. Otherwise, trades for all contracts with a delivery period that fully falls between `period_start` and `period_end` will be considered.
        :type period_match_exact: bool
        :param delivery_period_duration_minutes:
        :type delivery_period_duration_minutes: int
        :param delivery_area_buy:
        :type delivery_area_buy: str
        :param delivery_area_sell:
        :type delivery_area_sell: str
        :param delivery_area_match_exact: If set to true, only trades where the buy **and** sell delivery areas exactly match `delivery_area_buy` and `delivery_area_sell` will be returned. Otherwise, trades where the buy **or** sell delivery areas match `delivery_area_buy` or `delivery_area_sell` will be returned.
        :type delivery_area_match_exact: bool
        :param contract_ids:
        :type contract_ids: list[str]
        :param products:
        :type products: list[str]
        :param execution_from_offset_minutes: Excludes trades that were executed before `delivery_period_start - execution_from_offset_minutes`
        :type execution_from_offset_minutes: int
        :param execution_to_offset_minutes: Excludes trades that were executed after `delivery_period_start - execution_to_offset_minutes`
        :type execution_to_offset_minutes: int
        :param self_trades:
        :type self_trades: SelfTradeSelector
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: HistoricTradesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_trades_with_http_info(exchange, **kwargs)  # noqa: E501

    def get_historic_trades_with_http_info(self, exchange, **kwargs):  # noqa: E501
        """Get trades for historic contracts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_historic_trades_with_http_info(exchange, async_req=True)
        >>> result = thread.get()

        :param exchange: The target exchange (required)
        :type exchange: Exchange
        :param page_size: The number of trades to return in one page. Setting this field to `0` will return all trades if `period_match_exact` is set to `true` or only one contract ID is provided.
        :type page_size: int
        :param page_token: Used for request pagination. If a response has the field `next_page_token` set, you can provide that value as the `page_token` parameter to retrieve the next page of results. The first request does not need to have the `page_token` parameter set.
        :type page_token: str
        :param exchange2: This value can be used to retrieve data from other exchanges. This is only possible for exchanges you are actively using, or have used in the past.  It defaults to the current exchange if no value is specified.
        :type exchange2: Exchange
        :param period_start: The lower limit (inclusive) of contract delivery periods. Can be set to match contract `delivery_start` exactly with `period_match_exact`
        :type period_start: datetime
        :param period_end: The upper limit (inclusive) of contract delivery periods. Can be set to match contract `delivery_end` exactly with `period_match_exact`
        :type period_end: datetime
        :param period_match_exact: If set to true, only trades for contract with a delivery period that exactly matches `period_start` and `period_end` will be returned. Otherwise, trades for all contracts with a delivery period that fully falls between `period_start` and `period_end` will be considered.
        :type period_match_exact: bool
        :param delivery_period_duration_minutes:
        :type delivery_period_duration_minutes: int
        :param delivery_area_buy:
        :type delivery_area_buy: str
        :param delivery_area_sell:
        :type delivery_area_sell: str
        :param delivery_area_match_exact: If set to true, only trades where the buy **and** sell delivery areas exactly match `delivery_area_buy` and `delivery_area_sell` will be returned. Otherwise, trades where the buy **or** sell delivery areas match `delivery_area_buy` or `delivery_area_sell` will be returned.
        :type delivery_area_match_exact: bool
        :param contract_ids:
        :type contract_ids: list[str]
        :param products:
        :type products: list[str]
        :param execution_from_offset_minutes: Excludes trades that were executed before `delivery_period_start - execution_from_offset_minutes`
        :type execution_from_offset_minutes: int
        :param execution_to_offset_minutes: Excludes trades that were executed after `delivery_period_start - execution_to_offset_minutes`
        :type execution_to_offset_minutes: int
        :param self_trades:
        :type self_trades: SelfTradeSelector
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(HistoricTradesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'page_size',
            'page_token',
            'exchange2',
            'period_start',
            'period_end',
            'period_match_exact',
            'delivery_period_duration_minutes',
            'delivery_area_buy',
            'delivery_area_sell',
            'delivery_area_match_exact',
            'contract_ids',
            'products',
            'execution_from_offset_minutes',
            'execution_to_offset_minutes',
            'self_trades'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_trades" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `get_historic_trades`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501

        query_params = []
        if local_var_params.get('page_size') is not None:  # noqa: E501
            query_params.append(('page_size', local_var_params['page_size']))  # noqa: E501
        if local_var_params.get('page_token') is not None:  # noqa: E501
            query_params.append(('page_token', local_var_params['page_token']))  # noqa: E501
        if local_var_params.get('exchange2') is not None:  # noqa: E501
            query_params.append(('exchange', local_var_params['exchange2']))  # noqa: E501
        if local_var_params.get('period_start') is not None:  # noqa: E501
            query_params.append(('period_start', local_var_params['period_start']))  # noqa: E501
        if local_var_params.get('period_end') is not None:  # noqa: E501
            query_params.append(('period_end', local_var_params['period_end']))  # noqa: E501
        if local_var_params.get('period_match_exact') is not None:  # noqa: E501
            query_params.append(('period_match_exact', local_var_params['period_match_exact']))  # noqa: E501
        if local_var_params.get('delivery_period_duration_minutes') is not None:  # noqa: E501
            query_params.append(('delivery_period_duration_minutes', local_var_params['delivery_period_duration_minutes']))  # noqa: E501
        if local_var_params.get('delivery_area_buy') is not None:  # noqa: E501
            query_params.append(('delivery_area_buy', local_var_params['delivery_area_buy']))  # noqa: E501
        if local_var_params.get('delivery_area_sell') is not None:  # noqa: E501
            query_params.append(('delivery_area_sell', local_var_params['delivery_area_sell']))  # noqa: E501
        if local_var_params.get('delivery_area_match_exact') is not None:  # noqa: E501
            query_params.append(('delivery_area_match_exact', local_var_params['delivery_area_match_exact']))  # noqa: E501
        if local_var_params.get('contract_ids') is not None:  # noqa: E501
            query_params.append(('contract_ids', local_var_params['contract_ids']))  # noqa: E501
            collection_formats['contract_ids'] = 'multi'  # noqa: E501
        if local_var_params.get('products') is not None:  # noqa: E501
            query_params.append(('products', local_var_params['products']))  # noqa: E501
            collection_formats['products'] = 'multi'  # noqa: E501
        if local_var_params.get('execution_from_offset_minutes') is not None:  # noqa: E501
            query_params.append(('execution_from_offset_minutes', local_var_params['execution_from_offset_minutes']))  # noqa: E501
        if local_var_params.get('execution_to_offset_minutes') is not None:  # noqa: E501
            query_params.append(('execution_to_offset_minutes', local_var_params['execution_to_offset_minutes']))  # noqa: E501
        if local_var_params.get('self_trades') is not None:  # noqa: E501
            query_params.append(('self_trades', local_var_params['self_trades']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "HistoricTradesResponse",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/historic/publictrades', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
