# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoint The PowerBot service is available at the following REST endpoint:  ``` $api_url_placeholder ```  Access to the API is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.26.4
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from powerbot_client.api_client import ApiClient
from powerbot_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class MarketApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def change_exchange_password(self, exchange, credentials, **kwargs):  # noqa: E501
        """Update exchange password  # noqa: E501

        Will change the exchange user's credentials and will then log out and re-login to the market with the new credentials.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.change_exchange_password(exchange, credentials, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param credentials: (required)
        :type credentials: ChangedCredentials
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.change_exchange_password_with_http_info(exchange, credentials, **kwargs)  # noqa: E501

    def change_exchange_password_with_http_info(self, exchange, credentials, **kwargs):  # noqa: E501
        """Update exchange password  # noqa: E501

        Will change the exchange user's credentials and will then log out and re-login to the market with the new credentials.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.change_exchange_password_with_http_info(exchange, credentials, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param credentials: (required)
        :type credentials: ChangedCredentials
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'credentials'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_exchange_password" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `change_exchange_password`")  # noqa: E501
        # verify the required parameter 'credentials' is set
        if self.api_client.client_side_validation and local_var_params.get('credentials') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `credentials` when calling `change_exchange_password`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'credentials' in local_var_params:
            body_params = local_var_params['credentials']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/{exchange}/v2/api/market', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_available_exchanges(self, **kwargs):  # noqa: E501
        """Get available exchanges  # noqa: E501

        Allows you to retrieve all available exchanges. This request does not require authentication, but will additionally return the exchange status if authenticated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_available_exchanges(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[MarketAvailability]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_available_exchanges_with_http_info(**kwargs)  # noqa: E501

    def get_available_exchanges_with_http_info(self, **kwargs):  # noqa: E501
        """Get available exchanges  # noqa: E501

        Allows you to retrieve all available exchanges. This request does not require authentication, but will additionally return the exchange status if authenticated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_available_exchanges_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[MarketAvailability], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_available_exchanges" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[MarketAvailability]",
        }

        return self.api_client.call_api(
            '/v2/api/exchanges', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_delivery_area(self, exchange, area_id, **kwargs):  # noqa: E501
        """Get delivery area information  # noqa: E501

        Get information about a specific delivery area  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_delivery_area(exchange, area_id, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param area_id: The delivery area EIC (required)
        :type area_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeliveryArea
        """
        kwargs['_return_http_data_only'] = True
        return self.get_delivery_area_with_http_info(exchange, area_id, **kwargs)  # noqa: E501

    def get_delivery_area_with_http_info(self, exchange, area_id, **kwargs):  # noqa: E501
        """Get delivery area information  # noqa: E501

        Get information about a specific delivery area  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_delivery_area_with_http_info(exchange, area_id, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param area_id: The delivery area EIC (required)
        :type area_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeliveryArea, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'area_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_delivery_area" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `get_delivery_area`")  # noqa: E501
        # verify the required parameter 'area_id' is set
        if self.api_client.client_side_validation and local_var_params.get('area_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `area_id` when calling `get_delivery_area`")  # noqa: E501

        if self.api_client.client_side_validation and ('area_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['area_id']) > 16):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `area_id` when calling `get_delivery_area`, length must be less than or equal to `16`")  # noqa: E501
        if self.api_client.client_side_validation and ('area_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['area_id']) < 16):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `area_id` when calling `get_delivery_area`, length must be greater than or equal to `16`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501
        if 'area_id' in local_var_params:
            path_params['area_id'] = local_var_params['area_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "DeliveryArea",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/delivery-area/{area_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_delivery_areas(self, exchange, **kwargs):  # noqa: E501
        """Get delivery areas  # noqa: E501

        Get information about delivery areas  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_delivery_areas(exchange, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param all: Return all delivery areas instead of just the accessible ones
        :type all: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[DeliveryArea]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_delivery_areas_with_http_info(exchange, **kwargs)  # noqa: E501

    def get_delivery_areas_with_http_info(self, exchange, **kwargs):  # noqa: E501
        """Get delivery areas  # noqa: E501

        Get information about delivery areas  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_delivery_areas_with_http_info(exchange, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param all: Return all delivery areas instead of just the accessible ones
        :type all: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[DeliveryArea], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'all'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_delivery_areas" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `get_delivery_areas`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501

        query_params = []
        if local_var_params.get('all') is not None:  # noqa: E501
            query_params.append(('all', local_var_params['all']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[DeliveryArea]",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/delivery-areas', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_health(self, exchange, **kwargs):  # noqa: E501
        """Get server health  # noqa: E501

        Allows you to retrieve the health of this instance for failover switches. Will return a healthy state if the market status is OK and stable. Please note that this request does not require authentication.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_health(exchange, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.get_health_with_http_info(exchange, **kwargs)  # noqa: E501

    def get_health_with_http_info(self, exchange, **kwargs):  # noqa: E501
        """Get server health  # noqa: E501

        Allows you to retrieve the health of this instance for failover switches. Will return a healthy state if the market status is OK and stable. Please note that this request does not require authentication.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_health_with_http_info(exchange, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'exchange'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_health" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `get_health`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/{exchange}/v2/api/market/health', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_notifications(self, exchange, **kwargs):  # noqa: E501
        """Get notifications from market operations  # noqa: E501

        Allows you to retrieve notifications from market operations (e.g. information about MARKET_HALT etc.) sent to the exchange user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_notifications(exchange, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param offset: Offset when loading a list of items
        :type offset: int
        :param limit: Limits the number of loaded items
        :type limit: int
        :param severity_at_least: This parameter is ignored at nordpool
        :type severity_at_least: Severity
        :param from_api_timestamp: from timestamp is 'inclusive' (i.e. >=)
        :type from_api_timestamp: datetime
        :param to_api_timestamp: to timestamp is 'exclusive' (i.e. <)
        :type to_api_timestamp: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[Notification]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_notifications_with_http_info(exchange, **kwargs)  # noqa: E501

    def get_notifications_with_http_info(self, exchange, **kwargs):  # noqa: E501
        """Get notifications from market operations  # noqa: E501

        Allows you to retrieve notifications from market operations (e.g. information about MARKET_HALT etc.) sent to the exchange user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_notifications_with_http_info(exchange, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param offset: Offset when loading a list of items
        :type offset: int
        :param limit: Limits the number of loaded items
        :type limit: int
        :param severity_at_least: This parameter is ignored at nordpool
        :type severity_at_least: Severity
        :param from_api_timestamp: from timestamp is 'inclusive' (i.e. >=)
        :type from_api_timestamp: datetime
        :param to_api_timestamp: to timestamp is 'exclusive' (i.e. <)
        :type to_api_timestamp: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[Notification], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'offset',
            'limit',
            'severity_at_least',
            'from_api_timestamp',
            'to_api_timestamp'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notifications" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `get_notifications`")  # noqa: E501

        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `get_notifications`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_notifications`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_notifications`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501

        query_params = []
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('severity_at_least') is not None:  # noqa: E501
            query_params.append(('severity_at_least', local_var_params['severity_at_least']))  # noqa: E501
        if local_var_params.get('from_api_timestamp') is not None:  # noqa: E501
            query_params.append(('from_api_timestamp', local_var_params['from_api_timestamp']))  # noqa: E501
        if local_var_params.get('to_api_timestamp') is not None:  # noqa: E501
            query_params.append(('to_api_timestamp', local_var_params['to_api_timestamp']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[Notification]",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/market/notifications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_status(self, exchange, **kwargs):  # noqa: E501
        """Get exchange and server status  # noqa: E501

        Delivers the status of the market and the server as well as configuration information (list of delivery areas etc.). **Heads up!** You should query if the server status is \"OK\" before starting any trading activities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_status(exchange, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MarketStatus
        """
        kwargs['_return_http_data_only'] = True
        return self.get_status_with_http_info(exchange, **kwargs)  # noqa: E501

    def get_status_with_http_info(self, exchange, **kwargs):  # noqa: E501
        """Get exchange and server status  # noqa: E501

        Delivers the status of the market and the server as well as configuration information (list of delivery areas etc.). **Heads up!** You should query if the server status is \"OK\" before starting any trading activities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_status_with_http_info(exchange, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MarketStatus, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `get_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "MarketStatus",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/market', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def login(self, exchange, credentials, **kwargs):  # noqa: E501
        """Perform exchange login  # noqa: E501

        Allows you to log the server into the exchange. This usually needs to be done only once at setup or if the exchange password has changed and can only be done by a master-API-key **Heads up!** This function is NOT for you logging into this server (access to that is done via an API key) but to log the server into the exchange.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.login(exchange, credentials, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param credentials: (required)
        :type credentials: Credentials
        :param force: It will disconnect anyone already connected with the specified account.  **Note**: Only relevant for M7 based exchanges (HUPX, SouthPool, TGE, EPEX, SEMO, OPCOM).
        :type force: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MarketStatus
        """
        kwargs['_return_http_data_only'] = True
        return self.login_with_http_info(exchange, credentials, **kwargs)  # noqa: E501

    def login_with_http_info(self, exchange, credentials, **kwargs):  # noqa: E501
        """Perform exchange login  # noqa: E501

        Allows you to log the server into the exchange. This usually needs to be done only once at setup or if the exchange password has changed and can only be done by a master-API-key **Heads up!** This function is NOT for you logging into this server (access to that is done via an API key) but to log the server into the exchange.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.login_with_http_info(exchange, credentials, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param credentials: (required)
        :type credentials: Credentials
        :param force: It will disconnect anyone already connected with the specified account.  **Note**: Only relevant for M7 based exchanges (HUPX, SouthPool, TGE, EPEX, SEMO, OPCOM).
        :type force: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MarketStatus, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'credentials',
            'force'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method login" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `login`")  # noqa: E501
        # verify the required parameter 'credentials' is set
        if self.api_client.client_side_validation and local_var_params.get('credentials') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `credentials` when calling `login`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501

        query_params = []
        if local_var_params.get('force') is not None:  # noqa: E501
            query_params.append(('force', local_var_params['force']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'credentials' in local_var_params:
            body_params = local_var_params['credentials']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "MarketStatus",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/market', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def logout(self, exchange, **kwargs):  # noqa: E501
        """Perform exchange logout  # noqa: E501

        Allows you to log the server out of the exchange. This needs to be done only on very rare occasions and can only be done by the master-API-key. **Heads up!** This function is NOT for you logging out of this server but to log out of the exchange.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.logout(exchange, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param delete_orders: If this parameter is set to true, all orders will be deleted on logout.
        :type delete_orders: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MarketStatus
        """
        kwargs['_return_http_data_only'] = True
        return self.logout_with_http_info(exchange, **kwargs)  # noqa: E501

    def logout_with_http_info(self, exchange, **kwargs):  # noqa: E501
        """Perform exchange logout  # noqa: E501

        Allows you to log the server out of the exchange. This needs to be done only on very rare occasions and can only be done by the master-API-key. **Heads up!** This function is NOT for you logging out of this server but to log out of the exchange.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.logout_with_http_info(exchange, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param delete_orders: If this parameter is set to true, all orders will be deleted on logout.
        :type delete_orders: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MarketStatus, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'delete_orders'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method logout" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `logout`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501

        query_params = []
        if local_var_params.get('delete_orders') is not None:  # noqa: E501
            query_params.append(('delete_orders', local_var_params['delete_orders']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "MarketStatus",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/market', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def set_market_options(self, exchange, credentials, **kwargs):  # noqa: E501
        """Set exchange options  # noqa: E501

        Allows you to configure options. You can activate internal trading (cross trading recognition) here by setting internal_trading to \"default_yes\" or \"default_no\" (which sets the default value for the \"internal trading\" parameter in POST /orders). Set to \"inactive\" to fully deactivate this feature (which will lead to the server ignoring the corresponding parameter in the orders). If set to \"inactive\", an error is returned when sending orders with \"internal_trading\" set to TRUE. **Note:** There is no cross-trade recognition for user defined block orders, linked orders and for iceberg orders with a peak-price-delta that is not equal to 0.  The parameter \"restrict_safe_mode\" defines which API keys can toggle the market mode via PUT /market/mode. If set to false, all master API keys, tenant master API keys and API keys with the 'can_trade' attribute set to true can toggle the market mode. If set to true, only master API keys are allowed to set the mode. **Heads up** - The scope of the safe mode includes ALL exchanges for the instance. However, it is not possible to immediately remove all orders from other exchanges, and there might be a small delay.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_market_options(exchange, credentials, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param credentials: (required)
        :type credentials: MarketOptions
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MarketStatus
        """
        kwargs['_return_http_data_only'] = True
        return self.set_market_options_with_http_info(exchange, credentials, **kwargs)  # noqa: E501

    def set_market_options_with_http_info(self, exchange, credentials, **kwargs):  # noqa: E501
        """Set exchange options  # noqa: E501

        Allows you to configure options. You can activate internal trading (cross trading recognition) here by setting internal_trading to \"default_yes\" or \"default_no\" (which sets the default value for the \"internal trading\" parameter in POST /orders). Set to \"inactive\" to fully deactivate this feature (which will lead to the server ignoring the corresponding parameter in the orders). If set to \"inactive\", an error is returned when sending orders with \"internal_trading\" set to TRUE. **Note:** There is no cross-trade recognition for user defined block orders, linked orders and for iceberg orders with a peak-price-delta that is not equal to 0.  The parameter \"restrict_safe_mode\" defines which API keys can toggle the market mode via PUT /market/mode. If set to false, all master API keys, tenant master API keys and API keys with the 'can_trade' attribute set to true can toggle the market mode. If set to true, only master API keys are allowed to set the mode. **Heads up** - The scope of the safe mode includes ALL exchanges for the instance. However, it is not possible to immediately remove all orders from other exchanges, and there might be a small delay.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_market_options_with_http_info(exchange, credentials, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param credentials: (required)
        :type credentials: MarketOptions
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MarketStatus, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'credentials'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_market_options" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `set_market_options`")  # noqa: E501
        # verify the required parameter 'credentials' is set
        if self.api_client.client_side_validation and local_var_params.get('credentials') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `credentials` when calling `set_market_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'credentials' in local_var_params:
            body_params = local_var_params['credentials']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "MarketStatus",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/market/options', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def switch_mode(self, exchange, value, **kwargs):  # noqa: E501
        """Toggle market mode  # noqa: E501

        Safe mode (emergency stop) has the following effects:  * all algorithm instances are stopped and can't be started  * all active orders are deleted from the market  * order entry / modification is disabled  * trades can still be recalled  This method is accessible to all master API keys, tenant master API keys and API keys with the 'can_trade' attribute set to true. If 'restrict_safe_mode' is enabled in the market options, only master API keys are allowed to set the mode. **Heads up** - The scope of the safe mode includes ALL exchanges for the instance. However, it is not possible to immediately remove all orders from other exchanges, and there might be a small delay.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.switch_mode(exchange, value, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param value: (required)
        :type value: MarketMode
        :param include_external_orders: If set to true, PowerBot will also delete orders that were not created through PowerBot, for example orders from ComTrader.
        :type include_external_orders: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.switch_mode_with_http_info(exchange, value, **kwargs)  # noqa: E501

    def switch_mode_with_http_info(self, exchange, value, **kwargs):  # noqa: E501
        """Toggle market mode  # noqa: E501

        Safe mode (emergency stop) has the following effects:  * all algorithm instances are stopped and can't be started  * all active orders are deleted from the market  * order entry / modification is disabled  * trades can still be recalled  This method is accessible to all master API keys, tenant master API keys and API keys with the 'can_trade' attribute set to true. If 'restrict_safe_mode' is enabled in the market options, only master API keys are allowed to set the mode. **Heads up** - The scope of the safe mode includes ALL exchanges for the instance. However, it is not possible to immediately remove all orders from other exchanges, and there might be a small delay.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.switch_mode_with_http_info(exchange, value, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param value: (required)
        :type value: MarketMode
        :param include_external_orders: If set to true, PowerBot will also delete orders that were not created through PowerBot, for example orders from ComTrader.
        :type include_external_orders: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'value',
            'include_external_orders'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method switch_mode" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `switch_mode`")  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and local_var_params.get('value') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `value` when calling `switch_mode`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501

        query_params = []
        if local_var_params.get('include_external_orders') is not None:  # noqa: E501
            query_params.append(('include_external_orders', local_var_params['include_external_orders']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'value' in local_var_params:
            body_params = local_var_params['value']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/{exchange}/v2/api/market/mode', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
