# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoint The PowerBot service is available at the following REST endpoint:  ``` $api_url_placeholder ```  Access to the API is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.26.4
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from powerbot_client.api_client import ApiClient
from powerbot_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class OrdersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_orders(self, exchange, order, **kwargs):  # noqa: E501
        """Place multiple orders  # noqa: E501

        Allows you to place a list of orders at once.  In case of success (no rejected orders), one or more order elements are returned for each order entry, otherwise a single error message is returned (`ErrorResponse`). To receive individual error messages for rejected orders, set `include_errors` to `true`.  If the placed orders interact with previously placed own orders (internal trades), the changes to those orders are also included in the response list.  When sending a list of orders, the list needs to have execution instructions being either \"valid\" (default) or linked. Please be aware that each order needs to be valid, otherwise all orders are declined by the exchange system. Please see documentation for further details.  The header of the return element includes a property named \"X-Total-Internal-Trades\", which tells you the number of internal trades that were involved in this request, if cross-trades were executed as internal trades.  Note that the expected net position parameters should not be used in combination with block products.  Please note that the response of an order placement is not consistent for different exchanges and different product types. Resulting from this, a user should never rely on a particular response of any order placement and always validate actions via other requests (e.g. GET/trades, GET/internal-trades, GET/orders).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_orders(exchange, order, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param order: (required)
        :type order: list[OrderEntry]
        :param exec_instruction: Defines the execution instruction for the whole list of orders:   * **NONE**: All orders are treated independently.   * **VALID**: default. All orders must be valid, meaning they must pass the order validation of the exchange system (e.g. the price of the order must be in the price range of the product). If one order does not pass the validation, the full list of submitted orders is rejected.   * **LNKD**: Linked orders - the provided orders are linked together and should be executed all at once. This option can only be used if all orders have the same product and the execution restriction FOK (Fill-or-Kill). In case one of the orders cannot be executed, the whole list is not executed by the exchange.
        :type exec_instruction: ExecutionInstruction
        :param internal_trading: If set to true, cross-trade recognition will be performed before submitting the orders to the exchange. Set it to false if you don't want internal trading. If left blank, default market options will apply. If internal trading is set to \"inactive\" in the market options, an error is returned when sending orders with \"internal_trading\" set to true.  **Note:** There is no cross-trade recognition for user defined block orders, linked orders and for iceberg orders with a peak-price-delta that is not equal to 0.
        :type internal_trading: bool
        :param fail_on_limit_violations: If set to true, a single limit violation will prevent sending all orders to the exchange. If set to false, orders for contracts which cause a violation won't be sent, orders which do not cause a violation will be sent to the exchange. If not set, true is taken as default value.  Please note that this only covers limit violations on limits defined by the system. Violating limits defined at exchange level on one order will not prevent correct orders from being sent to the exchange. In this case, this parameter does not have any effect.
        :type fail_on_limit_violations: bool
        :param ignore_order_action_quota: The behavior on this parameter is depending on the current exchange. * M7 (HUPX, SouthPool, TGE, EPEX, SEMO, OPCOM): If set to true, the exchange OMT limit can be bypassed, as long as the current load is under L2. * Nordpool: If set to true, default exchange throttling mechanism is bypassed by PowerBot. Nordpool may still reject the request.
        :type ignore_order_action_quota: bool
        :param include_errors: If this parameter is set to true, the response will contain orders that failed to be processed by the exchange, along with successfully placed orders. If set to false and any order fails, a single error object (`ErrorResponse`) containing all error messages will be returned. Please note that this parameter only effects the response and has no effect on how orders are treated by PowerBot or the exchange.
        :type include_errors: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[OwnOrder]
        """
        kwargs['_return_http_data_only'] = True
        return self.add_orders_with_http_info(exchange, order, **kwargs)  # noqa: E501

    def add_orders_with_http_info(self, exchange, order, **kwargs):  # noqa: E501
        """Place multiple orders  # noqa: E501

        Allows you to place a list of orders at once.  In case of success (no rejected orders), one or more order elements are returned for each order entry, otherwise a single error message is returned (`ErrorResponse`). To receive individual error messages for rejected orders, set `include_errors` to `true`.  If the placed orders interact with previously placed own orders (internal trades), the changes to those orders are also included in the response list.  When sending a list of orders, the list needs to have execution instructions being either \"valid\" (default) or linked. Please be aware that each order needs to be valid, otherwise all orders are declined by the exchange system. Please see documentation for further details.  The header of the return element includes a property named \"X-Total-Internal-Trades\", which tells you the number of internal trades that were involved in this request, if cross-trades were executed as internal trades.  Note that the expected net position parameters should not be used in combination with block products.  Please note that the response of an order placement is not consistent for different exchanges and different product types. Resulting from this, a user should never rely on a particular response of any order placement and always validate actions via other requests (e.g. GET/trades, GET/internal-trades, GET/orders).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_orders_with_http_info(exchange, order, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param order: (required)
        :type order: list[OrderEntry]
        :param exec_instruction: Defines the execution instruction for the whole list of orders:   * **NONE**: All orders are treated independently.   * **VALID**: default. All orders must be valid, meaning they must pass the order validation of the exchange system (e.g. the price of the order must be in the price range of the product). If one order does not pass the validation, the full list of submitted orders is rejected.   * **LNKD**: Linked orders - the provided orders are linked together and should be executed all at once. This option can only be used if all orders have the same product and the execution restriction FOK (Fill-or-Kill). In case one of the orders cannot be executed, the whole list is not executed by the exchange.
        :type exec_instruction: ExecutionInstruction
        :param internal_trading: If set to true, cross-trade recognition will be performed before submitting the orders to the exchange. Set it to false if you don't want internal trading. If left blank, default market options will apply. If internal trading is set to \"inactive\" in the market options, an error is returned when sending orders with \"internal_trading\" set to true.  **Note:** There is no cross-trade recognition for user defined block orders, linked orders and for iceberg orders with a peak-price-delta that is not equal to 0.
        :type internal_trading: bool
        :param fail_on_limit_violations: If set to true, a single limit violation will prevent sending all orders to the exchange. If set to false, orders for contracts which cause a violation won't be sent, orders which do not cause a violation will be sent to the exchange. If not set, true is taken as default value.  Please note that this only covers limit violations on limits defined by the system. Violating limits defined at exchange level on one order will not prevent correct orders from being sent to the exchange. In this case, this parameter does not have any effect.
        :type fail_on_limit_violations: bool
        :param ignore_order_action_quota: The behavior on this parameter is depending on the current exchange. * M7 (HUPX, SouthPool, TGE, EPEX, SEMO, OPCOM): If set to true, the exchange OMT limit can be bypassed, as long as the current load is under L2. * Nordpool: If set to true, default exchange throttling mechanism is bypassed by PowerBot. Nordpool may still reject the request.
        :type ignore_order_action_quota: bool
        :param include_errors: If this parameter is set to true, the response will contain orders that failed to be processed by the exchange, along with successfully placed orders. If set to false and any order fails, a single error object (`ErrorResponse`) containing all error messages will be returned. Please note that this parameter only effects the response and has no effect on how orders are treated by PowerBot or the exchange.
        :type include_errors: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[OwnOrder], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'order',
            'exec_instruction',
            'internal_trading',
            'fail_on_limit_violations',
            'ignore_order_action_quota',
            'include_errors'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_orders" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `add_orders`")  # noqa: E501
        # verify the required parameter 'order' is set
        if self.api_client.client_side_validation and local_var_params.get('order') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `order` when calling `add_orders`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501

        query_params = []
        if local_var_params.get('exec_instruction') is not None:  # noqa: E501
            query_params.append(('exec_instruction', local_var_params['exec_instruction']))  # noqa: E501
        if local_var_params.get('internal_trading') is not None:  # noqa: E501
            query_params.append(('internal_trading', local_var_params['internal_trading']))  # noqa: E501
        if local_var_params.get('fail_on_limit_violations') is not None:  # noqa: E501
            query_params.append(('fail_on_limit_violations', local_var_params['fail_on_limit_violations']))  # noqa: E501
        if local_var_params.get('ignore_order_action_quota') is not None:  # noqa: E501
            query_params.append(('ignore_order_action_quota', local_var_params['ignore_order_action_quota']))  # noqa: E501
        if local_var_params.get('include_errors') is not None:  # noqa: E501
            query_params.append(('include_errors', local_var_params['include_errors']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order' in local_var_params:
            body_params = local_var_params['order']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[OwnOrder]",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/orders/list', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_orders(self, exchange, portfolio_id, **kwargs):  # noqa: E501
        """Delete all orders  # noqa: E501

        Allows you to delete all orders of a portfolio  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_orders(exchange, portfolio_id, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param portfolio_id: (required)
        :type portfolio_id: list[str]
        :param delivery_areas:
        :type delivery_areas: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[OwnOrder]
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_orders_with_http_info(exchange, portfolio_id, **kwargs)  # noqa: E501

    def delete_orders_with_http_info(self, exchange, portfolio_id, **kwargs):  # noqa: E501
        """Delete all orders  # noqa: E501

        Allows you to delete all orders of a portfolio  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_orders_with_http_info(exchange, portfolio_id, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param portfolio_id: (required)
        :type portfolio_id: list[str]
        :param delivery_areas:
        :type delivery_areas: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[OwnOrder], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'portfolio_id',
            'delivery_areas'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_orders" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `delete_orders`")  # noqa: E501
        # verify the required parameter 'portfolio_id' is set
        if self.api_client.client_side_validation and local_var_params.get('portfolio_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `portfolio_id` when calling `delete_orders`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501

        query_params = []
        if local_var_params.get('portfolio_id') is not None:  # noqa: E501
            query_params.append(('portfolio_id', local_var_params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501
        if local_var_params.get('delivery_areas') is not None:  # noqa: E501
            query_params.append(('delivery_areas', local_var_params['delivery_areas']))  # noqa: E501
            collection_formats['delivery_areas'] = 'csv'  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[OwnOrder]",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/orders', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_own_order_history(self, exchange, order_id, **kwargs):  # noqa: E501
        """List all revisions of an order  # noqa: E501

        List all revisions of an order. This request keeps track of the complete order history regardless of changed IDs, as an order_id might change over time when certain modifications are applied. Therefore, querying an order_id includes all preceding IDs of the requested order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_own_order_history(exchange, order_id, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param order_id: This id will be used to get all orders related. (required)
        :type order_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[OwnOrder]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_own_order_history_with_http_info(exchange, order_id, **kwargs)  # noqa: E501

    def get_own_order_history_with_http_info(self, exchange, order_id, **kwargs):  # noqa: E501
        """List all revisions of an order  # noqa: E501

        List all revisions of an order. This request keeps track of the complete order history regardless of changed IDs, as an order_id might change over time when certain modifications are applied. Therefore, querying an order_id includes all preceding IDs of the requested order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_own_order_history_with_http_info(exchange, order_id, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param order_id: This id will be used to get all orders related. (required)
        :type order_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[OwnOrder], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'order_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_own_order_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `get_own_order_history`")  # noqa: E501
        # verify the required parameter 'order_id' is set
        if self.api_client.client_side_validation and local_var_params.get('order_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `order_id` when calling `get_own_order_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501
        if 'order_id' in local_var_params:
            path_params['order_id'] = local_var_params['order_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[OwnOrder]",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/orders/{order_id}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_own_orders(self, exchange, **kwargs):  # noqa: E501
        """List own orders  # noqa: E501

        Retrieves a list of all your own orders at the exchange for an array of portfolios. Allows you to filter your orders for delivery area and/or contract_id. The return element will provide all the order_ids, the contracts the orders belong to, as well as an action status, which determines the current status of the order (added, partly executed, fully executed, etc).  Please use the action status of orders to determine if you have done trades, as trade reporting from the exchange is sometimes slightly delayed.  The parameter active_only will only list orders, which are active. The filter user_code allows you to filter orders created by a specific exchange user. Please be aware that this method uses pagination. Shadow orders can only be retrieved as long as they are active.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_own_orders(exchange, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param portfolio_id:
        :type portfolio_id: list[str]
        :param offset: Offset when loading a list of items
        :type offset: int
        :param limit: Limits the number of loaded orders. If `active_only` is set to `true`, no limits are imposed (all matching orders are returned). If set to `false` the limit defaults to 150.
        :type limit: int
        :param contract_ids: Show only those orders related to a specific contract
        :type contract_ids: list[str]
        :param order_ids:
        :type order_ids: list[str]
        :param active_only: Returns only those orders which are active
        :type active_only: bool
        :param delivery_area: The EIC of the delivery area
        :type delivery_area: str
        :param user_code: the exchange user code
        :type user_code: str
        :param cl_ordr_id:
        :type cl_ordr_id: str
        :param txt: Filter by text.
        :type txt: str
        :param strategy_ids: Filter by strategy ID.
        :type strategy_ids: list[str]
        :param contract_id: Please use contract_ids instead! If contract_ids are set, this field will be ignored!
        :type contract_id: list[str]
        :param status:
        :type status: list[OrderState]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[OwnOrder]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_own_orders_with_http_info(exchange, **kwargs)  # noqa: E501

    def get_own_orders_with_http_info(self, exchange, **kwargs):  # noqa: E501
        """List own orders  # noqa: E501

        Retrieves a list of all your own orders at the exchange for an array of portfolios. Allows you to filter your orders for delivery area and/or contract_id. The return element will provide all the order_ids, the contracts the orders belong to, as well as an action status, which determines the current status of the order (added, partly executed, fully executed, etc).  Please use the action status of orders to determine if you have done trades, as trade reporting from the exchange is sometimes slightly delayed.  The parameter active_only will only list orders, which are active. The filter user_code allows you to filter orders created by a specific exchange user. Please be aware that this method uses pagination. Shadow orders can only be retrieved as long as they are active.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_own_orders_with_http_info(exchange, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param portfolio_id:
        :type portfolio_id: list[str]
        :param offset: Offset when loading a list of items
        :type offset: int
        :param limit: Limits the number of loaded orders. If `active_only` is set to `true`, no limits are imposed (all matching orders are returned). If set to `false` the limit defaults to 150.
        :type limit: int
        :param contract_ids: Show only those orders related to a specific contract
        :type contract_ids: list[str]
        :param order_ids:
        :type order_ids: list[str]
        :param active_only: Returns only those orders which are active
        :type active_only: bool
        :param delivery_area: The EIC of the delivery area
        :type delivery_area: str
        :param user_code: the exchange user code
        :type user_code: str
        :param cl_ordr_id:
        :type cl_ordr_id: str
        :param txt: Filter by text.
        :type txt: str
        :param strategy_ids: Filter by strategy ID.
        :type strategy_ids: list[str]
        :param contract_id: Please use contract_ids instead! If contract_ids are set, this field will be ignored!
        :type contract_id: list[str]
        :param status:
        :type status: list[OrderState]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[OwnOrder], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'portfolio_id',
            'offset',
            'limit',
            'contract_ids',
            'order_ids',
            'active_only',
            'delivery_area',
            'user_code',
            'cl_ordr_id',
            'txt',
            'strategy_ids',
            'contract_id',
            'status'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_own_orders" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `get_own_orders`")  # noqa: E501

        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `get_own_orders`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_own_orders`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_own_orders`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501

        query_params = []
        if local_var_params.get('portfolio_id') is not None:  # noqa: E501
            query_params.append(('portfolio_id', local_var_params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('contract_ids') is not None:  # noqa: E501
            query_params.append(('contract_ids', local_var_params['contract_ids']))  # noqa: E501
            collection_formats['contract_ids'] = 'csv'  # noqa: E501
        if local_var_params.get('order_ids') is not None:  # noqa: E501
            query_params.append(('order_ids', local_var_params['order_ids']))  # noqa: E501
            collection_formats['order_ids'] = 'csv'  # noqa: E501
        if local_var_params.get('active_only') is not None:  # noqa: E501
            query_params.append(('active_only', local_var_params['active_only']))  # noqa: E501
        if local_var_params.get('delivery_area') is not None:  # noqa: E501
            query_params.append(('delivery_area', local_var_params['delivery_area']))  # noqa: E501
        if local_var_params.get('user_code') is not None:  # noqa: E501
            query_params.append(('user_code', local_var_params['user_code']))  # noqa: E501
        if local_var_params.get('cl_ordr_id') is not None:  # noqa: E501
            query_params.append(('clOrdrId', local_var_params['cl_ordr_id']))  # noqa: E501
        if local_var_params.get('txt') is not None:  # noqa: E501
            query_params.append(('txt', local_var_params['txt']))  # noqa: E501
        if local_var_params.get('strategy_ids') is not None:  # noqa: E501
            query_params.append(('strategy_ids', local_var_params['strategy_ids']))  # noqa: E501
            collection_formats['strategy_ids'] = 'multi'  # noqa: E501
        if local_var_params.get('contract_id') is not None:  # noqa: E501
            query_params.append(('contract_id', local_var_params['contract_id']))  # noqa: E501
            collection_formats['contract_id'] = 'csv'  # noqa: E501
        if local_var_params.get('status') is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
            collection_formats['status'] = 'multi'  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[OwnOrder]",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/orders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_own_orders_history(self, exchange, from_api_timestamp, to_api_timestamp, **kwargs):  # noqa: E501
        """Own order history  # noqa: E501

        List own order history for a given time period. This method uses pagination. The result is sorted by `api_timestamp`, and includes all order revisions within the specified time period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_own_orders_history(exchange, from_api_timestamp, to_api_timestamp, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param from_api_timestamp: from timestamp is 'inclusive' (i.e. >=) (required)
        :type from_api_timestamp: datetime
        :param to_api_timestamp: to timestamp is 'exclusive' (i.e. <) (required)
        :type to_api_timestamp: datetime
        :param offset: Offset when loading a list of items
        :type offset: int
        :param limit: Limits the number of loaded orders
        :type limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[OwnOrder]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_own_orders_history_with_http_info(exchange, from_api_timestamp, to_api_timestamp, **kwargs)  # noqa: E501

    def get_own_orders_history_with_http_info(self, exchange, from_api_timestamp, to_api_timestamp, **kwargs):  # noqa: E501
        """Own order history  # noqa: E501

        List own order history for a given time period. This method uses pagination. The result is sorted by `api_timestamp`, and includes all order revisions within the specified time period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_own_orders_history_with_http_info(exchange, from_api_timestamp, to_api_timestamp, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param from_api_timestamp: from timestamp is 'inclusive' (i.e. >=) (required)
        :type from_api_timestamp: datetime
        :param to_api_timestamp: to timestamp is 'exclusive' (i.e. <) (required)
        :type to_api_timestamp: datetime
        :param offset: Offset when loading a list of items
        :type offset: int
        :param limit: Limits the number of loaded orders
        :type limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[OwnOrder], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'from_api_timestamp',
            'to_api_timestamp',
            'offset',
            'limit'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_own_orders_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `get_own_orders_history`")  # noqa: E501
        # verify the required parameter 'from_api_timestamp' is set
        if self.api_client.client_side_validation and local_var_params.get('from_api_timestamp') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `from_api_timestamp` when calling `get_own_orders_history`")  # noqa: E501
        # verify the required parameter 'to_api_timestamp' is set
        if self.api_client.client_side_validation and local_var_params.get('to_api_timestamp') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `to_api_timestamp` when calling `get_own_orders_history`")  # noqa: E501

        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `get_own_orders_history`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_own_orders_history`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_own_orders_history`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501

        query_params = []
        if local_var_params.get('from_api_timestamp') is not None:  # noqa: E501
            query_params.append(('from_api_timestamp', local_var_params['from_api_timestamp']))  # noqa: E501
        if local_var_params.get('to_api_timestamp') is not None:  # noqa: E501
            query_params.append(('to_api_timestamp', local_var_params['to_api_timestamp']))  # noqa: E501
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[OwnOrder]",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/orders/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def modify_order(self, exchange, order_id, revision_no, **kwargs):  # noqa: E501
        """Modify single order  # noqa: E501

        DEPRECATED: please use `PUT /orders/list`.  Allows you to change, activate or deactivate an existing order at the market. In order to change an order, you need to provide the order_id as well as the latest revision of the order (available via GET /orders), in order to prevent changing an order that has been changed (e.g. partly executed) since you last observed it. If the revision number is incorrect, the modification will be declined by the exchange system.  Note that some modifications do not update the order directly (e.g price/quantity changes), depending on the exchange. In this case, a new order is created with the modification and the original order is deleted.  Please note that the response of an order modification is not consistent for different exchanges and different product types. Resulting from this, a user should never rely on a particular response of any order modification and always validate actions via other requests (e.g. GET/trades, GET/internal-trades, GET/orders).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_order(exchange, order_id, revision_no, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param order_id: the unique order_id of the order which should be modified. **Heads up!** The order_id can change after the modification. (required)
        :type order_id: str
        :param revision_no: The revision of the order which should be modified **Heads up!** If the revision does not match with the order's current revision in the exchange backend the modification will cause an error. (required)
        :type revision_no: int
        :param internal_trading: If set to true, cross-trade recognition will be performed before submitting the orders to the exchange. Set it to false if you don't want internal trading. If left blank, default market options will apply. If internal trading is set to \"inactive\" in the market options, an error is returned when sending orders with \"internal_trading\" set to true.  **Note:** There is no cross-trade recognition for user defined block orders, linked orders and for iceberg orders with a peak-price-delta that is not equal to 0.
        :type internal_trading: bool
        :param fail_on_limit_violations: If set to true, a single limit violation will prevent sending all orders to the exchange. If set to false, orders for contracts which cause a violation won't be sent, orders which do not cause a violation will be sent to the exchange. If not set, true is taken as default value.  Please note that this only covers limit violations on limits defined by the system. Violating limits defined at exchange level on one order will not prevent correct orders from being sent to the exchange. In this case, this parameter does not have any effect.
        :type fail_on_limit_violations: bool
        :param ignore_order_action_quota: The behavior on this parameter is depending on the current exchange. * M7 (HUPX, SouthPool, TGE, EPEX, SEMO, OPCOM): If set to true, the exchange OMT limit can be bypassed, as long as the current load is under L2. * Nordpool: If set to true, default exchange throttling mechanism is bypassed by PowerBot. Nordpool may still reject the request.
        :type ignore_order_action_quota: bool
        :param modifications:
        :type modifications: OrderModify
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[OwnOrder]
        """
        kwargs['_return_http_data_only'] = True
        return self.modify_order_with_http_info(exchange, order_id, revision_no, **kwargs)  # noqa: E501

    def modify_order_with_http_info(self, exchange, order_id, revision_no, **kwargs):  # noqa: E501
        """Modify single order  # noqa: E501

        DEPRECATED: please use `PUT /orders/list`.  Allows you to change, activate or deactivate an existing order at the market. In order to change an order, you need to provide the order_id as well as the latest revision of the order (available via GET /orders), in order to prevent changing an order that has been changed (e.g. partly executed) since you last observed it. If the revision number is incorrect, the modification will be declined by the exchange system.  Note that some modifications do not update the order directly (e.g price/quantity changes), depending on the exchange. In this case, a new order is created with the modification and the original order is deleted.  Please note that the response of an order modification is not consistent for different exchanges and different product types. Resulting from this, a user should never rely on a particular response of any order modification and always validate actions via other requests (e.g. GET/trades, GET/internal-trades, GET/orders).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_order_with_http_info(exchange, order_id, revision_no, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param order_id: the unique order_id of the order which should be modified. **Heads up!** The order_id can change after the modification. (required)
        :type order_id: str
        :param revision_no: The revision of the order which should be modified **Heads up!** If the revision does not match with the order's current revision in the exchange backend the modification will cause an error. (required)
        :type revision_no: int
        :param internal_trading: If set to true, cross-trade recognition will be performed before submitting the orders to the exchange. Set it to false if you don't want internal trading. If left blank, default market options will apply. If internal trading is set to \"inactive\" in the market options, an error is returned when sending orders with \"internal_trading\" set to true.  **Note:** There is no cross-trade recognition for user defined block orders, linked orders and for iceberg orders with a peak-price-delta that is not equal to 0.
        :type internal_trading: bool
        :param fail_on_limit_violations: If set to true, a single limit violation will prevent sending all orders to the exchange. If set to false, orders for contracts which cause a violation won't be sent, orders which do not cause a violation will be sent to the exchange. If not set, true is taken as default value.  Please note that this only covers limit violations on limits defined by the system. Violating limits defined at exchange level on one order will not prevent correct orders from being sent to the exchange. In this case, this parameter does not have any effect.
        :type fail_on_limit_violations: bool
        :param ignore_order_action_quota: The behavior on this parameter is depending on the current exchange. * M7 (HUPX, SouthPool, TGE, EPEX, SEMO, OPCOM): If set to true, the exchange OMT limit can be bypassed, as long as the current load is under L2. * Nordpool: If set to true, default exchange throttling mechanism is bypassed by PowerBot. Nordpool may still reject the request.
        :type ignore_order_action_quota: bool
        :param modifications:
        :type modifications: OrderModify
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[OwnOrder], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'order_id',
            'revision_no',
            'internal_trading',
            'fail_on_limit_violations',
            'ignore_order_action_quota',
            'modifications'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_order" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `modify_order`")  # noqa: E501
        # verify the required parameter 'order_id' is set
        if self.api_client.client_side_validation and local_var_params.get('order_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `order_id` when calling `modify_order`")  # noqa: E501
        # verify the required parameter 'revision_no' is set
        if self.api_client.client_side_validation and local_var_params.get('revision_no') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `revision_no` when calling `modify_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501
        if 'order_id' in local_var_params:
            path_params['order_id'] = local_var_params['order_id']  # noqa: E501
        if 'revision_no' in local_var_params:
            path_params['revision_no'] = local_var_params['revision_no']  # noqa: E501

        query_params = []
        if local_var_params.get('internal_trading') is not None:  # noqa: E501
            query_params.append(('internal_trading', local_var_params['internal_trading']))  # noqa: E501
        if local_var_params.get('fail_on_limit_violations') is not None:  # noqa: E501
            query_params.append(('fail_on_limit_violations', local_var_params['fail_on_limit_violations']))  # noqa: E501
        if local_var_params.get('ignore_order_action_quota') is not None:  # noqa: E501
            query_params.append(('ignore_order_action_quota', local_var_params['ignore_order_action_quota']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'modifications' in local_var_params:
            body_params = local_var_params['modifications']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[OwnOrder]",
            409: "ErrorResponse",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/order/{order_id}/{revision_no}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def modify_orders(self, exchange, **kwargs):  # noqa: E501
        """Modify multiple orders  # noqa: E501

        Allows you to modify, activate or deactivate existing orders. In case of success (no rejected modifications), one or more order elements are returned for each order entry, otherwise a single error message is returned (`ErrorResponse`). To receive individual error messages for rejected orders, set `include_errors` to `true`.  If the modified orders interact with previously placed own orders (internal trades), the changes to those orders are also included in the response list.  To change an order, you need to provide the `order_id` as well as the latest revision number of the order (available via `GET /orders`), in order to prevent changing an order that has been changed (e.g. partly executed) since you last observed it. If the revision number is incorrect, the modification will be declined by the exchange system.  Note that some modifications do not update the order directly (e.g price/quantity changes), depending on the exchange. In this case, a new order with a new ID is created with the modification and the original order is deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_orders(exchange, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param internal_trading: If set to true, cross-trade recognition will be performed before submitting the orders to the exchange. Set it to false if you don't want internal trading. If left blank, default market options will apply. If internal trading is set to \"inactive\" in the market options, an error is returned when sending orders with \"internal_trading\" set to true.  **Note:** There is no cross-trade recognition for user defined block orders, linked orders and for iceberg orders with a peak-price-delta that is not equal to 0.
        :type internal_trading: bool
        :param fail_on_limit_violations: If set to true, a single limit violation will prevent sending all orders to the exchange. If set to false, orders for contracts which cause a violation won't be sent, orders which do not cause a violation will be sent to the exchange. If not set, true is taken as default value.  Please note that this only covers limit violations on limits defined by the system. Violating limits defined at exchange level on one order will not prevent correct orders from being sent to the exchange. In this case, this parameter does not have any effect.
        :type fail_on_limit_violations: bool
        :param ignore_order_action_quota: The behavior on this parameter is depending on the current exchange. * M7 (HUPX, SouthPool, TGE, EPEX, SEMO, OPCOM): If set to true, the exchange OMT limit can be bypassed, as long as the current load is under L2. * Nordpool: If set to true, default exchange throttling mechanism is bypassed by PowerBot. Nordpool may still reject the request.
        :type ignore_order_action_quota: bool
        :param include_errors: If this parameter is set to true, the response will contain orders that failed to be processed by the exchange, along with successfully placed orders. If set to false and any order fails, a single error object (`ErrorResponse`) containing all error messages will be returned. Please note that this parameter only effects the response and has no effect on how orders are treated by PowerBot or the exchange.
        :type include_errors: bool
        :param infer_order_revisions: Removes the need to supply the current revision of orders to be modified.  This can lead to unintended consequences (e.g. an order being in a different initial state that the client assumes), and can still fail due to concurrent modifications.
        :type infer_order_revisions: bool
        :param modifications:
        :type modifications: list[OrderModifyItem]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[OwnOrder]
        """
        kwargs['_return_http_data_only'] = True
        return self.modify_orders_with_http_info(exchange, **kwargs)  # noqa: E501

    def modify_orders_with_http_info(self, exchange, **kwargs):  # noqa: E501
        """Modify multiple orders  # noqa: E501

        Allows you to modify, activate or deactivate existing orders. In case of success (no rejected modifications), one or more order elements are returned for each order entry, otherwise a single error message is returned (`ErrorResponse`). To receive individual error messages for rejected orders, set `include_errors` to `true`.  If the modified orders interact with previously placed own orders (internal trades), the changes to those orders are also included in the response list.  To change an order, you need to provide the `order_id` as well as the latest revision number of the order (available via `GET /orders`), in order to prevent changing an order that has been changed (e.g. partly executed) since you last observed it. If the revision number is incorrect, the modification will be declined by the exchange system.  Note that some modifications do not update the order directly (e.g price/quantity changes), depending on the exchange. In this case, a new order with a new ID is created with the modification and the original order is deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_orders_with_http_info(exchange, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param internal_trading: If set to true, cross-trade recognition will be performed before submitting the orders to the exchange. Set it to false if you don't want internal trading. If left blank, default market options will apply. If internal trading is set to \"inactive\" in the market options, an error is returned when sending orders with \"internal_trading\" set to true.  **Note:** There is no cross-trade recognition for user defined block orders, linked orders and for iceberg orders with a peak-price-delta that is not equal to 0.
        :type internal_trading: bool
        :param fail_on_limit_violations: If set to true, a single limit violation will prevent sending all orders to the exchange. If set to false, orders for contracts which cause a violation won't be sent, orders which do not cause a violation will be sent to the exchange. If not set, true is taken as default value.  Please note that this only covers limit violations on limits defined by the system. Violating limits defined at exchange level on one order will not prevent correct orders from being sent to the exchange. In this case, this parameter does not have any effect.
        :type fail_on_limit_violations: bool
        :param ignore_order_action_quota: The behavior on this parameter is depending on the current exchange. * M7 (HUPX, SouthPool, TGE, EPEX, SEMO, OPCOM): If set to true, the exchange OMT limit can be bypassed, as long as the current load is under L2. * Nordpool: If set to true, default exchange throttling mechanism is bypassed by PowerBot. Nordpool may still reject the request.
        :type ignore_order_action_quota: bool
        :param include_errors: If this parameter is set to true, the response will contain orders that failed to be processed by the exchange, along with successfully placed orders. If set to false and any order fails, a single error object (`ErrorResponse`) containing all error messages will be returned. Please note that this parameter only effects the response and has no effect on how orders are treated by PowerBot or the exchange.
        :type include_errors: bool
        :param infer_order_revisions: Removes the need to supply the current revision of orders to be modified.  This can lead to unintended consequences (e.g. an order being in a different initial state that the client assumes), and can still fail due to concurrent modifications.
        :type infer_order_revisions: bool
        :param modifications:
        :type modifications: list[OrderModifyItem]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[OwnOrder], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'internal_trading',
            'fail_on_limit_violations',
            'ignore_order_action_quota',
            'include_errors',
            'infer_order_revisions',
            'modifications'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_orders" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `modify_orders`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501

        query_params = []
        if local_var_params.get('internal_trading') is not None:  # noqa: E501
            query_params.append(('internal_trading', local_var_params['internal_trading']))  # noqa: E501
        if local_var_params.get('fail_on_limit_violations') is not None:  # noqa: E501
            query_params.append(('fail_on_limit_violations', local_var_params['fail_on_limit_violations']))  # noqa: E501
        if local_var_params.get('ignore_order_action_quota') is not None:  # noqa: E501
            query_params.append(('ignore_order_action_quota', local_var_params['ignore_order_action_quota']))  # noqa: E501
        if local_var_params.get('include_errors') is not None:  # noqa: E501
            query_params.append(('include_errors', local_var_params['include_errors']))  # noqa: E501
        if local_var_params.get('infer_order_revisions') is not None:  # noqa: E501
            query_params.append(('infer_order_revisions', local_var_params['infer_order_revisions']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'modifications' in local_var_params:
            body_params = local_var_params['modifications']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[OwnOrder]",
            409: "ErrorResponse",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/orders/list', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_status(self, exchange, orders, **kwargs):  # noqa: E501
        """Change status of all orders  # noqa: E501

        Modifies the status of all your orders at the exchange at once. Please be aware that this is an exchange backend request, which would modify the status of all orders at the exchange (including other tenants and portfolios) and can thus only be performed with api keys that have access to all portfolios within the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_status(exchange, orders, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param orders: (required)
        :type orders: UpdateStatus
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.update_status_with_http_info(exchange, orders, **kwargs)  # noqa: E501

    def update_status_with_http_info(self, exchange, orders, **kwargs):  # noqa: E501
        """Change status of all orders  # noqa: E501

        Modifies the status of all your orders at the exchange at once. Please be aware that this is an exchange backend request, which would modify the status of all orders at the exchange (including other tenants and portfolios) and can thus only be performed with api keys that have access to all portfolios within the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_status_with_http_info(exchange, orders, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param orders: (required)
        :type orders: UpdateStatus
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'orders'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `update_status`")  # noqa: E501
        # verify the required parameter 'orders' is set
        if self.api_client.client_side_validation and local_var_params.get('orders') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `orders` when calling `update_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'orders' in local_var_params:
            body_params = local_var_params['orders']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/{exchange}/v2/api/orders/status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
