# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoint The PowerBot service is available at the following REST endpoint:  ``` $api_url_placeholder ```  Access to the API is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.26.4
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from powerbot_client.api_client import ApiClient
from powerbot_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ReportApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_report_csv_for_period(self, exchange, delivery_area, delivery_day_from, delivery_day_to, **kwargs):  # noqa: E501
        """Create CSV trading report  # noqa: E501

        Creates a detailed trading report in CSV format for a delivery area and a given delivery period. However, as the CSV format is two-dimensional, this report delivers less data compared to the regular report method.  As the generation of the report requires a lot of calculations, please use wisely. The maximum period you can request is limited to 31 days. The request retrieves an array of portfolios and can thus deliver data for one or more portfolios at the same time. However, some data (e.g. positions) cannot be aggregated for portfolios and will thus not show up, if you request data from more than one portfolio. The report can use filters for clOrdrId and txt, which means that only trades for which the filter is valid are included in the report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_report_csv_for_period(exchange, delivery_area, delivery_day_from, delivery_day_to, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param delivery_area: The EIC of the delivery area (required)
        :type delivery_area: str
        :param delivery_day_from: The day the report is for (example \"2018-10-23\") (required)
        :type delivery_day_from: date
        :param delivery_day_to: The day the report is for (example \"2018-10-30\") (required)
        :type delivery_day_to: date
        :param portfolio_id:
        :type portfolio_id: list[str]
        :param cl_ordr_id: Show only those trades related to orders with a specific 'client order id' (something like 'your reference' which you can submit) together with an order
        :type cl_ordr_id: str
        :param txt: Show only those trades related to orders with a specific 'custom text'. Similar to the clOrdrId, you can submit a string inside the 'txt' attribute of an order which helps you to identify trades originating from a specific order at a later point
        :type txt: str
        :param column_separator:
        :type column_separator: str
        :param comma_separator:
        :type comma_separator: str
        :param txt_matching_mode:
        :type txt_matching_mode: TextMatchingMode
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_report_csv_for_period_with_http_info(exchange, delivery_area, delivery_day_from, delivery_day_to, **kwargs)  # noqa: E501

    def get_report_csv_for_period_with_http_info(self, exchange, delivery_area, delivery_day_from, delivery_day_to, **kwargs):  # noqa: E501
        """Create CSV trading report  # noqa: E501

        Creates a detailed trading report in CSV format for a delivery area and a given delivery period. However, as the CSV format is two-dimensional, this report delivers less data compared to the regular report method.  As the generation of the report requires a lot of calculations, please use wisely. The maximum period you can request is limited to 31 days. The request retrieves an array of portfolios and can thus deliver data for one or more portfolios at the same time. However, some data (e.g. positions) cannot be aggregated for portfolios and will thus not show up, if you request data from more than one portfolio. The report can use filters for clOrdrId and txt, which means that only trades for which the filter is valid are included in the report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_report_csv_for_period_with_http_info(exchange, delivery_area, delivery_day_from, delivery_day_to, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param delivery_area: The EIC of the delivery area (required)
        :type delivery_area: str
        :param delivery_day_from: The day the report is for (example \"2018-10-23\") (required)
        :type delivery_day_from: date
        :param delivery_day_to: The day the report is for (example \"2018-10-30\") (required)
        :type delivery_day_to: date
        :param portfolio_id:
        :type portfolio_id: list[str]
        :param cl_ordr_id: Show only those trades related to orders with a specific 'client order id' (something like 'your reference' which you can submit) together with an order
        :type cl_ordr_id: str
        :param txt: Show only those trades related to orders with a specific 'custom text'. Similar to the clOrdrId, you can submit a string inside the 'txt' attribute of an order which helps you to identify trades originating from a specific order at a later point
        :type txt: str
        :param column_separator:
        :type column_separator: str
        :param comma_separator:
        :type comma_separator: str
        :param txt_matching_mode:
        :type txt_matching_mode: TextMatchingMode
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'delivery_area',
            'delivery_day_from',
            'delivery_day_to',
            'portfolio_id',
            'cl_ordr_id',
            'txt',
            'column_separator',
            'comma_separator',
            'txt_matching_mode'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_report_csv_for_period" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `get_report_csv_for_period`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `get_report_csv_for_period`")  # noqa: E501
        # verify the required parameter 'delivery_day_from' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_day_from') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_day_from` when calling `get_report_csv_for_period`")  # noqa: E501
        # verify the required parameter 'delivery_day_to' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_day_to') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_day_to` when calling `get_report_csv_for_period`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501
        if 'delivery_area' in local_var_params:
            path_params['delivery_area'] = local_var_params['delivery_area']  # noqa: E501

        query_params = []
        if local_var_params.get('portfolio_id') is not None:  # noqa: E501
            query_params.append(('portfolio_id', local_var_params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501
        if local_var_params.get('delivery_day_from') is not None:  # noqa: E501
            query_params.append(('delivery_day_from', local_var_params['delivery_day_from']))  # noqa: E501
        if local_var_params.get('delivery_day_to') is not None:  # noqa: E501
            query_params.append(('delivery_day_to', local_var_params['delivery_day_to']))  # noqa: E501
        if local_var_params.get('cl_ordr_id') is not None:  # noqa: E501
            query_params.append(('clOrdrId', local_var_params['cl_ordr_id']))  # noqa: E501
        if local_var_params.get('txt') is not None:  # noqa: E501
            query_params.append(('txt', local_var_params['txt']))  # noqa: E501
        if local_var_params.get('column_separator') is not None:  # noqa: E501
            query_params.append(('column_separator', local_var_params['column_separator']))  # noqa: E501
        if local_var_params.get('comma_separator') is not None:  # noqa: E501
            query_params.append(('comma_separator', local_var_params['comma_separator']))  # noqa: E501
        if local_var_params.get('txt_matching_mode') is not None:  # noqa: E501
            query_params.append(('txt_matching_mode', local_var_params['txt_matching_mode']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/csv'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "str",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/report/{delivery_area}/csv', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_report_for_period(self, exchange, delivery_area, **kwargs):  # noqa: E501
        """Create JSON trading report  # noqa: E501

        Creates a detailed trading report for a delivery area and a given delivery period, which contains all relevant information.  As the generation of the report requires a lot of calculations, please use wisely.  The time period you can request is limited to a maximum of 31 days. There are two options to set the time period, you must use exactly one: * Timestamp: Use parameters 'delivery_from' and 'delivery_to'. Both fields must be set. Only full hours are considered. * Date: Within the date option the mandatory parameters are 'delivery_day_from' and 'delivery_day_to'. Optionally 'delivery_day_from_starting_hour' and 'delivery_day_to_ending_hour' can be set.  The request retrieves an array of portfolios and can thus deliver data for one or more portfolios at the same time. However, some data (e.g. positions) cannot be aggregated for portfolios and will therefore not show up, if you request data from more than one portfolio. Optionally, the report can include the trades for the portfolio(s) that have a delivery period within the report period. In case (parts of) the requested time period lie in the future, the report will return additional information about quantities of outstanding active orders. In addition, the report can use filters for 'clOrdrId' and 'txt', which means that only trades and orders for which the filter is valid are included in the report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_report_for_period(exchange, delivery_area, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param delivery_area: The EIC of the delivery area (required)
        :type delivery_area: str
        :param portfolio_id:
        :type portfolio_id: list[str]
        :param delivery_day_from: The day the report starts. This field is mutually exclusive with 'delivery_from' and 'delivery_to'.
        :type delivery_day_from: date
        :param delivery_day_to: The day the report ends. This field is mutually exclusive with 'delivery_from' and 'delivery_to'.
        :type delivery_day_to: date
        :param delivery_day_from_starting_hour: The starting hour of the report (0 = midnight)
        :type delivery_day_from_starting_hour: int
        :param delivery_day_to_ending_hour: The ending hour of the report (0 = midnight)
        :type delivery_day_to_ending_hour: int
        :param cl_ordr_id: Use only trades in the calculation of the report, which are related to orders with a specific 'client order id' (something like 'your reference' which you can submit) together with an order
        :type cl_ordr_id: str
        :param txt: Use only trades in the calculation of the report, which are related to orders with a specific 'custom text'. Similar to the clOrdrId, you can submit a string inside the 'txt' attribute of an order which helps you to identify trades originating from a specific order at a later point
        :type txt: str
        :param with_trades:
        :type with_trades: bool
        :param txt_matching_mode:
        :type txt_matching_mode: TextMatchingMode
        :param with_auction_positions: Setting this parameter to true will add intraday and day-ahead auction positions to the report.
        :type with_auction_positions: bool
        :param with_auction_trades: Setting this parameter to true will add intraday and day-ahead auction trades to the report.
        :type with_auction_trades: bool
        :param delivery_from: The timestamp indicating when the report starts. This field is mutually exclusive with 'delivery_day_from' and 'delivery_day_to'.
        :type delivery_from: datetime
        :param delivery_to: The timestamp indicating when the report ends. This field is mutually exclusive with 'delivery_day_from' and 'delivery_day_to'.
        :type delivery_to: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Report
        """
        kwargs['_return_http_data_only'] = True
        return self.get_report_for_period_with_http_info(exchange, delivery_area, **kwargs)  # noqa: E501

    def get_report_for_period_with_http_info(self, exchange, delivery_area, **kwargs):  # noqa: E501
        """Create JSON trading report  # noqa: E501

        Creates a detailed trading report for a delivery area and a given delivery period, which contains all relevant information.  As the generation of the report requires a lot of calculations, please use wisely.  The time period you can request is limited to a maximum of 31 days. There are two options to set the time period, you must use exactly one: * Timestamp: Use parameters 'delivery_from' and 'delivery_to'. Both fields must be set. Only full hours are considered. * Date: Within the date option the mandatory parameters are 'delivery_day_from' and 'delivery_day_to'. Optionally 'delivery_day_from_starting_hour' and 'delivery_day_to_ending_hour' can be set.  The request retrieves an array of portfolios and can thus deliver data for one or more portfolios at the same time. However, some data (e.g. positions) cannot be aggregated for portfolios and will therefore not show up, if you request data from more than one portfolio. Optionally, the report can include the trades for the portfolio(s) that have a delivery period within the report period. In case (parts of) the requested time period lie in the future, the report will return additional information about quantities of outstanding active orders. In addition, the report can use filters for 'clOrdrId' and 'txt', which means that only trades and orders for which the filter is valid are included in the report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_report_for_period_with_http_info(exchange, delivery_area, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param delivery_area: The EIC of the delivery area (required)
        :type delivery_area: str
        :param portfolio_id:
        :type portfolio_id: list[str]
        :param delivery_day_from: The day the report starts. This field is mutually exclusive with 'delivery_from' and 'delivery_to'.
        :type delivery_day_from: date
        :param delivery_day_to: The day the report ends. This field is mutually exclusive with 'delivery_from' and 'delivery_to'.
        :type delivery_day_to: date
        :param delivery_day_from_starting_hour: The starting hour of the report (0 = midnight)
        :type delivery_day_from_starting_hour: int
        :param delivery_day_to_ending_hour: The ending hour of the report (0 = midnight)
        :type delivery_day_to_ending_hour: int
        :param cl_ordr_id: Use only trades in the calculation of the report, which are related to orders with a specific 'client order id' (something like 'your reference' which you can submit) together with an order
        :type cl_ordr_id: str
        :param txt: Use only trades in the calculation of the report, which are related to orders with a specific 'custom text'. Similar to the clOrdrId, you can submit a string inside the 'txt' attribute of an order which helps you to identify trades originating from a specific order at a later point
        :type txt: str
        :param with_trades:
        :type with_trades: bool
        :param txt_matching_mode:
        :type txt_matching_mode: TextMatchingMode
        :param with_auction_positions: Setting this parameter to true will add intraday and day-ahead auction positions to the report.
        :type with_auction_positions: bool
        :param with_auction_trades: Setting this parameter to true will add intraday and day-ahead auction trades to the report.
        :type with_auction_trades: bool
        :param delivery_from: The timestamp indicating when the report starts. This field is mutually exclusive with 'delivery_day_from' and 'delivery_day_to'.
        :type delivery_from: datetime
        :param delivery_to: The timestamp indicating when the report ends. This field is mutually exclusive with 'delivery_day_from' and 'delivery_day_to'.
        :type delivery_to: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Report, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'delivery_area',
            'portfolio_id',
            'delivery_day_from',
            'delivery_day_to',
            'delivery_day_from_starting_hour',
            'delivery_day_to_ending_hour',
            'cl_ordr_id',
            'txt',
            'with_trades',
            'txt_matching_mode',
            'with_auction_positions',
            'with_auction_trades',
            'delivery_from',
            'delivery_to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_report_for_period" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `get_report_for_period`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `get_report_for_period`")  # noqa: E501

        if self.api_client.client_side_validation and 'delivery_day_from_starting_hour' in local_var_params and local_var_params['delivery_day_from_starting_hour'] > 23:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `delivery_day_from_starting_hour` when calling `get_report_for_period`, must be a value less than or equal to `23`")  # noqa: E501
        if self.api_client.client_side_validation and 'delivery_day_from_starting_hour' in local_var_params and local_var_params['delivery_day_from_starting_hour'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `delivery_day_from_starting_hour` when calling `get_report_for_period`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'delivery_day_to_ending_hour' in local_var_params and local_var_params['delivery_day_to_ending_hour'] > 23:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `delivery_day_to_ending_hour` when calling `get_report_for_period`, must be a value less than or equal to `23`")  # noqa: E501
        if self.api_client.client_side_validation and 'delivery_day_to_ending_hour' in local_var_params and local_var_params['delivery_day_to_ending_hour'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `delivery_day_to_ending_hour` when calling `get_report_for_period`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501
        if 'delivery_area' in local_var_params:
            path_params['delivery_area'] = local_var_params['delivery_area']  # noqa: E501

        query_params = []
        if local_var_params.get('portfolio_id') is not None:  # noqa: E501
            query_params.append(('portfolio_id', local_var_params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501
        if local_var_params.get('delivery_day_from') is not None:  # noqa: E501
            query_params.append(('delivery_day_from', local_var_params['delivery_day_from']))  # noqa: E501
        if local_var_params.get('delivery_day_to') is not None:  # noqa: E501
            query_params.append(('delivery_day_to', local_var_params['delivery_day_to']))  # noqa: E501
        if local_var_params.get('delivery_day_from_starting_hour') is not None:  # noqa: E501
            query_params.append(('delivery_day_from_starting_hour', local_var_params['delivery_day_from_starting_hour']))  # noqa: E501
        if local_var_params.get('delivery_day_to_ending_hour') is not None:  # noqa: E501
            query_params.append(('delivery_day_to_ending_hour', local_var_params['delivery_day_to_ending_hour']))  # noqa: E501
        if local_var_params.get('cl_ordr_id') is not None:  # noqa: E501
            query_params.append(('clOrdrId', local_var_params['cl_ordr_id']))  # noqa: E501
        if local_var_params.get('txt') is not None:  # noqa: E501
            query_params.append(('txt', local_var_params['txt']))  # noqa: E501
        if local_var_params.get('with_trades') is not None:  # noqa: E501
            query_params.append(('with_trades', local_var_params['with_trades']))  # noqa: E501
        if local_var_params.get('txt_matching_mode') is not None:  # noqa: E501
            query_params.append(('txt_matching_mode', local_var_params['txt_matching_mode']))  # noqa: E501
        if local_var_params.get('with_auction_positions') is not None:  # noqa: E501
            query_params.append(('with_auction_positions', local_var_params['with_auction_positions']))  # noqa: E501
        if local_var_params.get('with_auction_trades') is not None:  # noqa: E501
            query_params.append(('with_auction_trades', local_var_params['with_auction_trades']))  # noqa: E501
        if local_var_params.get('delivery_from') is not None:  # noqa: E501
            query_params.append(('delivery_from', local_var_params['delivery_from']))  # noqa: E501
        if local_var_params.get('delivery_to') is not None:  # noqa: E501
            query_params.append(('delivery_to', local_var_params['delivery_to']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "Report",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/report/{delivery_area}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_schedule_xml(self, exchange, delivery_area, delivery_day, member_eic, exchange_eic, receiver_eic, process_type, sender_role, receiver_role, **kwargs):  # noqa: E501
        """Create Schedule XML  # noqa: E501

        Create a delivery area internal schedule XML file for the nomination toward the TSO. Supported formats are ESS (v2.3) and CIM (v5.2), only including the schedule between the exchange member and the member. The revision will be increased with every request performed. You need to provide the EIC of the exchange member as well as the EIC of the exchange.  For a detailed documentation and example values for different countries, please refer to the [Knowledge Base](https://docs.powerbot-trading.com/docs/features/nomination-schedules/).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_schedule_xml(exchange, delivery_area, delivery_day, member_eic, exchange_eic, receiver_eic, process_type, sender_role, receiver_role, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param delivery_area: The EIC of the delivery area. (required)
        :type delivery_area: str
        :param delivery_day: The day the schedule is for. (required)
        :type delivery_day: date
        :param member_eic: The EIC of the exchange member. (required)
        :type member_eic: str
        :param exchange_eic: The EIC of the exchange. (required)
        :type exchange_eic: str
        :param receiver_eic: Receiver EIC (required)
        :type receiver_eic: str
        :param process_type: Process Type Code (required)
        :type process_type: str
        :param sender_role: Sender Role Code (required)
        :type sender_role: str
        :param receiver_role: Receiver Role Code (required)
        :type receiver_role: str
        :param schedule_format:
        :type schedule_format: ScheduleFormat
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_schedule_xml_with_http_info(exchange, delivery_area, delivery_day, member_eic, exchange_eic, receiver_eic, process_type, sender_role, receiver_role, **kwargs)  # noqa: E501

    def get_schedule_xml_with_http_info(self, exchange, delivery_area, delivery_day, member_eic, exchange_eic, receiver_eic, process_type, sender_role, receiver_role, **kwargs):  # noqa: E501
        """Create Schedule XML  # noqa: E501

        Create a delivery area internal schedule XML file for the nomination toward the TSO. Supported formats are ESS (v2.3) and CIM (v5.2), only including the schedule between the exchange member and the member. The revision will be increased with every request performed. You need to provide the EIC of the exchange member as well as the EIC of the exchange.  For a detailed documentation and example values for different countries, please refer to the [Knowledge Base](https://docs.powerbot-trading.com/docs/features/nomination-schedules/).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_schedule_xml_with_http_info(exchange, delivery_area, delivery_day, member_eic, exchange_eic, receiver_eic, process_type, sender_role, receiver_role, async_req=True)
        >>> result = thread.get()

        :param exchange: (required)
        :type exchange: Exchange
        :param delivery_area: The EIC of the delivery area. (required)
        :type delivery_area: str
        :param delivery_day: The day the schedule is for. (required)
        :type delivery_day: date
        :param member_eic: The EIC of the exchange member. (required)
        :type member_eic: str
        :param exchange_eic: The EIC of the exchange. (required)
        :type exchange_eic: str
        :param receiver_eic: Receiver EIC (required)
        :type receiver_eic: str
        :param process_type: Process Type Code (required)
        :type process_type: str
        :param sender_role: Sender Role Code (required)
        :type sender_role: str
        :param receiver_role: Receiver Role Code (required)
        :type receiver_role: str
        :param schedule_format:
        :type schedule_format: ScheduleFormat
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange',
            'delivery_area',
            'delivery_day',
            'member_eic',
            'exchange_eic',
            'receiver_eic',
            'process_type',
            'sender_role',
            'receiver_role',
            'schedule_format'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_schedule_xml" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `get_schedule_xml`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `get_schedule_xml`")  # noqa: E501
        # verify the required parameter 'delivery_day' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_day') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_day` when calling `get_schedule_xml`")  # noqa: E501
        # verify the required parameter 'member_eic' is set
        if self.api_client.client_side_validation and local_var_params.get('member_eic') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `member_eic` when calling `get_schedule_xml`")  # noqa: E501
        # verify the required parameter 'exchange_eic' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange_eic') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_eic` when calling `get_schedule_xml`")  # noqa: E501
        # verify the required parameter 'receiver_eic' is set
        if self.api_client.client_side_validation and local_var_params.get('receiver_eic') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `receiver_eic` when calling `get_schedule_xml`")  # noqa: E501
        # verify the required parameter 'process_type' is set
        if self.api_client.client_side_validation and local_var_params.get('process_type') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `process_type` when calling `get_schedule_xml`")  # noqa: E501
        # verify the required parameter 'sender_role' is set
        if self.api_client.client_side_validation and local_var_params.get('sender_role') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `sender_role` when calling `get_schedule_xml`")  # noqa: E501
        # verify the required parameter 'receiver_role' is set
        if self.api_client.client_side_validation and local_var_params.get('receiver_role') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `receiver_role` when calling `get_schedule_xml`")  # noqa: E501

        if self.api_client.client_side_validation and ('delivery_area' in local_var_params and  # noqa: E501
                                                        len(local_var_params['delivery_area']) > 16):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `delivery_area` when calling `get_schedule_xml`, length must be less than or equal to `16`")  # noqa: E501
        if self.api_client.client_side_validation and ('delivery_area' in local_var_params and  # noqa: E501
                                                        len(local_var_params['delivery_area']) < 16):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `delivery_area` when calling `get_schedule_xml`, length must be greater than or equal to `16`")  # noqa: E501
        if self.api_client.client_side_validation and ('member_eic' in local_var_params and  # noqa: E501
                                                        len(local_var_params['member_eic']) > 16):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `member_eic` when calling `get_schedule_xml`, length must be less than or equal to `16`")  # noqa: E501
        if self.api_client.client_side_validation and ('member_eic' in local_var_params and  # noqa: E501
                                                        len(local_var_params['member_eic']) < 16):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `member_eic` when calling `get_schedule_xml`, length must be greater than or equal to `16`")  # noqa: E501
        if self.api_client.client_side_validation and ('exchange_eic' in local_var_params and  # noqa: E501
                                                        len(local_var_params['exchange_eic']) > 16):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `exchange_eic` when calling `get_schedule_xml`, length must be less than or equal to `16`")  # noqa: E501
        if self.api_client.client_side_validation and ('exchange_eic' in local_var_params and  # noqa: E501
                                                        len(local_var_params['exchange_eic']) < 16):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `exchange_eic` when calling `get_schedule_xml`, length must be greater than or equal to `16`")  # noqa: E501
        if self.api_client.client_side_validation and ('receiver_eic' in local_var_params and  # noqa: E501
                                                        len(local_var_params['receiver_eic']) > 16):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `receiver_eic` when calling `get_schedule_xml`, length must be less than or equal to `16`")  # noqa: E501
        if self.api_client.client_side_validation and ('receiver_eic' in local_var_params and  # noqa: E501
                                                        len(local_var_params['receiver_eic']) < 16):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `receiver_eic` when calling `get_schedule_xml`, length must be greater than or equal to `16`")  # noqa: E501
        if self.api_client.client_side_validation and ('process_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['process_type']) > 3):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `process_type` when calling `get_schedule_xml`, length must be less than or equal to `3`")  # noqa: E501
        if self.api_client.client_side_validation and ('process_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['process_type']) < 3):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `process_type` when calling `get_schedule_xml`, length must be greater than or equal to `3`")  # noqa: E501
        if self.api_client.client_side_validation and ('sender_role' in local_var_params and  # noqa: E501
                                                        len(local_var_params['sender_role']) > 3):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sender_role` when calling `get_schedule_xml`, length must be less than or equal to `3`")  # noqa: E501
        if self.api_client.client_side_validation and ('sender_role' in local_var_params and  # noqa: E501
                                                        len(local_var_params['sender_role']) < 3):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sender_role` when calling `get_schedule_xml`, length must be greater than or equal to `3`")  # noqa: E501
        if self.api_client.client_side_validation and ('receiver_role' in local_var_params and  # noqa: E501
                                                        len(local_var_params['receiver_role']) > 3):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `receiver_role` when calling `get_schedule_xml`, length must be less than or equal to `3`")  # noqa: E501
        if self.api_client.client_side_validation and ('receiver_role' in local_var_params and  # noqa: E501
                                                        len(local_var_params['receiver_role']) < 3):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `receiver_role` when calling `get_schedule_xml`, length must be greater than or equal to `3`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'exchange' in local_var_params:
            path_params['exchange'] = local_var_params['exchange']  # noqa: E501
        if 'delivery_area' in local_var_params:
            path_params['delivery_area'] = local_var_params['delivery_area']  # noqa: E501
        if 'delivery_day' in local_var_params:
            path_params['delivery_day'] = local_var_params['delivery_day']  # noqa: E501

        query_params = []
        if local_var_params.get('member_eic') is not None:  # noqa: E501
            query_params.append(('member_eic', local_var_params['member_eic']))  # noqa: E501
        if local_var_params.get('exchange_eic') is not None:  # noqa: E501
            query_params.append(('exchange_eic', local_var_params['exchange_eic']))  # noqa: E501
        if local_var_params.get('receiver_eic') is not None:  # noqa: E501
            query_params.append(('receiver_eic', local_var_params['receiver_eic']))  # noqa: E501
        if local_var_params.get('process_type') is not None:  # noqa: E501
            query_params.append(('process_type', local_var_params['process_type']))  # noqa: E501
        if local_var_params.get('sender_role') is not None:  # noqa: E501
            query_params.append(('sender_role', local_var_params['sender_role']))  # noqa: E501
        if local_var_params.get('receiver_role') is not None:  # noqa: E501
            query_params.append(('receiver_role', local_var_params['receiver_role']))  # noqa: E501
        if local_var_params.get('schedule_format') is not None:  # noqa: E501
            query_params.append(('schedule_format', local_var_params['schedule_format']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/xml', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "str",
        }

        return self.api_client.call_api(
            '/{exchange}/v2/api/schedule/{delivery_area}/{delivery_day}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
