# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoint The PowerBot service is available at the following REST endpoint:  ``` $api_url_placeholder ```  Access to the API is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.26.4
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class AuctionPositions(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'delivery_start': 'datetime',
        'delivery_end': 'datetime',
        'net_pos': 'float',
        'min_net_pos': 'float',
        'max_net_pos': 'float',
        'abs_pos': 'float',
        'net_cash': 'float',
        'trades_spending': 'float',
        'trades_earnings': 'float'
    }

    attribute_map = {
        'delivery_start': 'delivery_start',
        'delivery_end': 'delivery_end',
        'net_pos': 'net_pos',
        'min_net_pos': 'min_net_pos',
        'max_net_pos': 'max_net_pos',
        'abs_pos': 'abs_pos',
        'net_cash': 'net_cash',
        'trades_spending': 'trades_spending',
        'trades_earnings': 'trades_earnings'
    }

    def __init__(self, delivery_start=None, delivery_end=None, net_pos=None, min_net_pos=None, max_net_pos=None, abs_pos=None, net_cash=None, trades_spending=None, trades_earnings=None, local_vars_configuration=None):  # noqa: E501
        """AuctionPositions - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._delivery_start = None
        self._delivery_end = None
        self._net_pos = None
        self._min_net_pos = None
        self._max_net_pos = None
        self._abs_pos = None
        self._net_cash = None
        self._trades_spending = None
        self._trades_earnings = None
        self.discriminator = None

        if delivery_start is not None:
            self.delivery_start = delivery_start
        if delivery_end is not None:
            self.delivery_end = delivery_end
        if net_pos is not None:
            self.net_pos = net_pos
        if min_net_pos is not None:
            self.min_net_pos = min_net_pos
        if max_net_pos is not None:
            self.max_net_pos = max_net_pos
        if abs_pos is not None:
            self.abs_pos = abs_pos
        if net_cash is not None:
            self.net_cash = net_cash
        if trades_spending is not None:
            self.trades_spending = trades_spending
        if trades_earnings is not None:
            self.trades_earnings = trades_earnings

    @property
    def delivery_start(self):
        """Gets the delivery_start of this AuctionPositions.  # noqa: E501


        :return: The delivery_start of this AuctionPositions.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_start

    @delivery_start.setter
    def delivery_start(self, delivery_start):
        """Sets the delivery_start of this AuctionPositions.


        :param delivery_start: The delivery_start of this AuctionPositions.  # noqa: E501
        :type delivery_start: datetime
        """

        self._delivery_start = delivery_start

    @property
    def delivery_end(self):
        """Gets the delivery_end of this AuctionPositions.  # noqa: E501


        :return: The delivery_end of this AuctionPositions.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_end

    @delivery_end.setter
    def delivery_end(self, delivery_end):
        """Sets the delivery_end of this AuctionPositions.


        :param delivery_end: The delivery_end of this AuctionPositions.  # noqa: E501
        :type delivery_end: datetime
        """

        self._delivery_end = delivery_end

    @property
    def net_pos(self):
        """Gets the net_pos of this AuctionPositions.  # noqa: E501

        The sum of all trades that exactly match the delivery period of this object.  # noqa: E501

        :return: The net_pos of this AuctionPositions.  # noqa: E501
        :rtype: float
        """
        return self._net_pos

    @net_pos.setter
    def net_pos(self, net_pos):
        """Sets the net_pos of this AuctionPositions.

        The sum of all trades that exactly match the delivery period of this object.  # noqa: E501

        :param net_pos: The net_pos of this AuctionPositions.  # noqa: E501
        :type net_pos: float
        """

        self._net_pos = net_pos

    @property
    def min_net_pos(self):
        """Gets the min_net_pos of this AuctionPositions.  # noqa: E501

        The minimum possible position for this exact delivery period, including the net position and any outstanding orders that reduce the net position.  # noqa: E501

        :return: The min_net_pos of this AuctionPositions.  # noqa: E501
        :rtype: float
        """
        return self._min_net_pos

    @min_net_pos.setter
    def min_net_pos(self, min_net_pos):
        """Sets the min_net_pos of this AuctionPositions.

        The minimum possible position for this exact delivery period, including the net position and any outstanding orders that reduce the net position.  # noqa: E501

        :param min_net_pos: The min_net_pos of this AuctionPositions.  # noqa: E501
        :type min_net_pos: float
        """

        self._min_net_pos = min_net_pos

    @property
    def max_net_pos(self):
        """Gets the max_net_pos of this AuctionPositions.  # noqa: E501

        The maximum possible position for this exact delivery period, including the net position and any outstanding orders that increase the net position.  # noqa: E501

        :return: The max_net_pos of this AuctionPositions.  # noqa: E501
        :rtype: float
        """
        return self._max_net_pos

    @max_net_pos.setter
    def max_net_pos(self, max_net_pos):
        """Sets the max_net_pos of this AuctionPositions.

        The maximum possible position for this exact delivery period, including the net position and any outstanding orders that increase the net position.  # noqa: E501

        :param max_net_pos: The max_net_pos of this AuctionPositions.  # noqa: E501
        :type max_net_pos: float
        """

        self._max_net_pos = max_net_pos

    @property
    def abs_pos(self):
        """Gets the abs_pos of this AuctionPositions.  # noqa: E501

        The absolute sum of traded quantities that exactly match this delivery period.  # noqa: E501

        :return: The abs_pos of this AuctionPositions.  # noqa: E501
        :rtype: float
        """
        return self._abs_pos

    @abs_pos.setter
    def abs_pos(self, abs_pos):
        """Sets the abs_pos of this AuctionPositions.

        The absolute sum of traded quantities that exactly match this delivery period.  # noqa: E501

        :param abs_pos: The abs_pos of this AuctionPositions.  # noqa: E501
        :type abs_pos: float
        """

        self._abs_pos = abs_pos

    @property
    def net_cash(self):
        """Gets the net_cash of this AuctionPositions.  # noqa: E501

        The sum of trade spending and trade earnings for this exact period.  # noqa: E501

        :return: The net_cash of this AuctionPositions.  # noqa: E501
        :rtype: float
        """
        return self._net_cash

    @net_cash.setter
    def net_cash(self, net_cash):
        """Sets the net_cash of this AuctionPositions.

        The sum of trade spending and trade earnings for this exact period.  # noqa: E501

        :param net_cash: The net_cash of this AuctionPositions.  # noqa: E501
        :type net_cash: float
        """

        self._net_cash = net_cash

    @property
    def trades_spending(self):
        """Gets the trades_spending of this AuctionPositions.  # noqa: E501

        The sum of all trade costs (price * quantity * delivery_period [hours]) that decrease the cash position.  # noqa: E501

        :return: The trades_spending of this AuctionPositions.  # noqa: E501
        :rtype: float
        """
        return self._trades_spending

    @trades_spending.setter
    def trades_spending(self, trades_spending):
        """Sets the trades_spending of this AuctionPositions.

        The sum of all trade costs (price * quantity * delivery_period [hours]) that decrease the cash position.  # noqa: E501

        :param trades_spending: The trades_spending of this AuctionPositions.  # noqa: E501
        :type trades_spending: float
        """

        self._trades_spending = trades_spending

    @property
    def trades_earnings(self):
        """Gets the trades_earnings of this AuctionPositions.  # noqa: E501

        The sum of all trade costs (price * quantity * delivery_period [hours]) that increase the cash position.  # noqa: E501

        :return: The trades_earnings of this AuctionPositions.  # noqa: E501
        :rtype: float
        """
        return self._trades_earnings

    @trades_earnings.setter
    def trades_earnings(self, trades_earnings):
        """Sets the trades_earnings of this AuctionPositions.

        The sum of all trade costs (price * quantity * delivery_period [hours]) that increase the cash position.  # noqa: E501

        :param trades_earnings: The trades_earnings of this AuctionPositions.  # noqa: E501
        :type trades_earnings: float
        """

        self._trades_earnings = trades_earnings

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AuctionPositions):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AuctionPositions):
            return True

        return self.to_dict() != other.to_dict()
