# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoint The PowerBot service is available at the following REST endpoint:  ``` $api_url_placeholder ```  Access to the API is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.26.4
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class AuctionProductPositions(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'product_name': 'str',
        'net_position': 'float',
        'absolute_position': 'float',
        'net_cash_position': 'float',
        'buy_quantity': 'float',
        'sell_quantity': 'float',
        'average_buy_price': 'float',
        'average_sell_price': 'float'
    }

    attribute_map = {
        'product_name': 'product_name',
        'net_position': 'net_position',
        'absolute_position': 'absolute_position',
        'net_cash_position': 'net_cash_position',
        'buy_quantity': 'buy_quantity',
        'sell_quantity': 'sell_quantity',
        'average_buy_price': 'average_buy_price',
        'average_sell_price': 'average_sell_price'
    }

    def __init__(self, product_name=None, net_position=None, absolute_position=None, net_cash_position=None, buy_quantity=None, sell_quantity=None, average_buy_price=None, average_sell_price=None, local_vars_configuration=None):  # noqa: E501
        """AuctionProductPositions - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._product_name = None
        self._net_position = None
        self._absolute_position = None
        self._net_cash_position = None
        self._buy_quantity = None
        self._sell_quantity = None
        self._average_buy_price = None
        self._average_sell_price = None
        self.discriminator = None

        if product_name is not None:
            self.product_name = product_name
        if net_position is not None:
            self.net_position = net_position
        if absolute_position is not None:
            self.absolute_position = absolute_position
        if net_cash_position is not None:
            self.net_cash_position = net_cash_position
        if buy_quantity is not None:
            self.buy_quantity = buy_quantity
        if sell_quantity is not None:
            self.sell_quantity = sell_quantity
        if average_buy_price is not None:
            self.average_buy_price = average_buy_price
        if average_sell_price is not None:
            self.average_sell_price = average_sell_price

    @property
    def product_name(self):
        """Gets the product_name of this AuctionProductPositions.  # noqa: E501

        The name of the auction product for which the positions are reported.  # noqa: E501

        :return: The product_name of this AuctionProductPositions.  # noqa: E501
        :rtype: str
        """
        return self._product_name

    @product_name.setter
    def product_name(self, product_name):
        """Sets the product_name of this AuctionProductPositions.

        The name of the auction product for which the positions are reported.  # noqa: E501

        :param product_name: The product_name of this AuctionProductPositions.  # noqa: E501
        :type product_name: str
        """

        self._product_name = product_name

    @property
    def net_position(self):
        """Gets the net_position of this AuctionProductPositions.  # noqa: E501

        The net position is calculated as the total quantity of BUY trades minus the total quantity of SELL trades, accounting for all trades from the respective auction that coincide with the time period.  # noqa: E501

        :return: The net_position of this AuctionProductPositions.  # noqa: E501
        :rtype: float
        """
        return self._net_position

    @net_position.setter
    def net_position(self, net_position):
        """Sets the net_position of this AuctionProductPositions.

        The net position is calculated as the total quantity of BUY trades minus the total quantity of SELL trades, accounting for all trades from the respective auction that coincide with the time period.  # noqa: E501

        :param net_position: The net_position of this AuctionProductPositions.  # noqa: E501
        :type net_position: float
        """

        self._net_position = net_position

    @property
    def absolute_position(self):
        """Gets the absolute_position of this AuctionProductPositions.  # noqa: E501

        The absolute position is the total sum of the absolute values of all BUY and SELL quantities from trades in the respective auction that coincide with the time period.  # noqa: E501

        :return: The absolute_position of this AuctionProductPositions.  # noqa: E501
        :rtype: float
        """
        return self._absolute_position

    @absolute_position.setter
    def absolute_position(self, absolute_position):
        """Sets the absolute_position of this AuctionProductPositions.

        The absolute position is the total sum of the absolute values of all BUY and SELL quantities from trades in the respective auction that coincide with the time period.  # noqa: E501

        :param absolute_position: The absolute_position of this AuctionProductPositions.  # noqa: E501
        :type absolute_position: float
        """

        self._absolute_position = absolute_position

    @property
    def net_cash_position(self):
        """Gets the net_cash_position of this AuctionProductPositions.  # noqa: E501

        The net cash position represents the sum of all trade expenditures and trade revenues for the specified time period and auction.  # noqa: E501

        :return: The net_cash_position of this AuctionProductPositions.  # noqa: E501
        :rtype: float
        """
        return self._net_cash_position

    @net_cash_position.setter
    def net_cash_position(self, net_cash_position):
        """Sets the net_cash_position of this AuctionProductPositions.

        The net cash position represents the sum of all trade expenditures and trade revenues for the specified time period and auction.  # noqa: E501

        :param net_cash_position: The net_cash_position of this AuctionProductPositions.  # noqa: E501
        :type net_cash_position: float
        """

        self._net_cash_position = net_cash_position

    @property
    def buy_quantity(self):
        """Gets the buy_quantity of this AuctionProductPositions.  # noqa: E501

        The total BUY quantity for this time period and auction in MW.  # noqa: E501

        :return: The buy_quantity of this AuctionProductPositions.  # noqa: E501
        :rtype: float
        """
        return self._buy_quantity

    @buy_quantity.setter
    def buy_quantity(self, buy_quantity):
        """Sets the buy_quantity of this AuctionProductPositions.

        The total BUY quantity for this time period and auction in MW.  # noqa: E501

        :param buy_quantity: The buy_quantity of this AuctionProductPositions.  # noqa: E501
        :type buy_quantity: float
        """

        self._buy_quantity = buy_quantity

    @property
    def sell_quantity(self):
        """Gets the sell_quantity of this AuctionProductPositions.  # noqa: E501

        The total SELL quantity for this time period and auction in MW.  # noqa: E501

        :return: The sell_quantity of this AuctionProductPositions.  # noqa: E501
        :rtype: float
        """
        return self._sell_quantity

    @sell_quantity.setter
    def sell_quantity(self, sell_quantity):
        """Sets the sell_quantity of this AuctionProductPositions.

        The total SELL quantity for this time period and auction in MW.  # noqa: E501

        :param sell_quantity: The sell_quantity of this AuctionProductPositions.  # noqa: E501
        :type sell_quantity: float
        """

        self._sell_quantity = sell_quantity

    @property
    def average_buy_price(self):
        """Gets the average_buy_price of this AuctionProductPositions.  # noqa: E501

        The volume weighted average price of all BUY trades for the respective time period and auction.  # noqa: E501

        :return: The average_buy_price of this AuctionProductPositions.  # noqa: E501
        :rtype: float
        """
        return self._average_buy_price

    @average_buy_price.setter
    def average_buy_price(self, average_buy_price):
        """Sets the average_buy_price of this AuctionProductPositions.

        The volume weighted average price of all BUY trades for the respective time period and auction.  # noqa: E501

        :param average_buy_price: The average_buy_price of this AuctionProductPositions.  # noqa: E501
        :type average_buy_price: float
        """

        self._average_buy_price = average_buy_price

    @property
    def average_sell_price(self):
        """Gets the average_sell_price of this AuctionProductPositions.  # noqa: E501

        The volume weighted average price of all SELL trades for the respective time period and auction.  # noqa: E501

        :return: The average_sell_price of this AuctionProductPositions.  # noqa: E501
        :rtype: float
        """
        return self._average_sell_price

    @average_sell_price.setter
    def average_sell_price(self, average_sell_price):
        """Sets the average_sell_price of this AuctionProductPositions.

        The volume weighted average price of all SELL trades for the respective time period and auction.  # noqa: E501

        :param average_sell_price: The average_sell_price of this AuctionProductPositions.  # noqa: E501
        :type average_sell_price: float
        """

        self._average_sell_price = average_sell_price

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AuctionProductPositions):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AuctionProductPositions):
            return True

        return self.to_dict() != other.to_dict()
