# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoint The PowerBot service is available at the following REST endpoint:  ``` $api_url_placeholder ```  Access to the API is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.26.4
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class Block(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'price': 'float',
        'minimum_acceptance_ratio': 'float',
        'comment': 'str',
        'type': 'BlockType',
        'type_value': 'str',
        'state': 'BlockState',
        'periods': 'list[BlockPeriod]'
    }

    attribute_map = {
        'id': 'id',
        'price': 'price',
        'minimum_acceptance_ratio': 'minimum_acceptance_ratio',
        'comment': 'comment',
        'type': 'type',
        'type_value': 'type_value',
        'state': 'state',
        'periods': 'periods'
    }

    def __init__(self, id=None, price=None, minimum_acceptance_ratio=None, comment=None, type=None, type_value=None, state=None, periods=None, local_vars_configuration=None):  # noqa: E501
        """Block - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._price = None
        self._minimum_acceptance_ratio = None
        self._comment = None
        self._type = None
        self._type_value = None
        self._state = None
        self._periods = None
        self.discriminator = None

        self.id = id
        self.price = price
        self.minimum_acceptance_ratio = minimum_acceptance_ratio
        if comment is not None:
            self.comment = comment
        self.type = type
        if type_value is not None:
            self.type_value = type_value
        if state is not None:
            self.state = state
        self.periods = periods

    @property
    def id(self):
        """Gets the id of this Block.  # noqa: E501

        The identifier of the block.  # noqa: E501

        :return: The id of this Block.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Block.

        The identifier of the block.  # noqa: E501

        :param id: The id of this Block.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def price(self):
        """Gets the price of this Block.  # noqa: E501

        The price of the block.  # noqa: E501

        :return: The price of this Block.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this Block.

        The price of the block.  # noqa: E501

        :param price: The price of this Block.  # noqa: E501
        :type price: float
        """
        if self.local_vars_configuration.client_side_validation and price is None:  # noqa: E501
            raise ValueError("Invalid value for `price`, must not be `None`")  # noqa: E501

        self._price = price

    @property
    def minimum_acceptance_ratio(self):
        """Gets the minimum_acceptance_ratio of this Block.  # noqa: E501

        The minimum acceptance ratio of the block.  # noqa: E501

        :return: The minimum_acceptance_ratio of this Block.  # noqa: E501
        :rtype: float
        """
        return self._minimum_acceptance_ratio

    @minimum_acceptance_ratio.setter
    def minimum_acceptance_ratio(self, minimum_acceptance_ratio):
        """Sets the minimum_acceptance_ratio of this Block.

        The minimum acceptance ratio of the block.  # noqa: E501

        :param minimum_acceptance_ratio: The minimum_acceptance_ratio of this Block.  # noqa: E501
        :type minimum_acceptance_ratio: float
        """
        if self.local_vars_configuration.client_side_validation and minimum_acceptance_ratio is None:  # noqa: E501
            raise ValueError("Invalid value for `minimum_acceptance_ratio`, must not be `None`")  # noqa: E501

        self._minimum_acceptance_ratio = minimum_acceptance_ratio

    @property
    def comment(self):
        """Gets the comment of this Block.  # noqa: E501

        The comment of the block.  # noqa: E501

        :return: The comment of this Block.  # noqa: E501
        :rtype: str
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this Block.

        The comment of the block.  # noqa: E501

        :param comment: The comment of this Block.  # noqa: E501
        :type comment: str
        """

        self._comment = comment

    @property
    def type(self):
        """Gets the type of this Block.  # noqa: E501


        :return: The type of this Block.  # noqa: E501
        :rtype: BlockType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Block.


        :param type: The type of this Block.  # noqa: E501
        :type type: BlockType
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def type_value(self):
        """Gets the type_value of this Block.  # noqa: E501

        The value relevant for the block type. E.g. the ID of the parent block for a linked block or the group ID for an exclusive block.  # noqa: E501

        :return: The type_value of this Block.  # noqa: E501
        :rtype: str
        """
        return self._type_value

    @type_value.setter
    def type_value(self, type_value):
        """Sets the type_value of this Block.

        The value relevant for the block type. E.g. the ID of the parent block for a linked block or the group ID for an exclusive block.  # noqa: E501

        :param type_value: The type_value of this Block.  # noqa: E501
        :type type_value: str
        """

        self._type_value = type_value

    @property
    def state(self):
        """Gets the state of this Block.  # noqa: E501


        :return: The state of this Block.  # noqa: E501
        :rtype: BlockState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Block.


        :param state: The state of this Block.  # noqa: E501
        :type state: BlockState
        """

        self._state = state

    @property
    def periods(self):
        """Gets the periods of this Block.  # noqa: E501


        :return: The periods of this Block.  # noqa: E501
        :rtype: list[BlockPeriod]
        """
        return self._periods

    @periods.setter
    def periods(self, periods):
        """Sets the periods of this Block.


        :param periods: The periods of this Block.  # noqa: E501
        :type periods: list[BlockPeriod]
        """
        if self.local_vars_configuration.client_side_validation and periods is None:  # noqa: E501
            raise ValueError("Invalid value for `periods`, must not be `None`")  # noqa: E501

        self._periods = periods

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Block):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Block):
            return True

        return self.to_dict() != other.to_dict()
