# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoint The PowerBot service is available at the following REST endpoint:  ``` $api_url_placeholder ```  Access to the API is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.26.4
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class Capacity(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'api_timestamp': 'datetime',
        'timestamp': 'datetime',
        'from_delivery_area': 'str',
        'to_delivery_area': 'str',
        'revision': 'int',
        'delivery_start': 'datetime',
        'delivery_end': 'datetime',
        '_in': 'float',
        'out': 'float'
    }

    attribute_map = {
        'api_timestamp': 'api_timestamp',
        'timestamp': 'timestamp',
        'from_delivery_area': 'from_delivery_area',
        'to_delivery_area': 'to_delivery_area',
        'revision': 'revision',
        'delivery_start': 'delivery_start',
        'delivery_end': 'delivery_end',
        '_in': 'in',
        'out': 'out'
    }

    def __init__(self, api_timestamp=None, timestamp=None, from_delivery_area=None, to_delivery_area=None, revision=None, delivery_start=None, delivery_end=None, _in=None, out=None, local_vars_configuration=None):  # noqa: E501
        """Capacity - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._api_timestamp = None
        self._timestamp = None
        self._from_delivery_area = None
        self._to_delivery_area = None
        self._revision = None
        self._delivery_start = None
        self._delivery_end = None
        self.__in = None
        self._out = None
        self.discriminator = None

        if api_timestamp is not None:
            self.api_timestamp = api_timestamp
        if timestamp is not None:
            self.timestamp = timestamp
        self.from_delivery_area = from_delivery_area
        self.to_delivery_area = to_delivery_area
        if revision is not None:
            self.revision = revision
        self.delivery_start = delivery_start
        self.delivery_end = delivery_end
        self._in = _in
        self.out = out

    @property
    def api_timestamp(self):
        """Gets the api_timestamp of this Capacity.  # noqa: E501

        DEPRECATED: Use timestamp instead. The timestamp of the entry being received by the PowerBot API  # noqa: E501

        :return: The api_timestamp of this Capacity.  # noqa: E501
        :rtype: datetime
        """
        return self._api_timestamp

    @api_timestamp.setter
    def api_timestamp(self, api_timestamp):
        """Sets the api_timestamp of this Capacity.

        DEPRECATED: Use timestamp instead. The timestamp of the entry being received by the PowerBot API  # noqa: E501

        :param api_timestamp: The api_timestamp of this Capacity.  # noqa: E501
        :type api_timestamp: datetime
        """

        self._api_timestamp = api_timestamp

    @property
    def timestamp(self):
        """Gets the timestamp of this Capacity.  # noqa: E501

        The timestamp when the data was sent from the capacity system of the exchange  # noqa: E501

        :return: The timestamp of this Capacity.  # noqa: E501
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this Capacity.

        The timestamp when the data was sent from the capacity system of the exchange  # noqa: E501

        :param timestamp: The timestamp of this Capacity.  # noqa: E501
        :type timestamp: datetime
        """

        self._timestamp = timestamp

    @property
    def from_delivery_area(self):
        """Gets the from_delivery_area of this Capacity.  # noqa: E501

        EIC of the outgoing area  # noqa: E501

        :return: The from_delivery_area of this Capacity.  # noqa: E501
        :rtype: str
        """
        return self._from_delivery_area

    @from_delivery_area.setter
    def from_delivery_area(self, from_delivery_area):
        """Sets the from_delivery_area of this Capacity.

        EIC of the outgoing area  # noqa: E501

        :param from_delivery_area: The from_delivery_area of this Capacity.  # noqa: E501
        :type from_delivery_area: str
        """
        if self.local_vars_configuration.client_side_validation and from_delivery_area is None:  # noqa: E501
            raise ValueError("Invalid value for `from_delivery_area`, must not be `None`")  # noqa: E501

        self._from_delivery_area = from_delivery_area

    @property
    def to_delivery_area(self):
        """Gets the to_delivery_area of this Capacity.  # noqa: E501

        EIC of the incoming area  # noqa: E501

        :return: The to_delivery_area of this Capacity.  # noqa: E501
        :rtype: str
        """
        return self._to_delivery_area

    @to_delivery_area.setter
    def to_delivery_area(self, to_delivery_area):
        """Sets the to_delivery_area of this Capacity.

        EIC of the incoming area  # noqa: E501

        :param to_delivery_area: The to_delivery_area of this Capacity.  # noqa: E501
        :type to_delivery_area: str
        """
        if self.local_vars_configuration.client_side_validation and to_delivery_area is None:  # noqa: E501
            raise ValueError("Invalid value for `to_delivery_area`, must not be `None`")  # noqa: E501

        self._to_delivery_area = to_delivery_area

    @property
    def revision(self):
        """Gets the revision of this Capacity.  # noqa: E501

        Revision number of the entry  # noqa: E501

        :return: The revision of this Capacity.  # noqa: E501
        :rtype: int
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """Sets the revision of this Capacity.

        Revision number of the entry  # noqa: E501

        :param revision: The revision of this Capacity.  # noqa: E501
        :type revision: int
        """

        self._revision = revision

    @property
    def delivery_start(self):
        """Gets the delivery_start of this Capacity.  # noqa: E501

        Delivery start date-time  # noqa: E501

        :return: The delivery_start of this Capacity.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_start

    @delivery_start.setter
    def delivery_start(self, delivery_start):
        """Sets the delivery_start of this Capacity.

        Delivery start date-time  # noqa: E501

        :param delivery_start: The delivery_start of this Capacity.  # noqa: E501
        :type delivery_start: datetime
        """
        if self.local_vars_configuration.client_side_validation and delivery_start is None:  # noqa: E501
            raise ValueError("Invalid value for `delivery_start`, must not be `None`")  # noqa: E501

        self._delivery_start = delivery_start

    @property
    def delivery_end(self):
        """Gets the delivery_end of this Capacity.  # noqa: E501

        Delivery end date-time  # noqa: E501

        :return: The delivery_end of this Capacity.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_end

    @delivery_end.setter
    def delivery_end(self, delivery_end):
        """Sets the delivery_end of this Capacity.

        Delivery end date-time  # noqa: E501

        :param delivery_end: The delivery_end of this Capacity.  # noqa: E501
        :type delivery_end: datetime
        """
        if self.local_vars_configuration.client_side_validation and delivery_end is None:  # noqa: E501
            raise ValueError("Invalid value for `delivery_end`, must not be `None`")  # noqa: E501

        self._delivery_end = delivery_end

    @property
    def _in(self):
        """Gets the _in of this Capacity.  # noqa: E501

        The ATC value from \"to_delivery_area\" to \"from_delivery_area\"  # noqa: E501

        :return: The _in of this Capacity.  # noqa: E501
        :rtype: float
        """
        return self.__in

    @_in.setter
    def _in(self, _in):
        """Sets the _in of this Capacity.

        The ATC value from \"to_delivery_area\" to \"from_delivery_area\"  # noqa: E501

        :param _in: The _in of this Capacity.  # noqa: E501
        :type _in: float
        """
        if self.local_vars_configuration.client_side_validation and _in is None:  # noqa: E501
            raise ValueError("Invalid value for `_in`, must not be `None`")  # noqa: E501

        self.__in = _in

    @property
    def out(self):
        """Gets the out of this Capacity.  # noqa: E501

        The ATC value from \"from_delivery_area\" to \"to_delivery_area\"  # noqa: E501

        :return: The out of this Capacity.  # noqa: E501
        :rtype: float
        """
        return self._out

    @out.setter
    def out(self, out):
        """Sets the out of this Capacity.

        The ATC value from \"from_delivery_area\" to \"to_delivery_area\"  # noqa: E501

        :param out: The out of this Capacity.  # noqa: E501
        :type out: float
        """
        if self.local_vars_configuration.client_side_validation and out is None:  # noqa: E501
            raise ValueError("Invalid value for `out`, must not be `None`")  # noqa: E501

        self._out = out

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Capacity):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Capacity):
            return True

        return self.to_dict() != other.to_dict()
