# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoint The PowerBot service is available at the following REST endpoint:  ``` $api_url_placeholder ```  Access to the API is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.26.4
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class ContractItem(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'exchange': 'str',
        'product': 'str',
        'contract_id': 'str',
        'type': 'ContractType',
        'revision_no': 'int',
        'state': 'str',
        'name': 'str',
        'delivery_start': 'datetime',
        'delivery_end': 'datetime',
        'contract_details': 'object',
        'delivery_areas': 'list[str]',
        'delivery_area_states': 'list[DeliveryAreaState]'
    }

    attribute_map = {
        'exchange': 'exchange',
        'product': 'product',
        'contract_id': 'contract_id',
        'type': 'type',
        'revision_no': 'revision_no',
        'state': 'state',
        'name': 'name',
        'delivery_start': 'delivery_start',
        'delivery_end': 'delivery_end',
        'contract_details': 'contract_details',
        'delivery_areas': 'delivery_areas',
        'delivery_area_states': 'delivery_area_states'
    }

    def __init__(self, exchange=None, product=None, contract_id=None, type=None, revision_no=None, state=None, name=None, delivery_start=None, delivery_end=None, contract_details=None, delivery_areas=None, delivery_area_states=None, local_vars_configuration=None):  # noqa: E501
        """ContractItem - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._exchange = None
        self._product = None
        self._contract_id = None
        self._type = None
        self._revision_no = None
        self._state = None
        self._name = None
        self._delivery_start = None
        self._delivery_end = None
        self._contract_details = None
        self._delivery_areas = None
        self._delivery_area_states = None
        self.discriminator = None

        if exchange is not None:
            self.exchange = exchange
        if product is not None:
            self.product = product
        if contract_id is not None:
            self.contract_id = contract_id
        if type is not None:
            self.type = type
        if revision_no is not None:
            self.revision_no = revision_no
        if state is not None:
            self.state = state
        if name is not None:
            self.name = name
        if delivery_start is not None:
            self.delivery_start = delivery_start
        if delivery_end is not None:
            self.delivery_end = delivery_end
        if contract_details is not None:
            self.contract_details = contract_details
        if delivery_areas is not None:
            self.delivery_areas = delivery_areas
        if delivery_area_states is not None:
            self.delivery_area_states = delivery_area_states

    @property
    def exchange(self):
        """Gets the exchange of this ContractItem.  # noqa: E501


        :return: The exchange of this ContractItem.  # noqa: E501
        :rtype: str
        """
        return self._exchange

    @exchange.setter
    def exchange(self, exchange):
        """Sets the exchange of this ContractItem.


        :param exchange: The exchange of this ContractItem.  # noqa: E501
        :type exchange: str
        """

        self._exchange = exchange

    @property
    def product(self):
        """Gets the product of this ContractItem.  # noqa: E501


        :return: The product of this ContractItem.  # noqa: E501
        :rtype: str
        """
        return self._product

    @product.setter
    def product(self, product):
        """Sets the product of this ContractItem.


        :param product: The product of this ContractItem.  # noqa: E501
        :type product: str
        """

        self._product = product

    @property
    def contract_id(self):
        """Gets the contract_id of this ContractItem.  # noqa: E501

        The contract's unique id  # noqa: E501

        :return: The contract_id of this ContractItem.  # noqa: E501
        :rtype: str
        """
        return self._contract_id

    @contract_id.setter
    def contract_id(self, contract_id):
        """Sets the contract_id of this ContractItem.

        The contract's unique id  # noqa: E501

        :param contract_id: The contract_id of this ContractItem.  # noqa: E501
        :type contract_id: str
        """

        self._contract_id = contract_id

    @property
    def type(self):
        """Gets the type of this ContractItem.  # noqa: E501


        :return: The type of this ContractItem.  # noqa: E501
        :rtype: ContractType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ContractItem.


        :param type: The type of this ContractItem.  # noqa: E501
        :type type: ContractType
        """

        self._type = type

    @property
    def revision_no(self):
        """Gets the revision_no of this ContractItem.  # noqa: E501


        :return: The revision_no of this ContractItem.  # noqa: E501
        :rtype: int
        """
        return self._revision_no

    @revision_no.setter
    def revision_no(self, revision_no):
        """Sets the revision_no of this ContractItem.


        :param revision_no: The revision_no of this ContractItem.  # noqa: E501
        :type revision_no: int
        """

        self._revision_no = revision_no

    @property
    def state(self):
        """Gets the state of this ContractItem.  # noqa: E501


        :return: The state of this ContractItem.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this ContractItem.


        :param state: The state of this ContractItem.  # noqa: E501
        :type state: str
        """

        self._state = state

    @property
    def name(self):
        """Gets the name of this ContractItem.  # noqa: E501

        The name of the contract  # noqa: E501

        :return: The name of this ContractItem.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ContractItem.

        The name of the contract  # noqa: E501

        :param name: The name of this ContractItem.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def delivery_start(self):
        """Gets the delivery_start of this ContractItem.  # noqa: E501

        The delivery start time (UTC) of the contract  # noqa: E501

        :return: The delivery_start of this ContractItem.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_start

    @delivery_start.setter
    def delivery_start(self, delivery_start):
        """Sets the delivery_start of this ContractItem.

        The delivery start time (UTC) of the contract  # noqa: E501

        :param delivery_start: The delivery_start of this ContractItem.  # noqa: E501
        :type delivery_start: datetime
        """

        self._delivery_start = delivery_start

    @property
    def delivery_end(self):
        """Gets the delivery_end of this ContractItem.  # noqa: E501

        The delivery end time (UTC) of the contract  # noqa: E501

        :return: The delivery_end of this ContractItem.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_end

    @delivery_end.setter
    def delivery_end(self, delivery_end):
        """Sets the delivery_end of this ContractItem.

        The delivery end time (UTC) of the contract  # noqa: E501

        :param delivery_end: The delivery_end of this ContractItem.  # noqa: E501
        :type delivery_end: datetime
        """

        self._delivery_end = delivery_end

    @property
    def contract_details(self):
        """Gets the contract_details of this ContractItem.  # noqa: E501


        :return: The contract_details of this ContractItem.  # noqa: E501
        :rtype: object
        """
        return self._contract_details

    @contract_details.setter
    def contract_details(self, contract_details):
        """Sets the contract_details of this ContractItem.


        :param contract_details: The contract_details of this ContractItem.  # noqa: E501
        :type contract_details: object
        """

        self._contract_details = contract_details

    @property
    def delivery_areas(self):
        """Gets the delivery_areas of this ContractItem.  # noqa: E501


        :return: The delivery_areas of this ContractItem.  # noqa: E501
        :rtype: list[str]
        """
        return self._delivery_areas

    @delivery_areas.setter
    def delivery_areas(self, delivery_areas):
        """Sets the delivery_areas of this ContractItem.


        :param delivery_areas: The delivery_areas of this ContractItem.  # noqa: E501
        :type delivery_areas: list[str]
        """

        self._delivery_areas = delivery_areas

    @property
    def delivery_area_states(self):
        """Gets the delivery_area_states of this ContractItem.  # noqa: E501


        :return: The delivery_area_states of this ContractItem.  # noqa: E501
        :rtype: list[DeliveryAreaState]
        """
        return self._delivery_area_states

    @delivery_area_states.setter
    def delivery_area_states(self, delivery_area_states):
        """Sets the delivery_area_states of this ContractItem.


        :param delivery_area_states: The delivery_area_states of this ContractItem.  # noqa: E501
        :type delivery_area_states: list[DeliveryAreaState]
        """

        self._delivery_area_states = delivery_area_states

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ContractItem):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ContractItem):
            return True

        return self.to_dict() != other.to_dict()
