# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoint The PowerBot service is available at the following REST endpoint:  ``` $api_url_placeholder ```  Access to the API is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.26.4
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class MarketOptions(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'internal_trading': 'str',
        'block_potential_self_trades': 'str',
        'internal_trading_cross_area': 'bool',
        'internal_trading_cross_area_lead_time': 'int',
        'internal_trading_include_external_orders': 'bool',
        'internal_trading_across_tenants': 'bool',
        'default_delivery_area_id': 'str',
        'restrict_safe_mode': 'bool',
        'throttling_user_action': 'str',
        'enable_mfa': 'bool',
        'show_all_account_orders': 'bool',
        'session_max_age': 'int',
        'session_max_inactive_time': 'int'
    }

    attribute_map = {
        'internal_trading': 'internal_trading',
        'block_potential_self_trades': 'block_potential_self_trades',
        'internal_trading_cross_area': 'internal_trading_cross_area',
        'internal_trading_cross_area_lead_time': 'internal_trading_cross_area_lead_time',
        'internal_trading_include_external_orders': 'internal_trading_include_external_orders',
        'internal_trading_across_tenants': 'internal_trading_across_tenants',
        'default_delivery_area_id': 'default_delivery_area_id',
        'restrict_safe_mode': 'restrict_safe_mode',
        'throttling_user_action': 'throttling_user_action',
        'enable_mfa': 'enable_mfa',
        'show_all_account_orders': 'show_all_account_orders',
        'session_max_age': 'session_max_age',
        'session_max_inactive_time': 'session_max_inactive_time'
    }

    def __init__(self, internal_trading=None, block_potential_self_trades=None, internal_trading_cross_area=None, internal_trading_cross_area_lead_time=None, internal_trading_include_external_orders=None, internal_trading_across_tenants=None, default_delivery_area_id=None, restrict_safe_mode=None, throttling_user_action=None, enable_mfa=None, show_all_account_orders=None, session_max_age=None, session_max_inactive_time=None, local_vars_configuration=None):  # noqa: E501
        """MarketOptions - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._internal_trading = None
        self._block_potential_self_trades = None
        self._internal_trading_cross_area = None
        self._internal_trading_cross_area_lead_time = None
        self._internal_trading_include_external_orders = None
        self._internal_trading_across_tenants = None
        self._default_delivery_area_id = None
        self._restrict_safe_mode = None
        self._throttling_user_action = None
        self._enable_mfa = None
        self._show_all_account_orders = None
        self._session_max_age = None
        self._session_max_inactive_time = None
        self.discriminator = None

        if internal_trading is not None:
            self.internal_trading = internal_trading
        if block_potential_self_trades is not None:
            self.block_potential_self_trades = block_potential_self_trades
        if internal_trading_cross_area is not None:
            self.internal_trading_cross_area = internal_trading_cross_area
        if internal_trading_cross_area_lead_time is not None:
            self.internal_trading_cross_area_lead_time = internal_trading_cross_area_lead_time
        if internal_trading_include_external_orders is not None:
            self.internal_trading_include_external_orders = internal_trading_include_external_orders
        if internal_trading_across_tenants is not None:
            self.internal_trading_across_tenants = internal_trading_across_tenants
        if default_delivery_area_id is not None:
            self.default_delivery_area_id = default_delivery_area_id
        if restrict_safe_mode is not None:
            self.restrict_safe_mode = restrict_safe_mode
        if throttling_user_action is not None:
            self.throttling_user_action = throttling_user_action
        if enable_mfa is not None:
            self.enable_mfa = enable_mfa
        if show_all_account_orders is not None:
            self.show_all_account_orders = show_all_account_orders
        if session_max_age is not None:
            self.session_max_age = session_max_age
        if session_max_inactive_time is not None:
            self.session_max_inactive_time = session_max_inactive_time

    @property
    def internal_trading(self):
        """Gets the internal_trading of this MarketOptions.  # noqa: E501

        This setting configures the behaviour of the internal matching engine   * `inactive`    disabled, orders get sent to the exchange without checks for cross trades   * `default_yes` enabled by default, but can be disabled on a per-request basis   * `default_no`  disabled by default, but can be enabled on a per-request basis   * `active`      enabled for all requests  # noqa: E501

        :return: The internal_trading of this MarketOptions.  # noqa: E501
        :rtype: str
        """
        return self._internal_trading

    @internal_trading.setter
    def internal_trading(self, internal_trading):
        """Sets the internal_trading of this MarketOptions.

        This setting configures the behaviour of the internal matching engine   * `inactive`    disabled, orders get sent to the exchange without checks for cross trades   * `default_yes` enabled by default, but can be disabled on a per-request basis   * `default_no`  disabled by default, but can be enabled on a per-request basis   * `active`      enabled for all requests  # noqa: E501

        :param internal_trading: The internal_trading of this MarketOptions.  # noqa: E501
        :type internal_trading: str
        """
        allowed_values = ["inactive", "default_yes", "default_no", "active"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and internal_trading not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `internal_trading` ({0}), must be one of {1}"  # noqa: E501
                .format(internal_trading, allowed_values)
            )

        self._internal_trading = internal_trading

    @property
    def block_potential_self_trades(self):
        """Gets the block_potential_self_trades of this MarketOptions.  # noqa: E501

        This setting the behaviour of orders that could potentially lead to self-trades and can't be resolved by the internal matching engine   * `disabled`                don't check for non-resolveable potential self-trades   * `block_all`               reject requests with orders that could lead to self-trades (own bid >= own ask)   * `block_if_not_resolvable` reject requests with orders that could lead to self-trades that can't be resolved by the internal matching engine (e.g. across delivery areas)  # noqa: E501

        :return: The block_potential_self_trades of this MarketOptions.  # noqa: E501
        :rtype: str
        """
        return self._block_potential_self_trades

    @block_potential_self_trades.setter
    def block_potential_self_trades(self, block_potential_self_trades):
        """Sets the block_potential_self_trades of this MarketOptions.

        This setting the behaviour of orders that could potentially lead to self-trades and can't be resolved by the internal matching engine   * `disabled`                don't check for non-resolveable potential self-trades   * `block_all`               reject requests with orders that could lead to self-trades (own bid >= own ask)   * `block_if_not_resolvable` reject requests with orders that could lead to self-trades that can't be resolved by the internal matching engine (e.g. across delivery areas)  # noqa: E501

        :param block_potential_self_trades: The block_potential_self_trades of this MarketOptions.  # noqa: E501
        :type block_potential_self_trades: str
        """
        allowed_values = ["disabled", "block_all", "block_if_not_resolvable"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and block_potential_self_trades not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `block_potential_self_trades` ({0}), must be one of {1}"  # noqa: E501
                .format(block_potential_self_trades, allowed_values)
            )

        self._block_potential_self_trades = block_potential_self_trades

    @property
    def internal_trading_cross_area(self):
        """Gets the internal_trading_cross_area of this MarketOptions.  # noqa: E501

        German delivery areas have unlimited cross border capacities before entering `SDAT` mode. If this setting is set to true, then the German delivery areas will be treated as one area when matching internal trades during the `CONT` trading phase.  **Note**: NordPool does not report a contract's trading phase, so internal cross delivery trading area stays active until the lead time limit is reached.  # noqa: E501

        :return: The internal_trading_cross_area of this MarketOptions.  # noqa: E501
        :rtype: bool
        """
        return self._internal_trading_cross_area

    @internal_trading_cross_area.setter
    def internal_trading_cross_area(self, internal_trading_cross_area):
        """Sets the internal_trading_cross_area of this MarketOptions.

        German delivery areas have unlimited cross border capacities before entering `SDAT` mode. If this setting is set to true, then the German delivery areas will be treated as one area when matching internal trades during the `CONT` trading phase.  **Note**: NordPool does not report a contract's trading phase, so internal cross delivery trading area stays active until the lead time limit is reached.  # noqa: E501

        :param internal_trading_cross_area: The internal_trading_cross_area of this MarketOptions.  # noqa: E501
        :type internal_trading_cross_area: bool
        """

        self._internal_trading_cross_area = internal_trading_cross_area

    @property
    def internal_trading_cross_area_lead_time(self):
        """Gets the internal_trading_cross_area_lead_time of this MarketOptions.  # noqa: E501

        The time (in minutes) before a contract's delivery start, after which cross area matching gets disabled. If this option is set to '0', then cross area matching is enabled as long as a contract is in the trading phase `CONT`. Independent of this setting, cross area matching is only active during the `CONT` trading phase.  **Note**: NordPool does not report a contract's trading phase, so only the lead time determines if internal cross area trading should take place.  # noqa: E501

        :return: The internal_trading_cross_area_lead_time of this MarketOptions.  # noqa: E501
        :rtype: int
        """
        return self._internal_trading_cross_area_lead_time

    @internal_trading_cross_area_lead_time.setter
    def internal_trading_cross_area_lead_time(self, internal_trading_cross_area_lead_time):
        """Sets the internal_trading_cross_area_lead_time of this MarketOptions.

        The time (in minutes) before a contract's delivery start, after which cross area matching gets disabled. If this option is set to '0', then cross area matching is enabled as long as a contract is in the trading phase `CONT`. Independent of this setting, cross area matching is only active during the `CONT` trading phase.  **Note**: NordPool does not report a contract's trading phase, so only the lead time determines if internal cross area trading should take place.  # noqa: E501

        :param internal_trading_cross_area_lead_time: The internal_trading_cross_area_lead_time of this MarketOptions.  # noqa: E501
        :type internal_trading_cross_area_lead_time: int
        """
        if (self.local_vars_configuration.client_side_validation and
                internal_trading_cross_area_lead_time is not None and internal_trading_cross_area_lead_time < 0):  # noqa: E501
            raise ValueError("Invalid value for `internal_trading_cross_area_lead_time`, must be a value greater than or equal to `0`")  # noqa: E501

        self._internal_trading_cross_area_lead_time = internal_trading_cross_area_lead_time

    @property
    def internal_trading_include_external_orders(self):
        """Gets the internal_trading_include_external_orders of this MarketOptions.  # noqa: E501

        If set to true, PowerBot will also create internal trades with orders that were not created through PowerBot, for example orders from ComTrader.  # noqa: E501

        :return: The internal_trading_include_external_orders of this MarketOptions.  # noqa: E501
        :rtype: bool
        """
        return self._internal_trading_include_external_orders

    @internal_trading_include_external_orders.setter
    def internal_trading_include_external_orders(self, internal_trading_include_external_orders):
        """Sets the internal_trading_include_external_orders of this MarketOptions.

        If set to true, PowerBot will also create internal trades with orders that were not created through PowerBot, for example orders from ComTrader.  # noqa: E501

        :param internal_trading_include_external_orders: The internal_trading_include_external_orders of this MarketOptions.  # noqa: E501
        :type internal_trading_include_external_orders: bool
        """

        self._internal_trading_include_external_orders = internal_trading_include_external_orders

    @property
    def internal_trading_across_tenants(self):
        """Gets the internal_trading_across_tenants of this MarketOptions.  # noqa: E501

        Controls whether cross trade detection works across tenants. It is enabled by default.  # noqa: E501

        :return: The internal_trading_across_tenants of this MarketOptions.  # noqa: E501
        :rtype: bool
        """
        return self._internal_trading_across_tenants

    @internal_trading_across_tenants.setter
    def internal_trading_across_tenants(self, internal_trading_across_tenants):
        """Sets the internal_trading_across_tenants of this MarketOptions.

        Controls whether cross trade detection works across tenants. It is enabled by default.  # noqa: E501

        :param internal_trading_across_tenants: The internal_trading_across_tenants of this MarketOptions.  # noqa: E501
        :type internal_trading_across_tenants: bool
        """

        self._internal_trading_across_tenants = internal_trading_across_tenants

    @property
    def default_delivery_area_id(self):
        """Gets the default_delivery_area_id of this MarketOptions.  # noqa: E501

        In multi-area configurations, set this option in case you want a default delivery area  # noqa: E501

        :return: The default_delivery_area_id of this MarketOptions.  # noqa: E501
        :rtype: str
        """
        return self._default_delivery_area_id

    @default_delivery_area_id.setter
    def default_delivery_area_id(self, default_delivery_area_id):
        """Sets the default_delivery_area_id of this MarketOptions.

        In multi-area configurations, set this option in case you want a default delivery area  # noqa: E501

        :param default_delivery_area_id: The default_delivery_area_id of this MarketOptions.  # noqa: E501
        :type default_delivery_area_id: str
        """

        self._default_delivery_area_id = default_delivery_area_id

    @property
    def restrict_safe_mode(self):
        """Gets the restrict_safe_mode of this MarketOptions.  # noqa: E501

        Restrict switching market mode to the master API key. If set to true, only the master API key can toggle the market mode (call PUT/market/mode). If set to false, all master API keys, tenant master API keys and API keys with the 'can_trade' attribute set to true can toggle the market mode. Safe mode (emergency stop) has the following effects * all algorithm instances are stopped and can't be started * all active orders are deleted from the market * order entry / modification is disabled * trades can still be recalled  The default value is false.  # noqa: E501

        :return: The restrict_safe_mode of this MarketOptions.  # noqa: E501
        :rtype: bool
        """
        return self._restrict_safe_mode

    @restrict_safe_mode.setter
    def restrict_safe_mode(self, restrict_safe_mode):
        """Sets the restrict_safe_mode of this MarketOptions.

        Restrict switching market mode to the master API key. If set to true, only the master API key can toggle the market mode (call PUT/market/mode). If set to false, all master API keys, tenant master API keys and API keys with the 'can_trade' attribute set to true can toggle the market mode. Safe mode (emergency stop) has the following effects * all algorithm instances are stopped and can't be started * all active orders are deleted from the market * order entry / modification is disabled * trades can still be recalled  The default value is false.  # noqa: E501

        :param restrict_safe_mode: The restrict_safe_mode of this MarketOptions.  # noqa: E501
        :type restrict_safe_mode: bool
        """

        self._restrict_safe_mode = restrict_safe_mode

    @property
    def throttling_user_action(self):
        """Gets the throttling_user_action of this MarketOptions.  # noqa: E501

        This setting is only relevant for EPEX.  The behaviour of the exchange if you get suspended for violating your order quota limit. The default setting is `DO_NOTHING`.  **Warning**: To apply this setting, you will need to log out of the market and reconnect. In production, you will need to do this for both prod1 and prod2.  * `DO_NOTHING`       The exchange will take no further action after suspending you for order quota limit violations. * `HIBERNATE_ORDERS` The exchange will hibernate all user orders after suspending you for order quota limit violations.  # noqa: E501

        :return: The throttling_user_action of this MarketOptions.  # noqa: E501
        :rtype: str
        """
        return self._throttling_user_action

    @throttling_user_action.setter
    def throttling_user_action(self, throttling_user_action):
        """Sets the throttling_user_action of this MarketOptions.

        This setting is only relevant for EPEX.  The behaviour of the exchange if you get suspended for violating your order quota limit. The default setting is `DO_NOTHING`.  **Warning**: To apply this setting, you will need to log out of the market and reconnect. In production, you will need to do this for both prod1 and prod2.  * `DO_NOTHING`       The exchange will take no further action after suspending you for order quota limit violations. * `HIBERNATE_ORDERS` The exchange will hibernate all user orders after suspending you for order quota limit violations.  # noqa: E501

        :param throttling_user_action: The throttling_user_action of this MarketOptions.  # noqa: E501
        :type throttling_user_action: str
        """
        allowed_values = ["DO_NOTHING", "HIBERNATE_ORDERS"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and throttling_user_action not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `throttling_user_action` ({0}), must be one of {1}"  # noqa: E501
                .format(throttling_user_action, allowed_values)
            )

        self._throttling_user_action = throttling_user_action

    @property
    def enable_mfa(self):
        """Gets the enable_mfa of this MarketOptions.  # noqa: E501

        If set to true, PowerBot will enable MFA. The MFA secret will be returned in the response. It is not possible to retrieve the secret later on, so make sure you save it immediately.  **Note**: At this moment only M7 (HUPX, SouthPool, TGE, EPEX, SEMO, OPCOM) supports MFA.  # noqa: E501

        :return: The enable_mfa of this MarketOptions.  # noqa: E501
        :rtype: bool
        """
        return self._enable_mfa

    @enable_mfa.setter
    def enable_mfa(self, enable_mfa):
        """Sets the enable_mfa of this MarketOptions.

        If set to true, PowerBot will enable MFA. The MFA secret will be returned in the response. It is not possible to retrieve the secret later on, so make sure you save it immediately.  **Note**: At this moment only M7 (HUPX, SouthPool, TGE, EPEX, SEMO, OPCOM) supports MFA.  # noqa: E501

        :param enable_mfa: The enable_mfa of this MarketOptions.  # noqa: E501
        :type enable_mfa: bool
        """

        self._enable_mfa = enable_mfa

    @property
    def show_all_account_orders(self):
        """Gets the show_all_account_orders of this MarketOptions.  # noqa: E501

        If enabled, all orders from the exchange account get marked as `own_order: true` in the order book. Otherwise, only orders from accessible portfolios get marked.  Setting this to `false` has the side effect of `own_order` being set to `false` in all WebSocket events, regardless of user access.  The default setting is `true`.  # noqa: E501

        :return: The show_all_account_orders of this MarketOptions.  # noqa: E501
        :rtype: bool
        """
        return self._show_all_account_orders

    @show_all_account_orders.setter
    def show_all_account_orders(self, show_all_account_orders):
        """Sets the show_all_account_orders of this MarketOptions.

        If enabled, all orders from the exchange account get marked as `own_order: true` in the order book. Otherwise, only orders from accessible portfolios get marked.  Setting this to `false` has the side effect of `own_order` being set to `false` in all WebSocket events, regardless of user access.  The default setting is `true`.  # noqa: E501

        :param show_all_account_orders: The show_all_account_orders of this MarketOptions.  # noqa: E501
        :type show_all_account_orders: bool
        """

        self._show_all_account_orders = show_all_account_orders

    @property
    def session_max_age(self):
        """Gets the session_max_age of this MarketOptions.  # noqa: E501

        Specifies the max age of the cookie in seconds. Note: If the cookie-max-age is set to a negative number, the cookie will be deleted when the browser is closed  # noqa: E501

        :return: The session_max_age of this MarketOptions.  # noqa: E501
        :rtype: int
        """
        return self._session_max_age

    @session_max_age.setter
    def session_max_age(self, session_max_age):
        """Sets the session_max_age of this MarketOptions.

        Specifies the max age of the cookie in seconds. Note: If the cookie-max-age is set to a negative number, the cookie will be deleted when the browser is closed  # noqa: E501

        :param session_max_age: The session_max_age of this MarketOptions.  # noqa: E501
        :type session_max_age: int
        """

        self._session_max_age = session_max_age

    @property
    def session_max_inactive_time(self):
        """Gets the session_max_inactive_time of this MarketOptions.  # noqa: E501

        Specifies the max time in seconds a session can be inactive before it is invalidated. Note: If the session-max-inactive-time is set to 0 or a negative number, the session will never expire  # noqa: E501

        :return: The session_max_inactive_time of this MarketOptions.  # noqa: E501
        :rtype: int
        """
        return self._session_max_inactive_time

    @session_max_inactive_time.setter
    def session_max_inactive_time(self, session_max_inactive_time):
        """Sets the session_max_inactive_time of this MarketOptions.

        Specifies the max time in seconds a session can be inactive before it is invalidated. Note: If the session-max-inactive-time is set to 0 or a negative number, the session will never expire  # noqa: E501

        :param session_max_inactive_time: The session_max_inactive_time of this MarketOptions.  # noqa: E501
        :type session_max_inactive_time: int
        """

        self._session_max_inactive_time = session_max_inactive_time

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MarketOptions):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MarketOptions):
            return True

        return self.to_dict() != other.to_dict()
