# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoint The PowerBot service is available at the following REST endpoint:  ``` $api_url_placeholder ```  Access to the API is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.26.4
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class ProductInformation(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'product_name': 'str',
        'delivery_area': 'str',
        'price_currency': 'str',
        'quantity_unit': 'str',
        'duration_minutes': 'int',
        'location_required': 'bool'
    }

    attribute_map = {
        'product_name': 'product_name',
        'delivery_area': 'delivery_area',
        'price_currency': 'price_currency',
        'quantity_unit': 'quantity_unit',
        'duration_minutes': 'duration_minutes',
        'location_required': 'location_required'
    }

    def __init__(self, product_name=None, delivery_area=None, price_currency=None, quantity_unit=None, duration_minutes=None, location_required=None, local_vars_configuration=None):  # noqa: E501
        """ProductInformation - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._product_name = None
        self._delivery_area = None
        self._price_currency = None
        self._quantity_unit = None
        self._duration_minutes = None
        self._location_required = None
        self.discriminator = None

        if product_name is not None:
            self.product_name = product_name
        if delivery_area is not None:
            self.delivery_area = delivery_area
        if price_currency is not None:
            self.price_currency = price_currency
        if quantity_unit is not None:
            self.quantity_unit = quantity_unit
        if duration_minutes is not None:
            self.duration_minutes = duration_minutes
        if location_required is not None:
            self.location_required = location_required

    @property
    def product_name(self):
        """Gets the product_name of this ProductInformation.  # noqa: E501

        Name of the product  # noqa: E501

        :return: The product_name of this ProductInformation.  # noqa: E501
        :rtype: str
        """
        return self._product_name

    @product_name.setter
    def product_name(self, product_name):
        """Sets the product_name of this ProductInformation.

        Name of the product  # noqa: E501

        :param product_name: The product_name of this ProductInformation.  # noqa: E501
        :type product_name: str
        """

        self._product_name = product_name

    @property
    def delivery_area(self):
        """Gets the delivery_area of this ProductInformation.  # noqa: E501

        The EIC of the delivery area of the order book's product  # noqa: E501

        :return: The delivery_area of this ProductInformation.  # noqa: E501
        :rtype: str
        """
        return self._delivery_area

    @delivery_area.setter
    def delivery_area(self, delivery_area):
        """Sets the delivery_area of this ProductInformation.

        The EIC of the delivery area of the order book's product  # noqa: E501

        :param delivery_area: The delivery_area of this ProductInformation.  # noqa: E501
        :type delivery_area: str
        """

        self._delivery_area = delivery_area

    @property
    def price_currency(self):
        """Gets the price_currency of this ProductInformation.  # noqa: E501

        the price currency of the underlying contracts  # noqa: E501

        :return: The price_currency of this ProductInformation.  # noqa: E501
        :rtype: str
        """
        return self._price_currency

    @price_currency.setter
    def price_currency(self, price_currency):
        """Sets the price_currency of this ProductInformation.

        the price currency of the underlying contracts  # noqa: E501

        :param price_currency: The price_currency of this ProductInformation.  # noqa: E501
        :type price_currency: str
        """

        self._price_currency = price_currency

    @property
    def quantity_unit(self):
        """Gets the quantity_unit of this ProductInformation.  # noqa: E501

        the quantity unit of the underlying contracts  # noqa: E501

        :return: The quantity_unit of this ProductInformation.  # noqa: E501
        :rtype: str
        """
        return self._quantity_unit

    @quantity_unit.setter
    def quantity_unit(self, quantity_unit):
        """Sets the quantity_unit of this ProductInformation.

        the quantity unit of the underlying contracts  # noqa: E501

        :param quantity_unit: The quantity_unit of this ProductInformation.  # noqa: E501
        :type quantity_unit: str
        """

        self._quantity_unit = quantity_unit

    @property
    def duration_minutes(self):
        """Gets the duration_minutes of this ProductInformation.  # noqa: E501

        the duration of the product's contracts in minutes  # noqa: E501

        :return: The duration_minutes of this ProductInformation.  # noqa: E501
        :rtype: int
        """
        return self._duration_minutes

    @duration_minutes.setter
    def duration_minutes(self, duration_minutes):
        """Sets the duration_minutes of this ProductInformation.

        the duration of the product's contracts in minutes  # noqa: E501

        :param duration_minutes: The duration_minutes of this ProductInformation.  # noqa: E501
        :type duration_minutes: int
        """

        self._duration_minutes = duration_minutes

    @property
    def location_required(self):
        """Gets the location_required of this ProductInformation.  # noqa: E501

        Indicates if the product requires location information within the delivery area.  # noqa: E501

        :return: The location_required of this ProductInformation.  # noqa: E501
        :rtype: bool
        """
        return self._location_required

    @location_required.setter
    def location_required(self, location_required):
        """Sets the location_required of this ProductInformation.

        Indicates if the product requires location information within the delivery area.  # noqa: E501

        :param location_required: The location_required of this ProductInformation.  # noqa: E501
        :type location_required: bool
        """

        self._location_required = location_required

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProductInformation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ProductInformation):
            return True

        return self.to_dict() != other.to_dict()
