# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoint The PowerBot service is available at the following REST endpoint:  ``` $api_url_placeholder ```  Access to the API is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.26.4
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class SsoProviderOverviewItem(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'provider_id': 'str',
        'provider_name': 'str',
        'enabled': 'bool',
        'custom': 'bool',
        'user_count': 'int',
        'issuer': 'str',
        'organizations': 'list[SsoProviderOrganization]'
    }

    attribute_map = {
        'provider_id': 'provider_id',
        'provider_name': 'provider_name',
        'enabled': 'enabled',
        'custom': 'custom',
        'user_count': 'user_count',
        'issuer': 'issuer',
        'organizations': 'organizations'
    }

    def __init__(self, provider_id=None, provider_name=None, enabled=None, custom=None, user_count=None, issuer=None, organizations=None, local_vars_configuration=None):  # noqa: E501
        """SsoProviderOverviewItem - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._provider_id = None
        self._provider_name = None
        self._enabled = None
        self._custom = None
        self._user_count = None
        self._issuer = None
        self._organizations = None
        self.discriminator = None

        if provider_id is not None:
            self.provider_id = provider_id
        if provider_name is not None:
            self.provider_name = provider_name
        if enabled is not None:
            self.enabled = enabled
        if custom is not None:
            self.custom = custom
        if user_count is not None:
            self.user_count = user_count
        if issuer is not None:
            self.issuer = issuer
        if organizations is not None:
            self.organizations = organizations

    @property
    def provider_id(self):
        """Gets the provider_id of this SsoProviderOverviewItem.  # noqa: E501

        Unique identifier for the SSO provider.  # noqa: E501

        :return: The provider_id of this SsoProviderOverviewItem.  # noqa: E501
        :rtype: str
        """
        return self._provider_id

    @provider_id.setter
    def provider_id(self, provider_id):
        """Sets the provider_id of this SsoProviderOverviewItem.

        Unique identifier for the SSO provider.  # noqa: E501

        :param provider_id: The provider_id of this SsoProviderOverviewItem.  # noqa: E501
        :type provider_id: str
        """

        self._provider_id = provider_id

    @property
    def provider_name(self):
        """Gets the provider_name of this SsoProviderOverviewItem.  # noqa: E501

        The name of the SSO provider. Used for display purposes.  # noqa: E501

        :return: The provider_name of this SsoProviderOverviewItem.  # noqa: E501
        :rtype: str
        """
        return self._provider_name

    @provider_name.setter
    def provider_name(self, provider_name):
        """Sets the provider_name of this SsoProviderOverviewItem.

        The name of the SSO provider. Used for display purposes.  # noqa: E501

        :param provider_name: The provider_name of this SsoProviderOverviewItem.  # noqa: E501
        :type provider_name: str
        """

        self._provider_name = provider_name

    @property
    def enabled(self):
        """Gets the enabled of this SsoProviderOverviewItem.  # noqa: E501

        Indicates if the provider is fully configured. A provider is considered as configured once it has organizations assigned to it. For default providers, the organizations have to be explicitly added. Note that this field is true for all custom providers, since they don't support organizations.  # noqa: E501

        :return: The enabled of this SsoProviderOverviewItem.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this SsoProviderOverviewItem.

        Indicates if the provider is fully configured. A provider is considered as configured once it has organizations assigned to it. For default providers, the organizations have to be explicitly added. Note that this field is true for all custom providers, since they don't support organizations.  # noqa: E501

        :param enabled: The enabled of this SsoProviderOverviewItem.  # noqa: E501
        :type enabled: bool
        """

        self._enabled = enabled

    @property
    def custom(self):
        """Gets the custom of this SsoProviderOverviewItem.  # noqa: E501

        Indicates if the provider is a custom provider.  # noqa: E501

        :return: The custom of this SsoProviderOverviewItem.  # noqa: E501
        :rtype: bool
        """
        return self._custom

    @custom.setter
    def custom(self, custom):
        """Sets the custom of this SsoProviderOverviewItem.

        Indicates if the provider is a custom provider.  # noqa: E501

        :param custom: The custom of this SsoProviderOverviewItem.  # noqa: E501
        :type custom: bool
        """

        self._custom = custom

    @property
    def user_count(self):
        """Gets the user_count of this SsoProviderOverviewItem.  # noqa: E501

        Number of users assigned to this provider.  # noqa: E501

        :return: The user_count of this SsoProviderOverviewItem.  # noqa: E501
        :rtype: int
        """
        return self._user_count

    @user_count.setter
    def user_count(self, user_count):
        """Sets the user_count of this SsoProviderOverviewItem.

        Number of users assigned to this provider.  # noqa: E501

        :param user_count: The user_count of this SsoProviderOverviewItem.  # noqa: E501
        :type user_count: int
        """

        self._user_count = user_count

    @property
    def issuer(self):
        """Gets the issuer of this SsoProviderOverviewItem.  # noqa: E501

        URI Identifier for the issuer of the SSO provider.  # noqa: E501

        :return: The issuer of this SsoProviderOverviewItem.  # noqa: E501
        :rtype: str
        """
        return self._issuer

    @issuer.setter
    def issuer(self, issuer):
        """Sets the issuer of this SsoProviderOverviewItem.

        URI Identifier for the issuer of the SSO provider.  # noqa: E501

        :param issuer: The issuer of this SsoProviderOverviewItem.  # noqa: E501
        :type issuer: str
        """

        self._issuer = issuer

    @property
    def organizations(self):
        """Gets the organizations of this SsoProviderOverviewItem.  # noqa: E501


        :return: The organizations of this SsoProviderOverviewItem.  # noqa: E501
        :rtype: list[SsoProviderOrganization]
        """
        return self._organizations

    @organizations.setter
    def organizations(self, organizations):
        """Sets the organizations of this SsoProviderOverviewItem.


        :param organizations: The organizations of this SsoProviderOverviewItem.  # noqa: E501
        :type organizations: list[SsoProviderOrganization]
        """

        self._organizations = organizations

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SsoProviderOverviewItem):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SsoProviderOverviewItem):
            return True

        return self.to_dict() != other.to_dict()
