# AUTOGENERATED ON 2020-01-30 22:15:23.661530
## DO NOT MODIFY THIS FILE MANUALLY

from numpy import inf, nan

from autogoal.grammar import Continuous, Discrete, Categorical, Boolean
from autogoal.contrib.sklearn._builder import SklearnEstimator, SklearnTransformer
from autogoal.kb import *
from autogoal.utils import nice_repr

from sklearn.cluster._affinity_propagation import (
    AffinityPropagation as _AffinityPropagation,
)


@nice_repr
class AffinityPropagation(_AffinityPropagation, SklearnEstimator):
    def __init__(
        self,
        convergence_iter: Discrete(min=1, max=29),
        affinity: Categorical("euclidean"),
    ):
        SklearnEstimator.__init__(self)
        _AffinityPropagation.__init__(
            self, convergence_iter=convergence_iter, affinity=affinity
        )

    def run(
        self, input: Tuple(MatrixContinuousDense(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.cluster._agglomerative import FeatureAgglomeration as _FeatureAgglomeration


@nice_repr
class FeatureAgglomeration(_FeatureAgglomeration, SklearnTransformer):
    def __init__(
        self,
        n_clusters: Discrete(min=1, max=3),
        affinity: Categorical("euclidean"),
        compute_full_tree: Categorical("auto"),
        linkage: Categorical("average", "complete", "single", "ward"),
    ):
        SklearnTransformer.__init__(self)
        _FeatureAgglomeration.__init__(
            self,
            n_clusters=n_clusters,
            affinity=affinity,
            compute_full_tree=compute_full_tree,
            linkage=linkage,
        )

    def run(self, input: MatrixContinuousDense()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.cluster._birch import Birch as _Birch


@nice_repr
class Birch(_Birch, SklearnEstimator):
    def __init__(
        self,
        threshold: Continuous(min=-4.995, max=4.991),
        branching_factor: Discrete(min=2, max=99),
        n_clusters: Discrete(min=1, max=5),
        compute_labels: Boolean(),
    ):
        SklearnEstimator.__init__(self)
        _Birch.__init__(
            self,
            threshold=threshold,
            branching_factor=branching_factor,
            n_clusters=n_clusters,
            compute_labels=compute_labels,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.cluster._kmeans import KMeans as _KMeans


@nice_repr
class KMeans(_KMeans, SklearnEstimator):
    def __init__(
        self,
        n_clusters: Discrete(min=1, max=15),
        init: Categorical("random"),
        precompute_distances: Categorical("auto"),
    ):
        SklearnEstimator.__init__(self)
        _KMeans.__init__(
            self,
            n_clusters=n_clusters,
            init=init,
            precompute_distances=precompute_distances,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.cluster._kmeans import MiniBatchKMeans as _MiniBatchKMeans


@nice_repr
class MiniBatchKMeans(_MiniBatchKMeans, SklearnEstimator):
    def __init__(
        self,
        n_clusters: Discrete(min=1, max=15),
        init: Categorical("random"),
        compute_labels: Boolean(),
        tol: Continuous(min=-0.992, max=0.992),
        max_no_improvement: Discrete(min=1, max=19),
        reassignment_ratio: Continuous(min=-0.093, max=0.094),
    ):
        SklearnEstimator.__init__(self)
        _MiniBatchKMeans.__init__(
            self,
            n_clusters=n_clusters,
            init=init,
            compute_labels=compute_labels,
            tol=tol,
            max_no_improvement=max_no_improvement,
            reassignment_ratio=reassignment_ratio,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.cluster._mean_shift import MeanShift as _MeanShift


@nice_repr
class MeanShift(_MeanShift, SklearnEstimator):
    def __init__(self, bin_seeding: Boolean(), cluster_all: Boolean()):
        SklearnEstimator.__init__(self)
        _MeanShift.__init__(self, bin_seeding=bin_seeding, cluster_all=cluster_all)

    def run(
        self, input: Tuple(MatrixContinuousDense(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.decomposition._factor_analysis import FactorAnalysis as _FactorAnalysis


@nice_repr
class FactorAnalysis(_FactorAnalysis, SklearnTransformer):
    def __init__(
        self,
        tol: Continuous(min=-0.093, max=0.094),
        svd_method: Categorical("lapack", "randomized"),
        iterated_power: Discrete(min=1, max=5),
    ):
        SklearnTransformer.__init__(self)
        _FactorAnalysis.__init__(
            self, tol=tol, svd_method=svd_method, iterated_power=iterated_power
        )

    def run(self, input: MatrixContinuousDense()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.decomposition._fastica import FastICA as _FastICA


@nice_repr
class FastICA(_FastICA, SklearnTransformer):
    def __init__(
        self,
        algorithm: Categorical("deflation", "parallel"),
        whiten: Boolean(),
        fun: Categorical("cube", "exp", "logcosh"),
    ):
        SklearnTransformer.__init__(self)
        _FastICA.__init__(self, algorithm=algorithm, whiten=whiten, fun=fun)

    def run(self, input: MatrixContinuousDense()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.decomposition._incremental_pca import IncrementalPCA as _IncrementalPCA


@nice_repr
class IncrementalPCA(_IncrementalPCA, SklearnTransformer):
    def __init__(self, whiten: Boolean()):
        SklearnTransformer.__init__(self)
        _IncrementalPCA.__init__(self, whiten=whiten)

    def run(self, input: MatrixContinuousDense()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.decomposition._kernel_pca import KernelPCA as _KernelPCA


@nice_repr
class KernelPCA(_KernelPCA, SklearnTransformer):
    def __init__(
        self,
        degree: Discrete(min=1, max=5),
        alpha: Continuous(min=-9.995, max=9.991),
        fit_inverse_transform: Boolean(),
        eigen_solver: Categorical("arpack", "auto", "dense"),
        tol: Discrete(min=-99, max=99),
        remove_zero_eig: Boolean(),
    ):
        SklearnTransformer.__init__(self)
        _KernelPCA.__init__(
            self,
            degree=degree,
            alpha=alpha,
            fit_inverse_transform=fit_inverse_transform,
            eigen_solver=eigen_solver,
            tol=tol,
            remove_zero_eig=remove_zero_eig,
        )

    def run(self, input: MatrixContinuous()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.decomposition._lda import (
    LatentDirichletAllocation as _LatentDirichletAllocation,
)


@nice_repr
class LatentDirichletAllocation(_LatentDirichletAllocation, SklearnTransformer):
    def __init__(self,):
        SklearnTransformer.__init__(self)
        _LatentDirichletAllocation.__init__(self,)

    def run(self, input: MatrixContinuous()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.decomposition._nmf import NMF as _NMF


@nice_repr
class NMF(_NMF, SklearnTransformer):
    def __init__(
        self,
        alpha: Continuous(min=0.0, max=0.0),
        l1_ratio: Continuous(min=0.0, max=0.0),
        shuffle: Boolean(),
    ):
        SklearnTransformer.__init__(self)
        _NMF.__init__(self, alpha=alpha, l1_ratio=l1_ratio, shuffle=shuffle)

    def run(self, input: MatrixContinuous()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.decomposition._pca import PCA as _PCA


@nice_repr
class PCA(_PCA, SklearnTransformer):
    def __init__(
        self,
        whiten: Boolean(),
        svd_solver: Categorical("arpack", "auto", "full", "randomized"),
        tol: Continuous(min=-0.992, max=0.992),
        iterated_power: Categorical("auto", "randomized"),
    ):
        SklearnTransformer.__init__(self)
        _PCA.__init__(
            self,
            whiten=whiten,
            svd_solver=svd_solver,
            tol=tol,
            iterated_power=iterated_power,
        )

    def run(self, input: MatrixContinuousDense()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.decomposition._sparse_pca import MiniBatchSparsePCA as _MiniBatchSparsePCA


@nice_repr
class MiniBatchSparsePCA(_MiniBatchSparsePCA, SklearnTransformer):
    def __init__(
        self,
        ridge_alpha: Continuous(min=-0.093, max=0.094),
        n_iter: Discrete(min=1, max=199),
        batch_size: Discrete(min=1, max=5),
        shuffle: Boolean(),
        method: Categorical("cd", "lars"),
    ):
        SklearnTransformer.__init__(self)
        _MiniBatchSparsePCA.__init__(
            self,
            ridge_alpha=ridge_alpha,
            n_iter=n_iter,
            batch_size=batch_size,
            shuffle=shuffle,
            method=method,
        )

    def run(self, input: MatrixContinuousDense()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.decomposition._sparse_pca import SparsePCA as _SparsePCA


@nice_repr
class SparsePCA(_SparsePCA, SklearnTransformer):
    def __init__(
        self,
        ridge_alpha: Continuous(min=-0.093, max=0.094),
        method: Categorical("cd", "lars"),
    ):
        SklearnTransformer.__init__(self)
        _SparsePCA.__init__(self, ridge_alpha=ridge_alpha, method=method)

    def run(self, input: MatrixContinuousDense()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.decomposition._truncated_svd import TruncatedSVD as _TruncatedSVD


@nice_repr
class TruncatedSVD(_TruncatedSVD, SklearnTransformer):
    def __init__(
        self,
        n_components: Discrete(min=1, max=3),
        n_iter: Discrete(min=1, max=9),
        tol: Continuous(min=-0.992, max=0.992),
    ):
        SklearnTransformer.__init__(self)
        _TruncatedSVD.__init__(self, n_components=n_components, n_iter=n_iter, tol=tol)

    def run(self, input: MatrixContinuous()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.feature_extraction.text import CountVectorizer as _CountVectorizer


@nice_repr
class CountVectorizer(_CountVectorizer, SklearnTransformer):
    def __init__(self, lowercase: Boolean(), binary: Boolean()):
        SklearnTransformer.__init__(self)
        _CountVectorizer.__init__(self, lowercase=lowercase, binary=binary)

    def run(self, input: List(Sentence())) -> MatrixContinuousSparse():
        return SklearnTransformer.run(self, input)


from sklearn.feature_extraction.text import HashingVectorizer as _HashingVectorizer


@nice_repr
class HashingVectorizer(_HashingVectorizer, SklearnTransformer):
    def __init__(
        self,
        lowercase: Boolean(),
        n_features: Discrete(min=1, max=2097151),
        binary: Boolean(),
        norm: Categorical("l1"),
        alternate_sign: Boolean(),
    ):
        SklearnTransformer.__init__(self)
        _HashingVectorizer.__init__(
            self,
            lowercase=lowercase,
            n_features=n_features,
            binary=binary,
            norm=norm,
            alternate_sign=alternate_sign,
        )

    def run(self, input: List(Sentence())) -> MatrixContinuousSparse():
        return SklearnTransformer.run(self, input)


from sklearn.feature_extraction.text import TfidfTransformer as _TfidfTransformer


@nice_repr
class TfidfTransformer(_TfidfTransformer, SklearnTransformer):
    def __init__(
        self,
        norm: Categorical("l1", "l2"),
        use_idf: Boolean(),
        smooth_idf: Boolean(),
        sublinear_tf: Boolean(),
    ):
        SklearnTransformer.__init__(self)
        _TfidfTransformer.__init__(
            self,
            norm=norm,
            use_idf=use_idf,
            smooth_idf=smooth_idf,
            sublinear_tf=sublinear_tf,
        )

    def run(self, input: MatrixContinuous()) -> MatrixContinuousSparse():
        return SklearnTransformer.run(self, input)


from sklearn.feature_extraction.text import TfidfVectorizer as _TfidfVectorizer


@nice_repr
class TfidfVectorizer(_TfidfVectorizer, SklearnTransformer):
    def __init__(
        self,
        lowercase: Boolean(),
        binary: Boolean(),
        use_idf: Boolean(),
        smooth_idf: Boolean(),
        sublinear_tf: Boolean(),
    ):
        SklearnTransformer.__init__(self)
        _TfidfVectorizer.__init__(
            self,
            lowercase=lowercase,
            binary=binary,
            use_idf=use_idf,
            smooth_idf=smooth_idf,
            sublinear_tf=sublinear_tf,
        )

    def run(self, input: List(Sentence())) -> MatrixContinuousSparse():
        return SklearnTransformer.run(self, input)


from sklearn.impute._knn import KNNImputer as _KNNImputer


@nice_repr
class KNNImputer(_KNNImputer, SklearnTransformer):
    def __init__(
        self,
        n_neighbors: Discrete(min=1, max=9),
        weights: Categorical("distance", "uniform"),
        metric: Categorical("nan_euclidean"),
        add_indicator: Boolean(),
    ):
        SklearnTransformer.__init__(self)
        _KNNImputer.__init__(
            self,
            n_neighbors=n_neighbors,
            weights=weights,
            metric=metric,
            add_indicator=add_indicator,
        )

    def run(self, input: MatrixContinuousDense()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.linear_model._base import LinearRegression as _LinearRegression


@nice_repr
class LinearRegression(_LinearRegression, SklearnEstimator):
    def __init__(self, fit_intercept: Boolean(), normalize: Boolean()):
        SklearnEstimator.__init__(self)
        _LinearRegression.__init__(
            self, fit_intercept=fit_intercept, normalize=normalize
        )

    def run(
        self, input: Tuple(MatrixContinuous(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._bayes import ARDRegression as _ARDRegression


@nice_repr
class ARDRegression(_ARDRegression, SklearnEstimator):
    def __init__(
        self,
        n_iter: Discrete(min=1, max=599),
        tol: Continuous(min=-0.005, max=0.001),
        compute_score: Boolean(),
        threshold_lambda: Continuous(min=-99999.993, max=99999.995),
        fit_intercept: Boolean(),
        normalize: Boolean(),
    ):
        SklearnEstimator.__init__(self)
        _ARDRegression.__init__(
            self,
            n_iter=n_iter,
            tol=tol,
            compute_score=compute_score,
            threshold_lambda=threshold_lambda,
            fit_intercept=fit_intercept,
            normalize=normalize,
        )

    def run(
        self, input: Tuple(MatrixContinuousDense(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._bayes import BayesianRidge as _BayesianRidge


@nice_repr
class BayesianRidge(_BayesianRidge, SklearnEstimator):
    def __init__(
        self,
        n_iter: Discrete(min=1, max=599),
        tol: Continuous(min=-0.005, max=0.001),
        compute_score: Boolean(),
        fit_intercept: Boolean(),
        normalize: Boolean(),
    ):
        SklearnEstimator.__init__(self)
        _BayesianRidge.__init__(
            self,
            n_iter=n_iter,
            tol=tol,
            compute_score=compute_score,
            fit_intercept=fit_intercept,
            normalize=normalize,
        )

    def run(
        self, input: Tuple(MatrixContinuousDense(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._coordinate_descent import ElasticNet as _ElasticNet


@nice_repr
class ElasticNet(_ElasticNet, SklearnEstimator):
    def __init__(
        self,
        alpha: Continuous(min=-9.995, max=9.991),
        l1_ratio: Continuous(min=-4.995, max=4.991),
        fit_intercept: Boolean(),
        normalize: Boolean(),
        precompute: Boolean(),
        positive: Boolean(),
        selection: Categorical("cyclic", "random"),
    ):
        SklearnEstimator.__init__(self)
        _ElasticNet.__init__(
            self,
            alpha=alpha,
            l1_ratio=l1_ratio,
            fit_intercept=fit_intercept,
            normalize=normalize,
            precompute=precompute,
            positive=positive,
            selection=selection,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._coordinate_descent import Lasso as _Lasso


@nice_repr
class Lasso(_Lasso, SklearnEstimator):
    def __init__(
        self,
        alpha: Continuous(min=-9.995, max=9.991),
        fit_intercept: Boolean(),
        normalize: Boolean(),
        precompute: Boolean(),
        positive: Boolean(),
        selection: Categorical("cyclic", "random"),
    ):
        SklearnEstimator.__init__(self)
        _Lasso.__init__(
            self,
            alpha=alpha,
            fit_intercept=fit_intercept,
            normalize=normalize,
            precompute=precompute,
            positive=positive,
            selection=selection,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._huber import HuberRegressor as _HuberRegressor


@nice_repr
class HuberRegressor(_HuberRegressor, SklearnEstimator):
    def __init__(
        self, epsilon: Continuous(min=1.002, max=13.494), fit_intercept: Boolean()
    ):
        SklearnEstimator.__init__(self)
        _HuberRegressor.__init__(self, epsilon=epsilon, fit_intercept=fit_intercept)

    def run(
        self, input: Tuple(MatrixContinuous(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._least_angle import Lars as _Lars


@nice_repr
class Lars(_Lars, SklearnEstimator):
    def __init__(
        self,
        fit_intercept: Boolean(),
        normalize: Boolean(),
        precompute: Categorical("auto"),
        n_nonzero_coefs: Discrete(min=1, max=999),
        fit_path: Boolean(),
    ):
        SklearnEstimator.__init__(self)
        _Lars.__init__(
            self,
            fit_intercept=fit_intercept,
            normalize=normalize,
            precompute=precompute,
            n_nonzero_coefs=n_nonzero_coefs,
            fit_path=fit_path,
        )

    def run(
        self, input: Tuple(MatrixContinuousDense(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._least_angle import LassoLars as _LassoLars


@nice_repr
class LassoLars(_LassoLars, SklearnEstimator):
    def __init__(
        self,
        fit_intercept: Boolean(),
        normalize: Boolean(),
        precompute: Categorical("auto"),
        fit_path: Boolean(),
        positive: Boolean(),
    ):
        SklearnEstimator.__init__(self)
        _LassoLars.__init__(
            self,
            fit_intercept=fit_intercept,
            normalize=normalize,
            precompute=precompute,
            fit_path=fit_path,
            positive=positive,
        )

    def run(
        self, input: Tuple(MatrixContinuousDense(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._least_angle import LassoLarsIC as _LassoLarsIC


@nice_repr
class LassoLarsIC(_LassoLarsIC, SklearnEstimator):
    def __init__(
        self,
        criterion: Categorical("aic", "bic"),
        fit_intercept: Boolean(),
        normalize: Boolean(),
        precompute: Categorical("auto"),
        positive: Boolean(),
    ):
        SklearnEstimator.__init__(self)
        _LassoLarsIC.__init__(
            self,
            criterion=criterion,
            fit_intercept=fit_intercept,
            normalize=normalize,
            precompute=precompute,
            positive=positive,
        )

    def run(
        self, input: Tuple(MatrixContinuousDense(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._logistic import LogisticRegression as _LogisticRegression


@nice_repr
class LogisticRegression(_LogisticRegression, SklearnEstimator):
    def __init__(
        self,
        penalty: Categorical("l2", "none"),
        dual: Boolean(),
        C: Continuous(min=0.005, max=9.991),
        fit_intercept: Boolean(),
        solver: Categorical("lbfgs", "liblinear", "sag", "saga"),
        multi_class: Categorical("auto", "multinomial", "ovr"),
    ):
        SklearnEstimator.__init__(self)
        _LogisticRegression.__init__(
            self,
            penalty=penalty,
            dual=dual,
            C=C,
            fit_intercept=fit_intercept,
            solver=solver,
            multi_class=multi_class,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._omp import (
    OrthogonalMatchingPursuit as _OrthogonalMatchingPursuit,
)


@nice_repr
class OrthogonalMatchingPursuit(_OrthogonalMatchingPursuit, SklearnEstimator):
    def __init__(
        self,
        fit_intercept: Boolean(),
        normalize: Boolean(),
        precompute: Categorical("auto"),
    ):
        SklearnEstimator.__init__(self)
        _OrthogonalMatchingPursuit.__init__(
            self,
            fit_intercept=fit_intercept,
            normalize=normalize,
            precompute=precompute,
        )

    def run(
        self, input: Tuple(MatrixContinuousDense(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._passive_aggressive import (
    PassiveAggressiveClassifier as _PassiveAggressiveClassifier,
)


@nice_repr
class PassiveAggressiveClassifier(_PassiveAggressiveClassifier, SklearnEstimator):
    def __init__(
        self,
        C: Continuous(min=-9.995, max=9.991),
        fit_intercept: Boolean(),
        tol: Continuous(min=-0.005, max=0.001),
        early_stopping: Boolean(),
        validation_fraction: Continuous(min=0.006, max=0.993),
        n_iter_no_change: Discrete(min=1, max=9),
        shuffle: Boolean(),
        average: Boolean(),
    ):
        SklearnEstimator.__init__(self)
        _PassiveAggressiveClassifier.__init__(
            self,
            C=C,
            fit_intercept=fit_intercept,
            tol=tol,
            early_stopping=early_stopping,
            validation_fraction=validation_fraction,
            n_iter_no_change=n_iter_no_change,
            shuffle=shuffle,
            average=average,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._passive_aggressive import (
    PassiveAggressiveRegressor as _PassiveAggressiveRegressor,
)


@nice_repr
class PassiveAggressiveRegressor(_PassiveAggressiveRegressor, SklearnEstimator):
    def __init__(
        self,
        C: Continuous(min=-9.995, max=9.991),
        fit_intercept: Boolean(),
        tol: Continuous(min=-0.005, max=0.001),
        early_stopping: Boolean(),
        validation_fraction: Continuous(min=0.006, max=0.993),
        n_iter_no_change: Discrete(min=1, max=9),
        shuffle: Boolean(),
        epsilon: Continuous(min=-0.992, max=0.993),
        average: Boolean(),
    ):
        SklearnEstimator.__init__(self)
        _PassiveAggressiveRegressor.__init__(
            self,
            C=C,
            fit_intercept=fit_intercept,
            tol=tol,
            early_stopping=early_stopping,
            validation_fraction=validation_fraction,
            n_iter_no_change=n_iter_no_change,
            shuffle=shuffle,
            epsilon=epsilon,
            average=average,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._perceptron import Perceptron as _Perceptron


@nice_repr
class Perceptron(_Perceptron, SklearnEstimator):
    def __init__(
        self,
        fit_intercept: Boolean(),
        tol: Continuous(min=-0.005, max=0.001),
        shuffle: Boolean(),
        eta0: Continuous(min=0.005, max=9.991),
        early_stopping: Boolean(),
        validation_fraction: Continuous(min=0.006, max=0.993),
        n_iter_no_change: Discrete(min=1, max=9),
    ):
        SklearnEstimator.__init__(self)
        _Perceptron.__init__(
            self,
            fit_intercept=fit_intercept,
            tol=tol,
            shuffle=shuffle,
            eta0=eta0,
            early_stopping=early_stopping,
            validation_fraction=validation_fraction,
            n_iter_no_change=n_iter_no_change,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._ridge import Ridge as _Ridge


@nice_repr
class Ridge(_Ridge, SklearnEstimator):
    def __init__(
        self,
        alpha: Continuous(min=-9.995, max=9.991),
        fit_intercept: Boolean(),
        normalize: Boolean(),
        tol: Continuous(min=-0.005, max=0.001),
        solver: Categorical(
            "auto", "cholesky", "lsqr", "sag", "saga", "sparse_cg", "svd"
        ),
    ):
        SklearnEstimator.__init__(self)
        _Ridge.__init__(
            self,
            alpha=alpha,
            fit_intercept=fit_intercept,
            normalize=normalize,
            tol=tol,
            solver=solver,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._ridge import RidgeClassifier as _RidgeClassifier


@nice_repr
class RidgeClassifier(_RidgeClassifier, SklearnEstimator):
    def __init__(
        self,
        alpha: Continuous(min=-9.995, max=9.991),
        fit_intercept: Boolean(),
        normalize: Boolean(),
        tol: Continuous(min=-0.005, max=0.001),
        solver: Categorical(
            "auto", "cholesky", "lsqr", "sag", "saga", "sparse_cg", "svd"
        ),
    ):
        SklearnEstimator.__init__(self)
        _RidgeClassifier.__init__(
            self,
            alpha=alpha,
            fit_intercept=fit_intercept,
            normalize=normalize,
            tol=tol,
            solver=solver,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._stochastic_gradient import SGDClassifier as _SGDClassifier


@nice_repr
class SGDClassifier(_SGDClassifier, SklearnEstimator):
    def __init__(
        self,
        loss: Categorical(
            "epsilon_insensitive",
            "hinge",
            "huber",
            "log",
            "modified_huber",
            "perceptron",
            "squared_epsilon_insensitive",
            "squared_hinge",
            "squared_loss",
        ),
        penalty: Categorical("elasticnet", "l1", "l2"),
        l1_ratio: Continuous(min=0.001, max=0.999),
        fit_intercept: Boolean(),
        tol: Continuous(min=-0.005, max=0.001),
        shuffle: Boolean(),
        epsilon: Continuous(min=-0.992, max=0.993),
        learning_rate: Categorical("optimal"),
        eta0: Continuous(min=-0.992, max=0.992),
        power_t: Continuous(min=-4.995, max=4.991),
        early_stopping: Boolean(),
        validation_fraction: Continuous(min=0.006, max=0.993),
        n_iter_no_change: Discrete(min=1, max=9),
        average: Boolean(),
    ):
        SklearnEstimator.__init__(self)
        _SGDClassifier.__init__(
            self,
            loss=loss,
            penalty=penalty,
            l1_ratio=l1_ratio,
            fit_intercept=fit_intercept,
            tol=tol,
            shuffle=shuffle,
            epsilon=epsilon,
            learning_rate=learning_rate,
            eta0=eta0,
            power_t=power_t,
            early_stopping=early_stopping,
            validation_fraction=validation_fraction,
            n_iter_no_change=n_iter_no_change,
            average=average,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._stochastic_gradient import SGDRegressor as _SGDRegressor


@nice_repr
class SGDRegressor(_SGDRegressor, SklearnEstimator):
    def __init__(
        self,
        loss: Categorical(
            "epsilon_insensitive",
            "huber",
            "squared_epsilon_insensitive",
            "squared_loss",
        ),
        penalty: Categorical("elasticnet", "l1", "l2"),
        l1_ratio: Continuous(min=0.001, max=0.999),
        fit_intercept: Boolean(),
        tol: Continuous(min=-0.005, max=0.001),
        shuffle: Boolean(),
        epsilon: Continuous(min=-0.992, max=0.993),
        learning_rate: Categorical("adaptive", "constant", "invscaling", "optimal"),
        eta0: Continuous(min=0.003, max=0.094),
        power_t: Continuous(min=-2.494, max=2.491),
        early_stopping: Boolean(),
        validation_fraction: Continuous(min=0.006, max=0.993),
        n_iter_no_change: Discrete(min=1, max=9),
        average: Boolean(),
    ):
        SklearnEstimator.__init__(self)
        _SGDRegressor.__init__(
            self,
            loss=loss,
            penalty=penalty,
            l1_ratio=l1_ratio,
            fit_intercept=fit_intercept,
            tol=tol,
            shuffle=shuffle,
            epsilon=epsilon,
            learning_rate=learning_rate,
            eta0=eta0,
            power_t=power_t,
            early_stopping=early_stopping,
            validation_fraction=validation_fraction,
            n_iter_no_change=n_iter_no_change,
            average=average,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._theil_sen import TheilSenRegressor as _TheilSenRegressor


@nice_repr
class TheilSenRegressor(_TheilSenRegressor, SklearnEstimator):
    def __init__(
        self, fit_intercept: Boolean(), tol: Continuous(min=-0.005, max=0.001)
    ):
        SklearnEstimator.__init__(self)
        _TheilSenRegressor.__init__(self, fit_intercept=fit_intercept, tol=tol)

    def run(
        self, input: Tuple(MatrixContinuousDense(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.manifold._isomap import Isomap as _Isomap


@nice_repr
class Isomap(_Isomap, SklearnTransformer):
    def __init__(
        self,
        n_neighbors: Discrete(min=1, max=9),
        n_components: Discrete(min=1, max=3),
        eigen_solver: Categorical("arpack", "auto", "dense"),
        tol: Discrete(min=-99, max=99),
        path_method: Categorical("auto"),
        neighbors_algorithm: Categorical("auto", "ball_tree", "brute", "kd_tree"),
        p: Discrete(min=1, max=3),
    ):
        SklearnTransformer.__init__(self)
        _Isomap.__init__(
            self,
            n_neighbors=n_neighbors,
            n_components=n_components,
            eigen_solver=eigen_solver,
            tol=tol,
            path_method=path_method,
            neighbors_algorithm=neighbors_algorithm,
            p=p,
        )

    def run(self, input: MatrixContinuous()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.manifold._locally_linear import (
    LocallyLinearEmbedding as _LocallyLinearEmbedding,
)


@nice_repr
class LocallyLinearEmbedding(_LocallyLinearEmbedding, SklearnTransformer):
    def __init__(
        self,
        n_neighbors: Discrete(min=1, max=9),
        n_components: Discrete(min=1, max=3),
        reg: Continuous(min=-0.005, max=0.001),
        eigen_solver: Categorical("arpack", "auto", "dense"),
        method: Categorical("ltsa", "modified", "standard"),
        neighbors_algorithm: Categorical("auto", "ball_tree", "brute", "kd_tree"),
    ):
        SklearnTransformer.__init__(self)
        _LocallyLinearEmbedding.__init__(
            self,
            n_neighbors=n_neighbors,
            n_components=n_components,
            reg=reg,
            eigen_solver=eigen_solver,
            method=method,
            neighbors_algorithm=neighbors_algorithm,
        )

    def run(self, input: MatrixContinuousDense()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.naive_bayes import BernoulliNB as _BernoulliNB


@nice_repr
class BernoulliNB(_BernoulliNB, SklearnEstimator):
    def __init__(
        self,
        alpha: Continuous(min=0.0, max=9.991),
        binarize: Continuous(min=-0.992, max=0.992),
        fit_prior: Boolean(),
    ):
        SklearnEstimator.__init__(self)
        _BernoulliNB.__init__(self, alpha=alpha, binarize=binarize, fit_prior=fit_prior)

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.naive_bayes import CategoricalNB as _CategoricalNB


@nice_repr
class CategoricalNB(_CategoricalNB, SklearnEstimator):
    def __init__(self, fit_prior: Boolean()):
        SklearnEstimator.__init__(self)
        _CategoricalNB.__init__(self, fit_prior=fit_prior)

    def run(
        self, input: Tuple(MatrixContinuousDense(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.naive_bayes import ComplementNB as _ComplementNB


@nice_repr
class ComplementNB(_ComplementNB, SklearnEstimator):
    def __init__(self, fit_prior: Boolean(), norm: Boolean()):
        SklearnEstimator.__init__(self)
        _ComplementNB.__init__(self, fit_prior=fit_prior, norm=norm)

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.naive_bayes import GaussianNB as _GaussianNB


@nice_repr
class GaussianNB(_GaussianNB, SklearnEstimator):
    def __init__(self,):
        SklearnEstimator.__init__(self)
        _GaussianNB.__init__(self,)

    def run(
        self, input: Tuple(MatrixContinuousDense(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.naive_bayes import MultinomialNB as _MultinomialNB


@nice_repr
class MultinomialNB(_MultinomialNB, SklearnEstimator):
    def __init__(self, fit_prior: Boolean()):
        SklearnEstimator.__init__(self)
        _MultinomialNB.__init__(self, fit_prior=fit_prior)

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.neighbors._classification import (
    KNeighborsClassifier as _KNeighborsClassifier,
)


@nice_repr
class KNeighborsClassifier(_KNeighborsClassifier, SklearnEstimator):
    def __init__(
        self,
        n_neighbors: Discrete(min=1, max=9),
        weights: Categorical("distance", "uniform"),
        algorithm: Categorical("auto", "ball_tree", "brute", "kd_tree"),
        leaf_size: Discrete(min=1, max=59),
        p: Discrete(min=1, max=3),
        metric: Categorical("minkowski"),
    ):
        SklearnEstimator.__init__(self)
        _KNeighborsClassifier.__init__(
            self,
            n_neighbors=n_neighbors,
            weights=weights,
            algorithm=algorithm,
            leaf_size=leaf_size,
            p=p,
            metric=metric,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.neighbors._graph import KNeighborsTransformer as _KNeighborsTransformer


@nice_repr
class KNeighborsTransformer(_KNeighborsTransformer, SklearnTransformer):
    def __init__(
        self,
        mode: Categorical("connectivity", "distance"),
        n_neighbors: Discrete(min=1, max=9),
        algorithm: Categorical("auto", "ball_tree", "brute", "kd_tree"),
        leaf_size: Discrete(min=1, max=59),
        p: Discrete(min=1, max=3),
    ):
        SklearnTransformer.__init__(self)
        _KNeighborsTransformer.__init__(
            self,
            mode=mode,
            n_neighbors=n_neighbors,
            algorithm=algorithm,
            leaf_size=leaf_size,
            p=p,
        )

    def run(self, input: MatrixContinuous()) -> MatrixContinuousSparse():
        return SklearnTransformer.run(self, input)


from sklearn.neighbors._graph import (
    RadiusNeighborsTransformer as _RadiusNeighborsTransformer,
)


@nice_repr
class RadiusNeighborsTransformer(_RadiusNeighborsTransformer, SklearnTransformer):
    def __init__(
        self,
        mode: Categorical("connectivity", "distance"),
        radius: Continuous(min=-9.995, max=9.991),
        algorithm: Categorical("auto", "ball_tree", "brute", "kd_tree"),
        leaf_size: Discrete(min=1, max=59),
        p: Discrete(min=1, max=3),
    ):
        SklearnTransformer.__init__(self)
        _RadiusNeighborsTransformer.__init__(
            self,
            mode=mode,
            radius=radius,
            algorithm=algorithm,
            leaf_size=leaf_size,
            p=p,
        )

    def run(self, input: MatrixContinuous()) -> MatrixContinuousSparse():
        return SklearnTransformer.run(self, input)


from sklearn.neighbors._lof import LocalOutlierFactor as _LocalOutlierFactor


@nice_repr
class LocalOutlierFactor(_LocalOutlierFactor, SklearnEstimator):
    def __init__(
        self,
        n_neighbors: Discrete(min=1, max=39),
        algorithm: Categorical("auto", "ball_tree", "brute", "kd_tree"),
        leaf_size: Discrete(min=1, max=59),
        p: Discrete(min=1, max=3),
        contamination: Categorical("auto"),
        novelty: Boolean(),
    ):
        SklearnEstimator.__init__(self)
        _LocalOutlierFactor.__init__(
            self,
            n_neighbors=n_neighbors,
            algorithm=algorithm,
            leaf_size=leaf_size,
            p=p,
            contamination=contamination,
            novelty=novelty,
        )

    def run(self, input: MatrixContinuous()) -> DiscreteVector():
        return SklearnEstimator.run(self, input)


from sklearn.neighbors._nearest_centroid import NearestCentroid as _NearestCentroid


@nice_repr
class NearestCentroid(_NearestCentroid, SklearnEstimator):
    def __init__(self,):
        SklearnEstimator.__init__(self)
        _NearestCentroid.__init__(self,)

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.neighbors._regression import KNeighborsRegressor as _KNeighborsRegressor


@nice_repr
class KNeighborsRegressor(_KNeighborsRegressor, SklearnEstimator):
    def __init__(
        self,
        n_neighbors: Discrete(min=1, max=9),
        weights: Categorical("distance", "uniform"),
        algorithm: Categorical("auto", "ball_tree", "brute", "kd_tree"),
        leaf_size: Discrete(min=1, max=59),
        p: Discrete(min=1, max=3),
        metric: Categorical("minkowski"),
    ):
        SklearnEstimator.__init__(self)
        _KNeighborsRegressor.__init__(
            self,
            n_neighbors=n_neighbors,
            weights=weights,
            algorithm=algorithm,
            leaf_size=leaf_size,
            p=p,
            metric=metric,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.neighbors._regression import (
    RadiusNeighborsRegressor as _RadiusNeighborsRegressor,
)


@nice_repr
class RadiusNeighborsRegressor(_RadiusNeighborsRegressor, SklearnEstimator):
    def __init__(
        self,
        radius: Continuous(min=-9.995, max=9.991),
        weights: Categorical("distance", "uniform"),
        algorithm: Categorical("auto", "ball_tree", "brute", "kd_tree"),
        leaf_size: Discrete(min=1, max=59),
        p: Discrete(min=1, max=3),
    ):
        SklearnEstimator.__init__(self)
        _RadiusNeighborsRegressor.__init__(
            self,
            radius=radius,
            weights=weights,
            algorithm=algorithm,
            leaf_size=leaf_size,
            p=p,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.preprocessing._data import KernelCenterer as _KernelCenterer


@nice_repr
class KernelCenterer(_KernelCenterer, SklearnTransformer):
    def __init__(self,):
        SklearnTransformer.__init__(self)
        _KernelCenterer.__init__(self,)

    def run(self, input: MatrixContinuousDense()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.preprocessing._data import MinMaxScaler as _MinMaxScaler


@nice_repr
class MinMaxScaler(_MinMaxScaler, SklearnTransformer):
    def __init__(self,):
        SklearnTransformer.__init__(self)
        _MinMaxScaler.__init__(self,)

    def run(self, input: MatrixContinuousDense()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.preprocessing._data import PowerTransformer as _PowerTransformer


@nice_repr
class PowerTransformer(_PowerTransformer, SklearnTransformer):
    def __init__(self, standardize: Boolean()):
        SklearnTransformer.__init__(self)
        _PowerTransformer.__init__(self, standardize=standardize)

    def run(self, input: MatrixContinuousDense()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.preprocessing._data import RobustScaler as _RobustScaler


@nice_repr
class RobustScaler(_RobustScaler, SklearnTransformer):
    def __init__(self, with_centering: Boolean(), with_scaling: Boolean()):
        SklearnTransformer.__init__(self)
        _RobustScaler.__init__(
            self, with_centering=with_centering, with_scaling=with_scaling
        )

    def run(self, input: MatrixContinuousDense()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.preprocessing._data import StandardScaler as _StandardScaler


@nice_repr
class StandardScaler(_StandardScaler, SklearnTransformer):
    def __init__(self, with_mean: Boolean(), with_std: Boolean()):
        SklearnTransformer.__init__(self)
        _StandardScaler.__init__(self, with_mean=with_mean, with_std=with_std)

    def run(self, input: MatrixContinuousDense()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.preprocessing._discretization import KBinsDiscretizer as _KBinsDiscretizer


@nice_repr
class KBinsDiscretizer(_KBinsDiscretizer, SklearnTransformer):
    def __init__(
        self,
        n_bins: Discrete(min=2, max=9),
        encode: Categorical("onehot", "ordinal"),
        strategy: Categorical("kmeans", "quantile", "uniform"),
    ):
        SklearnTransformer.__init__(self)
        _KBinsDiscretizer.__init__(
            self, n_bins=n_bins, encode=encode, strategy=strategy
        )

    def run(self, input: MatrixContinuousDense()) -> MatrixContinuousSparse():
        return SklearnTransformer.run(self, input)


from sklearn.preprocessing._encoders import OneHotEncoder as _OneHotEncoder


@nice_repr
class OneHotEncoder(_OneHotEncoder, SklearnTransformer):
    def __init__(
        self,
        categories: Categorical("auto"),
        sparse: Boolean(),
        handle_unknown: Categorical("error", "ignore"),
    ):
        SklearnTransformer.__init__(self)
        _OneHotEncoder.__init__(
            self, categories=categories, sparse=sparse, handle_unknown=handle_unknown
        )

    def run(self, input: MatrixContinuousDense()) -> MatrixContinuousSparse():
        return SklearnTransformer.run(self, input)


from sklearn.preprocessing._encoders import OrdinalEncoder as _OrdinalEncoder


@nice_repr
class OrdinalEncoder(_OrdinalEncoder, SklearnTransformer):
    def __init__(self, categories: Categorical("auto")):
        SklearnTransformer.__init__(self)
        _OrdinalEncoder.__init__(self, categories=categories)

    def run(self, input: MatrixContinuousDense()) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.preprocessing._label import LabelBinarizer as _LabelBinarizer


@nice_repr
class LabelBinarizer(_LabelBinarizer, SklearnTransformer):
    def __init__(self, sparse_output: Boolean()):
        SklearnTransformer.__init__(self)
        _LabelBinarizer.__init__(self, sparse_output=sparse_output)

    def run(self, input: List(Category())) -> MatrixContinuousDense():
        return SklearnTransformer.run(self, input)


from sklearn.svm._classes import LinearSVC as _LinearSVC


@nice_repr
class LinearSVC(_LinearSVC, SklearnEstimator):
    def __init__(
        self,
        penalty: Categorical("l2"),
        loss: Categorical("hinge", "squared_hinge"),
        dual: Boolean(),
        C: Continuous(min=0.005, max=9.991),
        multi_class: Categorical("crammer_singer", "ovr"),
        fit_intercept: Boolean(),
    ):
        SklearnEstimator.__init__(self)
        _LinearSVC.__init__(
            self,
            penalty=penalty,
            loss=loss,
            dual=dual,
            C=C,
            multi_class=multi_class,
            fit_intercept=fit_intercept,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.svm._classes import LinearSVR as _LinearSVR


@nice_repr
class LinearSVR(_LinearSVR, SklearnEstimator):
    def __init__(
        self,
        epsilon: Continuous(min=0.0, max=0.992),
        C: Continuous(min=0.005, max=9.991),
        loss: Categorical("epsilon_insensitive", "squared_epsilon_insensitive"),
        fit_intercept: Boolean(),
        intercept_scaling: Continuous(min=0.005, max=9.991),
        dual: Boolean(),
    ):
        SklearnEstimator.__init__(self)
        _LinearSVR.__init__(
            self,
            epsilon=epsilon,
            C=C,
            loss=loss,
            fit_intercept=fit_intercept,
            intercept_scaling=intercept_scaling,
            dual=dual,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.svm._classes import NuSVC as _NuSVC


@nice_repr
class NuSVC(_NuSVC, SklearnEstimator):
    def __init__(
        self,
        kernel: Categorical("linear", "poly", "rbf", "sigmoid"),
        degree: Discrete(min=1, max=5),
        gamma: Categorical("auto", "scale"),
        coef0: Continuous(min=-0.992, max=0.992),
        shrinking: Boolean(),
        probability: Boolean(),
        cache_size: Discrete(min=1, max=399),
        decision_function_shape: Categorical("ovo", "ovr"),
        break_ties: Boolean(),
    ):
        SklearnEstimator.__init__(self)
        _NuSVC.__init__(
            self,
            kernel=kernel,
            degree=degree,
            gamma=gamma,
            coef0=coef0,
            shrinking=shrinking,
            probability=probability,
            cache_size=cache_size,
            decision_function_shape=decision_function_shape,
            break_ties=break_ties,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.svm._classes import NuSVR as _NuSVR


@nice_repr
class NuSVR(_NuSVR, SklearnEstimator):
    def __init__(
        self,
        C: Continuous(min=0.005, max=9.991),
        kernel: Categorical("linear", "poly", "rbf", "sigmoid"),
        degree: Discrete(min=1, max=5),
        gamma: Categorical("auto", "scale"),
        coef0: Continuous(min=-0.992, max=0.992),
        shrinking: Boolean(),
        cache_size: Discrete(min=1, max=399),
    ):
        SklearnEstimator.__init__(self)
        _NuSVR.__init__(
            self,
            C=C,
            kernel=kernel,
            degree=degree,
            gamma=gamma,
            coef0=coef0,
            shrinking=shrinking,
            cache_size=cache_size,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.svm._classes import OneClassSVM as _OneClassSVM


@nice_repr
class OneClassSVM(_OneClassSVM, SklearnEstimator):
    def __init__(
        self,
        kernel: Categorical("linear", "poly", "rbf", "sigmoid"),
        degree: Discrete(min=1, max=5),
        gamma: Categorical("auto", "scale"),
        coef0: Continuous(min=-0.992, max=0.992),
        shrinking: Boolean(),
        cache_size: Discrete(min=1, max=399),
    ):
        SklearnEstimator.__init__(self)
        _OneClassSVM.__init__(
            self,
            kernel=kernel,
            degree=degree,
            gamma=gamma,
            coef0=coef0,
            shrinking=shrinking,
            cache_size=cache_size,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.svm._classes import SVC as _SVC


@nice_repr
class SVC(_SVC, SklearnEstimator):
    def __init__(
        self,
        C: Continuous(min=0.005, max=9.991),
        degree: Discrete(min=1, max=5),
        gamma: Categorical("auto", "scale"),
        coef0: Continuous(min=-0.992, max=0.992),
        shrinking: Boolean(),
        probability: Boolean(),
        cache_size: Discrete(min=1, max=399),
        decision_function_shape: Categorical("ovo", "ovr"),
        break_ties: Boolean(),
    ):
        SklearnEstimator.__init__(self)
        _SVC.__init__(
            self,
            C=C,
            degree=degree,
            gamma=gamma,
            coef0=coef0,
            shrinking=shrinking,
            probability=probability,
            cache_size=cache_size,
            decision_function_shape=decision_function_shape,
            break_ties=break_ties,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.svm._classes import SVR as _SVR


@nice_repr
class SVR(_SVR, SklearnEstimator):
    def __init__(
        self,
        kernel: Categorical("linear", "poly", "rbf", "sigmoid"),
        degree: Discrete(min=1, max=5),
        gamma: Categorical("auto", "scale"),
        coef0: Continuous(min=-0.992, max=0.992),
        C: Continuous(min=0.005, max=9.991),
        epsilon: Continuous(min=0.006, max=0.993),
        shrinking: Boolean(),
        cache_size: Discrete(min=1, max=399),
    ):
        SklearnEstimator.__init__(self)
        _SVR.__init__(
            self,
            kernel=kernel,
            degree=degree,
            gamma=gamma,
            coef0=coef0,
            C=C,
            epsilon=epsilon,
            shrinking=shrinking,
            cache_size=cache_size,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.tree._classes import DecisionTreeClassifier as _DecisionTreeClassifier


@nice_repr
class DecisionTreeClassifier(_DecisionTreeClassifier, SklearnEstimator):
    def __init__(
        self,
        min_samples_split: Discrete(min=2, max=3),
        min_weight_fraction_leaf: Continuous(min=0.0, max=0.5),
        min_impurity_decrease: Continuous(min=0.0, max=0.992),
        ccp_alpha: Continuous(min=0.0, max=0.992),
    ):
        SklearnEstimator.__init__(self)
        _DecisionTreeClassifier.__init__(
            self,
            min_samples_split=min_samples_split,
            min_weight_fraction_leaf=min_weight_fraction_leaf,
            min_impurity_decrease=min_impurity_decrease,
            ccp_alpha=ccp_alpha,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.tree._classes import DecisionTreeRegressor as _DecisionTreeRegressor


@nice_repr
class DecisionTreeRegressor(_DecisionTreeRegressor, SklearnEstimator):
    def __init__(
        self,
        min_samples_split: Discrete(min=2, max=3),
        min_weight_fraction_leaf: Continuous(min=0.0, max=0.5),
        min_impurity_decrease: Continuous(min=0.0, max=0.992),
        ccp_alpha: Continuous(min=0.0, max=0.992),
    ):
        SklearnEstimator.__init__(self)
        _DecisionTreeRegressor.__init__(
            self,
            min_samples_split=min_samples_split,
            min_weight_fraction_leaf=min_weight_fraction_leaf,
            min_impurity_decrease=min_impurity_decrease,
            ccp_alpha=ccp_alpha,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


from sklearn.tree._classes import ExtraTreeClassifier as _ExtraTreeClassifier


@nice_repr
class ExtraTreeClassifier(_ExtraTreeClassifier, SklearnEstimator):
    def __init__(
        self,
        min_samples_split: Discrete(min=2, max=3),
        min_weight_fraction_leaf: Continuous(min=0.0, max=0.5),
        min_impurity_decrease: Continuous(min=0.0, max=0.992),
        ccp_alpha: Continuous(min=0.0, max=0.992),
    ):
        SklearnEstimator.__init__(self)
        _ExtraTreeClassifier.__init__(
            self,
            min_samples_split=min_samples_split,
            min_weight_fraction_leaf=min_weight_fraction_leaf,
            min_impurity_decrease=min_impurity_decrease,
            ccp_alpha=ccp_alpha,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), CategoricalVector())
    ) -> CategoricalVector():
        return SklearnEstimator.run(self, input)


from sklearn.tree._classes import ExtraTreeRegressor as _ExtraTreeRegressor


@nice_repr
class ExtraTreeRegressor(_ExtraTreeRegressor, SklearnEstimator):
    def __init__(
        self,
        min_samples_split: Discrete(min=2, max=3),
        min_weight_fraction_leaf: Continuous(min=0.0, max=0.5),
        min_impurity_decrease: Continuous(min=0.0, max=0.992),
        ccp_alpha: Continuous(min=0.0, max=0.992),
    ):
        SklearnEstimator.__init__(self)
        _ExtraTreeRegressor.__init__(
            self,
            min_samples_split=min_samples_split,
            min_weight_fraction_leaf=min_weight_fraction_leaf,
            min_impurity_decrease=min_impurity_decrease,
            ccp_alpha=ccp_alpha,
        )

    def run(
        self, input: Tuple(MatrixContinuous(), ContinuousVector())
    ) -> ContinuousVector():
        return SklearnEstimator.run(self, input)


__all__ = [
    "AffinityPropagation",
    "FeatureAgglomeration",
    "Birch",
    "KMeans",
    "MiniBatchKMeans",
    "MeanShift",
    "FactorAnalysis",
    "FastICA",
    "IncrementalPCA",
    "KernelPCA",
    "LatentDirichletAllocation",
    "NMF",
    "PCA",
    "MiniBatchSparsePCA",
    "SparsePCA",
    "TruncatedSVD",
    "CountVectorizer",
    "HashingVectorizer",
    "TfidfTransformer",
    "TfidfVectorizer",
    "KNNImputer",
    "LinearRegression",
    "ARDRegression",
    "BayesianRidge",
    "ElasticNet",
    "Lasso",
    "HuberRegressor",
    "Lars",
    "LassoLars",
    "LassoLarsIC",
    "LogisticRegression",
    "OrthogonalMatchingPursuit",
    "PassiveAggressiveClassifier",
    "PassiveAggressiveRegressor",
    "Perceptron",
    "Ridge",
    "RidgeClassifier",
    "SGDClassifier",
    "SGDRegressor",
    "TheilSenRegressor",
    "Isomap",
    "LocallyLinearEmbedding",
    "BernoulliNB",
    "CategoricalNB",
    "ComplementNB",
    "GaussianNB",
    "MultinomialNB",
    "KNeighborsClassifier",
    "KNeighborsTransformer",
    "RadiusNeighborsTransformer",
    "LocalOutlierFactor",
    "NearestCentroid",
    "KNeighborsRegressor",
    "RadiusNeighborsRegressor",
    "KernelCenterer",
    "MinMaxScaler",
    "PowerTransformer",
    "RobustScaler",
    "StandardScaler",
    "KBinsDiscretizer",
    "OneHotEncoder",
    "OrdinalEncoder",
    "LabelBinarizer",
    "LinearSVC",
    "LinearSVR",
    "NuSVC",
    "NuSVR",
    "OneClassSVM",
    "SVC",
    "SVR",
    "DecisionTreeClassifier",
    "DecisionTreeRegressor",
    "ExtraTreeClassifier",
    "ExtraTreeRegressor",
]
