# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicySetArgs', 'PolicySet']

@pulumi.input_type
class PolicySetArgs:
    def __init__(__self__, *,
                 service_name: pulumi.Input[_builtins.str],
                 childrens: Optional[pulumi.Input[Sequence[pulumi.Input['PolicySetChildrenArgs']]]] = None,
                 condition_attribute_name: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_attribute_value: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_dictionary_name: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_dictionary_value: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_is_negate: Optional[pulumi.Input[_builtins.bool]] = None,
                 condition_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_proxy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rank: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PolicySet resource.
        :param pulumi.Input[_builtins.str] service_name: Policy set service identifier. 'Allowed Protocols' or 'Server Sequence'.
        :param pulumi.Input[Sequence[pulumi.Input['PolicySetChildrenArgs']]] childrens: List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        :param pulumi.Input[_builtins.str] condition_attribute_name: Dictionary attribute name
        :param pulumi.Input[_builtins.str] condition_attribute_value: Attribute value for condition. Value type is specified in dictionary object.
        :param pulumi.Input[_builtins.str] condition_dictionary_name: Dictionary name
        :param pulumi.Input[_builtins.str] condition_dictionary_value: Dictionary value
        :param pulumi.Input[_builtins.str] condition_id: UUID for condition
        :param pulumi.Input[_builtins.bool] condition_is_negate: Indicates whereas this condition is in negate mode
        :param pulumi.Input[_builtins.str] condition_operator: Equality operator
                 - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`, `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`, `notEquals`, `notIn`, `notStartsWith`, `startsWith`, `macContains`, `macEndsWith`, `macEquals`, `macIn`, `macNotContains`, `macNotEndsWith`, `macNotEquals`, `macNotIn`, `macNotStartsWith`, `macStartsWith`
        :param pulumi.Input[_builtins.str] condition_type: Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that additional conditions are present under the children attribute.
                 - Choices: `ConditionAndBlock`, `ConditionAttributes`, `ConditionOrBlock`, `ConditionReference`
        :param pulumi.Input[_builtins.bool] default: Indicates if this policy set is the default one
        :param pulumi.Input[_builtins.str] description: The description of the policy set
        :param pulumi.Input[_builtins.bool] is_proxy: Flag which indicates if the policy set service is of type 'Proxy Sequence' or 'Allowed Protocols'
        :param pulumi.Input[_builtins.str] name: Given name for the policy set, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        :param pulumi.Input[_builtins.int] rank: The rank (priority) in relation to other policy sets. Lower rank is higher priority.
        :param pulumi.Input[_builtins.str] state: The state that the policy set is in. A disabled policy set cannot be matched.
                 - Choices: `disabled`, `enabled`, `monitor`
        """
        pulumi.set(__self__, "service_name", service_name)
        if childrens is not None:
            pulumi.set(__self__, "childrens", childrens)
        if condition_attribute_name is not None:
            pulumi.set(__self__, "condition_attribute_name", condition_attribute_name)
        if condition_attribute_value is not None:
            pulumi.set(__self__, "condition_attribute_value", condition_attribute_value)
        if condition_dictionary_name is not None:
            pulumi.set(__self__, "condition_dictionary_name", condition_dictionary_name)
        if condition_dictionary_value is not None:
            pulumi.set(__self__, "condition_dictionary_value", condition_dictionary_value)
        if condition_id is not None:
            pulumi.set(__self__, "condition_id", condition_id)
        if condition_is_negate is not None:
            pulumi.set(__self__, "condition_is_negate", condition_is_negate)
        if condition_operator is not None:
            pulumi.set(__self__, "condition_operator", condition_operator)
        if condition_type is not None:
            pulumi.set(__self__, "condition_type", condition_type)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_proxy is not None:
            pulumi.set(__self__, "is_proxy", is_proxy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rank is not None:
            pulumi.set(__self__, "rank", rank)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        Policy set service identifier. 'Allowed Protocols' or 'Server Sequence'.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def childrens(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicySetChildrenArgs']]]]:
        """
        List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        """
        return pulumi.get(self, "childrens")

    @childrens.setter
    def childrens(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicySetChildrenArgs']]]]):
        pulumi.set(self, "childrens", value)

    @_builtins.property
    @pulumi.getter(name="conditionAttributeName")
    def condition_attribute_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dictionary attribute name
        """
        return pulumi.get(self, "condition_attribute_name")

    @condition_attribute_name.setter
    def condition_attribute_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_attribute_name", value)

    @_builtins.property
    @pulumi.getter(name="conditionAttributeValue")
    def condition_attribute_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attribute value for condition. Value type is specified in dictionary object.
        """
        return pulumi.get(self, "condition_attribute_value")

    @condition_attribute_value.setter
    def condition_attribute_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_attribute_value", value)

    @_builtins.property
    @pulumi.getter(name="conditionDictionaryName")
    def condition_dictionary_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dictionary name
        """
        return pulumi.get(self, "condition_dictionary_name")

    @condition_dictionary_name.setter
    def condition_dictionary_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_dictionary_name", value)

    @_builtins.property
    @pulumi.getter(name="conditionDictionaryValue")
    def condition_dictionary_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dictionary value
        """
        return pulumi.get(self, "condition_dictionary_value")

    @condition_dictionary_value.setter
    def condition_dictionary_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_dictionary_value", value)

    @_builtins.property
    @pulumi.getter(name="conditionId")
    def condition_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UUID for condition
        """
        return pulumi.get(self, "condition_id")

    @condition_id.setter
    def condition_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_id", value)

    @_builtins.property
    @pulumi.getter(name="conditionIsNegate")
    def condition_is_negate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whereas this condition is in negate mode
        """
        return pulumi.get(self, "condition_is_negate")

    @condition_is_negate.setter
    def condition_is_negate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "condition_is_negate", value)

    @_builtins.property
    @pulumi.getter(name="conditionOperator")
    def condition_operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Equality operator
          - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`, `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`, `notEquals`, `notIn`, `notStartsWith`, `startsWith`, `macContains`, `macEndsWith`, `macEquals`, `macIn`, `macNotContains`, `macNotEndsWith`, `macNotEquals`, `macNotIn`, `macNotStartsWith`, `macStartsWith`
        """
        return pulumi.get(self, "condition_operator")

    @condition_operator.setter
    def condition_operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_operator", value)

    @_builtins.property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that additional conditions are present under the children attribute.
          - Choices: `ConditionAndBlock`, `ConditionAttributes`, `ConditionOrBlock`, `ConditionReference`
        """
        return pulumi.get(self, "condition_type")

    @condition_type.setter
    def condition_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_type", value)

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if this policy set is the default one
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the policy set
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isProxy")
    def is_proxy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag which indicates if the policy set service is of type 'Proxy Sequence' or 'Allowed Protocols'
        """
        return pulumi.get(self, "is_proxy")

    @is_proxy.setter
    def is_proxy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_proxy", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Given name for the policy set, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def rank(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The rank (priority) in relation to other policy sets. Lower rank is higher priority.
        """
        return pulumi.get(self, "rank")

    @rank.setter
    def rank(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rank", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state that the policy set is in. A disabled policy set cannot be matched.
          - Choices: `disabled`, `enabled`, `monitor`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _PolicySetState:
    def __init__(__self__, *,
                 childrens: Optional[pulumi.Input[Sequence[pulumi.Input['PolicySetChildrenArgs']]]] = None,
                 condition_attribute_name: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_attribute_value: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_dictionary_name: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_dictionary_value: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_is_negate: Optional[pulumi.Input[_builtins.bool]] = None,
                 condition_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_proxy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rank: Optional[pulumi.Input[_builtins.int]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PolicySet resources.
        :param pulumi.Input[Sequence[pulumi.Input['PolicySetChildrenArgs']]] childrens: List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        :param pulumi.Input[_builtins.str] condition_attribute_name: Dictionary attribute name
        :param pulumi.Input[_builtins.str] condition_attribute_value: Attribute value for condition. Value type is specified in dictionary object.
        :param pulumi.Input[_builtins.str] condition_dictionary_name: Dictionary name
        :param pulumi.Input[_builtins.str] condition_dictionary_value: Dictionary value
        :param pulumi.Input[_builtins.str] condition_id: UUID for condition
        :param pulumi.Input[_builtins.bool] condition_is_negate: Indicates whereas this condition is in negate mode
        :param pulumi.Input[_builtins.str] condition_operator: Equality operator
                 - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`, `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`, `notEquals`, `notIn`, `notStartsWith`, `startsWith`, `macContains`, `macEndsWith`, `macEquals`, `macIn`, `macNotContains`, `macNotEndsWith`, `macNotEquals`, `macNotIn`, `macNotStartsWith`, `macStartsWith`
        :param pulumi.Input[_builtins.str] condition_type: Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that additional conditions are present under the children attribute.
                 - Choices: `ConditionAndBlock`, `ConditionAttributes`, `ConditionOrBlock`, `ConditionReference`
        :param pulumi.Input[_builtins.bool] default: Indicates if this policy set is the default one
        :param pulumi.Input[_builtins.str] description: The description of the policy set
        :param pulumi.Input[_builtins.bool] is_proxy: Flag which indicates if the policy set service is of type 'Proxy Sequence' or 'Allowed Protocols'
        :param pulumi.Input[_builtins.str] name: Given name for the policy set, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        :param pulumi.Input[_builtins.int] rank: The rank (priority) in relation to other policy sets. Lower rank is higher priority.
        :param pulumi.Input[_builtins.str] service_name: Policy set service identifier. 'Allowed Protocols' or 'Server Sequence'.
        :param pulumi.Input[_builtins.str] state: The state that the policy set is in. A disabled policy set cannot be matched.
                 - Choices: `disabled`, `enabled`, `monitor`
        """
        if childrens is not None:
            pulumi.set(__self__, "childrens", childrens)
        if condition_attribute_name is not None:
            pulumi.set(__self__, "condition_attribute_name", condition_attribute_name)
        if condition_attribute_value is not None:
            pulumi.set(__self__, "condition_attribute_value", condition_attribute_value)
        if condition_dictionary_name is not None:
            pulumi.set(__self__, "condition_dictionary_name", condition_dictionary_name)
        if condition_dictionary_value is not None:
            pulumi.set(__self__, "condition_dictionary_value", condition_dictionary_value)
        if condition_id is not None:
            pulumi.set(__self__, "condition_id", condition_id)
        if condition_is_negate is not None:
            pulumi.set(__self__, "condition_is_negate", condition_is_negate)
        if condition_operator is not None:
            pulumi.set(__self__, "condition_operator", condition_operator)
        if condition_type is not None:
            pulumi.set(__self__, "condition_type", condition_type)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_proxy is not None:
            pulumi.set(__self__, "is_proxy", is_proxy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rank is not None:
            pulumi.set(__self__, "rank", rank)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def childrens(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicySetChildrenArgs']]]]:
        """
        List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        """
        return pulumi.get(self, "childrens")

    @childrens.setter
    def childrens(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicySetChildrenArgs']]]]):
        pulumi.set(self, "childrens", value)

    @_builtins.property
    @pulumi.getter(name="conditionAttributeName")
    def condition_attribute_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dictionary attribute name
        """
        return pulumi.get(self, "condition_attribute_name")

    @condition_attribute_name.setter
    def condition_attribute_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_attribute_name", value)

    @_builtins.property
    @pulumi.getter(name="conditionAttributeValue")
    def condition_attribute_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attribute value for condition. Value type is specified in dictionary object.
        """
        return pulumi.get(self, "condition_attribute_value")

    @condition_attribute_value.setter
    def condition_attribute_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_attribute_value", value)

    @_builtins.property
    @pulumi.getter(name="conditionDictionaryName")
    def condition_dictionary_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dictionary name
        """
        return pulumi.get(self, "condition_dictionary_name")

    @condition_dictionary_name.setter
    def condition_dictionary_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_dictionary_name", value)

    @_builtins.property
    @pulumi.getter(name="conditionDictionaryValue")
    def condition_dictionary_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dictionary value
        """
        return pulumi.get(self, "condition_dictionary_value")

    @condition_dictionary_value.setter
    def condition_dictionary_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_dictionary_value", value)

    @_builtins.property
    @pulumi.getter(name="conditionId")
    def condition_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UUID for condition
        """
        return pulumi.get(self, "condition_id")

    @condition_id.setter
    def condition_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_id", value)

    @_builtins.property
    @pulumi.getter(name="conditionIsNegate")
    def condition_is_negate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whereas this condition is in negate mode
        """
        return pulumi.get(self, "condition_is_negate")

    @condition_is_negate.setter
    def condition_is_negate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "condition_is_negate", value)

    @_builtins.property
    @pulumi.getter(name="conditionOperator")
    def condition_operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Equality operator
          - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`, `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`, `notEquals`, `notIn`, `notStartsWith`, `startsWith`, `macContains`, `macEndsWith`, `macEquals`, `macIn`, `macNotContains`, `macNotEndsWith`, `macNotEquals`, `macNotIn`, `macNotStartsWith`, `macStartsWith`
        """
        return pulumi.get(self, "condition_operator")

    @condition_operator.setter
    def condition_operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_operator", value)

    @_builtins.property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that additional conditions are present under the children attribute.
          - Choices: `ConditionAndBlock`, `ConditionAttributes`, `ConditionOrBlock`, `ConditionReference`
        """
        return pulumi.get(self, "condition_type")

    @condition_type.setter
    def condition_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_type", value)

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if this policy set is the default one
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the policy set
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isProxy")
    def is_proxy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag which indicates if the policy set service is of type 'Proxy Sequence' or 'Allowed Protocols'
        """
        return pulumi.get(self, "is_proxy")

    @is_proxy.setter
    def is_proxy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_proxy", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Given name for the policy set, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def rank(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The rank (priority) in relation to other policy sets. Lower rank is higher priority.
        """
        return pulumi.get(self, "rank")

    @rank.setter
    def rank(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rank", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy set service identifier. 'Allowed Protocols' or 'Server Sequence'.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state that the policy set is in. A disabled policy set cannot be matched.
          - Choices: `disabled`, `enabled`, `monitor`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("ise:deviceadmin/policySet:PolicySet")
class PolicySet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 childrens: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicySetChildrenArgs', 'PolicySetChildrenArgsDict']]]]] = None,
                 condition_attribute_name: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_attribute_value: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_dictionary_name: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_dictionary_value: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_is_negate: Optional[pulumi.Input[_builtins.bool]] = None,
                 condition_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_proxy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rank: Optional[pulumi.Input[_builtins.int]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Device Admin Policy Set.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.deviceadmin.PolicySet("example",
            name="PolicySet1",
            description="My description",
            is_proxy=False,
            rank=0,
            service_name="Default Device Admin",
            state="enabled",
            condition_type="ConditionAttributes",
            condition_is_negate=False,
            condition_attribute_name="Location",
            condition_attribute_value="All Locations",
            condition_dictionary_name="DEVICE",
            condition_operator="equals")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:deviceadmin/policySet:PolicySet example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicySetChildrenArgs', 'PolicySetChildrenArgsDict']]]] childrens: List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        :param pulumi.Input[_builtins.str] condition_attribute_name: Dictionary attribute name
        :param pulumi.Input[_builtins.str] condition_attribute_value: Attribute value for condition. Value type is specified in dictionary object.
        :param pulumi.Input[_builtins.str] condition_dictionary_name: Dictionary name
        :param pulumi.Input[_builtins.str] condition_dictionary_value: Dictionary value
        :param pulumi.Input[_builtins.str] condition_id: UUID for condition
        :param pulumi.Input[_builtins.bool] condition_is_negate: Indicates whereas this condition is in negate mode
        :param pulumi.Input[_builtins.str] condition_operator: Equality operator
                 - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`, `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`, `notEquals`, `notIn`, `notStartsWith`, `startsWith`, `macContains`, `macEndsWith`, `macEquals`, `macIn`, `macNotContains`, `macNotEndsWith`, `macNotEquals`, `macNotIn`, `macNotStartsWith`, `macStartsWith`
        :param pulumi.Input[_builtins.str] condition_type: Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that additional conditions are present under the children attribute.
                 - Choices: `ConditionAndBlock`, `ConditionAttributes`, `ConditionOrBlock`, `ConditionReference`
        :param pulumi.Input[_builtins.bool] default: Indicates if this policy set is the default one
        :param pulumi.Input[_builtins.str] description: The description of the policy set
        :param pulumi.Input[_builtins.bool] is_proxy: Flag which indicates if the policy set service is of type 'Proxy Sequence' or 'Allowed Protocols'
        :param pulumi.Input[_builtins.str] name: Given name for the policy set, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        :param pulumi.Input[_builtins.int] rank: The rank (priority) in relation to other policy sets. Lower rank is higher priority.
        :param pulumi.Input[_builtins.str] service_name: Policy set service identifier. 'Allowed Protocols' or 'Server Sequence'.
        :param pulumi.Input[_builtins.str] state: The state that the policy set is in. A disabled policy set cannot be matched.
                 - Choices: `disabled`, `enabled`, `monitor`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicySetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Device Admin Policy Set.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.deviceadmin.PolicySet("example",
            name="PolicySet1",
            description="My description",
            is_proxy=False,
            rank=0,
            service_name="Default Device Admin",
            state="enabled",
            condition_type="ConditionAttributes",
            condition_is_negate=False,
            condition_attribute_name="Location",
            condition_attribute_value="All Locations",
            condition_dictionary_name="DEVICE",
            condition_operator="equals")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:deviceadmin/policySet:PolicySet example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param PolicySetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicySetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 childrens: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicySetChildrenArgs', 'PolicySetChildrenArgsDict']]]]] = None,
                 condition_attribute_name: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_attribute_value: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_dictionary_name: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_dictionary_value: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_is_negate: Optional[pulumi.Input[_builtins.bool]] = None,
                 condition_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_proxy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rank: Optional[pulumi.Input[_builtins.int]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicySetArgs.__new__(PolicySetArgs)

            __props__.__dict__["childrens"] = childrens
            __props__.__dict__["condition_attribute_name"] = condition_attribute_name
            __props__.__dict__["condition_attribute_value"] = condition_attribute_value
            __props__.__dict__["condition_dictionary_name"] = condition_dictionary_name
            __props__.__dict__["condition_dictionary_value"] = condition_dictionary_value
            __props__.__dict__["condition_id"] = condition_id
            __props__.__dict__["condition_is_negate"] = condition_is_negate
            __props__.__dict__["condition_operator"] = condition_operator
            __props__.__dict__["condition_type"] = condition_type
            __props__.__dict__["default"] = default
            __props__.__dict__["description"] = description
            __props__.__dict__["is_proxy"] = is_proxy
            __props__.__dict__["name"] = name
            __props__.__dict__["rank"] = rank
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["state"] = state
        super(PolicySet, __self__).__init__(
            'ise:deviceadmin/policySet:PolicySet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            childrens: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicySetChildrenArgs', 'PolicySetChildrenArgsDict']]]]] = None,
            condition_attribute_name: Optional[pulumi.Input[_builtins.str]] = None,
            condition_attribute_value: Optional[pulumi.Input[_builtins.str]] = None,
            condition_dictionary_name: Optional[pulumi.Input[_builtins.str]] = None,
            condition_dictionary_value: Optional[pulumi.Input[_builtins.str]] = None,
            condition_id: Optional[pulumi.Input[_builtins.str]] = None,
            condition_is_negate: Optional[pulumi.Input[_builtins.bool]] = None,
            condition_operator: Optional[pulumi.Input[_builtins.str]] = None,
            condition_type: Optional[pulumi.Input[_builtins.str]] = None,
            default: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            is_proxy: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            rank: Optional[pulumi.Input[_builtins.int]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'PolicySet':
        """
        Get an existing PolicySet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicySetChildrenArgs', 'PolicySetChildrenArgsDict']]]] childrens: List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        :param pulumi.Input[_builtins.str] condition_attribute_name: Dictionary attribute name
        :param pulumi.Input[_builtins.str] condition_attribute_value: Attribute value for condition. Value type is specified in dictionary object.
        :param pulumi.Input[_builtins.str] condition_dictionary_name: Dictionary name
        :param pulumi.Input[_builtins.str] condition_dictionary_value: Dictionary value
        :param pulumi.Input[_builtins.str] condition_id: UUID for condition
        :param pulumi.Input[_builtins.bool] condition_is_negate: Indicates whereas this condition is in negate mode
        :param pulumi.Input[_builtins.str] condition_operator: Equality operator
                 - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`, `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`, `notEquals`, `notIn`, `notStartsWith`, `startsWith`, `macContains`, `macEndsWith`, `macEquals`, `macIn`, `macNotContains`, `macNotEndsWith`, `macNotEquals`, `macNotIn`, `macNotStartsWith`, `macStartsWith`
        :param pulumi.Input[_builtins.str] condition_type: Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that additional conditions are present under the children attribute.
                 - Choices: `ConditionAndBlock`, `ConditionAttributes`, `ConditionOrBlock`, `ConditionReference`
        :param pulumi.Input[_builtins.bool] default: Indicates if this policy set is the default one
        :param pulumi.Input[_builtins.str] description: The description of the policy set
        :param pulumi.Input[_builtins.bool] is_proxy: Flag which indicates if the policy set service is of type 'Proxy Sequence' or 'Allowed Protocols'
        :param pulumi.Input[_builtins.str] name: Given name for the policy set, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        :param pulumi.Input[_builtins.int] rank: The rank (priority) in relation to other policy sets. Lower rank is higher priority.
        :param pulumi.Input[_builtins.str] service_name: Policy set service identifier. 'Allowed Protocols' or 'Server Sequence'.
        :param pulumi.Input[_builtins.str] state: The state that the policy set is in. A disabled policy set cannot be matched.
                 - Choices: `disabled`, `enabled`, `monitor`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicySetState.__new__(_PolicySetState)

        __props__.__dict__["childrens"] = childrens
        __props__.__dict__["condition_attribute_name"] = condition_attribute_name
        __props__.__dict__["condition_attribute_value"] = condition_attribute_value
        __props__.__dict__["condition_dictionary_name"] = condition_dictionary_name
        __props__.__dict__["condition_dictionary_value"] = condition_dictionary_value
        __props__.__dict__["condition_id"] = condition_id
        __props__.__dict__["condition_is_negate"] = condition_is_negate
        __props__.__dict__["condition_operator"] = condition_operator
        __props__.__dict__["condition_type"] = condition_type
        __props__.__dict__["default"] = default
        __props__.__dict__["description"] = description
        __props__.__dict__["is_proxy"] = is_proxy
        __props__.__dict__["name"] = name
        __props__.__dict__["rank"] = rank
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["state"] = state
        return PolicySet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def childrens(self) -> pulumi.Output[Optional[Sequence['outputs.PolicySetChildren']]]:
        """
        List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        """
        return pulumi.get(self, "childrens")

    @_builtins.property
    @pulumi.getter(name="conditionAttributeName")
    def condition_attribute_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Dictionary attribute name
        """
        return pulumi.get(self, "condition_attribute_name")

    @_builtins.property
    @pulumi.getter(name="conditionAttributeValue")
    def condition_attribute_value(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Attribute value for condition. Value type is specified in dictionary object.
        """
        return pulumi.get(self, "condition_attribute_value")

    @_builtins.property
    @pulumi.getter(name="conditionDictionaryName")
    def condition_dictionary_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Dictionary name
        """
        return pulumi.get(self, "condition_dictionary_name")

    @_builtins.property
    @pulumi.getter(name="conditionDictionaryValue")
    def condition_dictionary_value(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Dictionary value
        """
        return pulumi.get(self, "condition_dictionary_value")

    @_builtins.property
    @pulumi.getter(name="conditionId")
    def condition_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        UUID for condition
        """
        return pulumi.get(self, "condition_id")

    @_builtins.property
    @pulumi.getter(name="conditionIsNegate")
    def condition_is_negate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whereas this condition is in negate mode
        """
        return pulumi.get(self, "condition_is_negate")

    @_builtins.property
    @pulumi.getter(name="conditionOperator")
    def condition_operator(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Equality operator
          - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`, `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`, `notEquals`, `notIn`, `notStartsWith`, `startsWith`, `macContains`, `macEndsWith`, `macEquals`, `macIn`, `macNotContains`, `macNotEndsWith`, `macNotEquals`, `macNotIn`, `macNotStartsWith`, `macStartsWith`
        """
        return pulumi.get(self, "condition_operator")

    @_builtins.property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that additional conditions are present under the children attribute.
          - Choices: `ConditionAndBlock`, `ConditionAttributes`, `ConditionOrBlock`, `ConditionReference`
        """
        return pulumi.get(self, "condition_type")

    @_builtins.property
    @pulumi.getter
    def default(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if this policy set is the default one
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the policy set
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="isProxy")
    def is_proxy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag which indicates if the policy set service is of type 'Proxy Sequence' or 'Allowed Protocols'
        """
        return pulumi.get(self, "is_proxy")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Given name for the policy set, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rank(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The rank (priority) in relation to other policy sets. Lower rank is higher priority.
        """
        return pulumi.get(self, "rank")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Policy set service identifier. 'Allowed Protocols' or 'Server Sequence'.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The state that the policy set is in. A disabled policy set cannot be matched.
          - Choices: `disabled`, `enabled`, `monitor`
        """
        return pulumi.get(self, "state")

