# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ActiveDirectoryJoinPointArgs', 'ActiveDirectoryJoinPoint']

@pulumi.input_type
class ActiveDirectoryJoinPointArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[_builtins.str],
                 ad_scopes_names: Optional[pulumi.Input[_builtins.str]] = None,
                 aging_time: Optional[pulumi.Input[_builtins.int]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointAttributeArgs']]]] = None,
                 auth_protection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 country: Optional[pulumi.Input[_builtins.str]] = None,
                 department: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_callback_for_dialin_client: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dialin_permission_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_domain_allowed_list: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_failed_auth_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_machine_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_machine_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_pass_change: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rewrites: Optional[pulumi.Input[_builtins.bool]] = None,
                 failed_auth_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointGroupArgs']]]] = None,
                 identity_not_in_ad_behaviour: Optional[pulumi.Input[_builtins.str]] = None,
                 job_title: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organizational_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 plaintext_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 rewrite_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointRewriteRuleArgs']]]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 state_or_province: Optional[pulumi.Input[_builtins.str]] = None,
                 street_address: Optional[pulumi.Input[_builtins.str]] = None,
                 telephone: Optional[pulumi.Input[_builtins.str]] = None,
                 unreachable_domains_behaviour: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ActiveDirectoryJoinPoint resource.
        :param pulumi.Input[_builtins.str] domain: AD domain associated with the join point
        :param pulumi.Input[_builtins.str] ad_scopes_names: String that contains the names of the scopes that the active directory belongs to. Names are separated by comma.
                 - Default value: `Default_Scope`
        :param pulumi.Input[_builtins.int] aging_time: Aging Time
                 - Default value: `5`
        :param pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointAttributeArgs']]] attributes: List of AD attributes
        :param pulumi.Input[_builtins.str] auth_protection_type: Enable prevent AD account lockout for WIRELESS/WIRED/BOTH
                 - Choices: `WIRELESS`, `WIRED`, `BOTH`
        :param pulumi.Input[_builtins.str] country: User info attribute
        :param pulumi.Input[_builtins.str] department: User info attribute
        :param pulumi.Input[_builtins.str] description: Join point description
        :param pulumi.Input[_builtins.str] email: User info attribute
        :param pulumi.Input[_builtins.bool] enable_callback_for_dialin_client: Enable Callback For Dial In Client
                 - Default value: `false`
        :param pulumi.Input[_builtins.bool] enable_dialin_permission_check: Enable Dial In Permission Check
                 - Default value: `false`
        :param pulumi.Input[_builtins.bool] enable_domain_allowed_list: - Default value: `true`
        :param pulumi.Input[_builtins.bool] enable_failed_auth_protection: Enable prevent AD account lockout due to too many bad password attempts
                 - Default value: `false`
        :param pulumi.Input[_builtins.bool] enable_machine_access: Enable Machine Access
                 - Default value: `true`
        :param pulumi.Input[_builtins.bool] enable_machine_auth: Enable Machine Authentication
                 - Default value: `true`
        :param pulumi.Input[_builtins.bool] enable_pass_change: Enable Password Change
                 - Default value: `true`
        :param pulumi.Input[_builtins.bool] enable_rewrites: Enable Rewrites
                 - Default value: `false`
        :param pulumi.Input[_builtins.int] failed_auth_threshold: Number of bad password attempts
                 - Default value: `5`
        :param pulumi.Input[_builtins.str] first_name: User info attribute
        :param pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointGroupArgs']]] groups: List of AD Groups
        :param pulumi.Input[_builtins.str] identity_not_in_ad_behaviour: Identity Not In AD Behaviour
                 - Choices: `REJECT`, `SEARCH_JOINED_FOREST`, `SEARCH_ALL`
        :param pulumi.Input[_builtins.str] job_title: User info attribute
        :param pulumi.Input[_builtins.str] last_name: User info attribute
        :param pulumi.Input[_builtins.str] locality: User info attribute
        :param pulumi.Input[_builtins.str] name: The name of the active directory join point
        :param pulumi.Input[_builtins.str] organizational_unit: User info attribute
        :param pulumi.Input[_builtins.bool] plaintext_auth: Plain Text Authentication
                 - Default value: `false`
        :param pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointRewriteRuleArgs']]] rewrite_rules: List of Rewrite rules
        :param pulumi.Input[_builtins.str] schema: Schema
                 - Choices: `ACTIVE_DIRECTORY`, `CUSTOM`
        :param pulumi.Input[_builtins.str] state_or_province: User info attribute
        :param pulumi.Input[_builtins.str] street_address: User info attribute
        :param pulumi.Input[_builtins.str] telephone: User info attribute
        :param pulumi.Input[_builtins.str] unreachable_domains_behaviour: Unreachable Domains Behaviour
                 - Choices: `PROCEED`, `DROP`
        """
        pulumi.set(__self__, "domain", domain)
        if ad_scopes_names is not None:
            pulumi.set(__self__, "ad_scopes_names", ad_scopes_names)
        if aging_time is not None:
            pulumi.set(__self__, "aging_time", aging_time)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if auth_protection_type is not None:
            pulumi.set(__self__, "auth_protection_type", auth_protection_type)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if department is not None:
            pulumi.set(__self__, "department", department)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if enable_callback_for_dialin_client is not None:
            pulumi.set(__self__, "enable_callback_for_dialin_client", enable_callback_for_dialin_client)
        if enable_dialin_permission_check is not None:
            pulumi.set(__self__, "enable_dialin_permission_check", enable_dialin_permission_check)
        if enable_domain_allowed_list is not None:
            pulumi.set(__self__, "enable_domain_allowed_list", enable_domain_allowed_list)
        if enable_failed_auth_protection is not None:
            pulumi.set(__self__, "enable_failed_auth_protection", enable_failed_auth_protection)
        if enable_machine_access is not None:
            pulumi.set(__self__, "enable_machine_access", enable_machine_access)
        if enable_machine_auth is not None:
            pulumi.set(__self__, "enable_machine_auth", enable_machine_auth)
        if enable_pass_change is not None:
            pulumi.set(__self__, "enable_pass_change", enable_pass_change)
        if enable_rewrites is not None:
            pulumi.set(__self__, "enable_rewrites", enable_rewrites)
        if failed_auth_threshold is not None:
            pulumi.set(__self__, "failed_auth_threshold", failed_auth_threshold)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if identity_not_in_ad_behaviour is not None:
            pulumi.set(__self__, "identity_not_in_ad_behaviour", identity_not_in_ad_behaviour)
        if job_title is not None:
            pulumi.set(__self__, "job_title", job_title)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if plaintext_auth is not None:
            pulumi.set(__self__, "plaintext_auth", plaintext_auth)
        if rewrite_rules is not None:
            pulumi.set(__self__, "rewrite_rules", rewrite_rules)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if state_or_province is not None:
            pulumi.set(__self__, "state_or_province", state_or_province)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)
        if telephone is not None:
            pulumi.set(__self__, "telephone", telephone)
        if unreachable_domains_behaviour is not None:
            pulumi.set(__self__, "unreachable_domains_behaviour", unreachable_domains_behaviour)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        AD domain associated with the join point
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="adScopesNames")
    def ad_scopes_names(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String that contains the names of the scopes that the active directory belongs to. Names are separated by comma.
          - Default value: `Default_Scope`
        """
        return pulumi.get(self, "ad_scopes_names")

    @ad_scopes_names.setter
    def ad_scopes_names(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ad_scopes_names", value)

    @_builtins.property
    @pulumi.getter(name="agingTime")
    def aging_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Aging Time
          - Default value: `5`
        """
        return pulumi.get(self, "aging_time")

    @aging_time.setter
    def aging_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "aging_time", value)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointAttributeArgs']]]]:
        """
        List of AD attributes
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @_builtins.property
    @pulumi.getter(name="authProtectionType")
    def auth_protection_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable prevent AD account lockout for WIRELESS/WIRED/BOTH
          - Choices: `WIRELESS`, `WIRED`, `BOTH`
        """
        return pulumi.get(self, "auth_protection_type")

    @auth_protection_type.setter
    def auth_protection_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_protection_type", value)

    @_builtins.property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "country", value)

    @_builtins.property
    @pulumi.getter
    def department(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "department")

    @department.setter
    def department(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "department", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Join point description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="enableCallbackForDialinClient")
    def enable_callback_for_dialin_client(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable Callback For Dial In Client
          - Default value: `false`
        """
        return pulumi.get(self, "enable_callback_for_dialin_client")

    @enable_callback_for_dialin_client.setter
    def enable_callback_for_dialin_client(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_callback_for_dialin_client", value)

    @_builtins.property
    @pulumi.getter(name="enableDialinPermissionCheck")
    def enable_dialin_permission_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable Dial In Permission Check
          - Default value: `false`
        """
        return pulumi.get(self, "enable_dialin_permission_check")

    @enable_dialin_permission_check.setter
    def enable_dialin_permission_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dialin_permission_check", value)

    @_builtins.property
    @pulumi.getter(name="enableDomainAllowedList")
    def enable_domain_allowed_list(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - Default value: `true`
        """
        return pulumi.get(self, "enable_domain_allowed_list")

    @enable_domain_allowed_list.setter
    def enable_domain_allowed_list(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_domain_allowed_list", value)

    @_builtins.property
    @pulumi.getter(name="enableFailedAuthProtection")
    def enable_failed_auth_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable prevent AD account lockout due to too many bad password attempts
          - Default value: `false`
        """
        return pulumi.get(self, "enable_failed_auth_protection")

    @enable_failed_auth_protection.setter
    def enable_failed_auth_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_failed_auth_protection", value)

    @_builtins.property
    @pulumi.getter(name="enableMachineAccess")
    def enable_machine_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable Machine Access
          - Default value: `true`
        """
        return pulumi.get(self, "enable_machine_access")

    @enable_machine_access.setter
    def enable_machine_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_machine_access", value)

    @_builtins.property
    @pulumi.getter(name="enableMachineAuth")
    def enable_machine_auth(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable Machine Authentication
          - Default value: `true`
        """
        return pulumi.get(self, "enable_machine_auth")

    @enable_machine_auth.setter
    def enable_machine_auth(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_machine_auth", value)

    @_builtins.property
    @pulumi.getter(name="enablePassChange")
    def enable_pass_change(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable Password Change
          - Default value: `true`
        """
        return pulumi.get(self, "enable_pass_change")

    @enable_pass_change.setter
    def enable_pass_change(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_pass_change", value)

    @_builtins.property
    @pulumi.getter(name="enableRewrites")
    def enable_rewrites(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable Rewrites
          - Default value: `false`
        """
        return pulumi.get(self, "enable_rewrites")

    @enable_rewrites.setter
    def enable_rewrites(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_rewrites", value)

    @_builtins.property
    @pulumi.getter(name="failedAuthThreshold")
    def failed_auth_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of bad password attempts
          - Default value: `5`
        """
        return pulumi.get(self, "failed_auth_threshold")

    @failed_auth_threshold.setter
    def failed_auth_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "failed_auth_threshold", value)

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "first_name", value)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointGroupArgs']]]]:
        """
        List of AD Groups
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointGroupArgs']]]]):
        pulumi.set(self, "groups", value)

    @_builtins.property
    @pulumi.getter(name="identityNotInAdBehaviour")
    def identity_not_in_ad_behaviour(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identity Not In AD Behaviour
          - Choices: `REJECT`, `SEARCH_JOINED_FOREST`, `SEARCH_ALL`
        """
        return pulumi.get(self, "identity_not_in_ad_behaviour")

    @identity_not_in_ad_behaviour.setter
    def identity_not_in_ad_behaviour(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_not_in_ad_behaviour", value)

    @_builtins.property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "job_title")

    @job_title.setter
    def job_title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_title", value)

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_name", value)

    @_builtins.property
    @pulumi.getter
    def locality(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locality", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the active directory join point
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "organizational_unit")

    @organizational_unit.setter
    def organizational_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organizational_unit", value)

    @_builtins.property
    @pulumi.getter(name="plaintextAuth")
    def plaintext_auth(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Plain Text Authentication
          - Default value: `false`
        """
        return pulumi.get(self, "plaintext_auth")

    @plaintext_auth.setter
    def plaintext_auth(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "plaintext_auth", value)

    @_builtins.property
    @pulumi.getter(name="rewriteRules")
    def rewrite_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointRewriteRuleArgs']]]]:
        """
        List of Rewrite rules
        """
        return pulumi.get(self, "rewrite_rules")

    @rewrite_rules.setter
    def rewrite_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointRewriteRuleArgs']]]]):
        pulumi.set(self, "rewrite_rules", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Schema
          - Choices: `ACTIVE_DIRECTORY`, `CUSTOM`
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="stateOrProvince")
    def state_or_province(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "state_or_province")

    @state_or_province.setter
    def state_or_province(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state_or_province", value)

    @_builtins.property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "street_address")

    @street_address.setter
    def street_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "street_address", value)

    @_builtins.property
    @pulumi.getter
    def telephone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "telephone")

    @telephone.setter
    def telephone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "telephone", value)

    @_builtins.property
    @pulumi.getter(name="unreachableDomainsBehaviour")
    def unreachable_domains_behaviour(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unreachable Domains Behaviour
          - Choices: `PROCEED`, `DROP`
        """
        return pulumi.get(self, "unreachable_domains_behaviour")

    @unreachable_domains_behaviour.setter
    def unreachable_domains_behaviour(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unreachable_domains_behaviour", value)


@pulumi.input_type
class _ActiveDirectoryJoinPointState:
    def __init__(__self__, *,
                 ad_scopes_names: Optional[pulumi.Input[_builtins.str]] = None,
                 aging_time: Optional[pulumi.Input[_builtins.int]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointAttributeArgs']]]] = None,
                 auth_protection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 country: Optional[pulumi.Input[_builtins.str]] = None,
                 department: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_callback_for_dialin_client: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dialin_permission_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_domain_allowed_list: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_failed_auth_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_machine_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_machine_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_pass_change: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rewrites: Optional[pulumi.Input[_builtins.bool]] = None,
                 failed_auth_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointGroupArgs']]]] = None,
                 identity_not_in_ad_behaviour: Optional[pulumi.Input[_builtins.str]] = None,
                 job_title: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organizational_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 plaintext_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 rewrite_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointRewriteRuleArgs']]]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 state_or_province: Optional[pulumi.Input[_builtins.str]] = None,
                 street_address: Optional[pulumi.Input[_builtins.str]] = None,
                 telephone: Optional[pulumi.Input[_builtins.str]] = None,
                 unreachable_domains_behaviour: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ActiveDirectoryJoinPoint resources.
        :param pulumi.Input[_builtins.str] ad_scopes_names: String that contains the names of the scopes that the active directory belongs to. Names are separated by comma.
                 - Default value: `Default_Scope`
        :param pulumi.Input[_builtins.int] aging_time: Aging Time
                 - Default value: `5`
        :param pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointAttributeArgs']]] attributes: List of AD attributes
        :param pulumi.Input[_builtins.str] auth_protection_type: Enable prevent AD account lockout for WIRELESS/WIRED/BOTH
                 - Choices: `WIRELESS`, `WIRED`, `BOTH`
        :param pulumi.Input[_builtins.str] country: User info attribute
        :param pulumi.Input[_builtins.str] department: User info attribute
        :param pulumi.Input[_builtins.str] description: Join point description
        :param pulumi.Input[_builtins.str] domain: AD domain associated with the join point
        :param pulumi.Input[_builtins.str] email: User info attribute
        :param pulumi.Input[_builtins.bool] enable_callback_for_dialin_client: Enable Callback For Dial In Client
                 - Default value: `false`
        :param pulumi.Input[_builtins.bool] enable_dialin_permission_check: Enable Dial In Permission Check
                 - Default value: `false`
        :param pulumi.Input[_builtins.bool] enable_domain_allowed_list: - Default value: `true`
        :param pulumi.Input[_builtins.bool] enable_failed_auth_protection: Enable prevent AD account lockout due to too many bad password attempts
                 - Default value: `false`
        :param pulumi.Input[_builtins.bool] enable_machine_access: Enable Machine Access
                 - Default value: `true`
        :param pulumi.Input[_builtins.bool] enable_machine_auth: Enable Machine Authentication
                 - Default value: `true`
        :param pulumi.Input[_builtins.bool] enable_pass_change: Enable Password Change
                 - Default value: `true`
        :param pulumi.Input[_builtins.bool] enable_rewrites: Enable Rewrites
                 - Default value: `false`
        :param pulumi.Input[_builtins.int] failed_auth_threshold: Number of bad password attempts
                 - Default value: `5`
        :param pulumi.Input[_builtins.str] first_name: User info attribute
        :param pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointGroupArgs']]] groups: List of AD Groups
        :param pulumi.Input[_builtins.str] identity_not_in_ad_behaviour: Identity Not In AD Behaviour
                 - Choices: `REJECT`, `SEARCH_JOINED_FOREST`, `SEARCH_ALL`
        :param pulumi.Input[_builtins.str] job_title: User info attribute
        :param pulumi.Input[_builtins.str] last_name: User info attribute
        :param pulumi.Input[_builtins.str] locality: User info attribute
        :param pulumi.Input[_builtins.str] name: The name of the active directory join point
        :param pulumi.Input[_builtins.str] organizational_unit: User info attribute
        :param pulumi.Input[_builtins.bool] plaintext_auth: Plain Text Authentication
                 - Default value: `false`
        :param pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointRewriteRuleArgs']]] rewrite_rules: List of Rewrite rules
        :param pulumi.Input[_builtins.str] schema: Schema
                 - Choices: `ACTIVE_DIRECTORY`, `CUSTOM`
        :param pulumi.Input[_builtins.str] state_or_province: User info attribute
        :param pulumi.Input[_builtins.str] street_address: User info attribute
        :param pulumi.Input[_builtins.str] telephone: User info attribute
        :param pulumi.Input[_builtins.str] unreachable_domains_behaviour: Unreachable Domains Behaviour
                 - Choices: `PROCEED`, `DROP`
        """
        if ad_scopes_names is not None:
            pulumi.set(__self__, "ad_scopes_names", ad_scopes_names)
        if aging_time is not None:
            pulumi.set(__self__, "aging_time", aging_time)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if auth_protection_type is not None:
            pulumi.set(__self__, "auth_protection_type", auth_protection_type)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if department is not None:
            pulumi.set(__self__, "department", department)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if enable_callback_for_dialin_client is not None:
            pulumi.set(__self__, "enable_callback_for_dialin_client", enable_callback_for_dialin_client)
        if enable_dialin_permission_check is not None:
            pulumi.set(__self__, "enable_dialin_permission_check", enable_dialin_permission_check)
        if enable_domain_allowed_list is not None:
            pulumi.set(__self__, "enable_domain_allowed_list", enable_domain_allowed_list)
        if enable_failed_auth_protection is not None:
            pulumi.set(__self__, "enable_failed_auth_protection", enable_failed_auth_protection)
        if enable_machine_access is not None:
            pulumi.set(__self__, "enable_machine_access", enable_machine_access)
        if enable_machine_auth is not None:
            pulumi.set(__self__, "enable_machine_auth", enable_machine_auth)
        if enable_pass_change is not None:
            pulumi.set(__self__, "enable_pass_change", enable_pass_change)
        if enable_rewrites is not None:
            pulumi.set(__self__, "enable_rewrites", enable_rewrites)
        if failed_auth_threshold is not None:
            pulumi.set(__self__, "failed_auth_threshold", failed_auth_threshold)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if identity_not_in_ad_behaviour is not None:
            pulumi.set(__self__, "identity_not_in_ad_behaviour", identity_not_in_ad_behaviour)
        if job_title is not None:
            pulumi.set(__self__, "job_title", job_title)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if plaintext_auth is not None:
            pulumi.set(__self__, "plaintext_auth", plaintext_auth)
        if rewrite_rules is not None:
            pulumi.set(__self__, "rewrite_rules", rewrite_rules)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if state_or_province is not None:
            pulumi.set(__self__, "state_or_province", state_or_province)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)
        if telephone is not None:
            pulumi.set(__self__, "telephone", telephone)
        if unreachable_domains_behaviour is not None:
            pulumi.set(__self__, "unreachable_domains_behaviour", unreachable_domains_behaviour)

    @_builtins.property
    @pulumi.getter(name="adScopesNames")
    def ad_scopes_names(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String that contains the names of the scopes that the active directory belongs to. Names are separated by comma.
          - Default value: `Default_Scope`
        """
        return pulumi.get(self, "ad_scopes_names")

    @ad_scopes_names.setter
    def ad_scopes_names(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ad_scopes_names", value)

    @_builtins.property
    @pulumi.getter(name="agingTime")
    def aging_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Aging Time
          - Default value: `5`
        """
        return pulumi.get(self, "aging_time")

    @aging_time.setter
    def aging_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "aging_time", value)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointAttributeArgs']]]]:
        """
        List of AD attributes
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @_builtins.property
    @pulumi.getter(name="authProtectionType")
    def auth_protection_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable prevent AD account lockout for WIRELESS/WIRED/BOTH
          - Choices: `WIRELESS`, `WIRED`, `BOTH`
        """
        return pulumi.get(self, "auth_protection_type")

    @auth_protection_type.setter
    def auth_protection_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_protection_type", value)

    @_builtins.property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "country", value)

    @_builtins.property
    @pulumi.getter
    def department(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "department")

    @department.setter
    def department(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "department", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Join point description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AD domain associated with the join point
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="enableCallbackForDialinClient")
    def enable_callback_for_dialin_client(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable Callback For Dial In Client
          - Default value: `false`
        """
        return pulumi.get(self, "enable_callback_for_dialin_client")

    @enable_callback_for_dialin_client.setter
    def enable_callback_for_dialin_client(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_callback_for_dialin_client", value)

    @_builtins.property
    @pulumi.getter(name="enableDialinPermissionCheck")
    def enable_dialin_permission_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable Dial In Permission Check
          - Default value: `false`
        """
        return pulumi.get(self, "enable_dialin_permission_check")

    @enable_dialin_permission_check.setter
    def enable_dialin_permission_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dialin_permission_check", value)

    @_builtins.property
    @pulumi.getter(name="enableDomainAllowedList")
    def enable_domain_allowed_list(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - Default value: `true`
        """
        return pulumi.get(self, "enable_domain_allowed_list")

    @enable_domain_allowed_list.setter
    def enable_domain_allowed_list(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_domain_allowed_list", value)

    @_builtins.property
    @pulumi.getter(name="enableFailedAuthProtection")
    def enable_failed_auth_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable prevent AD account lockout due to too many bad password attempts
          - Default value: `false`
        """
        return pulumi.get(self, "enable_failed_auth_protection")

    @enable_failed_auth_protection.setter
    def enable_failed_auth_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_failed_auth_protection", value)

    @_builtins.property
    @pulumi.getter(name="enableMachineAccess")
    def enable_machine_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable Machine Access
          - Default value: `true`
        """
        return pulumi.get(self, "enable_machine_access")

    @enable_machine_access.setter
    def enable_machine_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_machine_access", value)

    @_builtins.property
    @pulumi.getter(name="enableMachineAuth")
    def enable_machine_auth(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable Machine Authentication
          - Default value: `true`
        """
        return pulumi.get(self, "enable_machine_auth")

    @enable_machine_auth.setter
    def enable_machine_auth(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_machine_auth", value)

    @_builtins.property
    @pulumi.getter(name="enablePassChange")
    def enable_pass_change(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable Password Change
          - Default value: `true`
        """
        return pulumi.get(self, "enable_pass_change")

    @enable_pass_change.setter
    def enable_pass_change(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_pass_change", value)

    @_builtins.property
    @pulumi.getter(name="enableRewrites")
    def enable_rewrites(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable Rewrites
          - Default value: `false`
        """
        return pulumi.get(self, "enable_rewrites")

    @enable_rewrites.setter
    def enable_rewrites(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_rewrites", value)

    @_builtins.property
    @pulumi.getter(name="failedAuthThreshold")
    def failed_auth_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of bad password attempts
          - Default value: `5`
        """
        return pulumi.get(self, "failed_auth_threshold")

    @failed_auth_threshold.setter
    def failed_auth_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "failed_auth_threshold", value)

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "first_name", value)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointGroupArgs']]]]:
        """
        List of AD Groups
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointGroupArgs']]]]):
        pulumi.set(self, "groups", value)

    @_builtins.property
    @pulumi.getter(name="identityNotInAdBehaviour")
    def identity_not_in_ad_behaviour(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identity Not In AD Behaviour
          - Choices: `REJECT`, `SEARCH_JOINED_FOREST`, `SEARCH_ALL`
        """
        return pulumi.get(self, "identity_not_in_ad_behaviour")

    @identity_not_in_ad_behaviour.setter
    def identity_not_in_ad_behaviour(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_not_in_ad_behaviour", value)

    @_builtins.property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "job_title")

    @job_title.setter
    def job_title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_title", value)

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_name", value)

    @_builtins.property
    @pulumi.getter
    def locality(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locality", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the active directory join point
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "organizational_unit")

    @organizational_unit.setter
    def organizational_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organizational_unit", value)

    @_builtins.property
    @pulumi.getter(name="plaintextAuth")
    def plaintext_auth(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Plain Text Authentication
          - Default value: `false`
        """
        return pulumi.get(self, "plaintext_auth")

    @plaintext_auth.setter
    def plaintext_auth(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "plaintext_auth", value)

    @_builtins.property
    @pulumi.getter(name="rewriteRules")
    def rewrite_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointRewriteRuleArgs']]]]:
        """
        List of Rewrite rules
        """
        return pulumi.get(self, "rewrite_rules")

    @rewrite_rules.setter
    def rewrite_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActiveDirectoryJoinPointRewriteRuleArgs']]]]):
        pulumi.set(self, "rewrite_rules", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Schema
          - Choices: `ACTIVE_DIRECTORY`, `CUSTOM`
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="stateOrProvince")
    def state_or_province(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "state_or_province")

    @state_or_province.setter
    def state_or_province(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state_or_province", value)

    @_builtins.property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "street_address")

    @street_address.setter
    def street_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "street_address", value)

    @_builtins.property
    @pulumi.getter
    def telephone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "telephone")

    @telephone.setter
    def telephone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "telephone", value)

    @_builtins.property
    @pulumi.getter(name="unreachableDomainsBehaviour")
    def unreachable_domains_behaviour(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unreachable Domains Behaviour
          - Choices: `PROCEED`, `DROP`
        """
        return pulumi.get(self, "unreachable_domains_behaviour")

    @unreachable_domains_behaviour.setter
    def unreachable_domains_behaviour(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unreachable_domains_behaviour", value)


@pulumi.type_token("ise:identitymanagement/activeDirectoryJoinPoint:ActiveDirectoryJoinPoint")
class ActiveDirectoryJoinPoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ad_scopes_names: Optional[pulumi.Input[_builtins.str]] = None,
                 aging_time: Optional[pulumi.Input[_builtins.int]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActiveDirectoryJoinPointAttributeArgs', 'ActiveDirectoryJoinPointAttributeArgsDict']]]]] = None,
                 auth_protection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 country: Optional[pulumi.Input[_builtins.str]] = None,
                 department: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_callback_for_dialin_client: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dialin_permission_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_domain_allowed_list: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_failed_auth_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_machine_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_machine_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_pass_change: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rewrites: Optional[pulumi.Input[_builtins.bool]] = None,
                 failed_auth_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActiveDirectoryJoinPointGroupArgs', 'ActiveDirectoryJoinPointGroupArgsDict']]]]] = None,
                 identity_not_in_ad_behaviour: Optional[pulumi.Input[_builtins.str]] = None,
                 job_title: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organizational_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 plaintext_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 rewrite_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActiveDirectoryJoinPointRewriteRuleArgs', 'ActiveDirectoryJoinPointRewriteRuleArgsDict']]]]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 state_or_province: Optional[pulumi.Input[_builtins.str]] = None,
                 street_address: Optional[pulumi.Input[_builtins.str]] = None,
                 telephone: Optional[pulumi.Input[_builtins.str]] = None,
                 unreachable_domains_behaviour: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage an Active Directory Join Point.

        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:identitymanagement/activeDirectoryJoinPoint:ActiveDirectoryJoinPoint example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ad_scopes_names: String that contains the names of the scopes that the active directory belongs to. Names are separated by comma.
                 - Default value: `Default_Scope`
        :param pulumi.Input[_builtins.int] aging_time: Aging Time
                 - Default value: `5`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActiveDirectoryJoinPointAttributeArgs', 'ActiveDirectoryJoinPointAttributeArgsDict']]]] attributes: List of AD attributes
        :param pulumi.Input[_builtins.str] auth_protection_type: Enable prevent AD account lockout for WIRELESS/WIRED/BOTH
                 - Choices: `WIRELESS`, `WIRED`, `BOTH`
        :param pulumi.Input[_builtins.str] country: User info attribute
        :param pulumi.Input[_builtins.str] department: User info attribute
        :param pulumi.Input[_builtins.str] description: Join point description
        :param pulumi.Input[_builtins.str] domain: AD domain associated with the join point
        :param pulumi.Input[_builtins.str] email: User info attribute
        :param pulumi.Input[_builtins.bool] enable_callback_for_dialin_client: Enable Callback For Dial In Client
                 - Default value: `false`
        :param pulumi.Input[_builtins.bool] enable_dialin_permission_check: Enable Dial In Permission Check
                 - Default value: `false`
        :param pulumi.Input[_builtins.bool] enable_domain_allowed_list: - Default value: `true`
        :param pulumi.Input[_builtins.bool] enable_failed_auth_protection: Enable prevent AD account lockout due to too many bad password attempts
                 - Default value: `false`
        :param pulumi.Input[_builtins.bool] enable_machine_access: Enable Machine Access
                 - Default value: `true`
        :param pulumi.Input[_builtins.bool] enable_machine_auth: Enable Machine Authentication
                 - Default value: `true`
        :param pulumi.Input[_builtins.bool] enable_pass_change: Enable Password Change
                 - Default value: `true`
        :param pulumi.Input[_builtins.bool] enable_rewrites: Enable Rewrites
                 - Default value: `false`
        :param pulumi.Input[_builtins.int] failed_auth_threshold: Number of bad password attempts
                 - Default value: `5`
        :param pulumi.Input[_builtins.str] first_name: User info attribute
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActiveDirectoryJoinPointGroupArgs', 'ActiveDirectoryJoinPointGroupArgsDict']]]] groups: List of AD Groups
        :param pulumi.Input[_builtins.str] identity_not_in_ad_behaviour: Identity Not In AD Behaviour
                 - Choices: `REJECT`, `SEARCH_JOINED_FOREST`, `SEARCH_ALL`
        :param pulumi.Input[_builtins.str] job_title: User info attribute
        :param pulumi.Input[_builtins.str] last_name: User info attribute
        :param pulumi.Input[_builtins.str] locality: User info attribute
        :param pulumi.Input[_builtins.str] name: The name of the active directory join point
        :param pulumi.Input[_builtins.str] organizational_unit: User info attribute
        :param pulumi.Input[_builtins.bool] plaintext_auth: Plain Text Authentication
                 - Default value: `false`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActiveDirectoryJoinPointRewriteRuleArgs', 'ActiveDirectoryJoinPointRewriteRuleArgsDict']]]] rewrite_rules: List of Rewrite rules
        :param pulumi.Input[_builtins.str] schema: Schema
                 - Choices: `ACTIVE_DIRECTORY`, `CUSTOM`
        :param pulumi.Input[_builtins.str] state_or_province: User info attribute
        :param pulumi.Input[_builtins.str] street_address: User info attribute
        :param pulumi.Input[_builtins.str] telephone: User info attribute
        :param pulumi.Input[_builtins.str] unreachable_domains_behaviour: Unreachable Domains Behaviour
                 - Choices: `PROCEED`, `DROP`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ActiveDirectoryJoinPointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage an Active Directory Join Point.

        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:identitymanagement/activeDirectoryJoinPoint:ActiveDirectoryJoinPoint example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param ActiveDirectoryJoinPointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ActiveDirectoryJoinPointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ad_scopes_names: Optional[pulumi.Input[_builtins.str]] = None,
                 aging_time: Optional[pulumi.Input[_builtins.int]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActiveDirectoryJoinPointAttributeArgs', 'ActiveDirectoryJoinPointAttributeArgsDict']]]]] = None,
                 auth_protection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 country: Optional[pulumi.Input[_builtins.str]] = None,
                 department: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_callback_for_dialin_client: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dialin_permission_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_domain_allowed_list: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_failed_auth_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_machine_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_machine_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_pass_change: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rewrites: Optional[pulumi.Input[_builtins.bool]] = None,
                 failed_auth_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActiveDirectoryJoinPointGroupArgs', 'ActiveDirectoryJoinPointGroupArgsDict']]]]] = None,
                 identity_not_in_ad_behaviour: Optional[pulumi.Input[_builtins.str]] = None,
                 job_title: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organizational_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 plaintext_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 rewrite_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActiveDirectoryJoinPointRewriteRuleArgs', 'ActiveDirectoryJoinPointRewriteRuleArgsDict']]]]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 state_or_province: Optional[pulumi.Input[_builtins.str]] = None,
                 street_address: Optional[pulumi.Input[_builtins.str]] = None,
                 telephone: Optional[pulumi.Input[_builtins.str]] = None,
                 unreachable_domains_behaviour: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ActiveDirectoryJoinPointArgs.__new__(ActiveDirectoryJoinPointArgs)

            __props__.__dict__["ad_scopes_names"] = ad_scopes_names
            __props__.__dict__["aging_time"] = aging_time
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["auth_protection_type"] = auth_protection_type
            __props__.__dict__["country"] = country
            __props__.__dict__["department"] = department
            __props__.__dict__["description"] = description
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            __props__.__dict__["email"] = email
            __props__.__dict__["enable_callback_for_dialin_client"] = enable_callback_for_dialin_client
            __props__.__dict__["enable_dialin_permission_check"] = enable_dialin_permission_check
            __props__.__dict__["enable_domain_allowed_list"] = enable_domain_allowed_list
            __props__.__dict__["enable_failed_auth_protection"] = enable_failed_auth_protection
            __props__.__dict__["enable_machine_access"] = enable_machine_access
            __props__.__dict__["enable_machine_auth"] = enable_machine_auth
            __props__.__dict__["enable_pass_change"] = enable_pass_change
            __props__.__dict__["enable_rewrites"] = enable_rewrites
            __props__.__dict__["failed_auth_threshold"] = failed_auth_threshold
            __props__.__dict__["first_name"] = first_name
            __props__.__dict__["groups"] = groups
            __props__.__dict__["identity_not_in_ad_behaviour"] = identity_not_in_ad_behaviour
            __props__.__dict__["job_title"] = job_title
            __props__.__dict__["last_name"] = last_name
            __props__.__dict__["locality"] = locality
            __props__.__dict__["name"] = name
            __props__.__dict__["organizational_unit"] = organizational_unit
            __props__.__dict__["plaintext_auth"] = plaintext_auth
            __props__.__dict__["rewrite_rules"] = rewrite_rules
            __props__.__dict__["schema"] = schema
            __props__.__dict__["state_or_province"] = state_or_province
            __props__.__dict__["street_address"] = street_address
            __props__.__dict__["telephone"] = telephone
            __props__.__dict__["unreachable_domains_behaviour"] = unreachable_domains_behaviour
        super(ActiveDirectoryJoinPoint, __self__).__init__(
            'ise:identitymanagement/activeDirectoryJoinPoint:ActiveDirectoryJoinPoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ad_scopes_names: Optional[pulumi.Input[_builtins.str]] = None,
            aging_time: Optional[pulumi.Input[_builtins.int]] = None,
            attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActiveDirectoryJoinPointAttributeArgs', 'ActiveDirectoryJoinPointAttributeArgsDict']]]]] = None,
            auth_protection_type: Optional[pulumi.Input[_builtins.str]] = None,
            country: Optional[pulumi.Input[_builtins.str]] = None,
            department: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            enable_callback_for_dialin_client: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_dialin_permission_check: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_domain_allowed_list: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_failed_auth_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_machine_access: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_machine_auth: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_pass_change: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_rewrites: Optional[pulumi.Input[_builtins.bool]] = None,
            failed_auth_threshold: Optional[pulumi.Input[_builtins.int]] = None,
            first_name: Optional[pulumi.Input[_builtins.str]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActiveDirectoryJoinPointGroupArgs', 'ActiveDirectoryJoinPointGroupArgsDict']]]]] = None,
            identity_not_in_ad_behaviour: Optional[pulumi.Input[_builtins.str]] = None,
            job_title: Optional[pulumi.Input[_builtins.str]] = None,
            last_name: Optional[pulumi.Input[_builtins.str]] = None,
            locality: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organizational_unit: Optional[pulumi.Input[_builtins.str]] = None,
            plaintext_auth: Optional[pulumi.Input[_builtins.bool]] = None,
            rewrite_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActiveDirectoryJoinPointRewriteRuleArgs', 'ActiveDirectoryJoinPointRewriteRuleArgsDict']]]]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            state_or_province: Optional[pulumi.Input[_builtins.str]] = None,
            street_address: Optional[pulumi.Input[_builtins.str]] = None,
            telephone: Optional[pulumi.Input[_builtins.str]] = None,
            unreachable_domains_behaviour: Optional[pulumi.Input[_builtins.str]] = None) -> 'ActiveDirectoryJoinPoint':
        """
        Get an existing ActiveDirectoryJoinPoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ad_scopes_names: String that contains the names of the scopes that the active directory belongs to. Names are separated by comma.
                 - Default value: `Default_Scope`
        :param pulumi.Input[_builtins.int] aging_time: Aging Time
                 - Default value: `5`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActiveDirectoryJoinPointAttributeArgs', 'ActiveDirectoryJoinPointAttributeArgsDict']]]] attributes: List of AD attributes
        :param pulumi.Input[_builtins.str] auth_protection_type: Enable prevent AD account lockout for WIRELESS/WIRED/BOTH
                 - Choices: `WIRELESS`, `WIRED`, `BOTH`
        :param pulumi.Input[_builtins.str] country: User info attribute
        :param pulumi.Input[_builtins.str] department: User info attribute
        :param pulumi.Input[_builtins.str] description: Join point description
        :param pulumi.Input[_builtins.str] domain: AD domain associated with the join point
        :param pulumi.Input[_builtins.str] email: User info attribute
        :param pulumi.Input[_builtins.bool] enable_callback_for_dialin_client: Enable Callback For Dial In Client
                 - Default value: `false`
        :param pulumi.Input[_builtins.bool] enable_dialin_permission_check: Enable Dial In Permission Check
                 - Default value: `false`
        :param pulumi.Input[_builtins.bool] enable_domain_allowed_list: - Default value: `true`
        :param pulumi.Input[_builtins.bool] enable_failed_auth_protection: Enable prevent AD account lockout due to too many bad password attempts
                 - Default value: `false`
        :param pulumi.Input[_builtins.bool] enable_machine_access: Enable Machine Access
                 - Default value: `true`
        :param pulumi.Input[_builtins.bool] enable_machine_auth: Enable Machine Authentication
                 - Default value: `true`
        :param pulumi.Input[_builtins.bool] enable_pass_change: Enable Password Change
                 - Default value: `true`
        :param pulumi.Input[_builtins.bool] enable_rewrites: Enable Rewrites
                 - Default value: `false`
        :param pulumi.Input[_builtins.int] failed_auth_threshold: Number of bad password attempts
                 - Default value: `5`
        :param pulumi.Input[_builtins.str] first_name: User info attribute
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActiveDirectoryJoinPointGroupArgs', 'ActiveDirectoryJoinPointGroupArgsDict']]]] groups: List of AD Groups
        :param pulumi.Input[_builtins.str] identity_not_in_ad_behaviour: Identity Not In AD Behaviour
                 - Choices: `REJECT`, `SEARCH_JOINED_FOREST`, `SEARCH_ALL`
        :param pulumi.Input[_builtins.str] job_title: User info attribute
        :param pulumi.Input[_builtins.str] last_name: User info attribute
        :param pulumi.Input[_builtins.str] locality: User info attribute
        :param pulumi.Input[_builtins.str] name: The name of the active directory join point
        :param pulumi.Input[_builtins.str] organizational_unit: User info attribute
        :param pulumi.Input[_builtins.bool] plaintext_auth: Plain Text Authentication
                 - Default value: `false`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActiveDirectoryJoinPointRewriteRuleArgs', 'ActiveDirectoryJoinPointRewriteRuleArgsDict']]]] rewrite_rules: List of Rewrite rules
        :param pulumi.Input[_builtins.str] schema: Schema
                 - Choices: `ACTIVE_DIRECTORY`, `CUSTOM`
        :param pulumi.Input[_builtins.str] state_or_province: User info attribute
        :param pulumi.Input[_builtins.str] street_address: User info attribute
        :param pulumi.Input[_builtins.str] telephone: User info attribute
        :param pulumi.Input[_builtins.str] unreachable_domains_behaviour: Unreachable Domains Behaviour
                 - Choices: `PROCEED`, `DROP`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ActiveDirectoryJoinPointState.__new__(_ActiveDirectoryJoinPointState)

        __props__.__dict__["ad_scopes_names"] = ad_scopes_names
        __props__.__dict__["aging_time"] = aging_time
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["auth_protection_type"] = auth_protection_type
        __props__.__dict__["country"] = country
        __props__.__dict__["department"] = department
        __props__.__dict__["description"] = description
        __props__.__dict__["domain"] = domain
        __props__.__dict__["email"] = email
        __props__.__dict__["enable_callback_for_dialin_client"] = enable_callback_for_dialin_client
        __props__.__dict__["enable_dialin_permission_check"] = enable_dialin_permission_check
        __props__.__dict__["enable_domain_allowed_list"] = enable_domain_allowed_list
        __props__.__dict__["enable_failed_auth_protection"] = enable_failed_auth_protection
        __props__.__dict__["enable_machine_access"] = enable_machine_access
        __props__.__dict__["enable_machine_auth"] = enable_machine_auth
        __props__.__dict__["enable_pass_change"] = enable_pass_change
        __props__.__dict__["enable_rewrites"] = enable_rewrites
        __props__.__dict__["failed_auth_threshold"] = failed_auth_threshold
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["groups"] = groups
        __props__.__dict__["identity_not_in_ad_behaviour"] = identity_not_in_ad_behaviour
        __props__.__dict__["job_title"] = job_title
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["locality"] = locality
        __props__.__dict__["name"] = name
        __props__.__dict__["organizational_unit"] = organizational_unit
        __props__.__dict__["plaintext_auth"] = plaintext_auth
        __props__.__dict__["rewrite_rules"] = rewrite_rules
        __props__.__dict__["schema"] = schema
        __props__.__dict__["state_or_province"] = state_or_province
        __props__.__dict__["street_address"] = street_address
        __props__.__dict__["telephone"] = telephone
        __props__.__dict__["unreachable_domains_behaviour"] = unreachable_domains_behaviour
        return ActiveDirectoryJoinPoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adScopesNames")
    def ad_scopes_names(self) -> pulumi.Output[_builtins.str]:
        """
        String that contains the names of the scopes that the active directory belongs to. Names are separated by comma.
          - Default value: `Default_Scope`
        """
        return pulumi.get(self, "ad_scopes_names")

    @_builtins.property
    @pulumi.getter(name="agingTime")
    def aging_time(self) -> pulumi.Output[_builtins.int]:
        """
        Aging Time
          - Default value: `5`
        """
        return pulumi.get(self, "aging_time")

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[Sequence['outputs.ActiveDirectoryJoinPointAttribute']]]:
        """
        List of AD attributes
        """
        return pulumi.get(self, "attributes")

    @_builtins.property
    @pulumi.getter(name="authProtectionType")
    def auth_protection_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Enable prevent AD account lockout for WIRELESS/WIRED/BOTH
          - Choices: `WIRELESS`, `WIRED`, `BOTH`
        """
        return pulumi.get(self, "auth_protection_type")

    @_builtins.property
    @pulumi.getter
    def country(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter
    def department(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "department")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Join point description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        AD domain associated with the join point
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="enableCallbackForDialinClient")
    def enable_callback_for_dialin_client(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable Callback For Dial In Client
          - Default value: `false`
        """
        return pulumi.get(self, "enable_callback_for_dialin_client")

    @_builtins.property
    @pulumi.getter(name="enableDialinPermissionCheck")
    def enable_dialin_permission_check(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable Dial In Permission Check
          - Default value: `false`
        """
        return pulumi.get(self, "enable_dialin_permission_check")

    @_builtins.property
    @pulumi.getter(name="enableDomainAllowedList")
    def enable_domain_allowed_list(self) -> pulumi.Output[_builtins.bool]:
        """
        - Default value: `true`
        """
        return pulumi.get(self, "enable_domain_allowed_list")

    @_builtins.property
    @pulumi.getter(name="enableFailedAuthProtection")
    def enable_failed_auth_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable prevent AD account lockout due to too many bad password attempts
          - Default value: `false`
        """
        return pulumi.get(self, "enable_failed_auth_protection")

    @_builtins.property
    @pulumi.getter(name="enableMachineAccess")
    def enable_machine_access(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable Machine Access
          - Default value: `true`
        """
        return pulumi.get(self, "enable_machine_access")

    @_builtins.property
    @pulumi.getter(name="enableMachineAuth")
    def enable_machine_auth(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable Machine Authentication
          - Default value: `true`
        """
        return pulumi.get(self, "enable_machine_auth")

    @_builtins.property
    @pulumi.getter(name="enablePassChange")
    def enable_pass_change(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable Password Change
          - Default value: `true`
        """
        return pulumi.get(self, "enable_pass_change")

    @_builtins.property
    @pulumi.getter(name="enableRewrites")
    def enable_rewrites(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable Rewrites
          - Default value: `false`
        """
        return pulumi.get(self, "enable_rewrites")

    @_builtins.property
    @pulumi.getter(name="failedAuthThreshold")
    def failed_auth_threshold(self) -> pulumi.Output[_builtins.int]:
        """
        Number of bad password attempts
          - Default value: `5`
        """
        return pulumi.get(self, "failed_auth_threshold")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Optional[Sequence['outputs.ActiveDirectoryJoinPointGroup']]]:
        """
        List of AD Groups
        """
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter(name="identityNotInAdBehaviour")
    def identity_not_in_ad_behaviour(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Identity Not In AD Behaviour
          - Choices: `REJECT`, `SEARCH_JOINED_FOREST`, `SEARCH_ALL`
        """
        return pulumi.get(self, "identity_not_in_ad_behaviour")

    @_builtins.property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "job_title")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "last_name")

    @_builtins.property
    @pulumi.getter
    def locality(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "locality")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the active directory join point
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "organizational_unit")

    @_builtins.property
    @pulumi.getter(name="plaintextAuth")
    def plaintext_auth(self) -> pulumi.Output[_builtins.bool]:
        """
        Plain Text Authentication
          - Default value: `false`
        """
        return pulumi.get(self, "plaintext_auth")

    @_builtins.property
    @pulumi.getter(name="rewriteRules")
    def rewrite_rules(self) -> pulumi.Output[Optional[Sequence['outputs.ActiveDirectoryJoinPointRewriteRule']]]:
        """
        List of Rewrite rules
        """
        return pulumi.get(self, "rewrite_rules")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Schema
          - Choices: `ACTIVE_DIRECTORY`, `CUSTOM`
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="stateOrProvince")
    def state_or_province(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "state_or_province")

    @_builtins.property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "street_address")

    @_builtins.property
    @pulumi.getter
    def telephone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User info attribute
        """
        return pulumi.get(self, "telephone")

    @_builtins.property
    @pulumi.getter(name="unreachableDomainsBehaviour")
    def unreachable_domains_behaviour(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unreachable Domains Behaviour
          - Choices: `PROCEED`, `DROP`
        """
        return pulumi.get(self, "unreachable_domains_behaviour")

