# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRepositoryResult',
    'AwaitableGetRepositoryResult',
    'get_repository',
    'get_repository_output',
]

@pulumi.output_type
class GetRepositoryResult:
    """
    A collection of values returned by getRepository.
    """
    def __init__(__self__, enable_pki=None, id=None, name=None, password=None, path=None, protocol=None, server_name=None, user_name=None):
        if enable_pki and not isinstance(enable_pki, bool):
            raise TypeError("Expected argument 'enable_pki' to be a bool")
        pulumi.set(__self__, "enable_pki", enable_pki)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if server_name and not isinstance(server_name, str):
            raise TypeError("Expected argument 'server_name' to be a str")
        pulumi.set(__self__, "server_name", server_name)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="enablePki")
    def enable_pki(self) -> _builtins.bool:
        """
        Enable PKI
        """
        return pulumi.get(self, "enable_pki")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the object
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Repository name should be less than 80 characters and can contain alphanumeric, underscore, hyphen and dot characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        Password can contain alphanumeric and/or special characters.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path should always start with "/" and can contain alphanumeric, underscore, hyphen and dot characters.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Protocol
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="serverName")
    def server_name(self) -> _builtins.str:
        """
        Name of the server
        """
        return pulumi.get(self, "server_name")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        """
        User name
        """
        return pulumi.get(self, "user_name")


class AwaitableGetRepositoryResult(GetRepositoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryResult(
            enable_pki=self.enable_pki,
            id=self.id,
            name=self.name,
            password=self.password,
            path=self.path,
            protocol=self.protocol,
            server_name=self.server_name,
            user_name=self.user_name)


def get_repository(id: Optional[_builtins.str] = None,
                   name: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryResult:
    """
    This data source can read the Repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ise as ise

    example = ise.system.get_repository(id="repo1")
    ```


    :param _builtins.str id: The id of the object
    :param _builtins.str name: Repository name should be less than 80 characters and can contain alphanumeric, underscore, hyphen and dot characters.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ise:system/getRepository:getRepository', __args__, opts=opts, typ=GetRepositoryResult).value

    return AwaitableGetRepositoryResult(
        enable_pki=pulumi.get(__ret__, 'enable_pki'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        password=pulumi.get(__ret__, 'password'),
        path=pulumi.get(__ret__, 'path'),
        protocol=pulumi.get(__ret__, 'protocol'),
        server_name=pulumi.get(__ret__, 'server_name'),
        user_name=pulumi.get(__ret__, 'user_name'))
def get_repository_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepositoryResult]:
    """
    This data source can read the Repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ise as ise

    example = ise.system.get_repository(id="repo1")
    ```


    :param _builtins.str id: The id of the object
    :param _builtins.str name: Repository name should be less than 80 characters and can contain alphanumeric, underscore, hyphen and dot characters.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ise:system/getRepository:getRepository', __args__, opts=opts, typ=GetRepositoryResult)
    return __ret__.apply(lambda __response__: GetRepositoryResult(
        enable_pki=pulumi.get(__response__, 'enable_pki'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        password=pulumi.get(__response__, 'password'),
        path=pulumi.get(__response__, 'path'),
        protocol=pulumi.get(__response__, 'protocol'),
        server_name=pulumi.get(__response__, 'server_name'),
        user_name=pulumi.get(__response__, 'user_name')))
