"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContainerGroup = exports.ContainerGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const eci_generated_1 = require("./eci.generated");
Object.defineProperty(exports, "ContainerGroupProperty", { enumerable: true, get: function () { return eci_generated_1.RosContainerGroup; } });
/**
 * A ROS resource type:  `ALIYUN::ECI::ContainerGroup`
 */
class ContainerGroup extends ros.Resource {
    /**
     * Create a new `ALIYUN::ECI::ContainerGroup`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosContainerGroup = new eci_generated_1.RosContainerGroup(this, id, {
            securityContextSysctl: props.securityContextSysctl,
            memory: props.memory,
            initContainer: props.initContainer,
            cpu: props.cpu,
            eipInstanceId: props.eipInstanceId,
            containerGroupName: props.containerGroupName,
            container: props.container,
            imageSnapshotId: props.imageSnapshotId,
            ramRoleName: props.ramRoleName,
            dnsConfig: props.dnsConfig,
            autoMatchImageCache: props.autoMatchImageCache,
            ipv6AddressCount: props.ipv6AddressCount,
            imageRegistryCredential: props.imageRegistryCredential,
            spotPriceLimit: props.spotPriceLimit,
            instanceType: props.instanceType,
            spotStrategy: props.spotStrategy,
            activeDeadlineSeconds: props.activeDeadlineSeconds,
            hostAliase: props.hostAliase,
            zoneId: props.zoneId,
            terminationGracePeriodSeconds: props.terminationGracePeriodSeconds,
            vSwitchId: props.vSwitchId,
            securityGroupId: props.securityGroupId,
            slsEnable: props.slsEnable,
            restartPolicy: props.restartPolicy,
            volume: props.volume,
            acrRegistryInfo: props.acrRegistryInfo,
            tag: props.tag,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosContainerGroup;
        this.attrContainerGroupId = rosContainerGroup.attrContainerGroupId;
        this.attrContainerGroupName = rosContainerGroup.attrContainerGroupName;
        this.attrEniInstanceId = rosContainerGroup.attrEniInstanceId;
        this.attrInternetIp = rosContainerGroup.attrInternetIp;
        this.attrIntranetIp = rosContainerGroup.attrIntranetIp;
        this.attrIpv6Address = rosContainerGroup.attrIpv6Address;
        this.attrRegionId = rosContainerGroup.attrRegionId;
        this.attrSecurityGroupId = rosContainerGroup.attrSecurityGroupId;
        this.attrVSwitchId = rosContainerGroup.attrVSwitchId;
        this.attrZoneId = rosContainerGroup.attrZoneId;
    }
}
exports.ContainerGroup = ContainerGroup;
//# sourceMappingURL=data:application/json;base64,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