# Copyright 2023 Luminary Cloud, Inc. All Rights Reserved.
import logging

logger = logging.getLogger(__name__)

# General exception type generated by this module
class AuthException(Exception):
    def __init__(self, *args: object):
        super().__init__(self, *args)
        logger.error(args[0], exc_info=self)


# Raised when user interaction is required for auth when it is not desired.
class InteractiveAuthException(AuthException):
    pass


# Raised when there's something fishy going on.
class SecurityAlertException(AuthException):
    def __init__(self, *args: object):
        super().__init__(self, *args)
        logger.critical(args[0], exc_info=self)
