"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class FileMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    EXT_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    SHA256_CHECKSUM_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The file name without extension."""
    ext: builtins.str
    """File extension if known; please leave empty otherwise.
    TypeScript doesn't support "extension" as a field name.
    """
    size: builtins.int
    """The total size of the file in bytes."""
    sha256_checksum: builtins.bytes
    """Checksum of the whole file contents, as a raw SHA256 32 byte string. Not a
    hex string.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        ext: builtins.str = ...,
        size: builtins.int = ...,
        sha256_checksum: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["ext", b"ext", "name", b"name", "sha256_checksum", b"sha256_checksum", "size", b"size"]) -> None: ...

global___FileMetadata = FileMetadata

class File(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METADATA_FIELD_NUMBER: builtins.int
    FULL_CONTENTS_FIELD_NUMBER: builtins.int
    SIGNED_URL_FIELD_NUMBER: builtins.int
    FILE_ID_FIELD_NUMBER: builtins.int
    @property
    def metadata(self) -> global___FileMetadata:
        """Metadata of the file."""
    full_contents: builtins.bytes
    """File contents as bytes, included directly in the response."""
    signed_url: builtins.str
    """Signed URL which can be used to download the file."""
    file_id: builtins.str
    """File ID.  If specified, the file may be fetched from
    https://{app url}/fetch/{file id}
    Auth token must be included in the fetch request via http authorization header.
    """
    def __init__(
        self,
        *,
        metadata: global___FileMetadata | None = ...,
        full_contents: builtins.bytes = ...,
        signed_url: builtins.str = ...,
        file_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["contents", b"contents", "file_id", b"file_id", "full_contents", b"full_contents", "metadata", b"metadata", "signed_url", b"signed_url"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["contents", b"contents", "file_id", b"file_id", "full_contents", b"full_contents", "metadata", b"metadata", "signed_url", b"signed_url"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["contents", b"contents"]) -> typing_extensions.Literal["full_contents", "signed_url", "file_id"] | None: ...

global___File = File

class FileChunk(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METADATA_FIELD_NUMBER: builtins.int
    BYTES_FIELD_NUMBER: builtins.int
    @property
    def metadata(self) -> global___FileMetadata:
        """Metadata of the file."""
    @property
    def bytes(self) -> global___ByteChunk:
        """The chunk of data."""
    def __init__(
        self,
        *,
        metadata: global___FileMetadata | None = ...,
        bytes: global___ByteChunk | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["bytes", b"bytes", "metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bytes", b"bytes", "metadata", b"metadata"]) -> None: ...

global___FileChunk = FileChunk

class ByteChunk(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_OFFSET_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    NEXT_OFFSET_FIELD_NUMBER: builtins.int
    LAST_CHUNK_FIELD_NUMBER: builtins.int
    start_offset: builtins.int
    """The start offset of the included chunk."""
    data: builtins.bytes
    """The included chunk."""
    next_offset: builtins.int
    """If last_chunk is set to false then this value should be sent as the start_offset to request the next
    chunk to return.
    """
    last_chunk: builtins.bool
    """Denotes if this is the last chunk of the file. If this field is set to true then you have received all
    contents and you can stop sending requests.
    """
    def __init__(
        self,
        *,
        start_offset: builtins.int = ...,
        data: builtins.bytes = ...,
        next_offset: builtins.int = ...,
        last_chunk: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data", "last_chunk", b"last_chunk", "next_offset", b"next_offset", "start_offset", b"start_offset"]) -> None: ...

global___ByteChunk = ByteChunk

class Vector3(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    X_FIELD_NUMBER: builtins.int
    Y_FIELD_NUMBER: builtins.int
    Z_FIELD_NUMBER: builtins.int
    x: builtins.float
    y: builtins.float
    z: builtins.float
    def __init__(
        self,
        *,
        x: builtins.float = ...,
        y: builtins.float = ...,
        z: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["x", b"x", "y", b"y", "z", b"z"]) -> None: ...

global___Vector3 = Vector3
