"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import luminarycloud._proto.base.base_pb2
import luminarycloud._proto.cadmetadata.cadmetadata_pb2
import luminarycloud._proto.geometry.geometry_pb2
import luminarycloud._proto.lcn.lcmesh_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class Geometry(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Geometry._Status.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: Geometry._Status.ValueType  # 0
        """Status is unknown"""
        BUSY: Geometry._Status.ValueType  # 1
        """Geometry is being processed → HAS_FEATURE_ERRORS | READY_FOR_CHECK"""
        HAS_FEATURE_ERRORS: Geometry._Status.ValueType  # 5
        """Geometry has issues but can be processed → BUSY"""
        READY_FOR_CHECK: Geometry._Status.ValueType  # 2
        """Geometry needs to be checked → CHECKING"""
        CHECKING: Geometry._Status.ValueType  # 6
        """Geometry check is running → FAILED_CHECK | READY"""
        FAILED_CHECK: Geometry._Status.ValueType  # 3
        """Geometry failed check and cannot be used → BUSY"""
        READY: Geometry._Status.ValueType  # 4
        """Geometry is ready for use → BUSY"""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    UNKNOWN: Geometry.Status.ValueType  # 0
    """Status is unknown"""
    BUSY: Geometry.Status.ValueType  # 1
    """Geometry is being processed → HAS_FEATURE_ERRORS | READY_FOR_CHECK"""
    HAS_FEATURE_ERRORS: Geometry.Status.ValueType  # 5
    """Geometry has issues but can be processed → BUSY"""
    READY_FOR_CHECK: Geometry.Status.ValueType  # 2
    """Geometry needs to be checked → CHECKING"""
    CHECKING: Geometry.Status.ValueType  # 6
    """Geometry check is running → FAILED_CHECK | READY"""
    FAILED_CHECK: Geometry.Status.ValueType  # 3
    """Geometry failed check and cannot be used → BUSY"""
    READY: Geometry.Status.ValueType  # 4
    """Geometry is ready for use → BUSY"""

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    DELETED_FIELD_NUMBER: builtins.int
    LAST_VERSION_ID_FIELD_NUMBER: builtins.int
    USES_TAGS_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    VERSIONS_FIELD_NUMBER: builtins.int
    id: builtins.str
    name: builtins.str
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    deleted: builtins.bool
    last_version_id: builtins.str
    uses_tags: builtins.bool
    project_id: builtins.str
    status: global___Geometry.Status.ValueType
    @property
    def versions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GeometryVersion]:
        """Versions are not populated by default, but can be included by request."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        deleted: builtins.bool = ...,
        last_version_id: builtins.str = ...,
        uses_tags: builtins.bool = ...,
        project_id: builtins.str = ...,
        status: global___Geometry.Status.ValueType | None = ...,
        versions: collections.abc.Iterable[global___GeometryVersion] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_status", b"_status", "create_time", b"create_time", "status", b"status", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_status", b"_status", "create_time", b"create_time", "deleted", b"deleted", "id", b"id", "last_version_id", b"last_version_id", "name", b"name", "project_id", b"project_id", "status", b"status", "update_time", b"update_time", "uses_tags", b"uses_tags", "versions", b"versions"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_status", b"_status"]) -> typing_extensions.Literal["status"] | None: ...

global___Geometry = Geometry

class GeometryVersion(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    KERNEL_TYPE_FIELD_NUMBER: builtins.int
    NAMED_VARIABLE_SET_VERSION_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    geometry_id: builtins.str
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    name: builtins.str
    kernel_type: luminarycloud._proto.geometry.geometry_pb2.KernelType.ValueType
    named_variable_set_version_id: builtins.str
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        geometry_id: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        kernel_type: luminarycloud._proto.geometry.geometry_pb2.KernelType.ValueType = ...,
        named_variable_set_version_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "geometry_id", b"geometry_id", "id", b"id", "kernel_type", b"kernel_type", "name", b"name", "named_variable_set_version_id", b"named_variable_set_version_id"]) -> None: ...

global___GeometryVersion = GeometryVersion

class TessellationData(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    META_DATA_FIELD_NUMBER: builtins.int
    LCN_META_FIELD_NUMBER: builtins.int
    CAD_METADATA_FIELD_NUMBER: builtins.int
    GEOMETRY_VERSION_ID_FIELD_NUMBER: builtins.int
    FEATURE_ID_FIELD_NUMBER: builtins.int
    DATA_URL_FIELD_NUMBER: builtins.int
    META_DATA_URL_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    meta_data: builtins.bytes
    @property
    def lcn_meta(self) -> luminarycloud._proto.lcn.lcmesh_pb2.MeshFileMetadata: ...
    @property
    def cad_metadata(self) -> luminarycloud._proto.cadmetadata.cadmetadata_pb2.CadMetadata: ...
    geometry_version_id: builtins.str
    """Geometry version associated with the tessellation."""
    feature_id: builtins.str
    """Feature ID associated with the tessellation. Only set if the tessellation
    is up to a certain feature. If empty, it refers to the latest version of
    the geometry.
    """
    data_url: builtins.str
    """URL of the tessellation file. This is the URL that the client should use
    to download the tessellation if it's not empty.
    """
    meta_data_url: builtins.str
    """URL of the metadata file. This is the URL that the client should use to
    download the metadata if it's not empty.
    """
    def __init__(
        self,
        *,
        data: builtins.bytes = ...,
        meta_data: builtins.bytes = ...,
        lcn_meta: luminarycloud._proto.lcn.lcmesh_pb2.MeshFileMetadata | None = ...,
        cad_metadata: luminarycloud._proto.cadmetadata.cadmetadata_pb2.CadMetadata | None = ...,
        geometry_version_id: builtins.str = ...,
        feature_id: builtins.str = ...,
        data_url: builtins.str = ...,
        meta_data_url: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cad_metadata", b"cad_metadata", "lcn_meta", b"lcn_meta"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cad_metadata", b"cad_metadata", "data", b"data", "data_url", b"data_url", "feature_id", b"feature_id", "geometry_version_id", b"geometry_version_id", "lcn_meta", b"lcn_meta", "meta_data", b"meta_data", "meta_data_url", b"meta_data_url"]) -> None: ...

global___TessellationData = TessellationData

class GetGeometryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    geometry_id: builtins.str
    def __init__(
        self,
        *,
        geometry_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id"]) -> None: ...

global___GetGeometryRequest = GetGeometryRequest

class GetGeometryResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_FIELD_NUMBER: builtins.int
    @property
    def geometry(self) -> global___Geometry: ...
    def __init__(
        self,
        *,
        geometry: global___Geometry | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["geometry", b"geometry"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry", b"geometry"]) -> None: ...

global___GetGeometryResponse = GetGeometryResponse

class ListGeometryFeaturesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    GEOMETRY_VERSION_ID_FIELD_NUMBER: builtins.int
    geometry_id: builtins.str
    geometry_version_id: builtins.str
    def __init__(
        self,
        *,
        geometry_id: builtins.str = ...,
        geometry_version_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id", "geometry_version_id", b"geometry_version_id", "parent_resource_id", b"parent_resource_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id", "geometry_version_id", b"geometry_version_id", "parent_resource_id", b"parent_resource_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["parent_resource_id", b"parent_resource_id"]) -> typing_extensions.Literal["geometry_id", "geometry_version_id"] | None: ...

global___ListGeometryFeaturesRequest = ListGeometryFeaturesRequest

class ListGeometryFeaturesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEATURES_FIELD_NUMBER: builtins.int
    @property
    def features(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[luminarycloud._proto.geometry.geometry_pb2.Feature]:
        """The list of currently active features in the latest version of the
        geometry.
        """
    def __init__(
        self,
        *,
        features: collections.abc.Iterable[luminarycloud._proto.geometry.geometry_pb2.Feature] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["features", b"features"]) -> None: ...

global___ListGeometryFeaturesResponse = ListGeometryFeaturesResponse

class ListGeometryFeatureIssuesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    GEOMETRY_VERSION_ID_FIELD_NUMBER: builtins.int
    geometry_id: builtins.str
    geometry_version_id: builtins.str
    def __init__(
        self,
        *,
        geometry_id: builtins.str = ...,
        geometry_version_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id", "geometry_version_id", b"geometry_version_id", "parent_resource_id", b"parent_resource_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id", "geometry_version_id", b"geometry_version_id", "parent_resource_id", b"parent_resource_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["parent_resource_id", b"parent_resource_id"]) -> typing_extensions.Literal["geometry_id", "geometry_version_id"] | None: ...

global___ListGeometryFeatureIssuesRequest = ListGeometryFeatureIssuesRequest

class ListGeometryFeatureIssuesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEATURES_ISSUES_FIELD_NUMBER: builtins.int
    @property
    def features_issues(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[luminarycloud._proto.geometry.geometry_pb2.FeatureIssues]:
        """Issues with features in the geometry. Issues may be informational, warnings
        or errors.
        """
    def __init__(
        self,
        *,
        features_issues: collections.abc.Iterable[luminarycloud._proto.geometry.geometry_pb2.FeatureIssues] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["features_issues", b"features_issues"]) -> None: ...

global___ListGeometryFeatureIssuesResponse = ListGeometryFeatureIssuesResponse

class ListGeometryEntitiesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    GEOMETRY_VERSION_ID_FIELD_NUMBER: builtins.int
    geometry_id: builtins.str
    geometry_version_id: builtins.str
    def __init__(
        self,
        *,
        geometry_id: builtins.str = ...,
        geometry_version_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id", "geometry_version_id", b"geometry_version_id", "parent_resource_id", b"parent_resource_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id", "geometry_version_id", b"geometry_version_id", "parent_resource_id", b"parent_resource_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["parent_resource_id", b"parent_resource_id"]) -> typing_extensions.Literal["geometry_id", "geometry_version_id"] | None: ...

global___ListGeometryEntitiesRequest = ListGeometryEntitiesRequest

class ListGeometryEntitiesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FACES_FIELD_NUMBER: builtins.int
    BODIES_FIELD_NUMBER: builtins.int
    @property
    def faces(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[luminarycloud._proto.geometry.geometry_pb2.Face]:
        """The faces currently in the geometry."""
    @property
    def bodies(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[luminarycloud._proto.geometry.geometry_pb2.Body]:
        """The bodies currently in the geometry."""
    def __init__(
        self,
        *,
        faces: collections.abc.Iterable[luminarycloud._proto.geometry.geometry_pb2.Face] | None = ...,
        bodies: collections.abc.Iterable[luminarycloud._proto.geometry.geometry_pb2.Body] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bodies", b"bodies", "faces", b"faces"]) -> None: ...

global___ListGeometryEntitiesResponse = ListGeometryEntitiesResponse

class ListGeometriesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    INCLUDE_INTERESTING_VERSIONS_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    include_interesting_versions: builtins.bool
    """Optional. By default, versions are not included for the geometries. If true, the server will
    include a subset of the gemoetries' versions, specifically those that are named OR have an
    associated Mesh OR are the latest version of their geometry.
    """
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        include_interesting_versions: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["include_interesting_versions", b"include_interesting_versions", "project_id", b"project_id"]) -> None: ...

global___ListGeometriesRequest = ListGeometriesRequest

class ListGeometriesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRIES_FIELD_NUMBER: builtins.int
    @property
    def geometries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Geometry]: ...
    def __init__(
        self,
        *,
        geometries: collections.abc.Iterable[global___Geometry] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometries", b"geometries"]) -> None: ...

global___ListGeometriesResponse = ListGeometriesResponse

class SubscribeGeometryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    geometry_id: builtins.str
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        geometry_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id", "project_id", b"project_id"]) -> None: ...

global___SubscribeGeometryRequest = SubscribeGeometryRequest

class GeometryHistory(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class HistoryEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        MODIFICATION_FIELD_NUMBER: builtins.int
        GEOMETRY_VERSION_INITIAL_ID_FIELD_NUMBER: builtins.int
        GEOMETRY_VERSION_NEW_ID_FIELD_NUMBER: builtins.int
        CHECKPOINT_URL_FIELD_NUMBER: builtins.int
        @property
        def modification(self) -> luminarycloud._proto.geometry.geometry_pb2.Modification: ...
        geometry_version_initial_id: builtins.str
        geometry_version_new_id: builtins.str
        checkpoint_url: builtins.str
        def __init__(
            self,
            *,
            modification: luminarycloud._proto.geometry.geometry_pb2.Modification | None = ...,
            geometry_version_initial_id: builtins.str = ...,
            geometry_version_new_id: builtins.str = ...,
            checkpoint_url: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["modification", b"modification"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["checkpoint_url", b"checkpoint_url", "geometry_version_initial_id", b"geometry_version_initial_id", "geometry_version_new_id", b"geometry_version_new_id", "modification", b"modification"]) -> None: ...

    HISTORY_ENTRY_FIELD_NUMBER: builtins.int
    @property
    def history_entry(self) -> global___GeometryHistory.HistoryEntry: ...
    def __init__(
        self,
        *,
        history_entry: global___GeometryHistory.HistoryEntry | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["history_entry", b"history_entry"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["history_entry", b"history_entry"]) -> None: ...

global___GeometryHistory = GeometryHistory

class SubscribeGeometryResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class GeometryCheckpoint(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        MESH_URL_FIELD_NUMBER: builtins.int
        FEATURES_FIELD_NUMBER: builtins.int
        FEATURES_ISSUES_FIELD_NUMBER: builtins.int
        GEOMETRY_HISTORY_FIELD_NUMBER: builtins.int
        TESSELLATION_DATA_FIELD_NUMBER: builtins.int
        N_AVAIL_UNDOS_FIELD_NUMBER: builtins.int
        N_AVAIL_REDOS_FIELD_NUMBER: builtins.int
        TAGS_FIELD_NUMBER: builtins.int
        KERNEL_TYPE_FIELD_NUMBER: builtins.int
        NAMED_VARIABLE_SET_VERSION_ID_FIELD_NUMBER: builtins.int
        mesh_url: builtins.str
        @property
        def features(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[luminarycloud._proto.geometry.geometry_pb2.Feature]: ...
        @property
        def features_issues(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[luminarycloud._proto.geometry.geometry_pb2.FeatureIssues]: ...
        @property
        def geometry_history(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GeometryHistory]: ...
        @property
        def tessellation_data(self) -> global___TessellationData:
            """NOTE: tessellation_data may be empty or some of its fields may be empty
            in case the checkpoint relates to/ the response of a feature rename
            or tag-related request. In that case, the clients should not update their
            tessellation. If they have yet to receive a valid tessellation, they
            should wait until they receive such a message.
            """
        n_avail_undos: builtins.int
        n_avail_redos: builtins.int
        @property
        def tags(self) -> luminarycloud._proto.geometry.geometry_pb2.Tags: ...
        kernel_type: luminarycloud._proto.geometry.geometry_pb2.KernelType.ValueType
        named_variable_set_version_id: builtins.str
        def __init__(
            self,
            *,
            mesh_url: builtins.str = ...,
            features: collections.abc.Iterable[luminarycloud._proto.geometry.geometry_pb2.Feature] | None = ...,
            features_issues: collections.abc.Iterable[luminarycloud._proto.geometry.geometry_pb2.FeatureIssues] | None = ...,
            geometry_history: collections.abc.Iterable[global___GeometryHistory] | None = ...,
            tessellation_data: global___TessellationData | None = ...,
            n_avail_undos: builtins.int = ...,
            n_avail_redos: builtins.int = ...,
            tags: luminarycloud._proto.geometry.geometry_pb2.Tags | None = ...,
            kernel_type: luminarycloud._proto.geometry.geometry_pb2.KernelType.ValueType = ...,
            named_variable_set_version_id: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["tags", b"tags", "tessellation_data", b"tessellation_data"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["features", b"features", "features_issues", b"features_issues", "geometry_history", b"geometry_history", "kernel_type", b"kernel_type", "mesh_url", b"mesh_url", "n_avail_redos", b"n_avail_redos", "n_avail_undos", b"n_avail_undos", "named_variable_set_version_id", b"named_variable_set_version_id", "tags", b"tags", "tessellation_data", b"tessellation_data"]) -> None: ...

    class BusyState(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class FeatureProgress(google.protobuf.message.Message):
            """Indicates that the server is creating or updating a feature."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            FEATURE_ID_FIELD_NUMBER: builtins.int
            feature_id: builtins.str
            def __init__(
                self,
                *,
                feature_id: builtins.str = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["feature_id", b"feature_id"]) -> None: ...

        class FeatureTessellation(google.protobuf.message.Message):
            """Indicates that the server is computing a tessellation of the geometry."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            FEATURE_ID_FIELD_NUMBER: builtins.int
            feature_id: builtins.str
            """Server is computing a tessellation up to this feature_id. If feature_id
            is empty, a full tessellation is being computed.
            """
            def __init__(
                self,
                *,
                feature_id: builtins.str = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["feature_id", b"feature_id"]) -> None: ...

        class UndoRedo(google.protobuf.message.Message):
            """Indicates that the server is undoing or redoing an operation."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            def __init__(
                self,
            ) -> None: ...

        class Reloading(google.protobuf.message.Message):
            """Indicates that the server is reloading the geometry."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            def __init__(
                self,
            ) -> None: ...

        class DeleteFeature(google.protobuf.message.Message):
            """Indicates that the server is deleting a feature."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            FEATURE_ID_FIELD_NUMBER: builtins.int
            feature_id: builtins.str
            def __init__(
                self,
                *,
                feature_id: builtins.str = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["feature_id", b"feature_id"]) -> None: ...

        class RenameFeature(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            FEATURE_ID_FIELD_NUMBER: builtins.int
            feature_id: builtins.str
            def __init__(
                self,
                *,
                feature_id: builtins.str = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["feature_id", b"feature_id"]) -> None: ...

        class TagOperation(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            def __init__(
                self,
            ) -> None: ...

        MESSAGE_FIELD_NUMBER: builtins.int
        FEATURE_PROGRESS_FIELD_NUMBER: builtins.int
        FEATURE_TESSELLATION_FIELD_NUMBER: builtins.int
        UNDO_REDO_FIELD_NUMBER: builtins.int
        RELOADING_FIELD_NUMBER: builtins.int
        DELETE_FEATURE_FIELD_NUMBER: builtins.int
        RENAME_FEATURE_FIELD_NUMBER: builtins.int
        TAG_OPERATION_FIELD_NUMBER: builtins.int
        message: builtins.str
        """May be empty even if the server sent a busy state, i.e. we may not report
        progress messages even if the server is busy.
        """
        @property
        def feature_progress(self) -> global___SubscribeGeometryResponse.BusyState.FeatureProgress: ...
        @property
        def feature_tessellation(self) -> global___SubscribeGeometryResponse.BusyState.FeatureTessellation: ...
        @property
        def undo_redo(self) -> global___SubscribeGeometryResponse.BusyState.UndoRedo: ...
        @property
        def reloading(self) -> global___SubscribeGeometryResponse.BusyState.Reloading: ...
        @property
        def delete_feature(self) -> global___SubscribeGeometryResponse.BusyState.DeleteFeature: ...
        @property
        def rename_feature(self) -> global___SubscribeGeometryResponse.BusyState.RenameFeature: ...
        @property
        def tag_operation(self) -> global___SubscribeGeometryResponse.BusyState.TagOperation: ...
        def __init__(
            self,
            *,
            message: builtins.str = ...,
            feature_progress: global___SubscribeGeometryResponse.BusyState.FeatureProgress | None = ...,
            feature_tessellation: global___SubscribeGeometryResponse.BusyState.FeatureTessellation | None = ...,
            undo_redo: global___SubscribeGeometryResponse.BusyState.UndoRedo | None = ...,
            reloading: global___SubscribeGeometryResponse.BusyState.Reloading | None = ...,
            delete_feature: global___SubscribeGeometryResponse.BusyState.DeleteFeature | None = ...,
            rename_feature: global___SubscribeGeometryResponse.BusyState.RenameFeature | None = ...,
            tag_operation: global___SubscribeGeometryResponse.BusyState.TagOperation | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["BusyStateType", b"BusyStateType", "delete_feature", b"delete_feature", "feature_progress", b"feature_progress", "feature_tessellation", b"feature_tessellation", "reloading", b"reloading", "rename_feature", b"rename_feature", "tag_operation", b"tag_operation", "undo_redo", b"undo_redo"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["BusyStateType", b"BusyStateType", "delete_feature", b"delete_feature", "feature_progress", b"feature_progress", "feature_tessellation", b"feature_tessellation", "message", b"message", "reloading", b"reloading", "rename_feature", b"rename_feature", "tag_operation", b"tag_operation", "undo_redo", b"undo_redo"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["BusyStateType", b"BusyStateType"]) -> typing_extensions.Literal["feature_progress", "feature_tessellation", "undo_redo", "reloading", "delete_feature", "rename_feature", "tag_operation"] | None: ...

    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    CHECKPOINT_FIELD_NUMBER: builtins.int
    BUSY_FIELD_NUMBER: builtins.int
    WORKER_DISCONNECTED_FIELD_NUMBER: builtins.int
    RECEIVED_ERROR_FIELD_NUMBER: builtins.int
    geometry_id: builtins.str
    @property
    def checkpoint(self) -> global___SubscribeGeometryResponse.GeometryCheckpoint:
        """Tesselation returned for a given request."""
    @property
    def busy(self) -> global___SubscribeGeometryResponse.BusyState:
        """Tells the subscribers that the server is busy. Helps to coordinate with
        the clients so that they know that there are requests being processed.
        """
    worker_disconnected: builtins.bool
    """Tells the subscribers that the stateful worker handling this geometry is
    disconnected.
    """
    received_error: builtins.bool
    """There was an error when processing the request, but the server is still
    alive. Let the clients know about it so that they can update their
    connection state instead of closing the stream with an error.
    """
    def __init__(
        self,
        *,
        geometry_id: builtins.str = ...,
        checkpoint: global___SubscribeGeometryResponse.GeometryCheckpoint | None = ...,
        busy: global___SubscribeGeometryResponse.BusyState | None = ...,
        worker_disconnected: builtins.bool = ...,
        received_error: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["ResponseType", b"ResponseType", "busy", b"busy", "checkpoint", b"checkpoint", "received_error", b"received_error", "worker_disconnected", b"worker_disconnected"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["ResponseType", b"ResponseType", "busy", b"busy", "checkpoint", b"checkpoint", "geometry_id", b"geometry_id", "received_error", b"received_error", "worker_disconnected", b"worker_disconnected"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["ResponseType", b"ResponseType"]) -> typing_extensions.Literal["checkpoint", "busy", "worker_disconnected", "received_error"] | None: ...

global___SubscribeGeometryResponse = SubscribeGeometryResponse

class ModifyGeometryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    MODIFICATION_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    geometry_id: builtins.str
    @property
    def modification(self) -> luminarycloud._proto.geometry.geometry_pb2.Modification: ...
    request_id: builtins.str
    """Optional. Used to deduplicate requests. If it is not set, no deduplication
    attempts will be made. Else, the server will check that no geometry version
    was previously created with this request ID.
    """
    def __init__(
        self,
        *,
        geometry_id: builtins.str = ...,
        modification: luminarycloud._proto.geometry.geometry_pb2.Modification | None = ...,
        request_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["modification", b"modification"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id", "modification", b"modification", "request_id", b"request_id"]) -> None: ...

global___ModifyGeometryRequest = ModifyGeometryRequest

class ModifyGeometryResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEATURES_FIELD_NUMBER: builtins.int
    VOLUMES_FIELD_NUMBER: builtins.int
    FEATURES_ISSUES_FIELD_NUMBER: builtins.int
    @property
    def features(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[luminarycloud._proto.geometry.geometry_pb2.Feature]:
        """The list of currently active features in the geometry, after the requested
        modification was applied. Caller should check features.issues for any
        issues that may affect the feature.
        """
    @property
    def volumes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[luminarycloud._proto.geometry.geometry_pb2.Volume]:
        """The volumes in the geometry, after the requested modification was applied."""
    @property
    def features_issues(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[luminarycloud._proto.geometry.geometry_pb2.FeatureIssues]:
        """Issues associated to features."""
    def __init__(
        self,
        *,
        features: collections.abc.Iterable[luminarycloud._proto.geometry.geometry_pb2.Feature] | None = ...,
        volumes: collections.abc.Iterable[luminarycloud._proto.geometry.geometry_pb2.Volume] | None = ...,
        features_issues: collections.abc.Iterable[luminarycloud._proto.geometry.geometry_pb2.FeatureIssues] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["features", b"features", "features_issues", b"features_issues", "volumes", b"volumes"]) -> None: ...

global___ModifyGeometryResponse = ModifyGeometryResponse

class CreateGeometryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    WEB_GEOMETRY_ID_FIELD_NUMBER: builtins.int
    SCALING_FLOAT_FIELD_NUMBER: builtins.int
    SCALING_FIELD_NUMBER: builtins.int
    WAIT_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """Required. The project to create the new geometry in."""
    name: builtins.str
    """Optional. User specified geometry name, does not need to be unique. Maximum
    allowed length is 256 characters. If omitted, a default name will be used.
    """
    url: builtins.str
    """One of url/web_geometry_id required.
    Url of the source CAD file. File must have been uploaded to the
    same project using the upload APIs, this url can be found in the
    FinishUpload response.
    """
    web_geometry_id: builtins.str
    """One of url/web_geometry_id required.
    Id for web_geometry, such as returned from UploadWebGeometryReply.
    """
    scaling_float: builtins.float
    """One of scaling/scaling_float required. scaling will take priority.
    (deprecated) Scaling of the source CAD file.
    """
    @property
    def scaling(self) -> luminarycloud._proto.base.base_pb2.AdFloatType:
        """One of scaling/scaling_float required. scaling will take priority.
        Scaling of the source CAD file.
        """
    wait: builtins.bool
    """Optional. If set to true, the server will wait for the geometry import to
    complete before sending the response. Otherwise, it will respond
    immediately and the import will occur in the background. Defaults to false.
    """
    request_id: builtins.str
    """Optional. Used to deduplicate requests. If it is not set, no deduplication
    attempts will be made. Else, the server will check that no geometry was
    previously created with this request ID.
    """
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        name: builtins.str = ...,
        url: builtins.str = ...,
        web_geometry_id: builtins.str = ...,
        scaling_float: builtins.float = ...,
        scaling: luminarycloud._proto.base.base_pb2.AdFloatType | None = ...,
        wait: builtins.bool = ...,
        request_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["scaling", b"scaling"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "project_id", b"project_id", "request_id", b"request_id", "scaling", b"scaling", "scaling_float", b"scaling_float", "url", b"url", "wait", b"wait", "web_geometry_id", b"web_geometry_id"]) -> None: ...

global___CreateGeometryRequest = CreateGeometryRequest

class CreateGeometryResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_FIELD_NUMBER: builtins.int
    @property
    def geometry(self) -> global___Geometry: ...
    def __init__(
        self,
        *,
        geometry: global___Geometry | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["geometry", b"geometry"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry", b"geometry"]) -> None: ...

global___CreateGeometryResponse = CreateGeometryResponse

class UpdateGeometryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    geometry_id: builtins.str
    name: builtins.str
    def __init__(
        self,
        *,
        geometry_id: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id", "name", b"name"]) -> None: ...

global___UpdateGeometryRequest = UpdateGeometryRequest

class UpdateGeometryResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_FIELD_NUMBER: builtins.int
    @property
    def geometry(self) -> global___Geometry: ...
    def __init__(
        self,
        *,
        geometry: global___Geometry | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["geometry", b"geometry"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry", b"geometry"]) -> None: ...

global___UpdateGeometryResponse = UpdateGeometryResponse

class CopyGeometryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    geometry_id: builtins.str
    """Required. The ID of the geometry to copy."""
    name: builtins.str
    """Optional. User specified geometry name, does not need to be unique. Maximum
    allowed length is 256 characters. If omitted, a default name will be used.
    """
    request_id: builtins.str
    """Optional. Used to deduplicate requests. If it is not set, no deduplication
    attempts will be made. Else, the server will check that no geometry was
    previously created with this request ID.
    """
    def __init__(
        self,
        *,
        geometry_id: builtins.str = ...,
        name: builtins.str = ...,
        request_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id", "name", b"name", "request_id", b"request_id"]) -> None: ...

global___CopyGeometryRequest = CopyGeometryRequest

class CopyGeometryResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_FIELD_NUMBER: builtins.int
    @property
    def geometry(self) -> global___Geometry: ...
    def __init__(
        self,
        *,
        geometry: global___Geometry | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["geometry", b"geometry"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry", b"geometry"]) -> None: ...

global___CopyGeometryResponse = CopyGeometryResponse

class CopyGeometryFromVersionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_VERSION_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    geometry_version_id: builtins.str
    """Required. The ID of the geometry version to copy."""
    name: builtins.str
    """Optional. User specified geometry name, does not need to be unique. Maximum
    allowed length is 256 characters. If omitted, a default name will be used.
    """
    request_id: builtins.str
    """Optional. Used to deduplicate requests. If it is not set, no deduplication
    attempts will be made. Else, the server will check that no geometry was
    previously created with this request ID.
    """
    def __init__(
        self,
        *,
        geometry_version_id: builtins.str = ...,
        name: builtins.str = ...,
        request_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_version_id", b"geometry_version_id", "name", b"name", "request_id", b"request_id"]) -> None: ...

global___CopyGeometryFromVersionRequest = CopyGeometryFromVersionRequest

class CopyGeometryFromVersionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_FIELD_NUMBER: builtins.int
    @property
    def geometry(self) -> global___Geometry: ...
    def __init__(
        self,
        *,
        geometry: global___Geometry | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["geometry", b"geometry"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry", b"geometry"]) -> None: ...

global___CopyGeometryFromVersionResponse = CopyGeometryFromVersionResponse

class DeleteGeometryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    geometry_id: builtins.str
    """Required. The ID of the geometry to delete."""
    def __init__(
        self,
        *,
        geometry_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id"]) -> None: ...

global___DeleteGeometryRequest = DeleteGeometryRequest

class DeleteGeometryResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteGeometryResponse = DeleteGeometryResponse

class CheckGeometryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    GEOMETRY_VERSION_ID_FIELD_NUMBER: builtins.int
    geometry_id: builtins.str
    """The geometry to check."""
    geometry_version_id: builtins.str
    """Optional. The geometry version ID."""
    def __init__(
        self,
        *,
        geometry_id: builtins.str = ...,
        geometry_version_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id", "geometry_version_id", b"geometry_version_id"]) -> None: ...

global___CheckGeometryRequest = CheckGeometryRequest

class CheckGeometryResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OK_FIELD_NUMBER: builtins.int
    ISSUES_FIELD_NUMBER: builtins.int
    ok: builtins.bool
    """If true, the geometry check operation completed without crashing.
    This doesn't necessarily mean that the geometry is ready for meshing,
    so always inspect issues and resolve any errors.
    """
    @property
    def issues(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of issues with the geometry."""
    def __init__(
        self,
        *,
        ok: builtins.bool = ...,
        issues: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["issues", b"issues", "ok", b"ok"]) -> None: ...

global___CheckGeometryResponse = CheckGeometryResponse

class GetCheckGeometryResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OK_FIELD_NUMBER: builtins.int
    ISSUES_FIELD_NUMBER: builtins.int
    FINISHED_FIELD_NUMBER: builtins.int
    ok: builtins.bool
    """If true, the geometry is ready for meshing (issues may be non-empty and
    contain informational or warning messages).
    If false, the geometry contains errors. Inspect issues and resolve any
    errors.
    """
    @property
    def issues(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of issues with the geometry."""
    finished: builtins.bool
    """Whether the check has finished."""
    def __init__(
        self,
        *,
        ok: builtins.bool = ...,
        issues: collections.abc.Iterable[builtins.str] | None = ...,
        finished: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["finished", b"finished", "issues", b"issues", "ok", b"ok"]) -> None: ...

global___GetCheckGeometryResponse = GetCheckGeometryResponse

class TessellationUpToModificationRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    MODIFICATION_ID_FIELD_NUMBER: builtins.int
    geometry_id: builtins.str
    modification_id: builtins.str
    def __init__(
        self,
        *,
        geometry_id: builtins.str = ...,
        modification_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id", "modification_id", b"modification_id"]) -> None: ...

global___TessellationUpToModificationRequest = TessellationUpToModificationRequest

class TessellationUpToModificationResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TESSEL_URL_FIELD_NUMBER: builtins.int
    tessel_url: builtins.str
    def __init__(
        self,
        *,
        tessel_url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["tessel_url", b"tessel_url"]) -> None: ...

global___TessellationUpToModificationResponse = TessellationUpToModificationResponse

class LatestTessellationRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    geometry_id: builtins.str
    def __init__(
        self,
        *,
        geometry_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id"]) -> None: ...

global___LatestTessellationRequest = LatestTessellationRequest

class LatestTessellationResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TESSELATION_URL_FIELD_NUMBER: builtins.int
    tesselation_url: builtins.str
    def __init__(
        self,
        *,
        tesselation_url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["tesselation_url", b"tesselation_url"]) -> None: ...

global___LatestTessellationResponse = LatestTessellationResponse

class KeepAliveRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    geometry_id: builtins.str
    def __init__(
        self,
        *,
        geometry_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id"]) -> None: ...

global___KeepAliveRequest = KeepAliveRequest

class KeepAliveResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___KeepAliveResponse = KeepAliveResponse

class PanicRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___PanicRequest = PanicRequest

class PanicResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___PanicResponse = PanicResponse

class StopWorkerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    geometry_id: builtins.str
    def __init__(
        self,
        *,
        geometry_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id"]) -> None: ...

global___StopWorkerRequest = StopWorkerRequest

class StopWorkerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___StopWorkerResponse = StopWorkerResponse

class GetTagsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    GEOMETRY_VERSION_ID_FIELD_NUMBER: builtins.int
    geometry_id: builtins.str
    geometry_version_id: builtins.str
    def __init__(
        self,
        *,
        geometry_id: builtins.str = ...,
        geometry_version_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id", "geometry_version_id", b"geometry_version_id"]) -> None: ...

global___GetTagsRequest = GetTagsRequest

class GetTagsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TAGS_FIELD_NUMBER: builtins.int
    @property
    def tags(self) -> luminarycloud._proto.geometry.geometry_pb2.Tags: ...
    def __init__(
        self,
        *,
        tags: luminarycloud._proto.geometry.geometry_pb2.Tags | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["tags", b"tags"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["tags", b"tags"]) -> None: ...

global___GetTagsResponse = GetTagsResponse

class Tag(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    BODIES_FIELD_NUMBER: builtins.int
    VOLUMES_FIELD_NUMBER: builtins.int
    SURFACES_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the tag. Can be used to assign boundary conditions or other entities
    to the tag.
    """
    name: builtins.str
    """Name of the tag. Name is unique among all the tags."""
    @property
    def bodies(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """The IDs of the bodies that are associated with this tag. To be used when
        performing geometrical operations.
        """
    @property
    def volumes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The volume IDs associated with the bodies above. To be used when the user
        wants to unroll the entities within a tag. This list can be used as input
        for volume-like simulation settings such as zone IDs of volume entity
        relationships.
        """
    @property
    def surfaces(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Same as above but for surfaces."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        bodies: collections.abc.Iterable[builtins.int] | None = ...,
        volumes: collections.abc.Iterable[builtins.str] | None = ...,
        surfaces: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bodies", b"bodies", "id", b"id", "name", b"name", "surfaces", b"surfaces", "volumes", b"volumes"]) -> None: ...

global___Tag = Tag

class ListTagsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    GEOMETRY_VERSION_ID_FIELD_NUMBER: builtins.int
    geometry_id: builtins.str
    geometry_version_id: builtins.str
    def __init__(
        self,
        *,
        geometry_id: builtins.str = ...,
        geometry_version_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id", "geometry_version_id", b"geometry_version_id", "parent_resource_id", b"parent_resource_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id", "geometry_version_id", b"geometry_version_id", "parent_resource_id", b"parent_resource_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["parent_resource_id", b"parent_resource_id"]) -> typing_extensions.Literal["geometry_id", "geometry_version_id"] | None: ...

global___ListTagsRequest = ListTagsRequest

class ListTagsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TAGS_FIELD_NUMBER: builtins.int
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Tag]: ...
    def __init__(
        self,
        *,
        tags: collections.abc.Iterable[global___Tag] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["tags", b"tags"]) -> None: ...

global___ListTagsResponse = ListTagsResponse

class ListGeometryVersionsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    UNFILTERED_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    geometry_id: builtins.str
    """Required. The ID of the geometry to list versions for."""
    unfiltered: builtins.bool
    """Optional. By default, the server only returns versions that are named OR have an associated
    Mesh OR are the latest version of the geometry. If `unfiltered` is true, the server returns all
    versions.
    """
    page_size: builtins.int
    """Optional. The maximum number of versions to return. The service may return fewer than this
    value. Default is 50, max is 500. Values above 500 will be clipped to 500.
    """
    page_token: builtins.str
    """A page token, received from a previous `ListGeometryVersions` call.  Provide this to retrieve the
    subsequent page.

    When paginating, all other parameters provided to `ListGeometryVersions` must match the call that
    provided the page token.
    """
    def __init__(
        self,
        *,
        geometry_id: builtins.str = ...,
        unfiltered: builtins.bool = ...,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "page_size", b"page_size", "page_token", b"page_token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "geometry_id", b"geometry_id", "page_size", b"page_size", "page_token", b"page_token", "unfiltered", b"unfiltered"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...

global___ListGeometryVersionsRequest = ListGeometryVersionsRequest

class ListGeometryVersionsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_VERSIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_COUNT_FIELD_NUMBER: builtins.int
    @property
    def geometry_versions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GeometryVersion]:
        """Versions ordered by creation time, oldest first."""
    next_page_token: builtins.str
    """A token that can be used to retrieve the next page of results.
    If empty, there are no more results.
    """
    total_count: builtins.int
    """The total number of versions that match the request parameters."""
    def __init__(
        self,
        *,
        geometry_versions: collections.abc.Iterable[global___GeometryVersion] | None = ...,
        next_page_token: builtins.str = ...,
        total_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_versions", b"geometry_versions", "next_page_token", b"next_page_token", "total_count", b"total_count"]) -> None: ...

global___ListGeometryVersionsResponse = ListGeometryVersionsResponse

class GetGeometryVersionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_VERSION_ID_FIELD_NUMBER: builtins.int
    geometry_version_id: builtins.str
    def __init__(
        self,
        *,
        geometry_version_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_version_id", b"geometry_version_id"]) -> None: ...

global___GetGeometryVersionRequest = GetGeometryVersionRequest

class GetGeometryVersionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_VERSION_FIELD_NUMBER: builtins.int
    @property
    def geometry_version(self) -> global___GeometryVersion: ...
    def __init__(
        self,
        *,
        geometry_version: global___GeometryVersion | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["geometry_version", b"geometry_version"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_version", b"geometry_version"]) -> None: ...

global___GetGeometryVersionResponse = GetGeometryVersionResponse

class UpdateGeometryVersionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_VERSION_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    geometry_version_id: builtins.str
    name: builtins.str
    def __init__(
        self,
        *,
        geometry_version_id: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_version_id", b"geometry_version_id", "name", b"name"]) -> None: ...

global___UpdateGeometryVersionRequest = UpdateGeometryVersionRequest

class UpdateGeometryVersionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_VERSION_FIELD_NUMBER: builtins.int
    @property
    def geometry_version(self) -> global___GeometryVersion: ...
    def __init__(
        self,
        *,
        geometry_version: global___GeometryVersion | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["geometry_version", b"geometry_version"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_version", b"geometry_version"]) -> None: ...

global___UpdateGeometryVersionResponse = UpdateGeometryVersionResponse

class GetSdkCodeRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    GEOMETRY_VERSION_ID_FIELD_NUMBER: builtins.int
    geometry_id: builtins.str
    geometry_version_id: builtins.str
    """Optional. If empty, the latest version of the geometry will be used."""
    def __init__(
        self,
        *,
        geometry_id: builtins.str = ...,
        geometry_version_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id", "geometry_version_id", b"geometry_version_id"]) -> None: ...

global___GetSdkCodeRequest = GetSdkCodeRequest

class GetSdkCodeResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SDK_CODE_FIELD_NUMBER: builtins.int
    sdk_code: builtins.str
    def __init__(
        self,
        *,
        sdk_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["sdk_code", b"sdk_code"]) -> None: ...

global___GetSdkCodeResponse = GetSdkCodeResponse
