"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import luminarycloud._proto.api.v0.luminarycloud.common.common_pb2
import luminarycloud._proto.base.base_pb2
import luminarycloud._proto.cad.shape_pb2
import luminarycloud._proto.hexmesh.hexmesh_pb2
import luminarycloud._proto.upload.upload_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class Mesh(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _MeshStatus:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _MeshStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Mesh._MeshStatus.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MESH_STATUS_UNSPECIFIED: Mesh._MeshStatus.ValueType  # 0
        """A well-formed mesh resource will never have this value."""
        MESH_STATUS_CREATING: Mesh._MeshStatus.ValueType  # 1
        """Mesh is being created."""
        MESH_STATUS_COMPLETED: Mesh._MeshStatus.ValueType  # 2
        """Mesh was created successfully and can be used to create simulations."""
        MESH_STATUS_FAILED: Mesh._MeshStatus.ValueType  # 3
        """Mesh was not created successfully and is unusable."""

    class MeshStatus(_MeshStatus, metaclass=_MeshStatusEnumTypeWrapper): ...
    MESH_STATUS_UNSPECIFIED: Mesh.MeshStatus.ValueType  # 0
    """A well-formed mesh resource will never have this value."""
    MESH_STATUS_CREATING: Mesh.MeshStatus.ValueType  # 1
    """Mesh is being created."""
    MESH_STATUS_COMPLETED: Mesh.MeshStatus.ValueType  # 2
    """Mesh was created successfully and can be used to create simulations."""
    MESH_STATUS_FAILED: Mesh.MeshStatus.ValueType  # 3
    """Mesh was not created successfully and is unusable."""

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    GEOMETRY_VERSION_ID_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The unique identifier for the mesh."""
    name: builtins.str
    """User specified mesh name, does not need to be unique. Maximum
    allowed length is 256 characters.
    """
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Output only. The timestamp when the mesh was created."""
    status: global___Mesh.MeshStatus.ValueType
    """Output only. The current status of the mesh."""
    geometry_version_id: builtins.str
    """The geometry version ID associated with the mesh. May be null if the mesh
    was uploaded by the user.
    """
    project_id: builtins.str
    """The project ID associated with the mesh."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        status: global___Mesh.MeshStatus.ValueType = ...,
        geometry_version_id: builtins.str | None = ...,
        project_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_geometry_version_id", b"_geometry_version_id", "create_time", b"create_time", "geometry_version_id", b"geometry_version_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_geometry_version_id", b"_geometry_version_id", "create_time", b"create_time", "geometry_version_id", b"geometry_version_id", "id", b"id", "name", b"name", "project_id", b"project_id", "status", b"status"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_geometry_version_id", b"_geometry_version_id"]) -> typing_extensions.Literal["geometry_version_id"] | None: ...

global___Mesh = Mesh

class GetMeshRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. Identifies the mesh to retrieve."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___GetMeshRequest = GetMeshRequest

class GetMeshResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESH_FIELD_NUMBER: builtins.int
    @property
    def mesh(self) -> global___Mesh:
        """The requested mesh."""
    def __init__(
        self,
        *,
        mesh: global___Mesh | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["mesh", b"mesh"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["mesh", b"mesh"]) -> None: ...

global___GetMeshResponse = GetMeshResponse

class GetMeshMetadataRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. Identifies the mesh to retrieve."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___GetMeshMetadataRequest = GetMeshMetadataRequest

class GetMeshMetadataResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESH_METADATA_FIELD_NUMBER: builtins.int
    @property
    def mesh_metadata(self) -> global___MeshMetadata:
        """The requested mesh metadata."""
    def __init__(
        self,
        *,
        mesh_metadata: global___MeshMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["mesh_metadata", b"mesh_metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["mesh_metadata", b"mesh_metadata"]) -> None: ...

global___GetMeshMetadataResponse = GetMeshMetadataResponse

class MeshMetadata(google.protobuf.message.Message):
    """Mesh metadata includes the basic mesh statistics and details, including
    mesh zones, zone boundaries, mesh statistics, etc.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class MeshStats(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        N_POINTS_FIELD_NUMBER: builtins.int
        N_FACES_FIELD_NUMBER: builtins.int
        N_CVS_FIELD_NUMBER: builtins.int
        MIN_COORD_FIELD_NUMBER: builtins.int
        MAX_COORD_FIELD_NUMBER: builtins.int
        n_points: builtins.int
        """Number of points."""
        n_faces: builtins.int
        """Number of faces."""
        n_cvs: builtins.int
        """Number of cvs."""
        @property
        def min_coord(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3:
            """Min coordinate in the mesh."""
        @property
        def max_coord(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3:
            """Max coordinate in the mesh."""
        def __init__(
            self,
            *,
            n_points: builtins.int = ...,
            n_faces: builtins.int = ...,
            n_cvs: builtins.int = ...,
            min_coord: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
            max_coord: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["max_coord", b"max_coord", "min_coord", b"min_coord"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["max_coord", b"max_coord", "min_coord", b"min_coord", "n_cvs", b"n_cvs", "n_faces", b"n_faces", "n_points", b"n_points"]) -> None: ...

    class Boundary(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        STATS_FIELD_NUMBER: builtins.int
        name: builtins.str
        """Dataset name prefix of this zone. E.g.: "0/bound/airfoil",
        "1/bound/farfield",
        ...
        """
        @property
        def stats(self) -> global___MeshMetadata.MeshStats:
            """Mesh statistics of the boundary."""
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            stats: global___MeshMetadata.MeshStats | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["stats", b"stats"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "stats", b"stats"]) -> None: ...

    class Zone(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        BOUNDARIES_FIELD_NUMBER: builtins.int
        STATS_FIELD_NUMBER: builtins.int
        NAME_FIELD_NUMBER: builtins.int
        @property
        def boundaries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MeshMetadata.Boundary]:
            """Per-boundary metadata"""
        @property
        def stats(self) -> global___MeshMetadata.MeshStats:
            """Mesh statistics of the zone."""
        name: builtins.str
        """The zone/volume name if it could be inferred from the mesh conversion
        or mesh generation processes. This field may be empty.
        """
        def __init__(
            self,
            *,
            boundaries: collections.abc.Iterable[global___MeshMetadata.Boundary] | None = ...,
            stats: global___MeshMetadata.MeshStats | None = ...,
            name: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["stats", b"stats"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["boundaries", b"boundaries", "name", b"name", "stats", b"stats"]) -> None: ...

    ZONES_FIELD_NUMBER: builtins.int
    @property
    def zones(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MeshMetadata.Zone]:
        """Per-zone metadata."""
    def __init__(
        self,
        *,
        zones: collections.abc.Iterable[global___MeshMetadata.Zone] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["zones", b"zones"]) -> None: ...

global___MeshMetadata = MeshMetadata

class ListMeshesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """Required. The project to list meshes for."""
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["project_id", b"project_id"]) -> None: ...

global___ListMeshesRequest = ListMeshesRequest

class ListMeshesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESHES_FIELD_NUMBER: builtins.int
    @property
    def meshes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Mesh]:
        """The list of meshes belonging to the specified project. Order of meshes is
        unspecified.
        """
    def __init__(
        self,
        *,
        meshes: collections.abc.Iterable[global___Mesh] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["meshes", b"meshes"]) -> None: ...

global___ListMeshesResponse = ListMeshesResponse

class UpdateMeshRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. Identifies the mesh to update."""
    name: builtins.str
    """Required. Updated mesh name does not need to be unique. Maximum allowed
    length is 256 characters.
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "name", b"name"]) -> None: ...

global___UpdateMeshRequest = UpdateMeshRequest

class UpdateMeshResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESH_FIELD_NUMBER: builtins.int
    @property
    def mesh(self) -> global___Mesh:
        """The newly updated mesh."""
    def __init__(
        self,
        *,
        mesh: global___Mesh | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["mesh", b"mesh"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["mesh", b"mesh"]) -> None: ...

global___UpdateMeshResponse = UpdateMeshResponse

class CreateMeshRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    MESH_ADAPTATION_PARAMS_FIELD_NUMBER: builtins.int
    MESH_GENERATION_PARAMS_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """Required. The project that the mesh should be created in."""
    name: builtins.str
    """Optional. User specified mesh name, does not need to be unique. Maximum
    allowed length is 256 characters.
    """
    @property
    def mesh_adaptation_params(self) -> global___MeshAdaptationParams: ...
    @property
    def mesh_generation_params(self) -> global___MeshGenerationParams: ...
    request_id: builtins.str
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        name: builtins.str = ...,
        mesh_adaptation_params: global___MeshAdaptationParams | None = ...,
        mesh_generation_params: global___MeshGenerationParams | None = ...,
        request_id: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_request_id", b"_request_id", "mesh_adaptation_params", b"mesh_adaptation_params", "mesh_generation_params", b"mesh_generation_params", "params", b"params", "request_id", b"request_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_request_id", b"_request_id", "mesh_adaptation_params", b"mesh_adaptation_params", "mesh_generation_params", b"mesh_generation_params", "name", b"name", "params", b"params", "project_id", b"project_id", "request_id", b"request_id"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_request_id", b"_request_id"]) -> typing_extensions.Literal["request_id"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["params", b"params"]) -> typing_extensions.Literal["mesh_adaptation_params", "mesh_generation_params"] | None: ...

global___CreateMeshRequest = CreateMeshRequest

class CreateMeshResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESH_FIELD_NUMBER: builtins.int
    @property
    def mesh(self) -> global___Mesh:
        """The newly created mesh."""
    def __init__(
        self,
        *,
        mesh: global___Mesh | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["mesh", b"mesh"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["mesh", b"mesh"]) -> None: ...

global___CreateMeshResponse = CreateMeshResponse

class UploadMeshRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    SCALING_FIELD_NUMBER: builtins.int
    UPLOAD_TOKEN_FIELD_NUMBER: builtins.int
    FILE_CHUNK_FIELD_NUMBER: builtins.int
    MESH_TYPE_FIELD_NUMBER: builtins.int
    DO_NOT_READ_ZONES_OPENFOAM_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """Required. The project that the mesh should be uploaded to."""
    name: builtins.str
    """Optional. User specified mesh name, does not need to be unique. Maximum
    allowed length is 256 characters.
    """
    scaling: builtins.float
    """Optional. Apply a scaling factor to the mesh. If unset, default is 1.0."""
    upload_token: builtins.str
    """For the first chunk, upload_token should be unset.
    For subsequent chunks, upload_token is required to be set to the
    upload_token value from the preceding UploadMeshResponse.
    """
    @property
    def file_chunk(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.FileChunk:
        """Required. The current data chunk to be upload. file_chunk.metadata will be
        constant across requests for a single mesh upload, but file_chunk.bytes
        should be updated for each chunk.
        """
    mesh_type: luminarycloud._proto.upload.upload_pb2.MeshType.ValueType
    """Required. The type of mesh being uploaded, e.g. CGNS, ANSYS."""
    do_not_read_zones_openfoam: builtins.bool
    """Optional. Set to disable reading cell zones in the polyMesh/cellZones file
    from OpenFOAM. Default false.
    """
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        name: builtins.str = ...,
        scaling: builtins.float = ...,
        upload_token: builtins.str = ...,
        file_chunk: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.FileChunk | None = ...,
        mesh_type: luminarycloud._proto.upload.upload_pb2.MeshType.ValueType = ...,
        do_not_read_zones_openfoam: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["file_chunk", b"file_chunk"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["do_not_read_zones_openfoam", b"do_not_read_zones_openfoam", "file_chunk", b"file_chunk", "mesh_type", b"mesh_type", "name", b"name", "project_id", b"project_id", "scaling", b"scaling", "upload_token", b"upload_token"]) -> None: ...

global___UploadMeshRequest = UploadMeshRequest

class UploadMeshResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESH_FIELD_NUMBER: builtins.int
    UPLOAD_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def mesh(self) -> global___Mesh:
        """The newly uploaded mesh."""
    upload_token: builtins.str
    """The upload_token value is used to group chunks of data belonging to the
    same mesh. It should be passed unmodified in the UploadMeshRequest to
    upload subsequent chunks. If upload_token is empty, it means the server
    considers the mesh upload to be completed and does not expect any more
    chunks to be sent.
    """
    def __init__(
        self,
        *,
        mesh: global___Mesh | None = ...,
        upload_token: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["mesh", b"mesh"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["mesh", b"mesh", "upload_token", b"upload_token"]) -> None: ...

global___UploadMeshResponse = UploadMeshResponse

class DeleteMeshRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. Identifies the mesh to delete."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___DeleteMeshRequest = DeleteMeshRequest

class MeshAdaptationParams(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SOURCE_SIMULATION_ID_FIELD_NUMBER: builtins.int
    TARGET_CV_COUNT_FIELD_NUMBER: builtins.int
    H_RATIO_FIELD_NUMBER: builtins.int
    ASPECT_RATIO_FIELD_NUMBER: builtins.int
    source_simulation_id: builtins.str
    """Required. The simluation ID of a previously completed simulation. The
    source simulation will be used to extract the input mesh and mesh
    adaptation sensor from the solution.
    """
    target_cv_count: builtins.int
    """Required. Target count of mesh CVs."""
    h_ratio: builtins.float
    """Required. Boundary layer scaling. NOTE: will likely be removed before
    this API is release.
    """
    aspect_ratio: builtins.float
    """Required. Cell aspect ratio limit. NOTE: will likely be removed before
    this API is release.
    """
    def __init__(
        self,
        *,
        source_simulation_id: builtins.str = ...,
        target_cv_count: builtins.int = ...,
        h_ratio: builtins.float = ...,
        aspect_ratio: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["aspect_ratio", b"aspect_ratio", "h_ratio", b"h_ratio", "source_simulation_id", b"source_simulation_id", "target_cv_count", b"target_cv_count"]) -> None: ...

global___MeshAdaptationParams = MeshAdaptationParams

class MeshGenerationParams(google.protobuf.message.Message):
    """MeshGenerationParams represents mesh generation parameters
    This proto is used by SDK and UI for mesh generation and will be
    stored into the mesh table.

    IMPORTANT: MeshGenerationParams must be kept in sync with
    proto/meshgeneration/meshgeneration.proto. Also, when updating this proto, we
    need to update all the Golang code that writes/reads MeshGenerationParams from the DB.
    This is needed until the mesh params migration is done, likely as part of
    implementing meshing in the API (LC-13297). See details in LC-16188.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class VolumeParams(google.protobuf.message.Message):
        """Volume meshing parameters"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        MIN_SIZE_FIELD_NUMBER: builtins.int
        MAX_SIZE_FIELD_NUMBER: builtins.int
        VOLUMES_FIELD_NUMBER: builtins.int
        VOLUME_ENTITIES_FIELD_NUMBER: builtins.int
        min_size: builtins.float
        """The minimum mesh element size in meters; should be > 0.0"""
        max_size: builtins.float
        """The maximum mesh element size in meters; should be > 0.0"""
        @property
        def volumes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """Volumes this set of parameters applies to
            Each volume should belong to one and only one instance of VolumeParams
            """
        @property
        def volume_entities(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        def __init__(
            self,
            *,
            min_size: builtins.float = ...,
            max_size: builtins.float = ...,
            volumes: collections.abc.Iterable[builtins.int] | None = ...,
            volume_entities: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["max_size", b"max_size", "min_size", b"min_size", "volume_entities", b"volume_entities", "volumes", b"volumes"]) -> None: ...

    class ModelParams(google.protobuf.message.Message):
        """Model meshing parameters"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CURVATURE_FIELD_NUMBER: builtins.int
        MAX_SIZE_FIELD_NUMBER: builtins.int
        SURFACES_FIELD_NUMBER: builtins.int
        curvature: builtins.float
        """Geometric control of the CAD edges and faces in degrees; should be > 0.0."""
        max_size: builtins.float
        """The maximum mesh element size in meters for elements that are part of the model; should be > 0.0."""
        @property
        def surfaces(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """Surfaces this set of parameters applies to. Each surface should belong to
            one and only one instance of ModelParams.
            """
        def __init__(
            self,
            *,
            curvature: builtins.float = ...,
            max_size: builtins.float = ...,
            surfaces: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["curvature", b"curvature", "max_size", b"max_size", "surfaces", b"surfaces"]) -> None: ...

    class BoundaryLayerParams(google.protobuf.message.Message):
        """Boundary layer meshing parameters"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        N_LAYERS_FIELD_NUMBER: builtins.int
        INITIAL_SIZE_FIELD_NUMBER: builtins.int
        GROWTH_RATE_FIELD_NUMBER: builtins.int
        SURFACES_FIELD_NUMBER: builtins.int
        n_layers: builtins.int
        """Maximum number of layers within a boundary layer mesh; should be > 0."""
        initial_size: builtins.float
        """Size of the mesh layer nearest the boundary surface in meters; should be > 0.0"""
        growth_rate: builtins.float
        """Ratio of size between 2 successive boundary mesh layers; should be >= 1.0."""
        @property
        def surfaces(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """Surfaces this set of parameters applies to. Each surface should belong to
            one and only instance of BoundaryLayerParams.
            """
        def __init__(
            self,
            *,
            n_layers: builtins.int = ...,
            initial_size: builtins.float = ...,
            growth_rate: builtins.float = ...,
            surfaces: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["growth_rate", b"growth_rate", "initial_size", b"initial_size", "n_layers", b"n_layers", "surfaces", b"surfaces"]) -> None: ...

    class RefinementRegionParams(google.protobuf.message.Message):
        """Refinement region parameters"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        H_LIMIT_FIELD_NUMBER: builtins.int
        SPHERE_FIELD_NUMBER: builtins.int
        SPHERE_SHELL_FIELD_NUMBER: builtins.int
        CUBE_FIELD_NUMBER: builtins.int
        ORIENTED_CUBE_FIELD_NUMBER: builtins.int
        CYLINDER_FIELD_NUMBER: builtins.int
        ANNULAR_CYLINDER_FIELD_NUMBER: builtins.int
        ID_FIELD_NUMBER: builtins.int
        NAME_FIELD_NUMBER: builtins.int
        h_limit: builtins.float
        """length scale limit in refinement region in meters"""
        @property
        def sphere(self) -> luminarycloud._proto.cad.shape_pb2.Sphere: ...
        @property
        def sphere_shell(self) -> luminarycloud._proto.cad.shape_pb2.SphereShell: ...
        @property
        def cube(self) -> luminarycloud._proto.cad.shape_pb2.Cube: ...
        @property
        def oriented_cube(self) -> luminarycloud._proto.cad.shape_pb2.OrientedCube: ...
        @property
        def cylinder(self) -> luminarycloud._proto.cad.shape_pb2.Cylinder: ...
        @property
        def annular_cylinder(self) -> luminarycloud._proto.cad.shape_pb2.AnnularCylinder: ...
        id: builtins.str
        """The id of the refinement region to be used when visualizing the regions"""
        name: builtins.str
        """the user-defined name of the region"""
        def __init__(
            self,
            *,
            h_limit: builtins.float = ...,
            sphere: luminarycloud._proto.cad.shape_pb2.Sphere | None = ...,
            sphere_shell: luminarycloud._proto.cad.shape_pb2.SphereShell | None = ...,
            cube: luminarycloud._proto.cad.shape_pb2.Cube | None = ...,
            oriented_cube: luminarycloud._proto.cad.shape_pb2.OrientedCube | None = ...,
            cylinder: luminarycloud._proto.cad.shape_pb2.Cylinder | None = ...,
            annular_cylinder: luminarycloud._proto.cad.shape_pb2.AnnularCylinder | None = ...,
            id: builtins.str = ...,
            name: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["annular_cylinder", b"annular_cylinder", "cube", b"cube", "cylinder", b"cylinder", "oriented_cube", b"oriented_cube", "shape", b"shape", "sphere", b"sphere", "sphere_shell", b"sphere_shell"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["annular_cylinder", b"annular_cylinder", "cube", b"cube", "cylinder", b"cylinder", "h_limit", b"h_limit", "id", b"id", "name", b"name", "oriented_cube", b"oriented_cube", "shape", b"shape", "sphere", b"sphere", "sphere_shell", b"sphere_shell"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["shape", b"shape"]) -> typing_extensions.Literal["sphere", "sphere_shell", "cube", "oriented_cube", "cylinder", "annular_cylinder"] | None: ...

    class MeshComplexityParams(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _ComplexityType:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _ComplexityTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MeshGenerationParams.MeshComplexityParams._ComplexityType.ValueType], builtins.type):  # noqa: F821
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            MAX: MeshGenerationParams.MeshComplexityParams._ComplexityType.ValueType  # 0
            """corresponds to "mesh scaled only if mesh is larger than given target" """
            TARGET: MeshGenerationParams.MeshComplexityParams._ComplexityType.ValueType  # 1
            """corresponds to "mesh scaled to match target" """
            MIN: MeshGenerationParams.MeshComplexityParams._ComplexityType.ValueType  # 2
            """corresponds to generating a minimal mesh, when blmesh's MeshingMode is
            set to "BASE" (also duplicated in MeshingMultiPart.MeshingMode)
            """

        class ComplexityType(_ComplexityType, metaclass=_ComplexityTypeEnumTypeWrapper):
            """Which of the values are we using to define complexity. TARGET means
            target_cells is being used and the limit_max_cells should be 0. This is
            used to see the radio button in the UI.
            """

        MAX: MeshGenerationParams.MeshComplexityParams.ComplexityType.ValueType  # 0
        """corresponds to "mesh scaled only if mesh is larger than given target" """
        TARGET: MeshGenerationParams.MeshComplexityParams.ComplexityType.ValueType  # 1
        """corresponds to "mesh scaled to match target" """
        MIN: MeshGenerationParams.MeshComplexityParams.ComplexityType.ValueType  # 2
        """corresponds to generating a minimal mesh, when blmesh's MeshingMode is
        set to "BASE" (also duplicated in MeshingMultiPart.MeshingMode)
        """

        TARGET_CELLS_FIELD_NUMBER: builtins.int
        LIMIT_MAX_CELLS_FIELD_NUMBER: builtins.int
        TYPE_FIELD_NUMBER: builtins.int
        target_cells: builtins.int
        """Mesh scaled to match target"""
        limit_max_cells: builtins.int
        """Mesh scaled only if mesh is larger than given target"""
        type: global___MeshGenerationParams.MeshComplexityParams.ComplexityType.ValueType
        def __init__(
            self,
            *,
            target_cells: builtins.int = ...,
            limit_max_cells: builtins.int = ...,
            type: global___MeshGenerationParams.MeshComplexityParams.ComplexityType.ValueType = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["limit_max_cells", b"limit_max_cells", "target_cells", b"target_cells", "type", b"type"]) -> None: ...

    class OversetParams(google.protobuf.message.Message):
        """Overset meshing parameters"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SURFACES_FIELD_NUMBER: builtins.int
        @property
        def surfaces(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """Surfaces on overset boundaries
            [(options.is_geometry_reference) = true, (options.is_geometry_surfaces) = true]
            """
        def __init__(
            self,
            *,
            surfaces: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["surfaces", b"surfaces"]) -> None: ...

    class MeshingMode(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class Default(google.protobuf.message.Message):
            """Additional parameters for default meshing mode"""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            def __init__(
                self,
            ) -> None: ...

        class Base(google.protobuf.message.Message):
            """Additional parameters for base meshing mode"""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            def __init__(
                self,
            ) -> None: ...

        DEFAULT_FIELD_NUMBER: builtins.int
        BASE_FIELD_NUMBER: builtins.int
        @property
        def default(self) -> global___MeshGenerationParams.MeshingMode.Default: ...
        @property
        def base(self) -> global___MeshGenerationParams.MeshingMode.Base: ...
        def __init__(
            self,
            *,
            default: global___MeshGenerationParams.MeshingMode.Default | None = ...,
            base: global___MeshGenerationParams.MeshingMode.Base | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["base", b"base", "default", b"default", "mode", b"mode"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["base", b"base", "default", b"default", "mode", b"mode"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["mode", b"mode"]) -> typing_extensions.Literal["default", "base"] | None: ...

    BODY_X_AXIS_FIELD_NUMBER: builtins.int
    BODY_Y_AXIS_FIELD_NUMBER: builtins.int
    ADD_REFINEMENT_FIELD_NUMBER: builtins.int
    PROXIMITY_LAYERS_FIELD_NUMBER: builtins.int
    VOLUME_PARAMS_FIELD_NUMBER: builtins.int
    MODEL_PARAMS_FIELD_NUMBER: builtins.int
    BL_PARAMS_FIELD_NUMBER: builtins.int
    REFINE_PARAMS_FIELD_NUMBER: builtins.int
    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    MESH_COMPLEXITY_PARAMS_FIELD_NUMBER: builtins.int
    OVERSET_PARAMS_FIELD_NUMBER: builtins.int
    MESHING_MODE_FIELD_NUMBER: builtins.int
    USE_WRAP_FIELD_NUMBER: builtins.int
    @property
    def body_x_axis(self) -> luminarycloud._proto.base.base_pb2.AdVector3:
        """Body x-axis (used for refinement boxes)"""
    @property
    def body_y_axis(self) -> luminarycloud._proto.base.base_pb2.AdVector3:
        """Body y-axis (used for refinement boxes)"""
    add_refinement: builtins.bool
    """Whether to automatically add refinement boxes"""
    proximity_layers: builtins.int
    """Number of proximity layers"""
    @property
    def volume_params(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MeshGenerationParams.VolumeParams]:
        """Per-volume parameters"""
    @property
    def model_params(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MeshGenerationParams.ModelParams]:
        """Per-model parameters"""
    @property
    def bl_params(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MeshGenerationParams.BoundaryLayerParams]:
        """Per-BL parameters"""
    @property
    def refine_params(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MeshGenerationParams.RefinementRegionParams]:
        """Per-refinement region params"""
    geometry_id: builtins.str
    """The ID of the geometry to generate a mesh for."""
    @property
    def mesh_complexity_params(self) -> global___MeshGenerationParams.MeshComplexityParams: ...
    @property
    def overset_params(self) -> global___MeshGenerationParams.OversetParams: ...
    @property
    def meshing_mode(self) -> global___MeshGenerationParams.MeshingMode: ...
    use_wrap: builtins.bool
    def __init__(
        self,
        *,
        body_x_axis: luminarycloud._proto.base.base_pb2.AdVector3 | None = ...,
        body_y_axis: luminarycloud._proto.base.base_pb2.AdVector3 | None = ...,
        add_refinement: builtins.bool = ...,
        proximity_layers: builtins.int = ...,
        volume_params: collections.abc.Iterable[global___MeshGenerationParams.VolumeParams] | None = ...,
        model_params: collections.abc.Iterable[global___MeshGenerationParams.ModelParams] | None = ...,
        bl_params: collections.abc.Iterable[global___MeshGenerationParams.BoundaryLayerParams] | None = ...,
        refine_params: collections.abc.Iterable[global___MeshGenerationParams.RefinementRegionParams] | None = ...,
        geometry_id: builtins.str = ...,
        mesh_complexity_params: global___MeshGenerationParams.MeshComplexityParams | None = ...,
        overset_params: global___MeshGenerationParams.OversetParams | None = ...,
        meshing_mode: global___MeshGenerationParams.MeshingMode | None = ...,
        use_wrap: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["body_x_axis", b"body_x_axis", "body_y_axis", b"body_y_axis", "mesh_complexity_params", b"mesh_complexity_params", "meshing_mode", b"meshing_mode", "overset_params", b"overset_params"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["add_refinement", b"add_refinement", "bl_params", b"bl_params", "body_x_axis", b"body_x_axis", "body_y_axis", b"body_y_axis", "geometry_id", b"geometry_id", "mesh_complexity_params", b"mesh_complexity_params", "meshing_mode", b"meshing_mode", "model_params", b"model_params", "overset_params", b"overset_params", "proximity_layers", b"proximity_layers", "refine_params", b"refine_params", "use_wrap", b"use_wrap", "volume_params", b"volume_params"]) -> None: ...

global___MeshGenerationParams = MeshGenerationParams

class CreateHexMeshRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    HEX_MESH_CONFIG_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    @property
    def hex_mesh_config(self) -> luminarycloud._proto.hexmesh.hexmesh_pb2.HexMeshSpec: ...
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        hex_mesh_config: luminarycloud._proto.hexmesh.hexmesh_pb2.HexMeshSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["hex_mesh_config", b"hex_mesh_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["hex_mesh_config", b"hex_mesh_config", "project_id", b"project_id"]) -> None: ...

global___CreateHexMeshRequest = CreateHexMeshRequest

class CreateHexMeshResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESH_ID_FIELD_NUMBER: builtins.int
    mesh_id: builtins.str
    def __init__(
        self,
        *,
        mesh_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["mesh_id", b"mesh_id"]) -> None: ...

global___CreateHexMeshResponse = CreateHexMeshResponse

class GetMeshGenerationSdkCodeRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. Identifies the mesh to generate SDK code for."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___GetMeshGenerationSdkCodeRequest = GetMeshGenerationSdkCodeRequest

class GetMeshGenerationSdkCodeResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SDK_CODE_FIELD_NUMBER: builtins.int
    sdk_code: builtins.str
    """The generated SDK code that can recreate this mesh."""
    def __init__(
        self,
        *,
        sdk_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["sdk_code", b"sdk_code"]) -> None: ...

global___GetMeshGenerationSdkCodeResponse = GetMeshGenerationSdkCodeResponse
