"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import luminarycloud._proto.api.v0.luminarycloud.common.common_pb2
import luminarycloud._proto.base.base_pb2
import luminarycloud._proto.quantity.quantity_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _PhysicsAiLifecycleState:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PhysicsAiLifecycleStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PhysicsAiLifecycleState.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    LIFECYCLE_STATE_UNSPECIFIED: _PhysicsAiLifecycleState.ValueType  # 0
    """Default value, should not be used in practice."""
    LIFECYCLE_STATE_DEVELOPMENT: _PhysicsAiLifecycleState.ValueType  # 1
    """Not ready for general use."""
    LIFECYCLE_STATE_ACTIVE: _PhysicsAiLifecycleState.ValueType  # 2
    """Available for new training jobs."""
    LIFECYCLE_STATE_DEPRECATED: _PhysicsAiLifecycleState.ValueType  # 3
    """Can still serve inference, but not used for new training."""
    LIFECYCLE_STATE_RETIRED: _PhysicsAiLifecycleState.ValueType  # 4
    """Archived; no training or inference support."""

class PhysicsAiLifecycleState(_PhysicsAiLifecycleState, metaclass=_PhysicsAiLifecycleStateEnumTypeWrapper):
    """Lifecycle state of a Physics AI resource (architecture or model version)."""

LIFECYCLE_STATE_UNSPECIFIED: PhysicsAiLifecycleState.ValueType  # 0
"""Default value, should not be used in practice."""
LIFECYCLE_STATE_DEVELOPMENT: PhysicsAiLifecycleState.ValueType  # 1
"""Not ready for general use."""
LIFECYCLE_STATE_ACTIVE: PhysicsAiLifecycleState.ValueType  # 2
"""Available for new training jobs."""
LIFECYCLE_STATE_DEPRECATED: PhysicsAiLifecycleState.ValueType  # 3
"""Can still serve inference, but not used for new training."""
LIFECYCLE_STATE_RETIRED: PhysicsAiLifecycleState.ValueType  # 4
"""Archived; no training or inference support."""
global___PhysicsAiLifecycleState = PhysicsAiLifecycleState

class _TrainingDataSourceType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _TrainingDataSourceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_TrainingDataSourceType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TRAINING_DATA_SOURCE_TYPE_UNSPECIFIED: _TrainingDataSourceType.ValueType  # 0
    """Default value, should not be used in practice."""
    TRAINING_DATA_SOURCE_TYPE_SIMULATION_SOLUTIONS: _TrainingDataSourceType.ValueType  # 1
    """Training data from simulation solutions."""
    TRAINING_DATA_SOURCE_TYPE_EXTERNAL_DATASET: _TrainingDataSourceType.ValueType  # 2
    """Training data from external dataset."""

class TrainingDataSourceType(_TrainingDataSourceType, metaclass=_TrainingDataSourceTypeEnumTypeWrapper):
    """Training data source types"""

TRAINING_DATA_SOURCE_TYPE_UNSPECIFIED: TrainingDataSourceType.ValueType  # 0
"""Default value, should not be used in practice."""
TRAINING_DATA_SOURCE_TYPE_SIMULATION_SOLUTIONS: TrainingDataSourceType.ValueType  # 1
"""Training data from simulation solutions."""
TRAINING_DATA_SOURCE_TYPE_EXTERNAL_DATASET: TrainingDataSourceType.ValueType  # 2
"""Training data from external dataset."""
global___TrainingDataSourceType = TrainingDataSourceType

class _ModelInitializationType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ModelInitializationTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ModelInitializationType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    MODEL_INITIALIZATION_TYPE_UNSPECIFIED: _ModelInitializationType.ValueType  # 0
    """Default value, should not be used in practice."""
    MODEL_INITIALIZATION_TYPE_RANDOM: _ModelInitializationType.ValueType  # 1
    """Random initialization."""
    MODEL_INITIALIZATION_TYPE_MODEL_VERSION: _ModelInitializationType.ValueType  # 2
    """Initialize from existing model version."""
    MODEL_INITIALIZATION_TYPE_CHECKPOINT: _ModelInitializationType.ValueType  # 3
    """Initialize from checkpoint."""

class ModelInitializationType(_ModelInitializationType, metaclass=_ModelInitializationTypeEnumTypeWrapper):
    """Model initialization types"""

MODEL_INITIALIZATION_TYPE_UNSPECIFIED: ModelInitializationType.ValueType  # 0
"""Default value, should not be used in practice."""
MODEL_INITIALIZATION_TYPE_RANDOM: ModelInitializationType.ValueType  # 1
"""Random initialization."""
MODEL_INITIALIZATION_TYPE_MODEL_VERSION: ModelInitializationType.ValueType  # 2
"""Initialize from existing model version."""
MODEL_INITIALIZATION_TYPE_CHECKPOINT: ModelInitializationType.ValueType  # 3
"""Initialize from checkpoint."""
global___ModelInitializationType = ModelInitializationType

class PhysicsAiArchitectureVersion(google.protobuf.message.Message):
    """A physics ai architecture version."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CHANGELOG_FIELD_NUMBER: builtins.int
    LIFECYCLE_STATE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier for the architecture version."""
    name: builtins.str
    """Name of the architecture version."""
    changelog: builtins.str
    """Changelog for this version."""
    lifecycle_state: global___PhysicsAiLifecycleState.ValueType
    """Lifecycle state of the architecture version."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        changelog: builtins.str = ...,
        lifecycle_state: global___PhysicsAiLifecycleState.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["changelog", b"changelog", "id", b"id", "lifecycle_state", b"lifecycle_state", "name", b"name"]) -> None: ...

global___PhysicsAiArchitectureVersion = PhysicsAiArchitectureVersion

class PhysicsAiArchitecture(google.protobuf.message.Message):
    """A physics ai architecture."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    VERSIONS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier for the architecture."""
    name: builtins.str
    """Name of the architecture."""
    description: builtins.str
    """Description of the architecture."""
    @property
    def versions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PhysicsAiArchitectureVersion]:
        """All versions of this architecture."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        versions: collections.abc.Iterable[global___PhysicsAiArchitectureVersion] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "id", b"id", "name", b"name", "versions", b"versions"]) -> None: ...

global___PhysicsAiArchitecture = PhysicsAiArchitecture

class ListArchitecturesRequest(google.protobuf.message.Message):
    """Request message for listing physics ai architectures.
    Empty request since we don't use pagination
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ListArchitecturesRequest = ListArchitecturesRequest

class ListArchitecturesResponse(google.protobuf.message.Message):
    """Response message for listing physics ai architectures."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ARCHITECTURES_FIELD_NUMBER: builtins.int
    @property
    def architectures(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PhysicsAiArchitecture]:
        """List of physics ai architectures."""
    def __init__(
        self,
        *,
        architectures: collections.abc.Iterable[global___PhysicsAiArchitecture] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["architectures", b"architectures"]) -> None: ...

global___ListArchitecturesResponse = ListArchitecturesResponse

class PhysicsAiModelVersion(google.protobuf.message.Message):
    """A physics ai model version."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    LIFECYCLE_STATE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier for the model version."""
    name: builtins.str
    """Name of the model version."""
    lifecycle_state: global___PhysicsAiLifecycleState.ValueType
    """Lifecycle state of the model version."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        lifecycle_state: global___PhysicsAiLifecycleState.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "lifecycle_state", b"lifecycle_state", "name", b"name"]) -> None: ...

global___PhysicsAiModelVersion = PhysicsAiModelVersion

class PhysicsAiModel(google.protobuf.message.Message):
    """A physics ai model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    VERSIONS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier for the model."""
    name: builtins.str
    """Name of the model."""
    description: builtins.str
    """Description of the model."""
    @property
    def versions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PhysicsAiModelVersion]:
        """All versions of this model."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        versions: collections.abc.Iterable[global___PhysicsAiModelVersion] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "id", b"id", "name", b"name", "versions", b"versions"]) -> None: ...

global___PhysicsAiModel = PhysicsAiModel

class ListPretrainedModelsRequest(google.protobuf.message.Message):
    """Request message for listing physics ai models.
    Empty request since we don't use pagination
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ListPretrainedModelsRequest = ListPretrainedModelsRequest

class ListPretrainedModelsResponse(google.protobuf.message.Message):
    """Response message for listing physics ai models."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODELS_FIELD_NUMBER: builtins.int
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PhysicsAiModel]:
        """List of physics ai models."""
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[global___PhysicsAiModel] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["models", b"models"]) -> None: ...

global___ListPretrainedModelsResponse = ListPretrainedModelsResponse

class GetSolutionDataPhysicsAIRequest(google.protobuf.message.Message):
    """Request message for download and process solutions for physics ai"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SOLUTION_ID_FIELD_NUMBER: builtins.int
    EXCLUDE_SURFACES_FIELD_NUMBER: builtins.int
    FILL_HOLES_FIELD_NUMBER: builtins.int
    SURFACE_FIELDS_TO_KEEP_FIELD_NUMBER: builtins.int
    VOLUME_FIELDS_TO_KEEP_FIELD_NUMBER: builtins.int
    PROCESS_VOLUME_FIELD_NUMBER: builtins.int
    SINGLE_PRECISION_FIELD_NUMBER: builtins.int
    solution_id: builtins.str
    """Required. The globally unique identifier for the solution."""
    @property
    def exclude_surfaces(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of surfaces to exclude from surface solution during physics AI processing"""
    fill_holes: builtins.float
    """Size threshold for filling holes in the surface mesh (0 or negative value means no filling)"""
    @property
    def surface_fields_to_keep(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[luminarycloud._proto.quantity.quantity_pb2.QuantityType.ValueType]:
        """List of surface fields to keep (all others will be removed). If left empty, all fields are kept."""
    @property
    def volume_fields_to_keep(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[luminarycloud._proto.quantity.quantity_pb2.QuantityType.ValueType]:
        """List of volume fields to keep (all others will be removed). If left empty, all fields are kept."""
    process_volume: builtins.bool
    """Whether to process volume meshes during physics AI processing"""
    single_precision: builtins.bool
    """Whether to export the floating point fields in single precision"""
    def __init__(
        self,
        *,
        solution_id: builtins.str = ...,
        exclude_surfaces: collections.abc.Iterable[builtins.str] | None = ...,
        fill_holes: builtins.float = ...,
        surface_fields_to_keep: collections.abc.Iterable[luminarycloud._proto.quantity.quantity_pb2.QuantityType.ValueType] | None = ...,
        volume_fields_to_keep: collections.abc.Iterable[luminarycloud._proto.quantity.quantity_pb2.QuantityType.ValueType] | None = ...,
        process_volume: builtins.bool = ...,
        single_precision: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["exclude_surfaces", b"exclude_surfaces", "fill_holes", b"fill_holes", "process_volume", b"process_volume", "single_precision", b"single_precision", "solution_id", b"solution_id", "surface_fields_to_keep", b"surface_fields_to_keep", "volume_fields_to_keep", b"volume_fields_to_keep"]) -> None: ...

global___GetSolutionDataPhysicsAIRequest = GetSolutionDataPhysicsAIRequest

class GetSolutionDataPhysicsAIResponse(google.protobuf.message.Message):
    """Response message for download and process solutions for physics ai"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_FIELD_NUMBER: builtins.int
    @property
    def file(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File:
        """The processed solution data. Either a signed URL or a file ID."""
    def __init__(
        self,
        *,
        file: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["file", b"file"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["file", b"file"]) -> None: ...

global___GetSolutionDataPhysicsAIResponse = GetSolutionDataPhysicsAIResponse

class TrainingSolution(google.protobuf.message.Message):
    """A training solution specification"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SOLUTION_ID_FIELD_NUMBER: builtins.int
    DATA_SPLIT_FIELD_NUMBER: builtins.int
    solution_id: builtins.str
    """Solution ID to use for training."""
    data_split: builtins.str
    """Data split for this solution (train, validation, test)."""
    def __init__(
        self,
        *,
        solution_id: builtins.str = ...,
        data_split: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data_split", b"data_split", "solution_id", b"solution_id"]) -> None: ...

global___TrainingSolution = TrainingSolution

class PhysicsAiTrainingJob(google.protobuf.message.Message):
    """A Physics AI training job"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    ARCHITECTURE_VERSION_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    TRAINING_CONFIG_FIELD_NUMBER: builtins.int
    TRAINING_DATA_SOURCE_TYPE_FIELD_NUMBER: builtins.int
    TRAINING_DESCRIPTION_FIELD_NUMBER: builtins.int
    EXTERNAL_DATASET_URI_FIELD_NUMBER: builtins.int
    INITIALIZATION_TYPE_FIELD_NUMBER: builtins.int
    BASE_MODEL_VERSION_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    OUTPUT_MODEL_VERSION_ID_FIELD_NUMBER: builtins.int
    CREATION_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    COMPLETION_TIME_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier for the training job."""
    architecture_version_id: builtins.str
    """Architecture version ID being trained."""
    user_id: builtins.str
    """User ID who submitted the job."""
    training_config: builtins.str
    """Training configuration as JSON."""
    training_data_source_type: global___TrainingDataSourceType.ValueType
    """Type of training data source."""
    training_description: builtins.str
    """Description of the training job. (mutable)"""
    external_dataset_uri: builtins.str
    """External dataset URI (if using external dataset)."""
    initialization_type: global___ModelInitializationType.ValueType
    """Model initialization type."""
    base_model_version_id: builtins.str
    """Base model version ID (if initializing from existing model)."""
    @property
    def status(self) -> luminarycloud._proto.base.base_pb2.JobStatus:
        """Current status of the training job. (mutable)"""
    error_message: builtins.str
    """Error message (if failed)."""
    output_model_version_id: builtins.str
    """Output model version ID (if completed, so mutable)."""
    @property
    def creation_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Job creation time."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Job last update time, updated when status changes. (mutable)"""
    @property
    def completion_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Job completion time, set upon job completion. (mutable)"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        architecture_version_id: builtins.str = ...,
        user_id: builtins.str = ...,
        training_config: builtins.str = ...,
        training_data_source_type: global___TrainingDataSourceType.ValueType = ...,
        training_description: builtins.str = ...,
        external_dataset_uri: builtins.str = ...,
        initialization_type: global___ModelInitializationType.ValueType = ...,
        base_model_version_id: builtins.str = ...,
        status: luminarycloud._proto.base.base_pb2.JobStatus | None = ...,
        error_message: builtins.str = ...,
        output_model_version_id: builtins.str = ...,
        creation_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        completion_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["completion_time", b"completion_time", "creation_time", b"creation_time", "status", b"status", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["architecture_version_id", b"architecture_version_id", "base_model_version_id", b"base_model_version_id", "completion_time", b"completion_time", "creation_time", b"creation_time", "error_message", b"error_message", "external_dataset_uri", b"external_dataset_uri", "id", b"id", "initialization_type", b"initialization_type", "output_model_version_id", b"output_model_version_id", "status", b"status", "training_config", b"training_config", "training_data_source_type", b"training_data_source_type", "training_description", b"training_description", "update_time", b"update_time", "user_id", b"user_id"]) -> None: ...

global___PhysicsAiTrainingJob = PhysicsAiTrainingJob

class SubmitTrainingJobRequest(google.protobuf.message.Message):
    """Request message for submitting a training job"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ARCHITECTURE_VERSION_ID_FIELD_NUMBER: builtins.int
    TRAINING_DESCRIPTION_FIELD_NUMBER: builtins.int
    EXTERNAL_DATASET_URI_FIELD_NUMBER: builtins.int
    TRAINING_SOLUTIONS_FIELD_NUMBER: builtins.int
    TRAINING_CONFIG_FIELD_NUMBER: builtins.int
    INITIALIZATION_TYPE_FIELD_NUMBER: builtins.int
    BASE_MODEL_VERSION_ID_FIELD_NUMBER: builtins.int
    architecture_version_id: builtins.str
    """Architecture version ID to train."""
    training_description: builtins.str
    """Description of the training job."""
    external_dataset_uri: builtins.str
    """External dataset URI"""
    @property
    def training_solutions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TrainingSolution]:
        """Training solutions"""
    training_config: builtins.str
    """Training configuration in JSON format."""
    initialization_type: global___ModelInitializationType.ValueType
    """Model initialization type."""
    base_model_version_id: builtins.str
    """Base model version ID (if initializing from existing model)."""
    def __init__(
        self,
        *,
        architecture_version_id: builtins.str = ...,
        training_description: builtins.str = ...,
        external_dataset_uri: builtins.str = ...,
        training_solutions: collections.abc.Iterable[global___TrainingSolution] | None = ...,
        training_config: builtins.str = ...,
        initialization_type: global___ModelInitializationType.ValueType = ...,
        base_model_version_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["architecture_version_id", b"architecture_version_id", "base_model_version_id", b"base_model_version_id", "external_dataset_uri", b"external_dataset_uri", "initialization_type", b"initialization_type", "training_config", b"training_config", "training_description", b"training_description", "training_solutions", b"training_solutions"]) -> None: ...

global___SubmitTrainingJobRequest = SubmitTrainingJobRequest

class SubmitTrainingJobResponse(google.protobuf.message.Message):
    """Response message for submitting a training job"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRAINING_JOB_FIELD_NUMBER: builtins.int
    @property
    def training_job(self) -> global___PhysicsAiTrainingJob:
        """The created training job."""
    def __init__(
        self,
        *,
        training_job: global___PhysicsAiTrainingJob | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["training_job", b"training_job"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["training_job", b"training_job"]) -> None: ...

global___SubmitTrainingJobResponse = SubmitTrainingJobResponse
