"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class Project(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    MESHES_FIELD_NUMBER: builtins.int
    SIMULATIONS_FIELD_NUMBER: builtins.int
    STORAGE_USAGE_BYTES_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The unique identifier for the project."""
    name: builtins.str
    """Required. User specified project name, does not need to be unique. Maximum
    allowed length is 256 characters.
    """
    description: builtins.str
    """User specified project description. Maximum allowed length is 4096
    characters.
    """
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Output only. The timestamp when the project was created."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Output only. The timestamp when the project was most recently updated."""
    @property
    def meshes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The mesh IDs associated with this project."""
    @property
    def simulations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The simulation IDs associated with this project."""
    storage_usage_bytes: builtins.int
    """Output only.  The number of bytes of storage used by this project.
    This field is not guaranteed to be 100% up-to-date.
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        meshes: collections.abc.Iterable[builtins.str] | None = ...,
        simulations: collections.abc.Iterable[builtins.str] | None = ...,
        storage_usage_bytes: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "description", b"description", "id", b"id", "meshes", b"meshes", "name", b"name", "simulations", b"simulations", "storage_usage_bytes", b"storage_usage_bytes", "update_time", b"update_time"]) -> None: ...

global___Project = Project

class CreateProjectRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Required. User specified project name, does not need to be unique. Maximum
    allowed length is 256 characters.
    """
    description: builtins.str
    """User specified project description. Maximum allowed length is 4096
    characters.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "name", b"name"]) -> None: ...

global___CreateProjectRequest = CreateProjectRequest

class CreateProjectResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_FIELD_NUMBER: builtins.int
    @property
    def project(self) -> global___Project:
        """The newly created project."""
    def __init__(
        self,
        *,
        project: global___Project | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["project", b"project"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["project", b"project"]) -> None: ...

global___CreateProjectResponse = CreateProjectResponse

class GetProjectRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. Identifies the project to retrieve."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___GetProjectRequest = GetProjectRequest

class GetProjectResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_FIELD_NUMBER: builtins.int
    @property
    def project(self) -> global___Project:
        """The requested project."""
    def __init__(
        self,
        *,
        project: global___Project | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["project", b"project"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["project", b"project"]) -> None: ...

global___GetProjectResponse = GetProjectResponse

class ListProjectsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """Optional. The maximum number of projects to return. The service may return fewer than this
    value. Default is 50, max is 500. Values above 500 will be clipped to 500.
    """
    page_token: builtins.str
    """A page token, received from a previous `ListProjects` call.  Provide this to retrieve the
    subsequent page.

    When paginating, all other parameters provided to `ListProjects` must match the call that
    provided the page token.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "page_size", b"page_size", "page_token", b"page_token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...

global___ListProjectsRequest = ListProjectsRequest

class ListProjectsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECTS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_COUNT_FIELD_NUMBER: builtins.int
    @property
    def projects(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Project]:
        """Projects ordered by creation time, most recent first."""
    next_page_token: builtins.str
    """A token that can be used to retrieve the next page of results.
    If empty, there are no more results.
    """
    total_count: builtins.int
    """The total number of projects accessible to the user."""
    def __init__(
        self,
        *,
        projects: collections.abc.Iterable[global___Project] | None = ...,
        next_page_token: builtins.str = ...,
        total_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "projects", b"projects", "total_count", b"total_count"]) -> None: ...

global___ListProjectsResponse = ListProjectsResponse

class UpdateProjectRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. Identifies the project to update."""
    name: builtins.str
    """Optional. Updated project name does not need to be unique. Maximum allowed
    length is 256 characters.
    """
    description: builtins.str
    """Optional. Updated project description. Maximum allowed length is 4096
    characters.
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "id", b"id", "name", b"name"]) -> None: ...

global___UpdateProjectRequest = UpdateProjectRequest

class UpdateProjectResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_FIELD_NUMBER: builtins.int
    @property
    def project(self) -> global___Project:
        """The newly updated project."""
    def __init__(
        self,
        *,
        project: global___Project | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["project", b"project"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["project", b"project"]) -> None: ...

global___UpdateProjectResponse = UpdateProjectResponse

class DeleteProjectRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. Identifies the project to delete."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___DeleteProjectRequest = DeleteProjectRequest

class LoadGeometryToSetupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    GEOMETRY_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. Identifies the project to load geometry into."""
    geometry_id: builtins.str
    """Required. The geometry to load. The latest version of the geometry will be
    loaded.
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        geometry_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["geometry_id", b"geometry_id", "id", b"id"]) -> None: ...

global___LoadGeometryToSetupRequest = LoadGeometryToSetupRequest

class LoadGeometryToSetupResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___LoadGeometryToSetupResponse = LoadGeometryToSetupResponse

class ShareProjectRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _UserRole:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _UserRoleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ShareProjectRequest._UserRole.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        USER_ROLE_UNSPECIFIED: ShareProjectRequest._UserRole.ValueType  # 0
        USER_ROLE_VIEWER: ShareProjectRequest._UserRole.ValueType  # 1
        USER_ROLE_EDITOR: ShareProjectRequest._UserRole.ValueType  # 2

    class UserRole(_UserRole, metaclass=_UserRoleEnumTypeWrapper): ...
    USER_ROLE_UNSPECIFIED: ShareProjectRequest.UserRole.ValueType  # 0
    USER_ROLE_VIEWER: ShareProjectRequest.UserRole.ValueType  # 1
    USER_ROLE_EDITOR: ShareProjectRequest.UserRole.ValueType  # 2

    ID_FIELD_NUMBER: builtins.int
    EMAIL_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. Identifies the project to share."""
    email: builtins.str
    """Required. The email address of the user to share the project with."""
    role: global___ShareProjectRequest.UserRole.ValueType
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        email: builtins.str = ...,
        role: global___ShareProjectRequest.UserRole.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["email", b"email", "id", b"id", "role", b"role"]) -> None: ...

global___ShareProjectRequest = ShareProjectRequest

class ShareProjectWithSupportRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. Identifies the project to share with support."""
    message: builtins.str
    """Optional. A message to include with the support share request."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "message", b"message"]) -> None: ...

global___ShareProjectWithSupportRequest = ShareProjectWithSupportRequest

class UnshareProjectRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    EMAIL_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. Identifies the project to unshare."""
    email: builtins.str
    """Required. The email address of the user to unshare the project with."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        email: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["email", b"email", "id", b"id"]) -> None: ...

global___UnshareProjectRequest = UnshareProjectRequest

class UnshareProjectWithSupportRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. Identifies the project to unshare with support."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___UnshareProjectWithSupportRequest = UnshareProjectWithSupportRequest
