"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import luminarycloud._proto.api.v0.luminarycloud.common.common_pb2
import luminarycloud._proto.base.base_pb2
import luminarycloud._proto.client.simulation_pb2
import luminarycloud._proto.output.output_pb2
import luminarycloud._proto.output.reference_values_pb2
import luminarycloud._proto.quantity.quantity_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _CalculationType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CalculationTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CalculationType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CALCULATION_TYPE_UNSPECIFIED: _CalculationType.ValueType  # 0
    """Null value."""
    CALCULATION_TYPE_AGGREGATE: _CalculationType.ValueType  # 1
    """Output an aggregate value across all of the surfaces."""
    CALCULATION_TYPE_PER_SURFACE: _CalculationType.ValueType  # 2
    """Output one value per surface."""
    CALCULATION_TYPE_DIFFERENCE: _CalculationType.ValueType  # 3
    """Output the difference between the aggregate of all the IN surfaces and the aggregate of all the
    OUT surfaces. Not valid for a GetSimulationSurfaceQuantityOutputRequest, only for use in
    OutputNodes.
    """

class CalculationType(_CalculationType, metaclass=_CalculationTypeEnumTypeWrapper): ...

CALCULATION_TYPE_UNSPECIFIED: CalculationType.ValueType  # 0
"""Null value."""
CALCULATION_TYPE_AGGREGATE: CalculationType.ValueType  # 1
"""Output an aggregate value across all of the surfaces."""
CALCULATION_TYPE_PER_SURFACE: CalculationType.ValueType  # 2
"""Output one value per surface."""
CALCULATION_TYPE_DIFFERENCE: CalculationType.ValueType  # 3
"""Output the difference between the aggregate of all the IN surfaces and the aggregate of all the
OUT surfaces. Not valid for a GetSimulationSurfaceQuantityOutputRequest, only for use in
OutputNodes.
"""
global___CalculationType = CalculationType

class _AveragingType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AveragingTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AveragingType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    AVERAGING_TYPE_UNSPECIFIED: _AveragingType.ValueType  # 0
    """Null value."""
    AVERAGING_TYPE_MASS_FLOW: _AveragingType.ValueType  # 1
    """Average using the mass flow at each face divided by the total mass flow."""
    AVERAGING_TYPE_AREA: _AveragingType.ValueType  # 2
    """Average using the area of each face divided by the total area."""

class AveragingType(_AveragingType, metaclass=_AveragingTypeEnumTypeWrapper): ...

AVERAGING_TYPE_UNSPECIFIED: AveragingType.ValueType  # 0
"""Null value."""
AVERAGING_TYPE_MASS_FLOW: AveragingType.ValueType  # 1
"""Average using the mass flow at each face divided by the total mass flow."""
AVERAGING_TYPE_AREA: AveragingType.ValueType  # 2
"""Average using the area of each face divided by the total area."""
global___AveragingType = AveragingType

class Simulation(google.protobuf.message.Message):
    """Represents a simulation object."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _SimulationStatus:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SimulationStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Simulation._SimulationStatus.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SIMULATION_STATUS_UNSPECIFIED: Simulation._SimulationStatus.ValueType  # 0
        SIMULATION_STATUS_PENDING: Simulation._SimulationStatus.ValueType  # 1
        """Denotes that the simulation is waiting to be scheduled."""
        SIMULATION_STATUS_ACTIVE: Simulation._SimulationStatus.ValueType  # 2
        """Denotes that the simulation is running currently."""
        SIMULATION_STATUS_COMPLETED: Simulation._SimulationStatus.ValueType  # 3
        """Denotes that the simulation completed successfully."""
        SIMULATION_STATUS_FAILED: Simulation._SimulationStatus.ValueType  # 4
        """Denotes that the simulation completed in a failed state."""
        SIMULATION_STATUS_SUSPENDED: Simulation._SimulationStatus.ValueType  # 5
        """Denotes that the simulation is suspended."""

    class SimulationStatus(_SimulationStatus, metaclass=_SimulationStatusEnumTypeWrapper):
        """Represents current status of a simulation."""

    SIMULATION_STATUS_UNSPECIFIED: Simulation.SimulationStatus.ValueType  # 0
    SIMULATION_STATUS_PENDING: Simulation.SimulationStatus.ValueType  # 1
    """Denotes that the simulation is waiting to be scheduled."""
    SIMULATION_STATUS_ACTIVE: Simulation.SimulationStatus.ValueType  # 2
    """Denotes that the simulation is running currently."""
    SIMULATION_STATUS_COMPLETED: Simulation.SimulationStatus.ValueType  # 3
    """Denotes that the simulation completed successfully."""
    SIMULATION_STATUS_FAILED: Simulation.SimulationStatus.ValueType  # 4
    """Denotes that the simulation completed in a failed state."""
    SIMULATION_STATUS_SUSPENDED: Simulation.SimulationStatus.ValueType  # 5
    """Denotes that the simulation is suspended."""

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    MESH_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    DOE_NAME_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The unique identifier for the simulation."""
    name: builtins.str
    """Required. User specified simulation name, does not need to be unique.
    Maximum allowed length is 256 characters.
    """
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Output only. The timestamp when the simulation was created."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Output only. The timestamp when the simulation was last updated."""
    status: global___Simulation.SimulationStatus.ValueType
    """Output only. Current simulation status."""
    mesh_id: builtins.str
    """Output only. Mesh id associated with the simulation."""
    description: builtins.str
    """User specified description for this simulation."""
    project_id: builtins.str
    """Output only. The ID of the project containing this simulation."""
    doe_name: builtins.str
    """Name of the DOE that created this simulation."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        status: global___Simulation.SimulationStatus.ValueType = ...,
        mesh_id: builtins.str = ...,
        description: builtins.str = ...,
        project_id: builtins.str = ...,
        doe_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "description", b"description", "doe_name", b"doe_name", "id", b"id", "mesh_id", b"mesh_id", "name", b"name", "project_id", b"project_id", "status", b"status", "update_time", b"update_time"]) -> None: ...

global___Simulation = Simulation

class SimulationOptions(google.protobuf.message.Message):
    """Various settings to configure how a simulation is run."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _GPUType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _GPUTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SimulationOptions._GPUType.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        GPU_TYPE_UNSPECIFIED: SimulationOptions._GPUType.ValueType  # 0
        GPU_TYPE_V100: SimulationOptions._GPUType.ValueType  # 1
        GPU_TYPE_A100: SimulationOptions._GPUType.ValueType  # 2

    class GPUType(_GPUType, metaclass=_GPUTypeEnumTypeWrapper): ...
    GPU_TYPE_UNSPECIFIED: SimulationOptions.GPUType.ValueType  # 0
    GPU_TYPE_V100: SimulationOptions.GPUType.ValueType  # 1
    GPU_TYPE_A100: SimulationOptions.GPUType.ValueType  # 2

    BATCH_PROCESSING_FIELD_NUMBER: builtins.int
    GPU_TYPE_FIELD_NUMBER: builtins.int
    GPU_COUNT_FIELD_NUMBER: builtins.int
    batch_processing: builtins.bool
    """Optional. If set to true, batch processing will be used for this simulation.

    Use Batch Processing on simulations that are not time-sensitive to save up
    to 65% in credits.
    """
    gpu_type: global___SimulationOptions.GPUType.ValueType
    """The desired type of GPUs to use for the simulation."""
    gpu_count: builtins.int
    """The desired number of GPUs to use for the simulation."""
    def __init__(
        self,
        *,
        batch_processing: builtins.bool = ...,
        gpu_type: global___SimulationOptions.GPUType.ValueType = ...,
        gpu_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["batch_processing", b"batch_processing", "gpu_count", b"gpu_count", "gpu_type", b"gpu_type"]) -> None: ...

global___SimulationOptions = SimulationOptions

class CreateSimulationRequest(google.protobuf.message.Message):
    """Used to create a simulation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    MESH_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    SIMULATION_TEMPLATE_ID_FIELD_NUMBER: builtins.int
    SIMULATION_OPTIONS_FIELD_NUMBER: builtins.int
    SIMULATION_PARAM_FIELD_NUMBER: builtins.int
    SIMULATION_PARAM_JSON_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    NAMED_VARIABLE_SET_VERSION_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """Required. Project ID associated with this simulation."""
    mesh_id: builtins.str
    """Required. The mesh ID to run the simulation."""
    name: builtins.str
    """Required. User specified simulation name, does not need to be unique.
    Maximum allowed length is 256 characters.
    """
    simulation_template_id: builtins.str
    """Required. The simulation template ID containing the FVM parameters."""
    @property
    def simulation_options(self) -> global___SimulationOptions:
        """Optional. Various settings to configure how a simulation is run."""
    @property
    def simulation_param(self) -> luminarycloud._proto.client.simulation_pb2.SimulationParam:
        """DEPRECATED
        Optional. User specified simulation template. Either simulation_param
        or simulation_param_json must be set.
        """
    simulation_param_json: builtins.bytes
    """DEPRECATED
    Optional. User specified simulation template. Must be a
    luminary.proto.client.SimulationParam message serialized to JSON. Either
    simulation_param or simulation_param_json must be set.
    """
    description: builtins.str
    """Optional. User specified description for this simulation."""
    named_variable_set_version_id: builtins.str
    """Named Variable Set Version ID.
    Used to resolve Named variables in the simulation template.
    """
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        mesh_id: builtins.str = ...,
        name: builtins.str = ...,
        simulation_template_id: builtins.str = ...,
        simulation_options: global___SimulationOptions | None = ...,
        simulation_param: luminarycloud._proto.client.simulation_pb2.SimulationParam | None = ...,
        simulation_param_json: builtins.bytes = ...,
        description: builtins.str = ...,
        named_variable_set_version_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["simulation_options", b"simulation_options", "simulation_param", b"simulation_param"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "mesh_id", b"mesh_id", "name", b"name", "named_variable_set_version_id", b"named_variable_set_version_id", "project_id", b"project_id", "simulation_options", b"simulation_options", "simulation_param", b"simulation_param", "simulation_param_json", b"simulation_param_json", "simulation_template_id", b"simulation_template_id"]) -> None: ...

global___CreateSimulationRequest = CreateSimulationRequest

class CreateSimulationResponse(google.protobuf.message.Message):
    """Represents simulation created."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMULATION_FIELD_NUMBER: builtins.int
    @property
    def simulation(self) -> global___Simulation:
        """Required. The details of the newly created simulation."""
    def __init__(
        self,
        *,
        simulation: global___Simulation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["simulation", b"simulation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["simulation", b"simulation"]) -> None: ...

global___CreateSimulationResponse = CreateSimulationResponse

class GetSimulationRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The id of the simulation to retrieve."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___GetSimulationRequest = GetSimulationRequest

class GetSimulationResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMULATION_FIELD_NUMBER: builtins.int
    @property
    def simulation(self) -> global___Simulation:
        """Required. The details of the requested simulation."""
    def __init__(
        self,
        *,
        simulation: global___Simulation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["simulation", b"simulation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["simulation", b"simulation"]) -> None: ...

global___GetSimulationResponse = GetSimulationResponse

class UpdateSimulationRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. Identifies the simulation to update."""
    name: builtins.str
    """Optional fields that are set will be updated
    A new name.
    """
    description: builtins.str
    """A new description."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str | None = ...,
        description: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_description", b"_description", "_name", b"_name", "description", b"description", "name", b"name"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_description", b"_description", "_name", b"_name", "description", b"description", "id", b"id", "name", b"name"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_description", b"_description"]) -> typing_extensions.Literal["description"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_name", b"_name"]) -> typing_extensions.Literal["name"] | None: ...

global___UpdateSimulationRequest = UpdateSimulationRequest

class UpdateSimulationResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMULATION_FIELD_NUMBER: builtins.int
    @property
    def simulation(self) -> global___Simulation:
        """Required. The new details of the simulation."""
    def __init__(
        self,
        *,
        simulation: global___Simulation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["simulation", b"simulation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["simulation", b"simulation"]) -> None: ...

global___UpdateSimulationResponse = UpdateSimulationResponse

class ListSimulationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """Required. Used to retrieve simulations associated with a project."""
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["project_id", b"project_id"]) -> None: ...

global___ListSimulationsRequest = ListSimulationsRequest

class ListSimulationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMULATIONS_FIELD_NUMBER: builtins.int
    @property
    def simulations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Simulation]:
        """Required. A list of the user's simulations in a project.
        Order of simulations is unspecified.
        """
    def __init__(
        self,
        *,
        simulations: collections.abc.Iterable[global___Simulation] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["simulations", b"simulations"]) -> None: ...

global___ListSimulationsResponse = ListSimulationsResponse

class DeleteSimulationRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The id of the simulation to delete."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___DeleteSimulationRequest = DeleteSimulationRequest

class SuspendSimulationRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The id of the simulation to suspend."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___SuspendSimulationRequest = SuspendSimulationRequest

class GetSimulationGlobalResidualsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ResidualNormalization:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ResidualNormalizationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[GetSimulationGlobalResidualsRequest._ResidualNormalization.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        RESIDUAL_NORMALIZATION_UNSPECIFIED: GetSimulationGlobalResidualsRequest._ResidualNormalization.ValueType  # 0
        RESIDUAL_NORMALIZATION_RELATIVE: GetSimulationGlobalResidualsRequest._ResidualNormalization.ValueType  # 1
        RESIDUAL_NORMALIZATION_ABSOLUTE: GetSimulationGlobalResidualsRequest._ResidualNormalization.ValueType  # 2

    class ResidualNormalization(_ResidualNormalization, metaclass=_ResidualNormalizationEnumTypeWrapper):
        """Optional. Whether to return the absolute or relative residuals. If
        unspecified, it defaults to relative normalization.
        """

    RESIDUAL_NORMALIZATION_UNSPECIFIED: GetSimulationGlobalResidualsRequest.ResidualNormalization.ValueType  # 0
    RESIDUAL_NORMALIZATION_RELATIVE: GetSimulationGlobalResidualsRequest.ResidualNormalization.ValueType  # 1
    RESIDUAL_NORMALIZATION_ABSOLUTE: GetSimulationGlobalResidualsRequest.ResidualNormalization.ValueType  # 2

    ID_FIELD_NUMBER: builtins.int
    RESIDUAL_NORMALIZATION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The id of the simulation for which to get the global residuals."""
    residual_normalization: global___GetSimulationGlobalResidualsRequest.ResidualNormalization.ValueType
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        residual_normalization: global___GetSimulationGlobalResidualsRequest.ResidualNormalization.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "residual_normalization", b"residual_normalization"]) -> None: ...

global___GetSimulationGlobalResidualsRequest = GetSimulationGlobalResidualsRequest

class GetSimulationGlobalResidualsResponse(google.protobuf.message.Message):
    """TODO: Add sample output here."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CSV_FILE_FIELD_NUMBER: builtins.int
    @property
    def csv_file(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File:
        """Required. Residuals response as a csv file with scalar residual values for each time-step/iteration.
        Columns:
        - Time step (all rows will have a value of 0 for steady state simulations)
        - Iteration number
        - Physical time in seconds (all rows will have a value of 0 for steady state simulations)
        - A column for each available residual type
        """
    def __init__(
        self,
        *,
        csv_file: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["csv_file", b"csv_file"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["csv_file", b"csv_file"]) -> None: ...

global___GetSimulationGlobalResidualsResponse = GetSimulationGlobalResidualsResponse

class GetSimulationSurfaceQuantityOutputRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    QUANTITY_TYPE_FIELD_NUMBER: builtins.int
    SURFACE_IDS_FIELD_NUMBER: builtins.int
    CALCULATION_TYPE_FIELD_NUMBER: builtins.int
    FRAME_ID_FIELD_NUMBER: builtins.int
    FORCE_DIRECTION_FIELD_NUMBER: builtins.int
    MOMENT_CENTER_FIELD_NUMBER: builtins.int
    AVERAGING_TYPE_FIELD_NUMBER: builtins.int
    REFERENCE_VALUES_FIELD_NUMBER: builtins.int
    VECTOR_COMPONENT_FIELD_NUMBER: builtins.int
    MOMENT_CONVENTION_TYPE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The simulation id for which to get the surface quantity outputs."""
    quantity_type: luminarycloud._proto.quantity.quantity_pb2.QuantityType.ValueType
    """Required. Surface quantity type to return."""
    @property
    def surface_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Required. List of surfaces to compute the quantities for. (Should have at least one element)"""
    calculation_type: global___CalculationType.ValueType
    """Required. Specifies whether quantity should be calculated for surfaces
    altogether or separately.
    """
    frame_id: builtins.str
    """Optional. For "force" quantities, the ID of the reference frame that this
    output should be reported in.
    """
    @property
    def force_direction(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3:
        """Optional. Force direction for calculating "force" quantities."""
    @property
    def moment_center(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3:
        """Optional. Center of moment for calculating "force" quantities."""
    averaging_type: global___AveragingType.ValueType
    """Optional. Whether to weight faces by area or mass flow when calculating
    "average" quantities.
    """
    @property
    def reference_values(self) -> luminarycloud._proto.output.reference_values_pb2.ReferenceValues:
        """Optional. Reference values used for computing forces, moments and other
        non-dimensional output quantities.
        """
    vector_component: luminarycloud._proto.base.base_pb2.Vector3Component.ValueType
    """Optional. For 3-vector quantity types, e.g. Velocity, which vector component to return."""
    moment_convention_type: luminarycloud._proto.output.output_pb2.MomentConventionType.ValueType
    """Optional. For "aerodynamic moment" quantity types, the frame type to use for pitch, roll, and yaw moments."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        quantity_type: luminarycloud._proto.quantity.quantity_pb2.QuantityType.ValueType = ...,
        surface_ids: collections.abc.Iterable[builtins.str] | None = ...,
        calculation_type: global___CalculationType.ValueType = ...,
        frame_id: builtins.str = ...,
        force_direction: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
        moment_center: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.Vector3 | None = ...,
        averaging_type: global___AveragingType.ValueType = ...,
        reference_values: luminarycloud._proto.output.reference_values_pb2.ReferenceValues | None = ...,
        vector_component: luminarycloud._proto.base.base_pb2.Vector3Component.ValueType = ...,
        moment_convention_type: luminarycloud._proto.output.output_pb2.MomentConventionType.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["force_direction", b"force_direction", "moment_center", b"moment_center", "reference_values", b"reference_values"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["averaging_type", b"averaging_type", "calculation_type", b"calculation_type", "force_direction", b"force_direction", "frame_id", b"frame_id", "id", b"id", "moment_center", b"moment_center", "moment_convention_type", b"moment_convention_type", "quantity_type", b"quantity_type", "reference_values", b"reference_values", "surface_ids", b"surface_ids", "vector_component", b"vector_component"]) -> None: ...

global___GetSimulationSurfaceQuantityOutputRequest = GetSimulationSurfaceQuantityOutputRequest

class GetSimulationSurfaceQuantityOutputResponse(google.protobuf.message.Message):
    """TODO: Add sample output here."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CSV_FILE_FIELD_NUMBER: builtins.int
    @property
    def csv_file(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File:
        """Required. Outputs response as a csv file."""
    def __init__(
        self,
        *,
        csv_file: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["csv_file", b"csv_file"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["csv_file", b"csv_file"]) -> None: ...

global___GetSimulationSurfaceQuantityOutputResponse = GetSimulationSurfaceQuantityOutputResponse

class GetSimulationSurfaceSolutionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    TIME_STEP_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The simulation id of the solution to get."""
    time_step: builtins.int
    """The index of the time step of the solution to get.
    Required for transient simulations. Should not be set otherwise.
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        time_step: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "time_step", b"time_step"]) -> None: ...

global___GetSimulationSurfaceSolutionRequest = GetSimulationSurfaceSolutionRequest

class GetSimulationSurfaceSolutionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_FIELD_NUMBER: builtins.int
    @property
    def file(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File:
        """The surface solution being exported.  Either a signed URL or a file ID."""
    def __init__(
        self,
        *,
        file: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["file", b"file"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["file", b"file"]) -> None: ...

global___GetSimulationSurfaceSolutionResponse = GetSimulationSurfaceSolutionResponse

class GetSimulationVolumeSolutionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    TIME_STEP_FIELD_NUMBER: builtins.int
    SINGLE_PRECISION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The simulation id for which to get the volume solution."""
    time_step: builtins.int
    """The index of the time step of the solution to get.
    Required for transient simulations. Should not be set otherwise.
    """
    single_precision: builtins.bool
    """Whether to export the floating point fields in single precision."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        time_step: builtins.int = ...,
        single_precision: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "single_precision", b"single_precision", "time_step", b"time_step"]) -> None: ...

global___GetSimulationVolumeSolutionRequest = GetSimulationVolumeSolutionRequest

class GetSimulationVolumeSolutionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_FIELD_NUMBER: builtins.int
    @property
    def file(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File:
        """The volume solution being exported.  Either a signed URL or a file ID."""
    def __init__(
        self,
        *,
        file: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["file", b"file"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["file", b"file"]) -> None: ...

global___GetSimulationVolumeSolutionResponse = GetSimulationVolumeSolutionResponse

class GetSimulationParametersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The simulation id for which to get the simulation parameters."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___GetSimulationParametersRequest = GetSimulationParametersRequest

class SimulationQueueStatus(google.protobuf.message.Message):
    """Represents a simulation in the queue."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    SIMULATION_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CREATION_TIME_FIELD_NUMBER: builtins.int
    STARTED_TIME_FIELD_NUMBER: builtins.int
    IS_LMA_FIELD_NUMBER: builtins.int
    PRIORITY_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """The ID of the project this simulation belongs to."""
    simulation_id: builtins.str
    """The unique ID of the simulation."""
    name: builtins.str
    """The name of the simulation."""
    @property
    def creation_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when the job was created."""
    @property
    def started_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when the simulation started running. Only set if the simulation
        has started running.
        """
    is_lma: builtins.bool
    """Whether this is an LMA simulation."""
    priority: builtins.bool
    """Whether this is a priority job."""
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        simulation_id: builtins.str = ...,
        name: builtins.str = ...,
        creation_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        started_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        is_lma: builtins.bool = ...,
        priority: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_started_time", b"_started_time", "creation_time", b"creation_time", "started_time", b"started_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_started_time", b"_started_time", "creation_time", b"creation_time", "is_lma", b"is_lma", "name", b"name", "priority", b"priority", "project_id", b"project_id", "simulation_id", b"simulation_id", "started_time", b"started_time"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_started_time", b"_started_time"]) -> typing_extensions.Literal["started_time"] | None: ...

global___SimulationQueueStatus = SimulationQueueStatus

class ListQueuedSimulationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """Optional. The maximum number of jobs to return. The service may return
    fewer than this value. Default is 50, max is 100. Values above 100 will be
    replace by 100.
    """
    page_token: builtins.str
    """A page token, received from a previous call. Provide this to retrieve the
    subsequent page.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "page_size", b"page_size", "page_token", b"page_token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...

global___ListQueuedSimulationsRequest = ListQueuedSimulationsRequest

class ListQueuedSimulationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMULATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_COUNT_FIELD_NUMBER: builtins.int
    @property
    def simulations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SimulationQueueStatus]:
        """The list of simulations in the queue."""
    next_page_token: builtins.str
    """A page token that can be used to retrieve the next page of results.
    If empty, there are no more results.
    """
    total_count: builtins.int
    """The total number of simulations in the queue for this account."""
    def __init__(
        self,
        *,
        simulations: collections.abc.Iterable[global___SimulationQueueStatus] | None = ...,
        next_page_token: builtins.str = ...,
        total_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "simulations", b"simulations", "total_count", b"total_count"]) -> None: ...

global___ListQueuedSimulationsResponse = ListQueuedSimulationsResponse
