"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import abc
import google.protobuf.empty_pb2
import grpc
import luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2
import luminarycloud._proto.client.simulation_pb2

class SimulationServiceStub:
    """Provides APIs for running simulations and retrieve outputs."""

    def __init__(self, channel: grpc.Channel) -> None: ...
    CreateSimulation: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.CreateSimulationRequest,
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.CreateSimulationResponse,
    ]
    """Creates a new simulation in a project for the user."""
    GetSimulation: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationRequest,
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationResponse,
    ]
    """Retrieves current status of a simulation in a project."""
    UpdateSimulation: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.UpdateSimulationRequest,
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.UpdateSimulationResponse,
    ]
    """Updates a simulation"""
    ListSimulations: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.ListSimulationsRequest,
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.ListSimulationsResponse,
    ]
    """Lists simulations available to the user in a project."""
    DeleteSimulation: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.DeleteSimulationRequest,
        google.protobuf.empty_pb2.Empty,
    ]
    """Deletes a simulation in a project. The simulation will be stopped first if
    running. This operation cannot be reverted and all the simulation data will
    be deleted as part of this request.
    """
    SuspendSimulation: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.SuspendSimulationRequest,
        google.protobuf.empty_pb2.Empty,
    ]
    """Suspends an active simulation in a project."""
    GetSimulationGlobalResiduals: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationGlobalResidualsRequest,
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationGlobalResidualsResponse,
    ]
    """Retrieves simulation global residuals, formats them using csv and returns the full file contents to the caller.
    The caller can write the data to a file storage and use for further processing.
    """
    GetSimulationSurfaceQuantityOutput: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationSurfaceQuantityOutputRequest,
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationSurfaceQuantityOutputResponse,
    ]
    """Retrieves simulation surface quantity outputs(lift, drag, ...), formats them using csv and returns the full file contents
    to the caller.  The caller can write the data to a persistent file storage and use for further processing.
    """
    GetSimulationSurfaceSolution: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationSurfaceSolutionRequest,
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationSurfaceSolutionResponse,
    ]
    """TODO: Update this rpc to use a streaming response.
    Retrieves simulation surface fields data output, compresses them and returns bytes to the caller in multiple chunks.
    The caller may need to send multiple requests to receive the full contents, or may need to fetch the contents via
    a provided signed URL. The caller can write this data to a persistent file storage and use for further processing.
    """
    GetSimulationVolumeSolution: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationVolumeSolutionRequest,
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationVolumeSolutionResponse,
    ]
    """Outputs the volume solution of a completed steady state simulation as a compressed archive file. Returns bytes to the caller in multiple chunks.
    The caller may need to send multiple requests to receive the full contents, or may need to fetch the contents via
    a provided signed URL. The caller can write this data to a persistent file storage and use for further processing.
    """
    GetSimulationParameters: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationParametersRequest,
        luminarycloud._proto.client.simulation_pb2.SimulationParam,
    ]
    """Fetches the simulation parameters for an existing simulation."""
    ListQueuedSimulations: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.ListQueuedSimulationsRequest,
        luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.ListQueuedSimulationsResponse,
    ]
    """Lists simulations in the queue for the account of the requester. Only
    available for accounts with unlimited billing type.
    """

class SimulationServiceServicer(metaclass=abc.ABCMeta):
    """Provides APIs for running simulations and retrieve outputs."""

    @abc.abstractmethod
    def CreateSimulation(
        self,
        request: luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.CreateSimulationRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.CreateSimulationResponse:
        """Creates a new simulation in a project for the user."""
    @abc.abstractmethod
    def GetSimulation(
        self,
        request: luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationResponse:
        """Retrieves current status of a simulation in a project."""
    @abc.abstractmethod
    def UpdateSimulation(
        self,
        request: luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.UpdateSimulationRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.UpdateSimulationResponse:
        """Updates a simulation"""
    @abc.abstractmethod
    def ListSimulations(
        self,
        request: luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.ListSimulationsRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.ListSimulationsResponse:
        """Lists simulations available to the user in a project."""
    @abc.abstractmethod
    def DeleteSimulation(
        self,
        request: luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.DeleteSimulationRequest,
        context: grpc.ServicerContext,
    ) -> google.protobuf.empty_pb2.Empty:
        """Deletes a simulation in a project. The simulation will be stopped first if
        running. This operation cannot be reverted and all the simulation data will
        be deleted as part of this request.
        """
    @abc.abstractmethod
    def SuspendSimulation(
        self,
        request: luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.SuspendSimulationRequest,
        context: grpc.ServicerContext,
    ) -> google.protobuf.empty_pb2.Empty:
        """Suspends an active simulation in a project."""
    @abc.abstractmethod
    def GetSimulationGlobalResiduals(
        self,
        request: luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationGlobalResidualsRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationGlobalResidualsResponse:
        """Retrieves simulation global residuals, formats them using csv and returns the full file contents to the caller.
        The caller can write the data to a file storage and use for further processing.
        """
    @abc.abstractmethod
    def GetSimulationSurfaceQuantityOutput(
        self,
        request: luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationSurfaceQuantityOutputRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationSurfaceQuantityOutputResponse:
        """Retrieves simulation surface quantity outputs(lift, drag, ...), formats them using csv and returns the full file contents
        to the caller.  The caller can write the data to a persistent file storage and use for further processing.
        """
    @abc.abstractmethod
    def GetSimulationSurfaceSolution(
        self,
        request: luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationSurfaceSolutionRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationSurfaceSolutionResponse:
        """TODO: Update this rpc to use a streaming response.
        Retrieves simulation surface fields data output, compresses them and returns bytes to the caller in multiple chunks.
        The caller may need to send multiple requests to receive the full contents, or may need to fetch the contents via
        a provided signed URL. The caller can write this data to a persistent file storage and use for further processing.
        """
    @abc.abstractmethod
    def GetSimulationVolumeSolution(
        self,
        request: luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationVolumeSolutionRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationVolumeSolutionResponse:
        """Outputs the volume solution of a completed steady state simulation as a compressed archive file. Returns bytes to the caller in multiple chunks.
        The caller may need to send multiple requests to receive the full contents, or may need to fetch the contents via
        a provided signed URL. The caller can write this data to a persistent file storage and use for further processing.
        """
    @abc.abstractmethod
    def GetSimulationParameters(
        self,
        request: luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.GetSimulationParametersRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.client.simulation_pb2.SimulationParam:
        """Fetches the simulation parameters for an existing simulation."""
    @abc.abstractmethod
    def ListQueuedSimulations(
        self,
        request: luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.ListQueuedSimulationsRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.api.v0.luminarycloud.simulation.simulation_pb2.ListQueuedSimulationsResponse:
        """Lists simulations in the queue for the account of the requester. Only
        available for accounts with unlimited billing type.
        """

def add_SimulationServiceServicer_to_server(servicer: SimulationServiceServicer, server: grpc.Server) -> None: ...
