"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import luminarycloud._proto.client.simulation_pb2
import sys
import typing

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class SimulationTemplate(google.protobuf.message.Message):
    """Represents a simulation template object."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The unique identifier for the resource."""
    name: builtins.str
    """Required. User specified resource name, does not need to be unique.
    Maximum allowed length is 256 characters.
    """
    @property
    def parameters(self) -> luminarycloud._proto.client.simulation_pb2.SimulationParam:
        """Simulation parameters."""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Output only. The timestamp when the resource was created."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Output only. The timestamp when the resource was last updated."""
    project_id: builtins.str
    """Required. The project this sim template belongs to."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        parameters: luminarycloud._proto.client.simulation_pb2.SimulationParam | None = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        project_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "parameters", b"parameters", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "id", b"id", "name", b"name", "parameters", b"parameters", "project_id", b"project_id", "update_time", b"update_time"]) -> None: ...

global___SimulationTemplate = SimulationTemplate

class CreateSimulationTemplateRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    COPY_FROM_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """Required. Project id associated with this resource."""
    name: builtins.str
    """Required. User specified resource name, does not need to be unique.
    Maximum allowed length is 256 characters.
    """
    @property
    def parameters(self) -> luminarycloud._proto.client.simulation_pb2.SimulationParam:
        """Optional. Client params. Cannot be provided if `copy_from` is provided."""
    copy_from: builtins.str
    """Optional. ID of an existing simulation template. If provided, that template will be cloned to
    make the new template. Cannot be provided if `parameters` is provided.
    """
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        name: builtins.str = ...,
        parameters: luminarycloud._proto.client.simulation_pb2.SimulationParam | None = ...,
        copy_from: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_copy_from", b"_copy_from", "copy_from", b"copy_from", "parameters", b"parameters"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_copy_from", b"_copy_from", "copy_from", b"copy_from", "name", b"name", "parameters", b"parameters", "project_id", b"project_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_copy_from", b"_copy_from"]) -> typing_extensions.Literal["copy_from"] | None: ...

global___CreateSimulationTemplateRequest = CreateSimulationTemplateRequest

class CreateSimulationTemplateResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMULATION_TEMPLATE_FIELD_NUMBER: builtins.int
    @property
    def simulation_template(self) -> global___SimulationTemplate:
        """Required. The details of the newly created simulation template."""
    def __init__(
        self,
        *,
        simulation_template: global___SimulationTemplate | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["simulation_template", b"simulation_template"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["simulation_template", b"simulation_template"]) -> None: ...

global___CreateSimulationTemplateResponse = CreateSimulationTemplateResponse

class ListSimulationTemplatesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """Required. The ID of the project for which to list simulation templates."""
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["project_id", b"project_id"]) -> None: ...

global___ListSimulationTemplatesRequest = ListSimulationTemplatesRequest

class ListSimulationTemplatesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMULATION_TEMPLATES_FIELD_NUMBER: builtins.int
    @property
    def simulation_templates(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SimulationTemplate]:
        """Required. The requested list of simulation templates."""
    def __init__(
        self,
        *,
        simulation_templates: collections.abc.Iterable[global___SimulationTemplate] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["simulation_templates", b"simulation_templates"]) -> None: ...

global___ListSimulationTemplatesResponse = ListSimulationTemplatesResponse

class GetSimulationTemplateRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The unique identifier for the resource."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___GetSimulationTemplateRequest = GetSimulationTemplateRequest

class GetSimulationTemplateResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMULATION_TEMPLATE_FIELD_NUMBER: builtins.int
    @property
    def simulation_template(self) -> global___SimulationTemplate:
        """Required. The requested simulation template."""
    def __init__(
        self,
        *,
        simulation_template: global___SimulationTemplate | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["simulation_template", b"simulation_template"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["simulation_template", b"simulation_template"]) -> None: ...

global___GetSimulationTemplateResponse = GetSimulationTemplateResponse

class UpdateSimulationTemplateRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    COPY_FROM_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The unique identifier for the resource."""
    name: builtins.str
    """User specified resource name, does not need to be unique.
    Maximum allowed length is 256 characters. Ignored if empty.
    """
    @property
    def parameters(self) -> luminarycloud._proto.client.simulation_pb2.SimulationParam:
        """Simulation parameters."""
    copy_from: builtins.str
    """Optional. ID of an existing simulation template. If provided, all of that template's properties
    will be copied into this template. Cannot be provided if `parameters` is provided.
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str | None = ...,
        parameters: luminarycloud._proto.client.simulation_pb2.SimulationParam | None = ...,
        copy_from: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_copy_from", b"_copy_from", "_name", b"_name", "_parameters", b"_parameters", "copy_from", b"copy_from", "name", b"name", "parameters", b"parameters"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_copy_from", b"_copy_from", "_name", b"_name", "_parameters", b"_parameters", "copy_from", b"copy_from", "id", b"id", "name", b"name", "parameters", b"parameters"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_copy_from", b"_copy_from"]) -> typing_extensions.Literal["copy_from"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_name", b"_name"]) -> typing_extensions.Literal["name"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_parameters", b"_parameters"]) -> typing_extensions.Literal["parameters"] | None: ...

global___UpdateSimulationTemplateRequest = UpdateSimulationTemplateRequest

class UpdateSimulationTemplateResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMULATION_TEMPLATE_FIELD_NUMBER: builtins.int
    @property
    def simulation_template(self) -> global___SimulationTemplate:
        """Required. The updated simulation template."""
    def __init__(
        self,
        *,
        simulation_template: global___SimulationTemplate | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["simulation_template", b"simulation_template"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["simulation_template", b"simulation_template"]) -> None: ...

global___UpdateSimulationTemplateResponse = UpdateSimulationTemplateResponse

class DeleteSimulationTemplateRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The unique identifier for the resource."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___DeleteSimulationTemplateRequest = DeleteSimulationTemplateRequest

class ValidateSimulationTemplateRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The unique identifier for the resource."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___ValidateSimulationTemplateRequest = ValidateSimulationTemplateRequest

class ValidateSimulationTemplateResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IS_VALID_FIELD_NUMBER: builtins.int
    MESSAGES_FIELD_NUMBER: builtins.int
    is_valid: builtins.bool
    @property
    def messages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        is_valid: builtins.bool = ...,
        messages: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["is_valid", b"is_valid", "messages", b"messages"]) -> None: ...

global___ValidateSimulationTemplateResponse = ValidateSimulationTemplateResponse

class SyncSimulationTemplateToUIRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The ID of the simulation template to sync to the UI."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___SyncSimulationTemplateToUIRequest = SyncSimulationTemplateToUIRequest

class SyncSimulationTemplateToUIResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___SyncSimulationTemplateToUIResponse = SyncSimulationTemplateToUIResponse
