"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import luminarycloud._proto.api.v0.luminarycloud.common.common_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class Solution(google.protobuf.message.Message):
    """Represents a solution for some iteration of a simulation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    SIMULATION_ID_FIELD_NUMBER: builtins.int
    ITERATION_FIELD_NUMBER: builtins.int
    PHYSICAL_TIME_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The globally unique identifier for the solution."""
    simulation_id: builtins.str
    """The unique identifier for the parent simulation."""
    iteration: builtins.int
    """The iteration index of the solution.
    For transient simulations, this is the outer iteration index.
    """
    physical_time: builtins.float
    """For transient solutions, the physical time, in seconds, of the solution
    iteration.
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        simulation_id: builtins.str = ...,
        iteration: builtins.int = ...,
        physical_time: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "iteration", b"iteration", "physical_time", b"physical_time", "simulation_id", b"simulation_id"]) -> None: ...

global___Solution = Solution

class ListSolutionsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMULATION_ID_FIELD_NUMBER: builtins.int
    simulation_id: builtins.str
    """Required. The globally unique identifier for the parent simulation."""
    def __init__(
        self,
        *,
        simulation_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["simulation_id", b"simulation_id"]) -> None: ...

global___ListSolutionsRequest = ListSolutionsRequest

class ListSolutionsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SOLUTIONS_FIELD_NUMBER: builtins.int
    @property
    def solutions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Solution]:
        """Required. A list of the available solutions for a simulation."""
    def __init__(
        self,
        *,
        solutions: collections.abc.Iterable[global___Solution] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["solutions", b"solutions"]) -> None: ...

global___ListSolutionsResponse = ListSolutionsResponse

class GetSolutionSurfaceDataRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The globally unique identifier for the solution."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___GetSolutionSurfaceDataRequest = GetSolutionSurfaceDataRequest

class GetSolutionSurfaceDataResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_FIELD_NUMBER: builtins.int
    @property
    def file(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File:
        """The exported surface data.  Either a signed URL or a file ID."""
    def __init__(
        self,
        *,
        file: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["file", b"file"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["file", b"file"]) -> None: ...

global___GetSolutionSurfaceDataResponse = GetSolutionSurfaceDataResponse

class GetSolutionVolumeDataRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    SINGLE_PRECISION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The globally unique identifier for the solution."""
    single_precision: builtins.bool
    """Whether to export the floating point fields in single precision."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        single_precision: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "single_precision", b"single_precision"]) -> None: ...

global___GetSolutionVolumeDataRequest = GetSolutionVolumeDataRequest

class GetSolutionVolumeDataResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_FIELD_NUMBER: builtins.int
    @property
    def file(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File:
        """The exported volume data.  Either a signed URL or a file ID."""
    def __init__(
        self,
        *,
        file: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["file", b"file"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["file", b"file"]) -> None: ...

global___GetSolutionVolumeDataResponse = GetSolutionVolumeDataResponse

class GetSurfaceDeformationTemplateRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The globally unique identifier for the solution."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___GetSurfaceDeformationTemplateRequest = GetSurfaceDeformationTemplateRequest

class GetSurfaceDeformationTemplateResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_FIELD_NUMBER: builtins.int
    @property
    def file(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File:
        """The surface deformation template.  Either a signed URL or a file ID."""
    def __init__(
        self,
        *,
        file: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["file", b"file"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["file", b"file"]) -> None: ...

global___GetSurfaceDeformationTemplateResponse = GetSurfaceDeformationTemplateResponse

class GetSurfaceSensitivityDataRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The globally unique identifier for the solution."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___GetSurfaceSensitivityDataRequest = GetSurfaceSensitivityDataRequest

class GetSurfaceSensitivityDataResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_FIELD_NUMBER: builtins.int
    @property
    def file(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File:
        """The surface sensitivity data.  Either a signed URL or a file ID."""
    def __init__(
        self,
        *,
        file: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["file", b"file"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["file", b"file"]) -> None: ...

global___GetSurfaceSensitivityDataResponse = GetSurfaceSensitivityDataResponse

class GetParameterSensitivityDataRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. The globally unique identifier for the solution."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___GetParameterSensitivityDataRequest = GetParameterSensitivityDataRequest

class GetParameterSensitivityDataResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_FIELD_NUMBER: builtins.int
    @property
    def file(self) -> luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File:
        """The parameter sensitivity data.  Either a signed URL or a file ID."""
    def __init__(
        self,
        *,
        file: luminarycloud._proto.api.v0.luminarycloud.common.common_pb2.File | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["file", b"file"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["file", b"file"]) -> None: ...

global___GetParameterSensitivityDataResponse = GetParameterSensitivityDataResponse
