"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import abc
import grpc
import luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2

class SolutionServiceStub:
    """API for retrieving simulation solutions. The surface and volume solutions are
    available as subresources of each Solution.
    """

    def __init__(self, channel: grpc.Channel) -> None: ...
    ListSolutions: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.ListSolutionsRequest,
        luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.ListSolutionsResponse,
    ]
    """Retrieves a list of the available solutions for a simulation in ascending
    order of iteration.
    If the simulation is still running, more solutions may become available
    as it runs to completion.
    """
    GetSolutionSurfaceData: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetSolutionSurfaceDataRequest,
        luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetSolutionSurfaceDataResponse,
    ]
    """Retrieves surface fields data, compresses them and returns bytes to the caller in multiple chunks.
    The caller may need to send multiple requests to receive the full contents, or may need to fetch the contents via
    a provided signed URL. The caller can write this data to a persistent file storage and use for further processing.
    """
    GetSolutionVolumeData: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetSolutionVolumeDataRequest,
        luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetSolutionVolumeDataResponse,
    ]
    """Outputs the volume data for a solution as a compressed archive file. Returns bytes to the caller in multiple chunks.
    The caller may need to send multiple requests to receive the full contents, or may need to fetch the contents via
    a provided signed URL. The caller can write this data to a persistent file storage and use for further processing.
    """
    GetSurfaceDeformationTemplate: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetSurfaceDeformationTemplateRequest,
        luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetSurfaceDeformationTemplateResponse,
    ]
    """Retrieves the surface deformation template that may be associated with a solution."""
    GetSurfaceSensitivityData: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetSurfaceSensitivityDataRequest,
        luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetSurfaceSensitivityDataResponse,
    ]
    """Retrieves the surface sensitivity data that may be associated with a solution."""
    GetParameterSensitivityData: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetParameterSensitivityDataRequest,
        luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetParameterSensitivityDataResponse,
    ]
    """Retrieves the parameter sensitivity data that may be associated with a solution."""

class SolutionServiceServicer(metaclass=abc.ABCMeta):
    """API for retrieving simulation solutions. The surface and volume solutions are
    available as subresources of each Solution.
    """

    @abc.abstractmethod
    def ListSolutions(
        self,
        request: luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.ListSolutionsRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.ListSolutionsResponse:
        """Retrieves a list of the available solutions for a simulation in ascending
        order of iteration.
        If the simulation is still running, more solutions may become available
        as it runs to completion.
        """
    @abc.abstractmethod
    def GetSolutionSurfaceData(
        self,
        request: luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetSolutionSurfaceDataRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetSolutionSurfaceDataResponse:
        """Retrieves surface fields data, compresses them and returns bytes to the caller in multiple chunks.
        The caller may need to send multiple requests to receive the full contents, or may need to fetch the contents via
        a provided signed URL. The caller can write this data to a persistent file storage and use for further processing.
        """
    @abc.abstractmethod
    def GetSolutionVolumeData(
        self,
        request: luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetSolutionVolumeDataRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetSolutionVolumeDataResponse:
        """Outputs the volume data for a solution as a compressed archive file. Returns bytes to the caller in multiple chunks.
        The caller may need to send multiple requests to receive the full contents, or may need to fetch the contents via
        a provided signed URL. The caller can write this data to a persistent file storage and use for further processing.
        """
    @abc.abstractmethod
    def GetSurfaceDeformationTemplate(
        self,
        request: luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetSurfaceDeformationTemplateRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetSurfaceDeformationTemplateResponse:
        """Retrieves the surface deformation template that may be associated with a solution."""
    @abc.abstractmethod
    def GetSurfaceSensitivityData(
        self,
        request: luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetSurfaceSensitivityDataRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetSurfaceSensitivityDataResponse:
        """Retrieves the surface sensitivity data that may be associated with a solution."""
    @abc.abstractmethod
    def GetParameterSensitivityData(
        self,
        request: luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetParameterSensitivityDataRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.api.v0.luminarycloud.solution.solution_pb2.GetParameterSensitivityDataResponse:
        """Retrieves the parameter sensitivity data that may be associated with a solution."""

def add_SolutionServiceServicer_to_server(servicer: SolutionServiceServicer, server: grpc.Server) -> None: ...
