"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import luminarycloud._proto.output.output_pb2
import sys
import typing

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class BasicStoppingConditions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MAX_ITERATIONS_FIELD_NUMBER: builtins.int
    MAX_PHYSICAL_TIME_FIELD_NUMBER: builtins.int
    OP_FIELD_NUMBER: builtins.int
    MAX_INNER_ITERATIONS_FIELD_NUMBER: builtins.int
    max_iterations: builtins.int
    """The maximum number of iterations."""
    max_physical_time: builtins.float
    """The maximum physical time for transient simulations."""
    op: luminarycloud._proto.output.output_pb2.StoppingConditionOp.ValueType
    """Condition operation"""
    max_inner_iterations: builtins.int
    """Maximum inner iterations for implicit-time transient simulations."""
    def __init__(
        self,
        *,
        max_iterations: builtins.int = ...,
        max_physical_time: builtins.float = ...,
        op: luminarycloud._proto.output.output_pb2.StoppingConditionOp.ValueType = ...,
        max_inner_iterations: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["max_inner_iterations", b"max_inner_iterations", "max_iterations", b"max_iterations", "max_physical_time", b"max_physical_time", "op", b"op"]) -> None: ...

global___BasicStoppingConditions = BasicStoppingConditions

class StoppingCondition(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    OUTPUT_DEFINITION_ID_FIELD_NUMBER: builtins.int
    THRESHOLD_FIELD_NUMBER: builtins.int
    START_AT_ITERATION_FIELD_NUMBER: builtins.int
    AVERAGING_ITERATIONS_FIELD_NUMBER: builtins.int
    ITERATIONS_TO_CONSIDER_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique ID"""
    output_definition_id: builtins.str
    """The ID of the output definition defining the quantity to monitor."""
    threshold: builtins.float
    """The threshold beyond which the condition is met."""
    start_at_iteration: builtins.int
    """The starting iteration for this condition. The condition will evaluate to false before this
    iteration is reached.
    """
    averaging_iterations: builtins.int
    """Trailing average window length. Number of iterations over which the monitored value is averaged
    before the tolerance check is applied.
    """
    iterations_to_consider: builtins.int
    """Number of (averaged) iterations to consider when determining maximum percent deviation from the
    current value.
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        output_definition_id: builtins.str = ...,
        threshold: builtins.float = ...,
        start_at_iteration: builtins.int = ...,
        averaging_iterations: builtins.int = ...,
        iterations_to_consider: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["averaging_iterations", b"averaging_iterations", "id", b"id", "iterations_to_consider", b"iterations_to_consider", "output_definition_id", b"output_definition_id", "start_at_iteration", b"start_at_iteration", "threshold", b"threshold"]) -> None: ...

global___StoppingCondition = StoppingCondition

class GetBasicStoppingConditionsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMULATION_TEMPLATE_ID_FIELD_NUMBER: builtins.int
    simulation_template_id: builtins.str
    """Required. Identifies the simulation template for which to get the basic stopping conditions."""
    def __init__(
        self,
        *,
        simulation_template_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["simulation_template_id", b"simulation_template_id"]) -> None: ...

global___GetBasicStoppingConditionsRequest = GetBasicStoppingConditionsRequest

class GetBasicStoppingConditionsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BASIC_STOPPING_CONDITIONS_FIELD_NUMBER: builtins.int
    @property
    def basic_stopping_conditions(self) -> global___BasicStoppingConditions:
        """The basic stopping conditions."""
    def __init__(
        self,
        *,
        basic_stopping_conditions: global___BasicStoppingConditions | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["basic_stopping_conditions", b"basic_stopping_conditions"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["basic_stopping_conditions", b"basic_stopping_conditions"]) -> None: ...

global___GetBasicStoppingConditionsResponse = GetBasicStoppingConditionsResponse

class UpdateBasicStoppingConditionsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMULATION_TEMPLATE_ID_FIELD_NUMBER: builtins.int
    MAX_ITERATIONS_FIELD_NUMBER: builtins.int
    MAX_PHYSICAL_TIME_FIELD_NUMBER: builtins.int
    OP_FIELD_NUMBER: builtins.int
    MAX_INNER_ITERATIONS_FIELD_NUMBER: builtins.int
    simulation_template_id: builtins.str
    """Required. Identifies the simulation template for which to update the basic stopping conditions."""
    max_iterations: builtins.int
    """The maximum number of iterations."""
    max_physical_time: builtins.float
    """The maximum physical time for transient simulations."""
    op: luminarycloud._proto.output.output_pb2.StoppingConditionOp.ValueType
    """Condition operation"""
    max_inner_iterations: builtins.int
    """Maximum inner iterations for implicit-time transient simulations."""
    def __init__(
        self,
        *,
        simulation_template_id: builtins.str = ...,
        max_iterations: builtins.int | None = ...,
        max_physical_time: builtins.float | None = ...,
        op: luminarycloud._proto.output.output_pb2.StoppingConditionOp.ValueType | None = ...,
        max_inner_iterations: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_max_inner_iterations", b"_max_inner_iterations", "_max_iterations", b"_max_iterations", "_max_physical_time", b"_max_physical_time", "_op", b"_op", "max_inner_iterations", b"max_inner_iterations", "max_iterations", b"max_iterations", "max_physical_time", b"max_physical_time", "op", b"op"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_max_inner_iterations", b"_max_inner_iterations", "_max_iterations", b"_max_iterations", "_max_physical_time", b"_max_physical_time", "_op", b"_op", "max_inner_iterations", b"max_inner_iterations", "max_iterations", b"max_iterations", "max_physical_time", b"max_physical_time", "op", b"op", "simulation_template_id", b"simulation_template_id"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_max_inner_iterations", b"_max_inner_iterations"]) -> typing_extensions.Literal["max_inner_iterations"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_max_iterations", b"_max_iterations"]) -> typing_extensions.Literal["max_iterations"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_max_physical_time", b"_max_physical_time"]) -> typing_extensions.Literal["max_physical_time"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_op", b"_op"]) -> typing_extensions.Literal["op"] | None: ...

global___UpdateBasicStoppingConditionsRequest = UpdateBasicStoppingConditionsRequest

class UpdateBasicStoppingConditionsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BASIC_STOPPING_CONDITIONS_FIELD_NUMBER: builtins.int
    @property
    def basic_stopping_conditions(self) -> global___BasicStoppingConditions:
        """The updated basic stopping conditions."""
    def __init__(
        self,
        *,
        basic_stopping_conditions: global___BasicStoppingConditions | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["basic_stopping_conditions", b"basic_stopping_conditions"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["basic_stopping_conditions", b"basic_stopping_conditions"]) -> None: ...

global___UpdateBasicStoppingConditionsResponse = UpdateBasicStoppingConditionsResponse

class CreateOrUpdateStoppingConditionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMULATION_TEMPLATE_ID_FIELD_NUMBER: builtins.int
    OUTPUT_DEFINITION_ID_FIELD_NUMBER: builtins.int
    THRESHOLD_FIELD_NUMBER: builtins.int
    START_AT_ITERATION_FIELD_NUMBER: builtins.int
    AVERAGING_ITERATIONS_FIELD_NUMBER: builtins.int
    ITERATIONS_TO_CONSIDER_FIELD_NUMBER: builtins.int
    simulation_template_id: builtins.str
    """Required. Identifies the simulation template for which to create the stopping condition."""
    output_definition_id: builtins.str
    """Required. Identifies the output definition on which the stopping condition is based."""
    threshold: builtins.float
    """Required. For a residual stopping condition, the condition is met when the residual drops below
    this threshold.  For a non-residual-based stopping condition, the condition is met when the
    moving average in the monitored output deviates by less than this percentage of its current
    moving average over the specified number of iterations.
    """
    start_at_iteration: builtins.int
    """Optional. The starting iteration for this condition. The condition will evaluate to false
    before this iteration is reached. Default: 1.
    """
    averaging_iterations: builtins.int
    """Optional. Trailing average window length. Number of iterations over which the monitored value
    is averaged before the threshold check is applied. Default: 1.
    """
    iterations_to_consider: builtins.int
    """Optional. Number of (averaged) iterations to consider when determining maximum percent
    deviation from the current value. Default: 1.
    """
    def __init__(
        self,
        *,
        simulation_template_id: builtins.str = ...,
        output_definition_id: builtins.str = ...,
        threshold: builtins.float = ...,
        start_at_iteration: builtins.int | None = ...,
        averaging_iterations: builtins.int | None = ...,
        iterations_to_consider: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_averaging_iterations", b"_averaging_iterations", "_iterations_to_consider", b"_iterations_to_consider", "_start_at_iteration", b"_start_at_iteration", "averaging_iterations", b"averaging_iterations", "iterations_to_consider", b"iterations_to_consider", "start_at_iteration", b"start_at_iteration"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_averaging_iterations", b"_averaging_iterations", "_iterations_to_consider", b"_iterations_to_consider", "_start_at_iteration", b"_start_at_iteration", "averaging_iterations", b"averaging_iterations", "iterations_to_consider", b"iterations_to_consider", "output_definition_id", b"output_definition_id", "simulation_template_id", b"simulation_template_id", "start_at_iteration", b"start_at_iteration", "threshold", b"threshold"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_averaging_iterations", b"_averaging_iterations"]) -> typing_extensions.Literal["averaging_iterations"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_iterations_to_consider", b"_iterations_to_consider"]) -> typing_extensions.Literal["iterations_to_consider"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_start_at_iteration", b"_start_at_iteration"]) -> typing_extensions.Literal["start_at_iteration"] | None: ...

global___CreateOrUpdateStoppingConditionRequest = CreateOrUpdateStoppingConditionRequest

class CreateOrUpdateStoppingConditionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STOPPING_CONDITION_FIELD_NUMBER: builtins.int
    @property
    def stopping_condition(self) -> global___StoppingCondition:
        """The created or updated stopping condition."""
    def __init__(
        self,
        *,
        stopping_condition: global___StoppingCondition | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["stopping_condition", b"stopping_condition"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["stopping_condition", b"stopping_condition"]) -> None: ...

global___CreateOrUpdateStoppingConditionResponse = CreateOrUpdateStoppingConditionResponse

class GetStoppingConditionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    SIMULATION_TEMPLATE_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. Identifies the stopping condition to retrieve."""
    simulation_template_id: builtins.str
    """Required. Identifies the simulation template that owns the stopping condition."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        simulation_template_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "simulation_template_id", b"simulation_template_id"]) -> None: ...

global___GetStoppingConditionRequest = GetStoppingConditionRequest

class GetStoppingConditionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STOPPING_CONDITION_FIELD_NUMBER: builtins.int
    @property
    def stopping_condition(self) -> global___StoppingCondition:
        """The requested stopping condition."""
    def __init__(
        self,
        *,
        stopping_condition: global___StoppingCondition | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["stopping_condition", b"stopping_condition"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["stopping_condition", b"stopping_condition"]) -> None: ...

global___GetStoppingConditionResponse = GetStoppingConditionResponse

class ListStoppingConditionsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMULATION_TEMPLATE_ID_FIELD_NUMBER: builtins.int
    simulation_template_id: builtins.str
    """Required. Identifies the simulation template to list stopping conditions for."""
    def __init__(
        self,
        *,
        simulation_template_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["simulation_template_id", b"simulation_template_id"]) -> None: ...

global___ListStoppingConditionsRequest = ListStoppingConditionsRequest

class ListStoppingConditionsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STOPPING_CONDITIONS_FIELD_NUMBER: builtins.int
    @property
    def stopping_conditions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StoppingCondition]:
        """A list of a simulation template's stopping conditions. Order of stopping conditions is
        unspecified.
        """
    def __init__(
        self,
        *,
        stopping_conditions: collections.abc.Iterable[global___StoppingCondition] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["stopping_conditions", b"stopping_conditions"]) -> None: ...

global___ListStoppingConditionsResponse = ListStoppingConditionsResponse

class DeleteStoppingConditionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    SIMULATION_TEMPLATE_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. Identifies the stopping condition to retrieve."""
    simulation_template_id: builtins.str
    """Required. Identifies the simulation template that owns the stopping condition."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        simulation_template_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "simulation_template_id", b"simulation_template_id"]) -> None: ...

global___DeleteStoppingConditionRequest = DeleteStoppingConditionRequest

class DeleteStoppingConditionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteStoppingConditionResponse = DeleteStoppingConditionResponse
