# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from luminarycloud._proto.upload import upload_pb2 as proto_dot_upload_dot_upload__pb2


class UploadServiceStub(object):
    """Provides APIs for managing uploads.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.CreateUpload = channel.unary_unary(
                '/luminary.proto.api.v0.luminarycloud.upload.UploadService/CreateUpload',
                request_serializer=proto_dot_upload_dot_upload__pb2.CreateUploadRequest.SerializeToString,
                response_deserializer=proto_dot_upload_dot_upload__pb2.CreateUploadReply.FromString,
                )
        self.StartUpload = channel.unary_unary(
                '/luminary.proto.api.v0.luminarycloud.upload.UploadService/StartUpload',
                request_serializer=proto_dot_upload_dot_upload__pb2.StartUploadRequest.SerializeToString,
                response_deserializer=proto_dot_upload_dot_upload__pb2.StartUploadReply.FromString,
                )
        self.UploadData = channel.unary_unary(
                '/luminary.proto.api.v0.luminarycloud.upload.UploadService/UploadData',
                request_serializer=proto_dot_upload_dot_upload__pb2.UploadDataRequest.SerializeToString,
                response_deserializer=proto_dot_upload_dot_upload__pb2.UploadDataReply.FromString,
                )
        self.FinishUpload = channel.unary_unary(
                '/luminary.proto.api.v0.luminarycloud.upload.UploadService/FinishUpload',
                request_serializer=proto_dot_upload_dot_upload__pb2.FinishUploadRequest.SerializeToString,
                response_deserializer=proto_dot_upload_dot_upload__pb2.FinishUploadReply.FromString,
                )
        self.UploadWebGeometry = channel.unary_unary(
                '/luminary.proto.api.v0.luminarycloud.upload.UploadService/UploadWebGeometry',
                request_serializer=proto_dot_upload_dot_upload__pb2.UploadWebGeometryRequest.SerializeToString,
                response_deserializer=proto_dot_upload_dot_upload__pb2.UploadWebGeometryReply.FromString,
                )
        self.GetWebGeometryBaseUrl = channel.unary_unary(
                '/luminary.proto.api.v0.luminarycloud.upload.UploadService/GetWebGeometryBaseUrl',
                request_serializer=proto_dot_upload_dot_upload__pb2.GetWebGeometryBaseUrlRequest.SerializeToString,
                response_deserializer=proto_dot_upload_dot_upload__pb2.GetWebGeometryBaseUrlReply.FromString,
                )


class UploadServiceServicer(object):
    """Provides APIs for managing uploads.
    """

    def CreateUpload(self, request, context):
        """Create an Upload that can be used to upload a file to a project.

        The Upload APIs should be used in the following way:
        1. CreateUpload: Initiate an upload and provide file metadata to the server.
        2. StartUpload: Call this API with the upload ID from the CreateUpload
        response to inform the server of the upload method that will be used to
        complete the upload and get back the necessary information to proceed
        with the upload.
        3. UploadData:
        - If StartUpload was called with method=Simple, then the UploadData API
        can be used to upload file chunks.
        - If StartUpload was called with method=GCSResumable, then the client
        should not call UploadData, and instead upload the data using the
        signed URL returned by StartUpload.
        4. FinishUpload: Once the data has been uploaded, FinishUpload must be
        called to inform the server and provide any ResourceParams that are
        necessary to create the resource.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def StartUpload(self, request, context):
        """Start an upload, with the requested method.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UploadData(self, request, context):
        """Upload a chunk of data for an in-progress upload with method=SimpleMethod.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FinishUpload(self, request, context):
        """Complete an ongoing upload. Must be called after all file data has been
        successfully uploaded.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UploadWebGeometry(self, request, context):
        """Upload a URL referencing an asset on from an online geometry provider
        (e.g., Onshape). We store the reference and and perform no actual file
        transfer until use of the Onshape asset. It is merely for tracking references
        to the object.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetWebGeometryBaseUrl(self, request, context):
        """Get the originally associated URL for a given web geometry ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_UploadServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'CreateUpload': grpc.unary_unary_rpc_method_handler(
                    servicer.CreateUpload,
                    request_deserializer=proto_dot_upload_dot_upload__pb2.CreateUploadRequest.FromString,
                    response_serializer=proto_dot_upload_dot_upload__pb2.CreateUploadReply.SerializeToString,
            ),
            'StartUpload': grpc.unary_unary_rpc_method_handler(
                    servicer.StartUpload,
                    request_deserializer=proto_dot_upload_dot_upload__pb2.StartUploadRequest.FromString,
                    response_serializer=proto_dot_upload_dot_upload__pb2.StartUploadReply.SerializeToString,
            ),
            'UploadData': grpc.unary_unary_rpc_method_handler(
                    servicer.UploadData,
                    request_deserializer=proto_dot_upload_dot_upload__pb2.UploadDataRequest.FromString,
                    response_serializer=proto_dot_upload_dot_upload__pb2.UploadDataReply.SerializeToString,
            ),
            'FinishUpload': grpc.unary_unary_rpc_method_handler(
                    servicer.FinishUpload,
                    request_deserializer=proto_dot_upload_dot_upload__pb2.FinishUploadRequest.FromString,
                    response_serializer=proto_dot_upload_dot_upload__pb2.FinishUploadReply.SerializeToString,
            ),
            'UploadWebGeometry': grpc.unary_unary_rpc_method_handler(
                    servicer.UploadWebGeometry,
                    request_deserializer=proto_dot_upload_dot_upload__pb2.UploadWebGeometryRequest.FromString,
                    response_serializer=proto_dot_upload_dot_upload__pb2.UploadWebGeometryReply.SerializeToString,
            ),
            'GetWebGeometryBaseUrl': grpc.unary_unary_rpc_method_handler(
                    servicer.GetWebGeometryBaseUrl,
                    request_deserializer=proto_dot_upload_dot_upload__pb2.GetWebGeometryBaseUrlRequest.FromString,
                    response_serializer=proto_dot_upload_dot_upload__pb2.GetWebGeometryBaseUrlReply.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'luminary.proto.api.v0.luminarycloud.upload.UploadService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class UploadService(object):
    """Provides APIs for managing uploads.
    """

    @staticmethod
    def CreateUpload(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/luminary.proto.api.v0.luminarycloud.upload.UploadService/CreateUpload',
            proto_dot_upload_dot_upload__pb2.CreateUploadRequest.SerializeToString,
            proto_dot_upload_dot_upload__pb2.CreateUploadReply.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def StartUpload(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/luminary.proto.api.v0.luminarycloud.upload.UploadService/StartUpload',
            proto_dot_upload_dot_upload__pb2.StartUploadRequest.SerializeToString,
            proto_dot_upload_dot_upload__pb2.StartUploadReply.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def UploadData(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/luminary.proto.api.v0.luminarycloud.upload.UploadService/UploadData',
            proto_dot_upload_dot_upload__pb2.UploadDataRequest.SerializeToString,
            proto_dot_upload_dot_upload__pb2.UploadDataReply.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def FinishUpload(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/luminary.proto.api.v0.luminarycloud.upload.UploadService/FinishUpload',
            proto_dot_upload_dot_upload__pb2.FinishUploadRequest.SerializeToString,
            proto_dot_upload_dot_upload__pb2.FinishUploadReply.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def UploadWebGeometry(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/luminary.proto.api.v0.luminarycloud.upload.UploadService/UploadWebGeometry',
            proto_dot_upload_dot_upload__pb2.UploadWebGeometryRequest.SerializeToString,
            proto_dot_upload_dot_upload__pb2.UploadWebGeometryReply.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetWebGeometryBaseUrl(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/luminary.proto.api.v0.luminarycloud.upload.UploadService/GetWebGeometryBaseUrl',
            proto_dot_upload_dot_upload__pb2.GetWebGeometryBaseUrlRequest.SerializeToString,
            proto_dot_upload_dot_upload__pb2.GetWebGeometryBaseUrlReply.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
