"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import abc
import grpc
import luminarycloud._proto.upload.upload_pb2

class UploadServiceStub:
    """Provides APIs for managing uploads."""

    def __init__(self, channel: grpc.Channel) -> None: ...
    CreateUpload: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.upload.upload_pb2.CreateUploadRequest,
        luminarycloud._proto.upload.upload_pb2.CreateUploadReply,
    ]
    """Create an Upload that can be used to upload a file to a project.

    The Upload APIs should be used in the following way:
    1. CreateUpload: Initiate an upload and provide file metadata to the server.
    2. StartUpload: Call this API with the upload ID from the CreateUpload
       response to inform the server of the upload method that will be used to
       complete the upload and get back the necessary information to proceed
       with the upload.
    3. UploadData:
       - If StartUpload was called with method=Simple, then the UploadData API
         can be used to upload file chunks.
       - If StartUpload was called with method=GCSResumable, then the client
         should not call UploadData, and instead upload the data using the
         signed URL returned by StartUpload.
    4. FinishUpload: Once the data has been uploaded, FinishUpload must be
       called to inform the server and provide any ResourceParams that are
       necessary to create the resource.
    """
    StartUpload: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.upload.upload_pb2.StartUploadRequest,
        luminarycloud._proto.upload.upload_pb2.StartUploadReply,
    ]
    """Start an upload, with the requested method."""
    UploadData: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.upload.upload_pb2.UploadDataRequest,
        luminarycloud._proto.upload.upload_pb2.UploadDataReply,
    ]
    """Upload a chunk of data for an in-progress upload with method=SimpleMethod."""
    FinishUpload: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.upload.upload_pb2.FinishUploadRequest,
        luminarycloud._proto.upload.upload_pb2.FinishUploadReply,
    ]
    """Complete an ongoing upload. Must be called after all file data has been
    successfully uploaded.
    """
    UploadWebGeometry: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.upload.upload_pb2.UploadWebGeometryRequest,
        luminarycloud._proto.upload.upload_pb2.UploadWebGeometryReply,
    ]
    """Upload a URL referencing an asset on from an online geometry provider
    (e.g., Onshape). We store the reference and and perform no actual file
    transfer until use of the Onshape asset. It is merely for tracking references
    to the object.
    """
    GetWebGeometryBaseUrl: grpc.UnaryUnaryMultiCallable[
        luminarycloud._proto.upload.upload_pb2.GetWebGeometryBaseUrlRequest,
        luminarycloud._proto.upload.upload_pb2.GetWebGeometryBaseUrlReply,
    ]
    """Get the originally associated URL for a given web geometry ID."""

class UploadServiceServicer(metaclass=abc.ABCMeta):
    """Provides APIs for managing uploads."""

    @abc.abstractmethod
    def CreateUpload(
        self,
        request: luminarycloud._proto.upload.upload_pb2.CreateUploadRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.upload.upload_pb2.CreateUploadReply:
        """Create an Upload that can be used to upload a file to a project.

        The Upload APIs should be used in the following way:
        1. CreateUpload: Initiate an upload and provide file metadata to the server.
        2. StartUpload: Call this API with the upload ID from the CreateUpload
           response to inform the server of the upload method that will be used to
           complete the upload and get back the necessary information to proceed
           with the upload.
        3. UploadData:
           - If StartUpload was called with method=Simple, then the UploadData API
             can be used to upload file chunks.
           - If StartUpload was called with method=GCSResumable, then the client
             should not call UploadData, and instead upload the data using the
             signed URL returned by StartUpload.
        4. FinishUpload: Once the data has been uploaded, FinishUpload must be
           called to inform the server and provide any ResourceParams that are
           necessary to create the resource.
        """
    @abc.abstractmethod
    def StartUpload(
        self,
        request: luminarycloud._proto.upload.upload_pb2.StartUploadRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.upload.upload_pb2.StartUploadReply:
        """Start an upload, with the requested method."""
    @abc.abstractmethod
    def UploadData(
        self,
        request: luminarycloud._proto.upload.upload_pb2.UploadDataRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.upload.upload_pb2.UploadDataReply:
        """Upload a chunk of data for an in-progress upload with method=SimpleMethod."""
    @abc.abstractmethod
    def FinishUpload(
        self,
        request: luminarycloud._proto.upload.upload_pb2.FinishUploadRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.upload.upload_pb2.FinishUploadReply:
        """Complete an ongoing upload. Must be called after all file data has been
        successfully uploaded.
        """
    @abc.abstractmethod
    def UploadWebGeometry(
        self,
        request: luminarycloud._proto.upload.upload_pb2.UploadWebGeometryRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.upload.upload_pb2.UploadWebGeometryReply:
        """Upload a URL referencing an asset on from an online geometry provider
        (e.g., Onshape). We store the reference and and perform no actual file
        transfer until use of the Onshape asset. It is merely for tracking references
        to the object.
        """
    @abc.abstractmethod
    def GetWebGeometryBaseUrl(
        self,
        request: luminarycloud._proto.upload.upload_pb2.GetWebGeometryBaseUrlRequest,
        context: grpc.ServicerContext,
    ) -> luminarycloud._proto.upload.upload_pb2.GetWebGeometryBaseUrlReply:
        """Get the originally associated URL for a given web geometry ID."""

def add_UploadServiceServicer_to_server(servicer: UploadServiceServicer, server: grpc.Server) -> None: ...
